/*++

Module Name:

    bblfont.h

Abstract:

    This header file defines a font suitable for use with the HAL
    text on the GXT150P graphics adapter. The font data is standard
    OEM VGA font data (10x20 glyphs)

--*/

/*
UCHAR  BBLFont[12288] = {
*/
UCHAR  BBLFont[11832] = {
0x00, 0x02, 0x3e, 0x2c, 0x00, 0x00, 0x28, 0x63,
0x29, 0x20, 0x43, 0x6f, 0x70, 0x79, 0x72, 0x69,
0x67, 0x68, 0x74, 0x20, 0x42, 0x69, 0x74, 0x73,
0x74, 0x72, 0x65, 0x61, 0x6d, 0x20, 0x49, 0x6e,
0x63, 0x2e, 0x20, 0x31, 0x39, 0x38, 0x34, 0x2e,
0x20, 0x41, 0x6c, 0x6c, 0x20, 0x72, 0x69, 0x67,
0x68, 0x74, 0x73, 0x20, 0x72, 0x65, 0x73, 0x65,
0x72, 0x76, 0x65, 0x64, 0x2e, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x60, 0x00,
0x60, 0x00, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x90, 0x01, 0xff, 0x0a, 0x00,
0x14, 0x00, 0x30, 0x0a, 0x00, 0x0a, 0x00, 0x01,
0xfe, 0x1f, 0x00, 0xfd, 0x01, 0x00, 0x00, 0x00,
0x00, 0x36, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x72, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00,
0x72, 0x04, 0x0a, 0x00, 0x9a, 0x04, 0x0a, 0x00,
0xc2, 0x04, 0x0a, 0x00, 0xea, 0x04, 0x0a, 0x00,
0x12, 0x05, 0x0a, 0x00, 0x3a, 0x05, 0x0a, 0x00,
0x62, 0x05, 0x0a, 0x00, 0x8a, 0x05, 0x0a, 0x00,
0xb2, 0x05, 0x0a, 0x00, 0xda, 0x05, 0x0a, 0x00,
0x02, 0x06, 0x0a, 0x00, 0x2a, 0x06, 0x0a, 0x00,
0x52, 0x06, 0x0a, 0x00, 0x7a, 0x06, 0x0a, 0x00,
0xa2, 0x06, 0x0a, 0x00, 0xca, 0x06, 0x0a, 0x00,
0xf2, 0x06, 0x0a, 0x00, 0x1a, 0x07, 0x0a, 0x00,
0x42, 0x07, 0x0a, 0x00, 0x6a, 0x07, 0x0a, 0x00,
0x92, 0x07, 0x0a, 0x00, 0xba, 0x07, 0x0a, 0x00,
0xe2, 0x07, 0x0a, 0x00, 0x0a, 0x08, 0x0a, 0x00,
0x32, 0x08, 0x0a, 0x00, 0x5a, 0x08, 0x0a, 0x00,
0x82, 0x08, 0x0a, 0x00, 0xaa, 0x08, 0x0a, 0x00,
0xd2, 0x08, 0x0a, 0x00, 0xfa, 0x08, 0x0a, 0x00,
0x22, 0x09, 0x0a, 0x00, 0x4a, 0x09, 0x0a, 0x00,
0x72, 0x09, 0x0a, 0x00, 0x9a, 0x09, 0x0a, 0x00,
0xc2, 0x09, 0x0a, 0x00, 0xea, 0x09, 0x0a, 0x00,
0x12, 0x0a, 0x0a, 0x00, 0x3a, 0x0a, 0x0a, 0x00,
0x62, 0x0a, 0x0a, 0x00, 0x8a, 0x0a, 0x0a, 0x00,
0xb2, 0x0a, 0x0a, 0x00, 0xda, 0x0a, 0x0a, 0x00,
0x02, 0x0b, 0x0a, 0x00, 0x2a, 0x0b, 0x0a, 0x00,
0x52, 0x0b, 0x0a, 0x00, 0x7a, 0x0b, 0x0a, 0x00,
0xa2, 0x0b, 0x0a, 0x00, 0xca, 0x0b, 0x0a, 0x00,
0xf2, 0x0b, 0x0a, 0x00, 0x1a, 0x0c, 0x0a, 0x00,
0x42, 0x0c, 0x0a, 0x00, 0x6a, 0x0c, 0x0a, 0x00,
0x92, 0x0c, 0x0a, 0x00, 0xba, 0x0c, 0x0a, 0x00,
0xe2, 0x0c, 0x0a, 0x00, 0x0a, 0x0d, 0x0a, 0x00,
0x32, 0x0d, 0x0a, 0x00, 0x5a, 0x0d, 0x0a, 0x00,
0x82, 0x0d, 0x0a, 0x00, 0xaa, 0x0d, 0x0a, 0x00,
0xd2, 0x0d, 0x0a, 0x00, 0xfa, 0x0d, 0x0a, 0x00,
0x22, 0x0e, 0x0a, 0x00, 0x4a, 0x0e, 0x0a, 0x00,
0x72, 0x0e, 0x0a, 0x00, 0x9a, 0x0e, 0x0a, 0x00,
0xc2, 0x0e, 0x0a, 0x00, 0xea, 0x0e, 0x0a, 0x00,
0x12, 0x0f, 0x0a, 0x00, 0x3a, 0x0f, 0x0a, 0x00,
0x62, 0x0f, 0x0a, 0x00, 0x8a, 0x0f, 0x0a, 0x00,
0xb2, 0x0f, 0x0a, 0x00, 0xda, 0x0f, 0x0a, 0x00,
0x02, 0x10, 0x0a, 0x00, 0x2a, 0x10, 0x0a, 0x00,
0x52, 0x10, 0x0a, 0x00, 0x7a, 0x10, 0x0a, 0x00,
0xa2, 0x10, 0x0a, 0x00, 0xca, 0x10, 0x0a, 0x00,
0xf2, 0x10, 0x0a, 0x00, 0x1a, 0x11, 0x0a, 0x00,
0x42, 0x11, 0x0a, 0x00, 0x6a, 0x11, 0x0a, 0x00,
0x92, 0x11, 0x0a, 0x00, 0xba, 0x11, 0x0a, 0x00,
0xe2, 0x11, 0x0a, 0x00, 0x0a, 0x12, 0x0a, 0x00,
0x32, 0x12, 0x0a, 0x00, 0x5a, 0x12, 0x0a, 0x00,
0x82, 0x12, 0x0a, 0x00, 0xaa, 0x12, 0x0a, 0x00,
0xd2, 0x12, 0x0a, 0x00, 0xfa, 0x12, 0x0a, 0x00,
0x22, 0x13, 0x0a, 0x00, 0x4a, 0x13, 0x0a, 0x00,
0x72, 0x13, 0x0a, 0x00, 0x9a, 0x13, 0x0a, 0x00,
0xc2, 0x13, 0x0a, 0x00, 0xea, 0x13, 0x0a, 0x00,
0x12, 0x14, 0x0a, 0x00, 0x3a, 0x14, 0x0a, 0x00,
0x62, 0x14, 0x0a, 0x00, 0x8a, 0x14, 0x0a, 0x00,
0xb2, 0x14, 0x0a, 0x00, 0xda, 0x14, 0x0a, 0x00,
0x02, 0x15, 0x0a, 0x00, 0x2a, 0x15, 0x0a, 0x00,
0x52, 0x15, 0x0a, 0x00, 0x7a, 0x15, 0x0a, 0x00,
0xa2, 0x15, 0x0a, 0x00, 0xca, 0x15, 0x0a, 0x00,
0xf2, 0x15, 0x0a, 0x00, 0x1a, 0x16, 0x0a, 0x00,
0x42, 0x16, 0x0a, 0x00, 0x6a, 0x16, 0x0a, 0x00,
0x92, 0x16, 0x0a, 0x00, 0xba, 0x16, 0x0a, 0x00,
0xe2, 0x16, 0x0a, 0x00, 0x0a, 0x17, 0x0a, 0x00,
0x32, 0x17, 0x0a, 0x00, 0x5a, 0x17, 0x0a, 0x00,
0x82, 0x17, 0x0a, 0x00, 0xaa, 0x17, 0x0a, 0x00,
0xd2, 0x17, 0x0a, 0x00, 0xfa, 0x17, 0x0a, 0x00,
0x22, 0x18, 0x0a, 0x00, 0x4a, 0x18, 0x0a, 0x00,
0x72, 0x18, 0x0a, 0x00, 0x9a, 0x18, 0x0a, 0x00,
0xc2, 0x18, 0x0a, 0x00, 0xea, 0x18, 0x0a, 0x00,
0x12, 0x19, 0x0a, 0x00, 0x3a, 0x19, 0x0a, 0x00,
0x62, 0x19, 0x0a, 0x00, 0x8a, 0x19, 0x0a, 0x00,
0xb2, 0x19, 0x0a, 0x00, 0xda, 0x19, 0x0a, 0x00,
0x02, 0x1a, 0x0a, 0x00, 0x2a, 0x1a, 0x0a, 0x00,
0x52, 0x1a, 0x0a, 0x00, 0x7a, 0x1a, 0x0a, 0x00,
0xa2, 0x1a, 0x0a, 0x00, 0xca, 0x1a, 0x0a, 0x00,
0xf2, 0x1a, 0x0a, 0x00, 0x1a, 0x1b, 0x0a, 0x00,
0x42, 0x1b, 0x0a, 0x00, 0x6a, 0x1b, 0x0a, 0x00,
0x92, 0x1b, 0x0a, 0x00, 0xba, 0x1b, 0x0a, 0x00,
0xe2, 0x1b, 0x0a, 0x00, 0x0a, 0x1c, 0x0a, 0x00,
0x32, 0x1c, 0x0a, 0x00, 0x5a, 0x1c, 0x0a, 0x00,
0x82, 0x1c, 0x0a, 0x00, 0xaa, 0x1c, 0x0a, 0x00,
0xd2, 0x1c, 0x0a, 0x00, 0xfa, 0x1c, 0x0a, 0x00,
0x22, 0x1d, 0x0a, 0x00, 0x4a, 0x1d, 0x0a, 0x00,
0x72, 0x1d, 0x0a, 0x00, 0x9a, 0x1d, 0x0a, 0x00,
0xc2, 0x1d, 0x0a, 0x00, 0xea, 0x1d, 0x0a, 0x00,
0x12, 0x1e, 0x0a, 0x00, 0x3a, 0x1e, 0x0a, 0x00,
0x62, 0x1e, 0x0a, 0x00, 0x8a, 0x1e, 0x0a, 0x00,
0xb2, 0x1e, 0x0a, 0x00, 0xda, 0x1e, 0x0a, 0x00,
0x02, 0x1f, 0x0a, 0x00, 0x2a, 0x1f, 0x0a, 0x00,
0x52, 0x1f, 0x0a, 0x00, 0x7a, 0x1f, 0x0a, 0x00,
0xa2, 0x1f, 0x0a, 0x00, 0xca, 0x1f, 0x0a, 0x00,
0xf2, 0x1f, 0x0a, 0x00, 0x1a, 0x20, 0x0a, 0x00,
0x42, 0x20, 0x0a, 0x00, 0x6a, 0x20, 0x0a, 0x00,
0x92, 0x20, 0x0a, 0x00, 0xba, 0x20, 0x0a, 0x00,
0xe2, 0x20, 0x0a, 0x00, 0x0a, 0x21, 0x0a, 0x00,
0x32, 0x21, 0x0a, 0x00, 0x5a, 0x21, 0x0a, 0x00,
0x82, 0x21, 0x0a, 0x00, 0xaa, 0x21, 0x0a, 0x00,
0xd2, 0x21, 0x0a, 0x00, 0xfa, 0x21, 0x0a, 0x00,
0x22, 0x22, 0x0a, 0x00, 0x4a, 0x22, 0x0a, 0x00,
0x72, 0x22, 0x0a, 0x00, 0x9a, 0x22, 0x0a, 0x00,
0xc2, 0x22, 0x0a, 0x00, 0xea, 0x22, 0x0a, 0x00,
0x12, 0x23, 0x0a, 0x00, 0x3a, 0x23, 0x0a, 0x00,
0x62, 0x23, 0x0a, 0x00, 0x8a, 0x23, 0x0a, 0x00,
0xb2, 0x23, 0x0a, 0x00, 0xda, 0x23, 0x0a, 0x00,
0x02, 0x24, 0x0a, 0x00, 0x2a, 0x24, 0x0a, 0x00,
0x52, 0x24, 0x0a, 0x00, 0x7a, 0x24, 0x0a, 0x00,
0xa2, 0x24, 0x0a, 0x00, 0xca, 0x24, 0x0a, 0x00,
0xf2, 0x24, 0x0a, 0x00, 0x1a, 0x25, 0x0a, 0x00,
0x42, 0x25, 0x0a, 0x00, 0x6a, 0x25, 0x0a, 0x00,
0x92, 0x25, 0x0a, 0x00, 0xba, 0x25, 0x0a, 0x00,
0xe2, 0x25, 0x0a, 0x00, 0x0a, 0x26, 0x0a, 0x00,
0x32, 0x26, 0x0a, 0x00, 0x5a, 0x26, 0x0a, 0x00,
0x82, 0x26, 0x0a, 0x00, 0xaa, 0x26, 0x0a, 0x00,
0xd2, 0x26, 0x0a, 0x00, 0xfa, 0x26, 0x0a, 0x00,
0x22, 0x27, 0x0a, 0x00, 0x4a, 0x27, 0x0a, 0x00,
0x72, 0x27, 0x0a, 0x00, 0x9a, 0x27, 0x0a, 0x00,
0xc2, 0x27, 0x0a, 0x00, 0xea, 0x27, 0x0a, 0x00,
0x12, 0x28, 0x0a, 0x00, 0x3a, 0x28, 0x0a, 0x00,
0x62, 0x28, 0x0a, 0x00, 0x8a, 0x28, 0x0a, 0x00,
0xb2, 0x28, 0x0a, 0x00, 0xda, 0x28, 0x0a, 0x00,
0x02, 0x29, 0x0a, 0x00, 0x2a, 0x29, 0x0a, 0x00,
0x52, 0x29, 0x0a, 0x00, 0x7a, 0x29, 0x0a, 0x00,
0xa2, 0x29, 0x0a, 0x00, 0xca, 0x29, 0x0a, 0x00,
0xf2, 0x29, 0x0a, 0x00, 0x1a, 0x2a, 0x0a, 0x00,
0x42, 0x2a, 0x0a, 0x00, 0x6a, 0x2a, 0x0a, 0x00,
0x92, 0x2a, 0x0a, 0x00, 0xba, 0x2a, 0x0a, 0x00,
0xe2, 0x2a, 0x0a, 0x00, 0x0a, 0x2b, 0x0a, 0x00,
0x32, 0x2b, 0x0a, 0x00, 0x5a, 0x2b, 0x0a, 0x00,
0x82, 0x2b, 0x0a, 0x00, 0xaa, 0x2b, 0x0a, 0x00,
0xd2, 0x2b, 0x0a, 0x00, 0xfa, 0x2b, 0x08, 0x00,
0x22, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x7f,
0xe1, 0xc0, 0xd2, 0xd2, 0xc0, 0xde, 0xcc, 0xe1,
0x7f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x7f,
0xff, 0xff, 0xed, 0xed, 0xff, 0xe1, 0xf3, 0xff,
0x7f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x61, 0xf3, 0xff, 0xff, 0xff, 0x7f, 0x3f,
0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xc0,
0xc0, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x0c, 0x1e, 0x3f, 0x7f, 0xff, 0x7f, 0x3f,
0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x80, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0c, 0x1e, 0x1e, 0x6d, 0xff, 0xff, 0x6d, 0x0c,
0x0c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0xc0, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0c, 0x1e, 0x3f, 0x7f, 0xff, 0xff, 0x6d, 0x0c,
0x0c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0xc0, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x0c, 0x1e, 0x1e, 0x0c, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xc0, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x40, 0x40,
0x40, 0x40, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x1e, 0x21, 0x40, 0x80, 0x80, 0x80, 0x80, 0x40,
0x21, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40,
0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1,
0x80, 0x80, 0x8c, 0x9e, 0x9e, 0x8c, 0x80, 0x80,
0xe1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0x40, 0x40, 0x40, 0x40,
0x40, 0x40, 0x40, 0x40, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x01,
0x03, 0x07, 0x3e, 0x7e, 0xe7, 0xc3, 0xc3, 0xe7,
0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xc0, 0xc0, 0xc0, 0x40, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f,
0x61, 0xc0, 0xc0, 0xc0, 0xc0, 0x61, 0x3f, 0x0c,
0x0c, 0x3f, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xc0, 0xc0,
0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x0f, 0x0c, 0x0c, 0x0f,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x7c, 0xfc,
0xfc, 0xfc, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,
0xc0, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18,
0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x79,
0xfb, 0xf3, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0x7f,
0x33, 0x61, 0x61, 0x33, 0x7f, 0xde, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xc0, 0x80, 0x00, 0x80, 0x80, 0x00,
0x80, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x70, 0x78,
0x7c, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7c, 0x78,
0x70, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x07,
0x0f, 0x1f, 0x3f, 0x7f, 0x3f, 0x1f, 0x0f, 0x07,
0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x7f,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x7f,
0x3f, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x00, 0x00,
0x73, 0x73, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x7b,
0x7b, 0x7b, 0x7b, 0x3b, 0x1b, 0x1b, 0x1b, 0x1b,
0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x33,
0x30, 0x1c, 0x1e, 0x36, 0x33, 0x33, 0x1b, 0x1e,
0x0e, 0x03, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f,
0x7f, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x7f,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x7f,
0x3f, 0x1e, 0x0c, 0x7f, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80,
0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x7f,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x7f,
0x3f, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
0x0e, 0x07, 0x7f, 0x7f, 0x07, 0x0e, 0x0c, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
0x1c, 0x38, 0x7f, 0x7f, 0x38, 0x1c, 0x0c, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x60, 0x60, 0x60, 0x60, 0x7f, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x12, 0x33, 0x7f, 0x7f, 0x33, 0x12, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x7f, 0x3f, 0x1e, 0x0c, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e,
0x1e, 0x1e, 0x1e, 0x1e, 0x0c, 0x0c, 0x0c, 0x00,
0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33,
0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33,
0x33, 0x7f, 0x7f, 0x33, 0x33, 0x7f, 0x7f, 0x33,
0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00,
0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x1e, 0x3f,
0x73, 0x70, 0x38, 0x1c, 0x06, 0x03, 0x03, 0x73,
0x3f, 0x1e, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xdb, 0xdb,
0x76, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x33, 0x36,
0x66, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0xc0, 0xc0, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b,
0x31, 0x1b, 0x0e, 0x18, 0x33, 0x61, 0x61, 0x63,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
0xc0, 0x80, 0x00, 0x00, 0x80, 0xc0, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c,
0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0c, 0x18,
0x10, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
0x30, 0x10, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x0c,
0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
0x06, 0x04, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x61, 0x33, 0x1e, 0x7f, 0x1e, 0x33, 0x61,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
0x0c, 0x0c, 0x7f, 0x7f, 0x0c, 0x0c, 0x0c, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0c, 0x0c, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
0x03, 0x03, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18,
0x30, 0x30, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x61, 0x61, 0x6d, 0x6d, 0x61, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x3c,
0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x01, 0x03, 0x07, 0x0e, 0x1c, 0x38, 0x70,
0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x01, 0x03, 0x0e, 0x0f, 0x03, 0x01, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x33,
0x33, 0x33, 0x33, 0x63, 0x7f, 0x7f, 0x03, 0x03,
0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f,
0x60, 0x60, 0x7e, 0x7f, 0x03, 0x01, 0x01, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x60, 0x60, 0x6e, 0x7f, 0x73, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f,
0x01, 0x03, 0x06, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x61, 0x33, 0x1e, 0x3f, 0x73, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x61, 0x73, 0x3f, 0x1d, 0x01, 0x01, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00,
0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00,
0x0c, 0x0c, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
0x06, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c,
0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x3e, 0x3e, 0x00, 0x00, 0x3e, 0x3e, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
0x18, 0x0c, 0x06, 0x03, 0x01, 0x03, 0x06, 0x0c,
0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x61, 0x03, 0x07, 0x0e, 0x0c, 0x0c, 0x00,
0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x61, 0x61, 0x67, 0x6f, 0x69, 0x69, 0x6f, 0x67,
0x60, 0x3f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e,
0x33, 0x61, 0x61, 0x61, 0x61, 0x7f, 0x7f, 0x61,
0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7f,
0x61, 0x61, 0x61, 0x7f, 0x7f, 0x61, 0x61, 0x61,
0x7f, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00,
0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7f,
0x63, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x63,
0x7f, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f,
0x60, 0x60, 0x60, 0x7e, 0x7e, 0x60, 0x60, 0x60,
0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f,
0x60, 0x60, 0x60, 0x7e, 0x7e, 0x60, 0x60, 0x60,
0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x60, 0x60, 0x60, 0x67, 0x67, 0x61, 0x73,
0x3f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x61,
0x61, 0x61, 0x61, 0x7f, 0x7f, 0x61, 0x61, 0x61,
0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x67,
0x6e, 0x7c, 0x78, 0x70, 0x78, 0x7c, 0x6e, 0x67,
0x63, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60,
0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x61,
0x73, 0x73, 0x7f, 0x7f, 0x6d, 0x6d, 0x61, 0x61,
0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x71,
0x71, 0x79, 0x79, 0x6d, 0x6d, 0x67, 0x67, 0x63,
0x63, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7f,
0x63, 0x61, 0x61, 0x63, 0x7f, 0x7e, 0x60, 0x60,
0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x61, 0x61, 0x61, 0x61, 0x61, 0x67, 0x77,
0x3f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7f,
0x63, 0x61, 0x61, 0x63, 0x7f, 0x7e, 0x63, 0x61,
0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80,
0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x70, 0x38, 0x1c, 0x06, 0x03, 0x03, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x61,
0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x61,
0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x33,
0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x61,
0x61, 0x61, 0x6d, 0x6d, 0x6d, 0x6d, 0x6d, 0x6d,
0x7f, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x61,
0x33, 0x33, 0x1e, 0x0c, 0x0c, 0x1e, 0x33, 0x33,
0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x61,
0x61, 0x61, 0x61, 0x33, 0x1e, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f,
0x01, 0x03, 0x07, 0x0e, 0x1c, 0x38, 0x70, 0x60,
0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e,
0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
0x18, 0x18, 0x18, 0x1e, 0x1e, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60,
0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06,
0x03, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e,
0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
0x06, 0x06, 0x06, 0x1e, 0x1e, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x0c, 0x1e, 0x33, 0x40, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x7f, 0x7f, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x00, 0x00, 0x1c, 0x0c, 0x06, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x3e, 0x3f, 0x01, 0x3f, 0x7f, 0x61, 0x61,
0x7f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60,
0x60, 0x6e, 0x7f, 0x73, 0x61, 0x61, 0x61, 0x73,
0x7f, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x1e, 0x3f, 0x73, 0x60, 0x60, 0x60, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
0x01, 0x1d, 0x3f, 0x73, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x1e, 0x3f, 0x73, 0x61, 0x7f, 0x7f, 0x70,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1f,
0x18, 0x18, 0x7f, 0x7f, 0x18, 0x18, 0x18, 0x18,
0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x1e, 0x3f, 0x73, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1d, 0x01, 0x03, 0x3f, 0x3e, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60,
0x60, 0x6e, 0x7f, 0x73, 0x61, 0x61, 0x61, 0x61,
0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00,
0x00, 0x3c, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
0x00, 0x1e, 0x1e, 0x06, 0x06, 0x06, 0x06, 0x06,
0x06, 0x06, 0x06, 0x0e, 0x3c, 0x38, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60,
0x60, 0x63, 0x66, 0x6c, 0x78, 0x70, 0x7c, 0x66,
0x63, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x6d, 0x7f, 0x6d, 0x6d, 0x6d, 0x6d, 0x6d,
0x6d, 0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x6e, 0x7f, 0x73, 0x61, 0x61, 0x61, 0x61,
0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x1e, 0x3f, 0x73, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x6e, 0x7f, 0x73, 0x61, 0x61, 0x61, 0x73,
0x7f, 0x6e, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x1d, 0x3f, 0x73, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1d, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x6f, 0x7f, 0x78, 0x70, 0x60, 0x60, 0x60,
0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x1e, 0x3f, 0x61, 0x70, 0x3f, 0x03, 0x61,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
0x18, 0x3f, 0x3f, 0x18, 0x18, 0x18, 0x18, 0x18,
0x1f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x33,
0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x61, 0x61, 0x61, 0x6d, 0x6d, 0x7f, 0x7f,
0x73, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x61, 0x73, 0x3f, 0x1e, 0x0c, 0x1e, 0x3f,
0x73, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1d, 0x01, 0x01, 0x3f, 0x3e, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x7f, 0x7f, 0x03, 0x06, 0x0c, 0x18, 0x30,
0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0c,
0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x18, 0x18,
0x18, 0x18, 0x18, 0x0c, 0x07, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x0c,
0x06, 0x06, 0x06, 0x06, 0x06, 0x03, 0x06, 0x06,
0x06, 0x06, 0x06, 0x0c, 0x38, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6d, 0x47,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
0x1c, 0x3e, 0x77, 0x77, 0xe3, 0xe3, 0xe3, 0xff,
0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x73,
0x3f, 0x1e, 0x0c, 0x26, 0x1c, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33,
0x00, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0c, 0x18,
0x00, 0x1e, 0x3f, 0x73, 0x61, 0x7f, 0x7f, 0x70,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x21,
0x00, 0x3e, 0x3f, 0x01, 0x3f, 0x7f, 0x61, 0x61,
0x7f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33,
0x00, 0x3e, 0x3f, 0x01, 0x3f, 0x7f, 0x61, 0x61,
0x7f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x06,
0x00, 0x3e, 0x3f, 0x01, 0x3f, 0x7f, 0x61, 0x61,
0x7f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x1e, 0x33, 0x33, 0x1e,
0x00, 0x3e, 0x3f, 0x01, 0x3f, 0x7f, 0x61, 0x61,
0x7f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x1e, 0x3f, 0x73, 0x60, 0x60, 0x60, 0x73,
0x3f, 0x1e, 0x0c, 0x26, 0x1c, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x21,
0x00, 0x1e, 0x3f, 0x73, 0x61, 0x7f, 0x7f, 0x70,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33,
0x00, 0x1e, 0x3f, 0x73, 0x61, 0x7f, 0x7f, 0x70,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x06,
0x00, 0x1e, 0x3f, 0x73, 0x61, 0x7f, 0x7f, 0x70,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33,
0x00, 0x3c, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x21,
0x00, 0x3c, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x06,
0x00, 0x3c, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x33, 0x33, 0x00, 0x0c, 0x1e,
0x33, 0x61, 0x61, 0x61, 0x61, 0x7f, 0x7f, 0x61,
0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x1e, 0x33, 0x33, 0x1e, 0x0c, 0x1e,
0x33, 0x61, 0x61, 0x61, 0x61, 0x7f, 0x7f, 0x61,
0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x07, 0x0c, 0x18, 0x00, 0x7f, 0x7f,
0x60, 0x60, 0x60, 0x7e, 0x7e, 0x60, 0x60, 0x60,
0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x77, 0x7f, 0x0c, 0x7c, 0xff, 0xcc, 0xcc,
0xff, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xc0,
0xc0, 0xc0, 0x00, 0x00, 0xc0, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x3f,
0x6c, 0xcc, 0xcc, 0xcf, 0xcf, 0xfc, 0xfc, 0xcc,
0xcf, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0xc0,
0xc0, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x21,
0x00, 0x1e, 0x3f, 0x73, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33,
0x00, 0x1e, 0x3f, 0x73, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x06,
0x00, 0x1e, 0x3f, 0x73, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x21,
0x00, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x06,
0x00, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33,
0x00, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1d, 0x01, 0x01, 0x3f, 0x3e, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x00, 0x00, 0x00, 0x33, 0x33, 0x00, 0x1e, 0x3f,
0x73, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x33, 0x33, 0x00, 0x61, 0x61,
0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
0x0c, 0x1e, 0x3f, 0x73, 0x60, 0x60, 0x60, 0x73,
0x3f, 0x1e, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f,
0x31, 0x31, 0x30, 0x7c, 0x30, 0x30, 0x30, 0x31,
0x7f, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x61,
0x61, 0x61, 0x33, 0x1e, 0x7f, 0x7f, 0x0c, 0x7f,
0x7f, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7f,
0x63, 0x61, 0x61, 0x63, 0x7f, 0x7e, 0x61, 0x63,
0x6f, 0x63, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00,
0x80, 0x00, 0x07, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x7f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xcc,
0xcc, 0xfc, 0x78, 0x00, 0x00, 0x00, 0x80, 0xc0,
0xc0, 0xc0, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0c, 0x18,
0x00, 0x3e, 0x3f, 0x01, 0x3f, 0x7f, 0x61, 0x61,
0x7f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0c, 0x18,
0x00, 0x3c, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0c, 0x18,
0x00, 0x1e, 0x3f, 0x73, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0c, 0x18,
0x00, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x73,
0x3f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3f, 0x46,
0x00, 0x6e, 0x7f, 0x73, 0x61, 0x61, 0x61, 0x61,
0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x18, 0x3f, 0x46, 0x00, 0x61, 0x71,
0x71, 0x79, 0x79, 0x6d, 0x6d, 0x67, 0x67, 0x63,
0x63, 0x61, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x03,
0x3f, 0x63, 0x63, 0x3f, 0x00, 0x7f, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x3b,
0x31, 0x31, 0x3b, 0x1f, 0x00, 0x3f, 0x3f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00,
0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x1c,
0x38, 0x70, 0x61, 0x73, 0x3f, 0x1e, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x7f, 0x7f, 0x60, 0x60, 0x60, 0x60,
0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x7f, 0x7f, 0x03, 0x03, 0x03, 0x03,
0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x18, 0x38, 0x18, 0x18,
0x19, 0x1b, 0x07, 0x0e, 0x1c, 0x3b, 0x74, 0xe0,
0xc0, 0x83, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x40, 0xc0, 0xc0, 0x80, 0x00, 0x00,
0x00, 0x80, 0xc0, 0xc0, 0x80, 0x00, 0xc0, 0x00,
0x00, 0x00, 0x00, 0x00, 0x18, 0x38, 0x18, 0x18,
0x19, 0x1b, 0x07, 0x0e, 0x1c, 0x39, 0x73, 0xe5,
0xcd, 0x8f, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x40, 0xc0, 0xc0, 0x80, 0x00, 0x00,
0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x0c,
0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x19, 0x33, 0x66, 0x33, 0x19, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x66, 0x33, 0x19, 0x33, 0x66, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x84, 0x42, 0x21, 0x10, 0x08, 0x84,
0x42, 0x21, 0x10, 0x08, 0x84, 0x42, 0x21, 0x10,
0x08, 0x84, 0x42, 0x21, 0x10, 0x08, 0x00, 0x00,
0x00, 0x80, 0x40, 0x00, 0x00, 0x00, 0x80, 0x40,
0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x00, 0x00,
0x80, 0x40, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa,
0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa,
0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x40, 0x80,
0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
0x40, 0x80, 0x7b, 0xf7, 0xef, 0xde, 0xbd, 0x7b,
0xf7, 0xef, 0xde, 0xbd, 0x7b, 0xf7, 0xef, 0xde,
0xbd, 0x7b, 0xf7, 0xef, 0xde, 0xbd, 0xc0, 0x80,
0x40, 0xc0, 0xc0, 0xc0, 0x80, 0x40, 0xc0, 0xc0,
0xc0, 0x80, 0x40, 0xc0, 0xc0, 0xc0, 0x80, 0x40,
0xc0, 0xc0, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0xfc, 0xfc, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0xfc, 0xfc, 0x0c, 0x0c, 0xfc, 0xfc, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0xf3, 0xf3, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xff, 0xff, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xfc, 0xfc, 0x0c, 0x0c, 0xfc, 0xfc, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0xf3, 0xf3, 0x03, 0x03, 0xf3, 0xf3, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xff, 0xff, 0x03, 0x03, 0xf3, 0xf3, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0xf3, 0xf3, 0x03, 0x03, 0xff, 0xff, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0xfc, 0xfc, 0x0c, 0x0c, 0xfc, 0xfc, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xfc, 0xfc, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xff, 0xff, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0xff, 0xff, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0f, 0x0f, 0x0c, 0x0c, 0x0f, 0x0f, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00,
0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x70, 0x70, 0x7f, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0x00,
0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x7f, 0x7f, 0x70, 0x70, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00,
0x00, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0xf3, 0xf3, 0x00, 0x00, 0xff, 0xff, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0x00,
0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xff, 0xff, 0x00, 0x00, 0xf3, 0xf3, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00,
0x00, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x70, 0x70, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0x00,
0x00, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00,
0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0xf3, 0xf3, 0x00, 0x00, 0xf3, 0xf3, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0x00,
0x00, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00,
0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00,
0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xff, 0xff, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0f, 0x0f, 0x0c, 0x0c, 0x0f, 0x0f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00,
0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x0f, 0x0f, 0x0c, 0x0c, 0x0f, 0x0f, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00,
0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x7f, 0x7f, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0xf3, 0xf3, 0x73, 0x73, 0x73, 0x73,
0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00,
0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0xfc, 0xfc, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x19, 0x3f, 0x77, 0x63, 0x63, 0x63, 0x77,
0x3f, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7f,
0x63, 0x63, 0x62, 0x66, 0x67, 0x63, 0x61, 0x61,
0x6f, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f,
0x61, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f,
0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x3f,
0x18, 0x0c, 0x06, 0x03, 0x03, 0x06, 0x0c, 0x18,
0x3f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0xc0, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0xc0, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x1f, 0x3f, 0x76, 0x63, 0x61, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00,
0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x73,
0x7f, 0x6d, 0x40, 0x40, 0xc0, 0xc0, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x70, 0xf1, 0x19, 0x0b, 0x0e, 0x0e, 0x0c, 0x0c,
0x0c, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f,
0x0c, 0x3f, 0x7f, 0x61, 0x61, 0x7f, 0x3f, 0x0c,
0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
0x73, 0x61, 0x61, 0x7f, 0x7f, 0x61, 0x61, 0x73,
0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e,
0x33, 0x61, 0x61, 0x61, 0x61, 0x61, 0x21, 0x33,
0x73, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x3f, 0x70, 0x30, 0x18,
0x0e, 0x3f, 0x73, 0x63, 0x63, 0x63, 0x63, 0x63,
0x63, 0x76, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33,
0x7b, 0xcc, 0xcc, 0xcc, 0xcc, 0x7f, 0x77, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0x80, 0xc0, 0xc0, 0xc0,
0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
0x03, 0x1f, 0x37, 0x67, 0x6d, 0x6d, 0x79, 0x7b,
0x3e, 0x30, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80,
0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x3f,
0x70, 0x60, 0x60, 0x7f, 0x7f, 0x60, 0x60, 0x70,
0x3f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33,
0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f,
0x00, 0x00, 0x00, 0x7f, 0x7f, 0x00, 0x00, 0x00,
0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x80,
0x80, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
0x0c, 0x0c, 0x7f, 0x7f, 0x0c, 0x0c, 0x0c, 0x00,
0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
0x1c, 0x07, 0x01, 0x07, 0x1c, 0x70, 0x00, 0x7f,
0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
0x0e, 0x38, 0x60, 0x38, 0x0e, 0x03, 0x00, 0x7f,
0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
0x00, 0x80, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0f, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
0x00, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc,
0xcc, 0xfc, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
0x0c, 0x0c, 0x00, 0x7f, 0x7f, 0x00, 0x0c, 0x0c,
0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xf8, 0xcc,
0xcf, 0xc7, 0x00, 0x00, 0x78, 0xf8, 0xcc, 0xcf,
0xc7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x00, 0x00,
0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x33, 0x33,
0x33, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03,
0x03, 0x03, 0x63, 0x63, 0x73, 0x73, 0x1b, 0x0f,
0x0f, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x33,
0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x13,
0x03, 0x02, 0x0c, 0x1f, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f,
0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x35,
0x31, 0x34, 0x6f, 0x65, 0x6d, 0x00, 0x00, 0x00,
0xe8, 0x01, 0x34, 0x00, 0x56, 0x53, 0x5f, 0x56,
0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x49,
0x4e, 0x46, 0x4f, 0x00, 0xbd, 0x04, 0xef, 0xfe,
0x00, 0x00, 0x01, 0x00, 0x0a, 0x00, 0x03, 0x00,
0x67, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x03, 0x00,
0x67, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x01, 0x00, 0x00, 0x53, 0x74, 0x72, 0x69,
0x6e, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e,
0x66, 0x6f, 0x00, 0x00, 0x66, 0x01, 0x00, 0x00,
0x30, 0x34, 0x30, 0x39, 0x30, 0x34, 0x45, 0x34,
0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x17, 0x00,
0x43, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x4e,
0x61, 0x6d, 0x65, 0x00, 0x4d, 0x69, 0x63, 0x72,
0x6f, 0x73, 0x6f, 0x66, 0x74, 0x20, 0x43, 0x6f,
0x72, 0x70, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f,
0x6e, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x2b, 0x00,
0x46, 0x69, 0x6c, 0x65, 0x44, 0x65, 0x73, 0x63,
0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x00,
0x38, 0x35, 0x31, 0x34, 0x2f, 0x61, 0x20, 0x28,
0x31, 0x30, 0x32, 0x34, 0x78, 0x37, 0x36, 0x38,
0x29, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75,
0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x65, 0x72,
0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x20, 0x66, 0x6f,
0x6e, 0x74, 0x00, 0x00, 0x16, 0x00, 0x06, 0x00,
0x46, 0x69, 0x6c, 0x65, 0x56, 0x65, 0x72, 0x73,
0x69, 0x6f, 0x6e, 0x00, 0x33, 0x2e, 0x31, 0x30,
0x00, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x09, 0x00,
0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
0x4e, 0x61, 0x6d, 0x65, 0x00, 0x00, 0x00, 0x00,
0x4f, 0x45, 0x4d, 0x46, 0x4f, 0x4e, 0x54, 0x53,
0x00, 0x00, 0x00, 0x00, 0x3b, 0x00, 0x27, 0x00,
0x4c, 0x65, 0x67, 0x61, 0x6c, 0x43, 0x6f, 0x70,
0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x00, 0x00,
0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68,
0x74, 0x20, 0xa9, 0x20, 0x4d, 0x69, 0x63, 0x72,
0x6f, 0x73, 0x6f, 0x66, 0x74, 0x20, 0x43, 0x6f,
0x72, 0x70, 0x2e, 0x20, 0x31, 0x39, 0x39, 0x31,
0x2d, 0x31, 0x39, 0x39, 0x32, 0x00, 0x00, 0x00,
0x24, 0x00, 0x0c, 0x00, 0x4f, 0x72, 0x69, 0x67,
0x69, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x65,
0x6e, 0x61, 0x6d, 0x65, 0x00, 0x00, 0x00, 0x00,
0x38, 0x35, 0x31, 0x34, 0x4f, 0x45, 0x4d, 0x2e,
0x46, 0x4f, 0x4e, 0x00, 0x39, 0x00, 0x29, 0x00,
0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4e,
0x61, 0x6d, 0x65, 0x00, 0x4d, 0x69, 0x63, 0x72,
0x6f, 0x73, 0x6f, 0x66, 0x74, 0xae, 0x20, 0x57,
0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x28, 0x54,
0x4d, 0x29, 0x20, 0x4f, 0x70, 0x65, 0x72, 0x61,
0x74, 0x69, 0x6e, 0x67, 0x20, 0x53, 0x79, 0x73,
0x74, 0x65, 0x6d, 0x00, 0x00, 0x00, 0x00, 0x00,
0x1a, 0x00, 0x06, 0x00, 0x50, 0x72, 0x6f, 0x64,
0x75, 0x63, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
0x6f, 0x6e, 0x00, 0x00, 0x33, 0x2e, 0x31, 0x30,
0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00,
0x56, 0x61, 0x72, 0x46, 0x69, 0x6c, 0x65, 0x49,
0x6e, 0x66, 0x6f, 0x00, 0x14, 0x00, 0x04, 0x00,
0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
0x69, 0x6f, 0x6e, 0x00, 0x09, 0x04, 0xe4, 0x04,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

