#ident	"@(#) NEC esmnvram.h 1.1 95/02/20 16:50:43"
/**************************************************************** 
 ******* 	Copyright (C) 1994 NEC Corporation  	  ******* 
 ****************************************************************/

/*******

    File Name:
	
	envram.h  

    Abstract:
 
   	This module contains the definitions for the extended NVRAM.
	
    Author:

	Takehiro Ueda (tueda@oa2.kb.nec.co.jp) 	12/22/1994
 
    Modification History:

    	- M000 12/22/94 -   
		created.
		
*******/



/*******************************************************************************
 ********     NVRAM8KХȡˤեޥåȤʲ˵Ҥ롣     ********
 *******************************************************************************
 *
 *   S001  11/22/94
 *	쥳ɤͭ/̵ե饰Check̤/ѥե饰ƥ쥳ɤƬˤ
 *      ޤȤƥ쥳ɥ꡼Ƭˤǡ쥳ɤνˡѤä
 *	롣ԤϥॢԤϥ󥷥륢ˤय
 *	Ԥѡ
 * 	
 *	ԤƬˤϳƤХȿ򤢤魯
 *
 *	ܻͤˤäƹ¤Τͽꡣ
 *   
 *   S002  11/26/94
 *     	ΰECCϢѥ˥åϢƥ륨顼Ϣetc.
 *   	ƬΥإåNVRAMƬ˰ܤNVRAMƬˤإå
 *	ΰΥ쥳ɤľܥ뤿ΥեåȤĤ褦ˤ롣
 * 
 *      NVRAMΥˤ256Хñ̤ǥХڤ괹ʤ뤿
 *      ƥǡ256ХĹʲΤΡˤ256ХȥХޤʤ褦
 *      θΰECCϢѥ˥åϢetc.ˤƬɬ256Х
 *      Х꤫鳫Ϥ褦ˤ롣
 *
 *	ECC顼SIMM경2ХȤ1ХȤѹ
 *
 *  	ɥեå ɤϤ٤NVRAMƬΥեåȡ
 *
 *   S003  12/13/94
 *	NWȤȥꥨ顼ꥢ̲뤿Ƭ512ХȤ
 *	ꥨ顼ꥢȤեޥåȤNWȤ줹롣
 *
 *  	STEP1ǤϥԤʤܥꥢϻѤʤ
 *	ܥꥨ顼ꥢNWȤȤζ̲Τ˿ߤ
 *	ΤǤꡢECC顼ΰϤΤޤ޻Ĥ롣
 *
 *	512ХȤΥꥢƬߤ뤿ᡢΤ¾Ƥξΰ
 *	512ХȥեåȤ礭ʤ뤳Ȥˤʤ롣
 *
 *	ƥ󥨥ꥢؤΥեå2ХȤɲá
 *
 *	եåȤκƷ׻
 *
 *   S004  12/14/94
 *	¤κ
 *
 *	ǥѥ˥å Ǥǥȥåץ顼 Ǥѹ
 *
 *   S005  12/23/94
 *	4byte alignmentˤʤƥѥǥ󥰤ѹ
 *
 *	ȥåץ顼Υե饰2ӥåȤ˿ɲá
 *
 *      ƥ󥨥ꥢNVRAMإåˤȤꤳࡣ
 *	ˤȤʤƥ󥨥ꥢؤΥեåȤפȤʤ뤿
 *	2Хʬ̤ѤȤ롣
 *
 *	ƥ󥨥ꥢ˥ޥåʥСɲáեޥåȤ̵ͭ
 *	ޥåʥСȥե饰ǥå褦ˤ롣ޥåʥС
 *      0xFF651026Ȥ롣
 *
 *	ǥȥåץ顼 Ǥǥƥ२顼 Ǥѹ
 *
 *   S006  12/27/94
 *	#pragma pack() ɲ
 *
 *      char reserved[49]  char reserved[49] ˽ѹharmlessǤ
 *	ȿ... (^_^;
 *	
 *	unsigned short offset_ecc2err  offset_2biterr˽ѹ
 *	harmlessǤȿ... (^_^;
 *
 ******************************************************************************


 ################### 
 #  NVRAMإå  #
 ###################

     ######################################################
     #  F/Wѥ꡼顼ꥢ (NWȤȶ)  #
     ######################################################

	 512    ꥨ顼쥳(2Х)  256

		 #################### 
  		 #  쥳ɤ  #
		 ####################  

	   	1	ơ 		0:	1:۾(2bit顼̵ͭ)
		    1   1bit顼

 ###################### 
     #  Τ˴ؤ  #
     ######################

	   1	NVRAMξ֤򤢤魯ե饰

	         ##################
		 #  ե饰  #
		 ##################

		0	NVRAMͭ/̵      0:̵	1:ͭ
		  1	եޥåȤ̵ͭ  0:̵ 	1:ͭ
		2	READ-ONLY		0:NO 	1:YES
		3	LOCK			0:NO 	1:YES
		4	[reserved]
		5       
		6       
		7       
	  14	NVRAMեޥåȤ줿ॹ

	   3    [ reserved ]

 ###############################
     #  ALIVEΰ˴ؤ  #
     ###############################

	   2    ALIVEΰؤΥեå

 #######################################
     #  ECC1bit顼ΰ˴ؤ  #
     #######################################

	   2    ECC 1bit顼ƬؤΥեå
	 2    ECC 1bit顼1쥳ɥ
           2    ECC 1bit顼쥳ɿ
	   2    ECC 1bit顼ֺǸϿ쥳ɤؤΥեå
	   4    ֺǸECC1bit顼Υ꡼ɥǡ
	 8	ECC 1bit顼 	 ꥰ롼׿8

 #######################################
     #  ECC2bit顼ΰ˴ؤ  #
     #######################################

	   2    ECC 2bit顼ƬؤΥեå
	 2    ECC 2bit顼1쥳ɥ
           2    ECC 2bit顼쥳ɿ
	   2    ECC 2bit顼ֺǸϿ쥳ɤؤΥեå
           4	ֺǸECCʣbit顼Υ꡼ɥǡ
	   4    SIMM򴹥ե饰		 ꥰ롼׿4

		 ##################
		 #  ե饰  #
		 ##################

		0	롼NSIMM #0 (N=14) 0:OK 1:NG(׸)
		1	롼NSIMM #1    	
		2	롼NSIMM #2	
		3	롼NSIMM #3	
		4	[reserved]
		5	   
		6	   
		7
	   4    [reserved]

 ########################################
 #  ƥ२顼ΰ˴ؤ  #
 ########################################

	   2    ƥ२顼ƬؤΥեå
	 2    ƥ२顼1쥳ɥ
           2    ƥ२顼쥳ɿ
	   2    ƥ२顼ֺǸϿ쥳ɤؤΥեå

 ############################################
 #  ƥ륨顼ΰ˴ؤ  #
     ############################################

	   2    ƥ륨顼ƬؤΥեå
	 2    ƥ륨顼1쥳ɥ
           2    ƥ륨顼쥳ɿ
	   2    ƥ륨顼ֺǸϿ쥳ɤؤΥեå

 ##################################
 #  ;ΰ˴ؤ  #
     ##################################

	   2	;ƬؤΥեå

 ##############################
 #  ꥶΰ˴ؤ  #
     ##############################

	   2	ꥶΰƬؤΥեå


     ########################
     #  ƥ󥨥ꥢ  #
     ########################

   1	ƥξ֤򤢤魯ե饰

	         ##################
		 #  ե饰  #
		 ##################

                    0	[reserved]
		1	
		2	
		3	
		4	
		5	
		6	
		7	
	   3	[reserved]
	  32    ƥξʥƥ̾ 
	   4	ޥ󥷥ꥢʥС
           4	ޥåʥС
           4    [reserved]

-----------------------------------------------------------------------------
TOTAL    640 Х


 #######################################                      
 #  ALIVE, ڡ㡼󥨥ꥢ  #
 #######################################

	   1	ߤ٥
	  16	ALIVE켡
	  16	ALIVE 
          47    [reserved for pager call]

-----------------------------------------------------------------------------
TOTAL     80 Х


 ############################################################################## 
 #  ޤ720ХȡΰƬ256ХȥХ꤫Ϥޤ褦  #
 #  48ХȤ[reserved]Ȥƥѥǥ󥰤롣                                #
 ##############################################################################

	  48	[reserved]


 ####################### 
 # ꥨ顼  #
 #######################

	 400  	1bit顼쥳(25Х)   16

		 ####################
  		 #  쥳ɤ  #
		 ####################

			1ե饰

	        		 ##################
		 		 #  ե饰  #
		 		 ##################

				0	ͭ/̵    0:̵ 1:ͭ
				1	check/̤   0:̤   1:
				2	[reserved]
				3	
				4	
				5	
				6	
				7 
	 		4 	顼ɥ쥹
		       14	ȯॹ
	   		4	ɥ
	 		1	ꥰ롼
	   		1       SIMM
	 100	2bit顼쥳(25Х)  4

		 ####################
  		 #  쥳ɤ  #
		 ####################

			1	ե饰

	        		 ##################
		 		 #  ե饰  #
		 		 ##################

				0	ͭ/̵    0:̵ 1:ͭ
				1	check/̤   0:̤   1:
				2	[reserved]
				3	
				4	
				5	
				6	
				7	
	 		4 	顼ɥ쥹
		       14	ȯॹ
	   		4	ɥ
	 		1	ꥰ롼
	   		1       SIMM

-----------------------------------------------------------------------------
TOTAL    500 Х


 ###############################################################################
 #  ޤ1268ХȡΰƬ256ХȥХ꤫Ϥޤ褦  #
 #  12ХȤ[reserved]Ȥƥѥǥ󥰤롣                                 #
 ###############################################################################

	  12	[reserved]


 ##########################
 #  ƥ२顼  #
 ##########################

	2048	ƥ२顼 (1쥳512Х  4  2K) 

		 ####################
  		 #  쥳ɤ  #
		 ####################

			1	ե饰
	        		
                                 ##################
		 		 #  ե饰  #
		 		 ##################

				0	ͭ/̵    0:̵ 1:ͭ
				1	check/̤   0:̤   1:
				2   Dump/Dump SW 0:D    1:D SW
				3   ̵ͭ   0:̤   1:
				4	boot     0: 1:۾
				5	
				6	
				7	
		       14	ȯॹ
		      496       ƥ२顼
                        1       [reserved]

-----------------------------------------------------------------------------
TOTAL   2048 Х


 ####################################################### 
 #  ޤ3328Хȡ礦256ХȥХ  #
 #######################################################

                       
 ###############################################################
 #  ƥ륨顼 (1쥳128Х  32  4K)  #
 ###############################################################

	4096	ƥ륨顼 (1쥳128Х  32  4K) 

		 ####################
  		 #  쥳ɤ  #
                 ####################

			1	ե饰
	        		 ##################
		 		 #  ե饰  #
		 		 ##################

				0	ͭ/̵    0:̵ 1:ͭ
				1	check/̤   0:̤   1:
				2   Panic/Shutdown 0:P  1:S
				3   [reserved]     
				4	
				5	
				6	
				7	
		       14	ȯॹ
		       20	̾
		       80       ƥ륨顼
                       13       [reserved]

-----------------------------------------------------------------------------
TOTAL   4096 Х


 ####################################################### 
 #  ޤ7424Хȡ礦256ХȥХ  #
 #######################################################


 ##############################
 #  Ƚѥǡΰ  #
 ##############################

       256    [reserved]

-----------------------------------------------------------------------------
TOTAL    256 Х


 ############################################################### 
 #  ޤ7680(7K+512)Хȡ礦256ХȥХ  #
 ###############################################################


 ############################## 
 #  ꥶΰ (512Х)  #
 ##############################
 
	 512 	PAiNTS?
	
-----------------------------------------------------------------------------
TOTAL    512 Х


 #############################################
 #  ޤ8192(8K)ХȡNVRAMΤä  #
 #############################################

******************************************************************************/


#pragma pack(1)

/********************
 *                  *
 *  ¤    *
 *                  *
 ********************/


/*
 *  WAS & PSFWѥꥨ顼ΰ
 */
typedef struct _MEM_ERR_REC {
	unsigned char 	mem_status;  /* ơ */
	unsigned char 	err_count;   /* 1bit顼 */
} MEM_ERR_REC, *pMEM_ERR_REC;


/*
 *  ALIVEΰ˴ؤ
 */
typedef struct _ALIVE_AREA_INFO {
	unsigned short offset_alive;
				/* ALIVE󥨥ꥢեå */
} ALIVE_AREA_INFO, *pALIVE_AREA_INFO;


/*
 *  ECC1bit顼ΰ˴ؤ
 */
typedef struct _ECC1_ERR_AREA_INFO {
	unsigned short offset_1biterr;	/* ꥢƬؤΥեå */
	unsigned short size_rec;	/* 1쥳ɥ */
	unsigned short num_rec;		/* 쥳ɿ */
	unsigned short offset_latest;	/* ǿ쥳ɥեå */
	unsigned long read_data_latest; /* ǿ꡼ɥ顼ǡ */
	unsigned char err_count_group0; /* G#0 顼 */
	unsigned char err_count_group1; /* G#1 顼 */
	unsigned char err_count_group2; /* G#2 顼 */
	unsigned char err_count_group3; /* G#3 顼 */
	unsigned char err_count_group4; /* G#4 顼 */
	unsigned char err_count_group5; /* G#5 顼 */
	unsigned char err_count_group6; /* G#6 顼 */
	unsigned char err_count_group7; /* G#7 顼 */
} ECC1_ERR_AREA_INFO, *pECC1_ERR_AREA_INFO;


/*
 *  ECC2bit顼ΰ˴ؤ
 */
typedef	struct _ECC2_ERR_AREA_INFO {
	unsigned short offset_2biterr;	/* ꥢƬؤΥեå */
	unsigned short size_rec;	/* 1쥳ɥ */
	unsigned short num_rec;		/* 쥳ɿ */
	unsigned short offset_latest;	/* ǿ쥳ɥեå */
	unsigned long read_data_latest; /* ǿ꡼ɥ顼ǡ */
	unsigned char simm_flag_group1; /* G#1SIMMե饰 */
	unsigned char simm_flag_group2; /* G#2SIMMե饰 */
	unsigned char simm_flag_group3; /* G#3SIMMե饰 */
	unsigned char simm_flag_group4; /* G#4SIMMե饰 */
	char reserved[4]; 		/* reserved */
} ECC2_ERR_AREA_INFO, *pECC2_ERR_AREA_INFO;


/*
 *  ƥ२顼ΰ˴ؤ
 */
typedef struct _SYSTEM_ERR_AREA_INFO {
	unsigned short offset_systemerr;/* ꥢƬؤΥեå */
	unsigned short size_rec;	/* 1쥳ɥ */
	unsigned short num_rec;		/* 쥳ɿ */
	unsigned short offset_latest;	/* ǿ쥳ɥեå */
} SYSTEM_ERR_AREA_INFO, *pSYSTEM_ERR_AREA_INFO;


/*
 *  ƥ륨顼ΰ˴ؤ
 */
typedef struct _CRITICAL_ERR_AREA_INFO {
	unsigned short offset_critical;	/* ꥢƬؤΥեå */
	unsigned short size_rec;	/* 1쥳ɥ */
	unsigned short num_rec;		/* 쥳ɿ */
	unsigned short offset_latest;	/* ǿ쥳ɥեå */
} CRITICAL_ERR_AREA_INFO, *pCRITICAL_ERR_AREA_INFO;


/*
 *  ¾ξΰ˴ؤ
 */
typedef struct _MISC_AREA_INFO {
	unsigned short offset_misc; 
			      /* ξ󥨥ꥢƬեå */
} MISC_AREA_INFO, *pMISC_AREA_INFO;


/*
 *  ꥶΰ˴ؤ
 */
typedef struct _RESERVE_AREA_INFO {
	unsigned short offset_reserve; 
				/* ꥶ֥ꥢƬեå */
} RESERVE_AREA_INFO, *pRESERVE_AREA_INFO;


/*
 *  ƥ󥨥ꥢ
 *  49Х
 */

typedef struct _SYS_INFO {		
	unsigned char system_flag;	/* ƥ֥ե饰 */
 	char reserved1[3];		/* 4byte alignmentˤʤ */
	char sys_description[32];	/* ƥξ */
	unsigned long serical_num;  	/* ޥ󥷥ꥢʥС */
	unsigned long magic;		/* ޥåʥС */
 	char reserved2[4];		/* reserved */
} SYS_INFO, *pSYS_INFO;



/* 
 *  NVRAMإå 
 *  640Х
 */

typedef struct _NVRAM_HEADER {
	MEM_ERR_REC mem_err_map[256];   /* ꥨ顼NT&NW̥ꥢ */
	unsigned char nvram_flag;	/* nvramξ֥ե饰 */
	char when_formatted[14];	/* եޥåȥॹ */
	char reserved[3];		/* 4byte alignment ˤʤ */
	ALIVE_AREA_INFO alive;   	/* ALIVE󥨥ꥢ */
	ECC1_ERR_AREA_INFO ecc1bit_err; /* ECC1bit顼󥨥ꥢ */
	ECC2_ERR_AREA_INFO ecc2bit_err; /* ECC2bit顼󥨥ꥢ */
	SYSTEM_ERR_AREA_INFO system_err;/* ƥ२顼󥨥ꥢ */
	CRITICAL_ERR_AREA_INFO critical_err_log; 
					/* ƥ륨顼ꥢ */
	MISC_AREA_INFO misc; 		/* 󥨥ꥢ */
	RESERVE_AREA_INFO reserve; 	/* ꥶ֥ꥢեå */
	SYS_INFO system;		/* ƥ */
} NVRAM_HEADER, *pNVRAM_HEADER;



/*                      
 *  ALIVE, ڡ㡼󥨥ꥢ
 *  80Х
 */

typedef struct _ALIVE_INFO {		
	unsigned char alert_level;	/* ٥륰 */
	char primary_destination[16];	/* 켡ֹ */
	char secondary_destinaiton[16];	/* ֹ */
 	char reserved[47];		/* reserved for pager call */
} ALIVE_INFO, *pALIVE_INFO;


/* 
 *  ޤ720ХȡΰƬ256ХȥХ꤫Ϥޤ褦
 *   48ХȤ[reserved]Ȥƥѥǥ󥰤롣
 */

char reserved[48];


typedef struct _ECC1_ERR_REC {
	unsigned char record_flag;	/* 쥳ɥե饰 */
	unsigned long err_address;	/* 顼ɥ쥹 */
	char when_happened[14];		/* ȯॹ */
	unsigned long syndrome;		/* ɥ */
	unsigned char specified_group;  /* ꥰ롼 */
	unsigned char specified_simm;   /* SIMM */
} ECC1_ERR_REC, *pECC1_ERR_REC;


typedef struct _ECC2_ERR_REC {
	unsigned char record_flag;	/* 쥳ɥե饰 */
	unsigned long err_address;	/* 顼ɥ쥹 */
	char when_happened[14];		/* ȯॹ */
	unsigned long syndrome;		/* ɥ */
	unsigned char specified_group;  /* ꥰ롼 */
	unsigned char specified_simm;   /* SIMM */
} ECC2_ERR_REC, *pECC2_ERR_REC;


/* 
 * ꥨ顼
 *  500 Х
 */

ECC1_ERR_REC ecc1_err_rec_log[16];

ECC2_ERR_REC ecc2_err_rec_log[4];


/* 
 *  ޤ1268ХȡΰƬ256ХȥХ꤫Ϥޤ褦
 *   12ХȤ[reserved]Ȥƥѥǥ󥰤롣
 */

char reserved2[12];


typedef struct _STOP_ERR_REC {
	unsigned char record_flag;	/* 쥳ɥե饰 */
	char when_happened[14];		/* ȯॹ */
	char err_description[496];  	/* ƥ२顼 */
	char reserved[1]; 		/* reserved */
} STOP_ERR_REC, *pSTOP_ERR_REC;

/*
 *  åȥץ顼
 *  2048 Х
 */

STOP_ERR_REC stop_err_rec_log[4];


typedef struct _CRITICAL_ERR_REC {
	unsigned char record_flag;	/* 쥳ɥե饰 */
	char when_happened[14];		/* ȯॹ */
	char source[14];		/* ̾ */
	char err_description[496];  	/* ƥ륨顼 */
	char reserved[13];		/* reserved */
} CRITICAL_ERR_REC, *pCRITICAL;


/*                     
 *  ƥ륨顼 (1쥳128Х  32  4K)
 *  4096Х
 */

CRITICAL_ERR_REC critical_err_rec_log[32];


/*
 *  Ƚǡΰ. 
 *  256Х
 */

char reserved3[256];			/* reserved */


/* 
 *  ꥶΰ(PAiNTS?)
 *  512Х
 */
 
char reserved4[512];			/* reserved for paints ? */

#pragma pack(4)
