//#pragma comment(exestr, "$Header: /usr4/winnt/SOURCES/halpcims/src/hal/halsnipm/mips/RCS/vgadata.h,v 1.3 1995/11/02 11:04:33 flo Exp $")

#define MAX_CRT   0x19
#define GRAPH_MAX 0x9
#define MAX_PALETTE 0x15

// VGA constants

#define REVERSE_ATTRIBUTE 0x17 // white on blue

#define INIT_VGA_FONT()  \
        WRITE_REGISTER_UCHAR(VGA_SEQ_IDX,    0x02); \
        WRITE_REGISTER_UCHAR(VGA_SEQ_DATA,   0x04); \
        WRITE_REGISTER_UCHAR(VGA_SEQ_IDX,    0x04); \
        WRITE_REGISTER_UCHAR(VGA_SEQ_DATA,   0x06); \
        WRITE_REGISTER_UCHAR(VGA_GRAPH_IDX,  0x05); \
        WRITE_REGISTER_UCHAR(VGA_GRAPH_DATA, 0x08); \
        WRITE_REGISTER_UCHAR(VGA_GRAPH_IDX,  0x06); \
        WRITE_REGISTER_UCHAR(VGA_GRAPH_DATA, 0x01);

#define EXIT_VGA_FONT() \
        WRITE_REGISTER_UCHAR(VGA_SEQ_IDX,    0x02);  \
        WRITE_REGISTER_UCHAR(VGA_SEQ_DATA,   0x03);  \
        WRITE_REGISTER_UCHAR(VGA_SEQ_IDX,    0x04);  \
        WRITE_REGISTER_UCHAR(VGA_SEQ_DATA,   0x02);  \
        WRITE_REGISTER_UCHAR(VGA_GRAPH_IDX,  0x04);  \
        WRITE_REGISTER_UCHAR(VGA_GRAPH_DATA, 0x00);  \
        WRITE_REGISTER_UCHAR(VGA_GRAPH_IDX,  0x05);  \
        WRITE_REGISTER_UCHAR(VGA_GRAPH_DATA, 0x10);  \
        WRITE_REGISTER_UCHAR(VGA_GRAPH_IDX,  0x06);  \
        WRITE_REGISTER_UCHAR(VGA_GRAPH_DATA, 0x0e);


//
// Adresses for the Bt485 RamDac on the Orchid VLB  and Diamond Viper board
//

#define Bt485_MASK                   ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c6))
#define Bt485_ADDRRD                 ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c7))
#define Bt485_ADDR                   ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c8))
#define Bt485_DATA                   ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c9))
#define Bt485_CR0                    ((PVOID) ((ULONG)HalpVGAControlBase + 0x43c6))
#define Bt485_ADDRCURRD              ((PVOID) ((ULONG)HalpVGAControlBase + 0x43c7))
#define Bt485_ADDRCUR                ((PVOID) ((ULONG)HalpVGAControlBase + 0x43c8))
#define Bt485_DATACUR                ((PVOID) ((ULONG)HalpVGAControlBase + 0x43c9))
#define Bt485_STATUS                 ((PVOID) ((ULONG)HalpVGAControlBase + 0x83c6))
#define Bt485_CR3                    ((PVOID) ((ULONG)HalpVGAControlBase + 0x83c6))         /* if enabled */
#define Bt485_CURSORRAM              ((PVOID) ((ULONG)HalpVGAControlBase + 0x83c7))
#define Bt485_CR1                    ((PVOID) ((ULONG)HalpVGAControlBase + 0x83c8))
#define Bt485_CR2                    ((PVOID) ((ULONG)HalpVGAControlBase + 0x83c9))
#define Bt485_CURSOR_YL              ((PVOID) ((ULONG)HalpVGAControlBase + 0xc3c6))
#define Bt485_CURSOR_YH              ((PVOID) ((ULONG)HalpVGAControlBase + 0xc3c7))
#define Bt485_CURSOR_XL              ((PVOID) ((ULONG)HalpVGAControlBase + 0xc3c8))
#define Bt485_CURSOR_XH              ((PVOID) ((ULONG)HalpVGAControlBase + 0xc3c9))

// Some VGA Registers

#define  VGA_MISC_READ               ((PVOID) ((ULONG)HalpVGAControlBase + 0x03cc))
#define  VGA_MISC_WRITE              ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c2))
#define  VGA_SEQ_IDX                 ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c4))
#define  VGA_SEQ_DATA                ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c5))
#define  VGA_CRT_IDX                 ((PVOID) ((ULONG)HalpVGAControlBase + 0x03d4))
#define  VGA_CRT_DATA                ((PVOID) ((ULONG)HalpVGAControlBase + 0x03d5))
#define  VGA_ATC_IDX                 ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c0))
#define  VGA_ATC_DATA                ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c0))
#define  VGA_GRAPH_IDX               ((PVOID) ((ULONG)HalpVGAControlBase + 0x03ce))
#define  VGA_GRAPH_DATA              ((PVOID) ((ULONG)HalpVGAControlBase + 0x03cf))
#define  VGA_ATC_FF                  ((PVOID) ((ULONG)HalpVGAControlBase + 0x03da))
#define  VGA_DAC_MASK                ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c6))
#define  VGA_DAC_STATUS              ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c7))
#define  VGA_DAC_WRITE_INDEX         ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c8))
#define  VGA_DAC_DATA                ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c9))
#define  VGA_FEAT_CNTRL              ((PVOID) ((ULONG)HalpVGAControlBase + 0x03ca))
#define  S3_ADVFUNC_CNTL             ((PVOID) ((ULONG)HalpVGAControlBase + 0x4ae8))

// the same registers as offset for use in SetHwMode()

#define  MISC_READ                0x03cc
#define  MISC_WRITE               0x03c2
#define  SEQ_IDX                  0x03c4
#define  SEQ_DATA                 0x03c5
#define  CRT_IDX                  0x03d4
#define  CRT_DATA                 0x03d5
#define  ATC_IDX                  0x03c0
#define  ATC_DATA                 0x03c0
#define  GRAPH_IDX                0x03ce
#define  GRAPH_DATA               0x03cf
#define  ATC_FF                   0x03da
#define  DAC_MASK                 0x03c6
#define  DAC_STATUS               0x03c7
#define  DAC_WRITE_INDEX          0x03c8
#define  DAC_DATA                 0x03c9
#define  FEAT_CNTRL               0x03ca

// S3 Advanced Function control register

#define  ADVFUNC_CNTL             0x4ae8

#define  MAGIC_REG1              0x46e8 
#define  MAGIC_REG2              0x0102 
#define  CIRRUS_MAGIC1           0x03c3 
#define  CIRRUS_MAGIC2           0x0094 

//
// "magic" registers to enable the Video System on VGA 
// for non Intel  Systems
//
#define  VGA_MAGIC_REG1              ((PVOID) ((ULONG)HalpVGAControlBase + 0x46e8))
#define  VGA_MAGIC_REG2              ((PVOID) ((ULONG)HalpVGAControlBase + 0x0102))
#define  CIRRUS_MAGIC_REG1           ((PVOID) ((ULONG)HalpVGAControlBase + 0x03c3))
#define  CIRRUS_MAGIC_REG2           ((PVOID) ((ULONG)HalpVGAControlBase + 0x0094))


UCHAR base_colors[] = {
 0,  0,  0,  // color 0  (black)
 0,  0, 42,  // color 1  (drk. blue)
 0, 42,  0,  // color 2  (olive)
 0, 42, 42,  // color 3  ()
42,  0,  0,  // color 4  (brown)
42,  0, 42,  // color 5  (turquise)
42, 21,  0,  // color 6  (tundra )
63, 63, 63,  // color 7  (lt. grey(42,42,42 but we set it to white)
21, 21, 21,  // color 8  (drk. grey)
21, 21, 63,  // color 9  (blue)
21, 63, 21,  // color 10 (green)
21, 63, 63,  // color 11 (lt. blue)
63,  0,  0,  // color 12 (red)
63,  0, 63,  // color 13 (cyan)
63, 63,  0,  // color 14 (yellow)
63, 63, 63   // color 15 (white)
};

//
// this is an VGA 8x8 font (Codepage 437)
//

UCHAR font_8x8[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //0x00
0x7e, 0x81, 0xa5, 0x81, 0xbd, 0x99, 0x81, 0x7e, //0x01
0x7e, 0xff, 0xdb, 0xff, 0xc3, 0xe7, 0xff, 0x7e, //0x02
0x6c, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00, //0x03
0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x38, 0x10, 0x00, 
0x38, 0x7c, 0x38, 0xfe, 0xfe, 0x7c, 0x38, 0x7c, 
0x10, 0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x38, 0x7c, 
0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 
0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff, 
0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00, 
0xff, 0xc3, 0x99, 0xbd, 0xbd, 0x99, 0xc3, 0xff, 
0x0f, 0x07, 0x0f, 0x7d, 0xcc, 0xcc, 0xcc, 0x78, 
0x3c, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 
0x3f, 0x33, 0x3f, 0x30, 0x30, 0x70, 0xf0, 0xe0, 
0x7f, 0x63, 0x7f, 0x63, 0x63, 0x67, 0xe6, 0xc0, 
0x99, 0x5a, 0x3c, 0xe7, 0xe7, 0x3c, 0x5a, 0x99, 
0x80, 0xe0, 0xf8, 0xfe, 0xf8, 0xe0, 0x80, 0x00, 
0x02, 0x0e, 0x3e, 0xfe, 0x3e, 0x0e, 0x02, 0x00, 
0x18, 0x3c, 0x7e, 0x18, 0x18, 0x7e, 0x3c, 0x18, 
0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x00, 
0x7f, 0xdb, 0xdb, 0x7b, 0x1b, 0x1b, 0x1b, 0x00, 
0x3e, 0x63, 0x38, 0x6c, 0x6c, 0x38, 0xcc, 0x78, 
0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x00, 
0x18, 0x3c, 0x7e, 0x18, 0x7e, 0x3c, 0x18, 0xff, 
0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x00, 
0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 
0x00, 0x18, 0x0c, 0xfe, 0x0c, 0x18, 0x00, 0x00, 
0x00, 0x30, 0x60, 0xfe, 0x60, 0x30, 0x00, 0x00, 
0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 
0x00, 0x24, 0x66, 0xff, 0x66, 0x24, 0x00, 0x00, 
0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0x00, 0x00, 
0x00, 0xff, 0xff, 0x7e, 0x3c, 0x18, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x30, 0x78, 0x78, 0x30, 0x30, 0x00, 0x30, 0x00, 
0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x6c, 0x6c, 0xfe, 0x6c, 0xfe, 0x6c, 0x6c, 0x00, 
0x30, 0x7c, 0xc0, 0x78, 0x0c, 0xf8, 0x30, 0x00, 
0x00, 0xc6, 0xcc, 0x18, 0x30, 0x66, 0xc6, 0x00, 
0x38, 0x6c, 0x38, 0x76, 0xdc, 0xcc, 0x76, 0x00, 
0x60, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x18, 0x30, 0x60, 0x60, 0x60, 0x30, 0x18, 0x00, 
0x60, 0x30, 0x18, 0x18, 0x18, 0x30, 0x60, 0x00, 
0x00, 0x66, 0x3c, 0xff, 0x3c, 0x66, 0x00, 0x00, 
0x00, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x60, 
0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 
0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80, 0x00, 
0x7c, 0xc6, 0xce, 0xde, 0xf6, 0xe6, 0x7c, 0x00, 
0x30, 0x70, 0x30, 0x30, 0x30, 0x30, 0xfc, 0x00, 
0x78, 0xcc, 0x0c, 0x38, 0x60, 0xcc, 0xfc, 0x00, 
0x78, 0xcc, 0x0c, 0x38, 0x0c, 0xcc, 0x78, 0x00, 
0x1c, 0x3c, 0x6c, 0xcc, 0xfe, 0x0c, 0x1e, 0x00, 
0xfc, 0xc0, 0xf8, 0x0c, 0x0c, 0xcc, 0x78, 0x00, 
0x38, 0x60, 0xc0, 0xf8, 0xcc, 0xcc, 0x78, 0x00, 
0xfc, 0xcc, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x00, 
0x78, 0xcc, 0xcc, 0x78, 0xcc, 0xcc, 0x78, 0x00, 
0x78, 0xcc, 0xcc, 0x7c, 0x0c, 0x18, 0x70, 0x00, 
0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 
0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x60, 
0x18, 0x30, 0x60, 0xc0, 0x60, 0x30, 0x18, 0x00, 
0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, // =
0x60, 0x30, 0x18, 0x0c, 0x18, 0x30, 0x60, 0x00, // >
0x78, 0xcc, 0x0c, 0x18, 0x30, 0x00, 0x30, 0x00, // ?
0x7c, 0xc6, 0xde, 0xde, 0xde, 0xc0, 0x78, 0x00, // @
0x30, 0x78, 0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0x00, // A
0xfc, 0x66, 0x66, 0x7c, 0x66, 0x66, 0xfc, 0x00, // B
0x3c, 0x66, 0xc0, 0xc0, 0xc0, 0x66, 0x3c, 0x00, // C
0xf8, 0x6c, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, // D
0xfe, 0x62, 0x68, 0x78, 0x68, 0x62, 0xfe, 0x00, // E
0xfe, 0x62, 0x68, 0x78, 0x68, 0x60, 0xf0, 0x00, 
0x3c, 0x66, 0xc0, 0xc0, 0xce, 0x66, 0x3e, 0x00, 
0xcc, 0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0xcc, 0x00, 
0x78, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00, 
0x1e, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0x78, 0x00, 
0xe6, 0x66, 0x6c, 0x78, 0x6c, 0x66, 0xe6, 0x00, 
0xf0, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00, 
0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc6, 0x00, 
0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0x00, 
0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x00, 
0xfc, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xf0, 0x00, 
0x78, 0xcc, 0xcc, 0xcc, 0xdc, 0x78, 0x1c, 0x00, 
0xfc, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0xe6, 0x00, 
0x78, 0xcc, 0xe0, 0x70, 0x1c, 0xcc, 0x78, 0x00, 
0xfc, 0xb4, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00, 
0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xfc, 0x00, 
0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x30, 0x00, 
0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x00, 
0xc6, 0xc6, 0x6c, 0x38, 0x38, 0x6c, 0xc6, 0x00, 
0xcc, 0xcc, 0xcc, 0x78, 0x30, 0x30, 0x78, 0x00, 
0xfe, 0xc6, 0x8c, 0x18, 0x32, 0x66, 0xfe, 0x00, 
0x78, 0x60, 0x60, 0x60, 0x60, 0x60, 0x78, 0x00, 
0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x02, 0x00, 
0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x00, 
0x10, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00, 
0xe0, 0x60, 0x60, 0x7c, 0x66, 0x66, 0xdc, 0x00, 
0x00, 0x00, 0x78, 0xcc, 0xc0, 0xcc, 0x78, 0x00, 
0x1c, 0x0c, 0x0c, 0x7c, 0xcc, 0xcc, 0x76, 0x00, 
0x00, 0x00, 0x78, 0xcc, 0xfc, 0xc0, 0x78, 0x00, 
0x38, 0x6c, 0x60, 0xf0, 0x60, 0x60, 0xf0, 0x00, 
0x00, 0x00, 0x76, 0xcc, 0xcc, 0x7c, 0x0c, 0xf8, 
0xe0, 0x60, 0x6c, 0x76, 0x66, 0x66, 0xe6, 0x00, 
0x30, 0x00, 0x70, 0x30, 0x30, 0x30, 0x78, 0x00, 
0x0c, 0x00, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0x78, 
0xe0, 0x60, 0x66, 0x6c, 0x78, 0x6c, 0xe6, 0x00, 
0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00, 
0x00, 0x00, 0xcc, 0xfe, 0xfe, 0xd6, 0xc6, 0x00, 
0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0xcc, 0x00, 
0x00, 0x00, 0x78, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 
0x00, 0x00, 0xdc, 0x66, 0x66, 0x7c, 0x60, 0xf0, 
0x00, 0x00, 0x76, 0xcc, 0xcc, 0x7c, 0x0c, 0x1e, 
0x00, 0x00, 0xdc, 0x76, 0x66, 0x60, 0xf0, 0x00, 
0x00, 0x00, 0x7c, 0xc0, 0x78, 0x0c, 0xf8, 0x00, 
0x10, 0x30, 0x7c, 0x30, 0x30, 0x34, 0x18, 0x00, 
0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 
0x00, 0x00, 0xcc, 0xcc, 0xcc, 0x78, 0x30, 0x00, 
0x00, 0x00, 0xc6, 0xd6, 0xfe, 0xfe, 0x6c, 0x00, 
0x00, 0x00, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0x00, 
0x00, 0x00, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xf8, 
0x00, 0x00, 0xfc, 0x98, 0x30, 0x64, 0xfc, 0x00, 
0x1c, 0x30, 0x30, 0xe0, 0x30, 0x30, 0x1c, 0x00, 
0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 
0xe0, 0x30, 0x30, 0x1c, 0x30, 0x30, 0xe0, 0x00, 
0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0x00, 
0x78, 0xcc, 0xc0, 0xcc, 0x78, 0x18, 0x0c, 0x78, // 8 bit codes 0x80
0x00, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0x7e, 0x00, // 0x81 
0x1c, 0x00, 0x78, 0xcc, 0xfc, 0xc0, 0x78, 0x00, // 0x82 
0x7e, 0xc3, 0x3c, 0x06, 0x3e, 0x66, 0x3f, 0x00, // 0x83 
0xcc, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00, // 0x84 
0xe0, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00, // 0x85 
0x30, 0x30, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00, // 0x86a
0x00, 0x00, 0x78, 0xc0, 0xc0, 0x78, 0x0c, 0x38, // 0x87,c
0x7e, 0xc3, 0x3c, 0x66, 0x7e, 0x60, 0x3c, 0x00, // 0x88 
0xcc, 0x00, 0x78, 0xcc, 0xfc, 0xc0, 0x78, 0x00, // 0x89 ..e
0xe0, 0x00, 0x78, 0xcc, 0xfc, 0xc0, 0x78, 0x00, // 0x8a 
0xcc, 0x00, 0x70, 0x30, 0x30, 0x30, 0x78, 0x00, // 0x8b ..i
0x7c, 0xc6, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00, // 0x8c 
0xe0, 0x00, 0x70, 0x30, 0x30, 0x30, 0x78, 0x00, // 0x8d 
0xc6, 0x38, 0x6c, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, // 0x8e 
0x30, 0x30, 0x00, 0x78, 0xcc, 0xfc, 0xcc, 0x00, // 0x8f A
0x1c, 0x00, 0xfc, 0x60, 0x78, 0x60, 0xfc, 0x00, // 0x90
0x00, 0x00, 0x7f, 0x0c, 0x7f, 0xcc, 0x7f, 0x00, // 0x91
0x3e, 0x6c, 0xcc, 0xfe, 0xcc, 0xcc, 0xce, 0x00, // 0x92
0x78, 0xcc, 0x00, 0x78, 0xcc, 0xcc, 0x78, 0x00, // 0x93 
0x00, 0xcc, 0x00, 0x78, 0xcc, 0xcc, 0x78, 0x00, // 0x94 
0x00, 0xe0, 0x00, 0x78, 0xcc, 0xcc, 0x78, 0x00, // 0x95 
0x78, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0x7e, 0x00, // 0x96 
0x00, 0xe0, 0x00, 0xcc, 0xcc, 0xcc, 0x7e, 0x00, // 0x97 
0x00, 0xcc, 0x00, 0xcc, 0xcc, 0x7c, 0x0c, 0xf8, // 0x98 ..y
0xc3, 0x18, 0x3c, 0x66, 0x66, 0x3c, 0x18, 0x00, // 0x99 
0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, // 0x9a 
0x18, 0x18, 0x7e, 0xc0, 0xc0, 0x7e, 0x18, 0x18, // 0x9b
0x38, 0x6c, 0x64, 0xf0, 0x60, 0xe6, 0xfc, 0x00, // 0x9c  
0xcc, 0xcc, 0x78, 0xfc, 0x30, 0xfc, 0x30, 0x30, // 0x9d
0xf8, 0xcc, 0xcc, 0xfa, 0xc6, 0xcf, 0xc6, 0xc7, // 0x9e
0x0e, 0x1b, 0x18, 0x3c, 0x18, 0x18, 0xd8, 0x70, // 0x9f
0x1c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00, 
0x38, 0x00, 0x70, 0x30, 0x30, 0x30, 0x78, 0x00, 
0x00, 0x1c, 0x00, 0x78, 0xcc, 0xcc, 0x78, 0x00, 
0x00, 0x1c, 0x00, 0xcc, 0xcc, 0xcc, 0x7e, 0x00, 
0x00, 0xf8, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0x00, 
0xfc, 0x00, 0xcc, 0xec, 0xfc, 0xdc, 0xcc, 0x00, 
0x3c, 0x6c, 0x6c, 0x3e, 0x00, 0x7e, 0x00, 0x00, 
0x38, 0x6c, 0x6c, 0x38, 0x00, 0x7c, 0x00, 0x00, 
0x30, 0x00, 0x30, 0x60, 0xc0, 0xcc, 0x78, 0x00, 
0x38, 0x74, 0xaa, 0xba, 0xaa, 0x64, 0x38, 0x00,  // (R)
0x00, 0x00, 0x00, 0xfc, 0x0c, 0x0c, 0x00, 0x00, 
0xc3, 0xc6, 0xcc, 0xde, 0x33, 0x66, 0xcc, 0x0f, 
0xc3, 0xc6, 0xcc, 0xdb, 0x37, 0x6f, 0xcf, 0x03, 
0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 
0x00, 0x33, 0x66, 0xcc, 0x66, 0x33, 0x00, 0x00, 
0x00, 0xcc, 0x66, 0x33, 0x66, 0xcc, 0x00, 0x00, 
0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 
0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 
0xdb, 0x77, 0xdb, 0xee, 0xdb, 0x77, 0xdb, 0xee, 
0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 
0x18, 0x18, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18, 
0x36, 0x36, 0x36, 0x36, 0xf6, 0x36, 0x36, 0x36, 
0x00, 0x00, 0x00, 0x00, 0xfe, 0x36, 0x36, 0x36, 
0x3c, 0x42, 0x99, 0xa1, 0xa1, 0x99, 0x42, 0x3c,  // (c)
0x36, 0x36, 0xf6, 0x06, 0xf6, 0x36, 0x36, 0x36, 
0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
0x00, 0x00, 0xfe, 0x06, 0xf6, 0x36, 0x36, 0x36, 
0x36, 0x36, 0xf6, 0x06, 0xfe, 0x00, 0x00, 0x00, 
0x36, 0x36, 0x36, 0x36, 0xfe, 0x00, 0x00, 0x00, 
0x18, 0x18, 0xf8, 0x18, 0xf8, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18, 
0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00, 
0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 
0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 
0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18, 
0x18, 0x18, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 
0x36, 0x36, 0x36, 0x36, 0x37, 0x36, 0x36, 0x36, 
0x36, 0x36, 0x37, 0x30, 0x3f, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x3f, 0x30, 0x37, 0x36, 0x36, 0x36, 
0x36, 0x36, 0xf7, 0x00, 0xff, 0x00, 0x00, 0x00, 
0x00, 0x00, 0xff, 0x00, 0xf7, 0x36, 0x36, 0x36, 
0x36, 0x36, 0x37, 0x30, 0x37, 0x36, 0x36, 0x36, 
0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 
0x36, 0x36, 0xf7, 0x00, 0xf7, 0x36, 0x36, 0x36, 
0x18, 0x18, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 
0x36, 0x36, 0x36, 0x36, 0xff, 0x00, 0x00, 0x00, 
0x00, 0x00, 0xff, 0x00, 0xff, 0x18, 0x18, 0x18, 
0x00, 0x00, 0x00, 0x00, 0xff, 0x36, 0x36, 0x36, 
0x36, 0x36, 0x36, 0x36, 0x3f, 0x00, 0x00, 0x00, 
0x18, 0x18, 0x1f, 0x18, 0x1f, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 
0x00, 0x00, 0x00, 0x00, 0x3f, 0x36, 0x36, 0x36, 
0x36, 0x36, 0x36, 0x36, 0xff, 0x36, 0x36, 0x36, 
0x18, 0x18, 0xff, 0x18, 0xff, 0x18, 0x18, 0x18, 
0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 
0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x76, 0xdc, 0xc8, 0xdc, 0x76, 0x00, 
0x00, 0x78, 0xcc, 0xf8, 0xcc, 0xf8, 0xc0, 0xc0, 
0x00, 0xfc, 0xcc, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 
0x00, 0xfe, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 
0xfc, 0xcc, 0x60, 0x30, 0x60, 0xcc, 0xfc, 0x00, 
0x00, 0x00, 0x7e, 0xd8, 0xd8, 0xd8, 0x70, 0x00, 
0x00, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0xc0, 
0x00, 0x76, 0xdc, 0x18, 0x18, 0x18, 0x18, 0x00, 
0xfc, 0x30, 0x78, 0xcc, 0xcc, 0x78, 0x30, 0xfc, 
0x38, 0x6c, 0xc6, 0xfe, 0xc6, 0x6c, 0x38, 0x00, 
0x38, 0x6c, 0xc6, 0xc6, 0x6c, 0x6c, 0xee, 0x00, 
0x1c, 0x30, 0x18, 0x7c, 0xcc, 0xcc, 0x78, 0x00, 
0x00, 0x00, 0x7e, 0xdb, 0xdb, 0x7e, 0x00, 0x00, 
0x06, 0x0c, 0x7e, 0xdb, 0xdb, 0x7e, 0x60, 0xc0, 
0x38, 0x60, 0xc0, 0xf8, 0xc0, 0x60, 0x38, 0x00, 
0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x00, 
0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0x00, 
0x30, 0x30, 0xfc, 0x30, 0x30, 0x00, 0xfc, 0x00, 
0x60, 0x30, 0x18, 0x30, 0x60, 0x00, 0xfc, 0x00, 
0x18, 0x30, 0x60, 0x30, 0x18, 0x00, 0xfc, 0x00, 
0x0e, 0x1b, 0x1b, 0x18, 0x18, 0x18, 0x18, 0x18, 
0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0xd8, 0x70, 
0x30, 0x30, 0x00, 0xfc, 0x00, 0x30, 0x30, 0x00, 
0x00, 0x76, 0xdc, 0x00, 0x76, 0xdc, 0x00, 0x00, 
0x38, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 
0x0f, 0x0c, 0x0c, 0x0c, 0xec, 0x6c, 0x3c, 0x1c, 
0x78, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 
0x70, 0x18, 0x30, 0x60, 0x78, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

#define STORM_OFFSET            0x1c00
#define STORM_MISC_W            0x3c2
#define STORM_PCI_OPTION          0x40

#define STORM_RAMDAC_OFFSET        0x3c00
#define STORM_TVP3026_INDEX          0x00
#define STORM_TVP3026_DATA         0x0a

#define STORM_TVP3026_PIX_CLK_DATA    0x2d
#define STORM_TVP3026_MEM_CLK_DATA    0x2e
#define STORM_TVP3026_MCLK_CTL 0x39

#define STORM_TVP3026_PLL_ADDR        0x2c
#define STORM_TVP3026_PLL_RESET        0xff

#define  VGA_CRTCEXT_IDX                ((PVOID) ((ULONG)HalpVGAControlBase + 0x03de))
#define  VGA_CRTCEXT_DATA               ((PVOID) ((ULONG)HalpVGAControlBase + 0x03df))
#define  VGA_CRTCEXT0                    0x00
#define  VGA_CRTCEXT1                    0x01
#define  VGA_CRTCEXT2                    0x02
#define  VGA_CRTCEXT3                    0x03
#define  VGA_CRTCEXT4                    0x04
#define  VGA_CRTCEXT5                    0x05

#define STORM_STATUS            0x214
