/**************************************************************************\

$Header: r:rcs\TABLES.C 1.2 94/09/16 05:28:50 bleblanc Exp $

$Log:	TABLES.C $
 * Revision 1.2  94/09/16  05:28:50  bleblanc
 * modes 0,Z en 8-bit avec PCI_2M enleves
 *
 * Revision 1.1  94/08/22  05:44:29  bleblanc
 * Initial revision
 *

\**************************************************************************/


/*/****************************************************************************
*          name: tables.c
*
*   description: Offscreens and hardware modes definitions
*
*      designed: Benoit Leblanc
* last modified: $Author: bleblanc $
*
*       version: $Id: TABLES.C 1.2 94/09/16 05:28:50 bleblanc Exp $
*
******************************************************************************/

#include "switches.h"
#include "bind.h"
#include "defbind.h"

#ifdef WINDOWS_NT
    #if defined(ALLOC_PRAGMA)
    #pragma data_seg("PAGE")
    #endif
#endif

#define N_VRAM     0    /* normal off screen memory in VRAM, supports block mode */
#define N_DRAM     6    /* normal off screen memory in DRAM, no block mode */
#define Z_VRAM     1    /* z-buffer memory in VRAM, supports block mode */
#define Z_DRAM     7    /* z-buffer memory in DRAM, no block mode */
#define DB_VRAM    8

#define Z          1    /* Z-buffer available */
#define ND      0xc0    /* Not displayable , hw limited */
#define TV      0x02    /* TV Mode */
#define LUT     0x04    /* LUT mode (pseudo color) */
#define M565    0x08    /* Mode 565 XGA */
#define DB      0x10





/* OFFSCREENS DEFINITION */


/*------------------*/
/*** MGA-ULT/ 1Mb ***/
/*------------------*/

OffScrData OffScrFBM_000_A[] = {
/* 640x480/8 */
       N_VRAM, 0,  480, 640, 1158, 0x000000ff, 0,
/* 640x480/16 */
       N_VRAM, 0,  480, 640,  339, 0x0000ffff, 0,
/* 768x576/8 */
       N_VRAM, 0,  576, 768,  789, 0x000000ff, 0,
/* 768x576/16 */
       N_VRAM, 0,  576, 768,  106, 0x0000ffff, 0,
/* 800x600/8 */
       N_VRAM, 0,  600, 800,  710, 0x000000ff, 0,
/* 800x600/16 */
       N_VRAM, 0,  600, 800,   55, 0x0000ffff, 0,
/* 1024x768/8 */
       N_VRAM, 0,  768, 1024, 256, 0x000000ff, 0,
/* 1152x882/8 */
       N_VRAM, 0,  882, 1152,  28, 0x000000ff, 0,
};




/*----------------------------*/
/*** MGA-ULT/ 1Mb INTERLACE ***/
/*----------------------------*/

OffScrData iOffScrFBM_000_A[] = {
/* 640x480/8 */
       N_VRAM,   0,  480,  768,  885, 0x000000ff, 0,
       N_VRAM, 640,    0,  128,  480, 0x000000ff, 0,
/* 640x480/16 */
       N_VRAM,   0,  480,  768,  202, 0x0000ffff, 0,
       N_VRAM, 640,    0,  128,  480, 0x0000ffff, 0,
/* 800x600/8 */
       N_VRAM,   0,  600, 1024,  424, 0x000000ff, 0,
       N_VRAM, 800,    0,  224,  600, 0x000000ff, 0,
};




/*------------------------*/
/*** MGA-ULT/ 2Mb TITAN ***/
/*------------------------*/

OffScrData OffScrFBM_010_A[] = {
/* 640x480/8   */
       N_VRAM, 0,  480,  640, 2796, 0x000000ff, 0,
/* 640x480/16  */
       N_VRAM, 0,  480,  640, 1158, 0x0000ffff, 0,
/* 640x480/32  */
       N_VRAM, 0,  480,  640,  339, 0xffffffff, 0,
       N_VRAM, 0,    0,  640,  480, 0xff000000, 0,
/* 768x576/8   */
       N_VRAM, 0,  576,  768, 2154, 0x000000ff, 0,
/* 768x576/16  */
       N_VRAM, 0,  576,  768,  789, 0x0000ffff, 0,
/* 768x576/32  */
       N_VRAM, 0,  576,  768,  106, 0xffffffff, 0,
       N_VRAM, 0,    0,  768,  576, 0xff000000, 0,
/* 800x600/8   */
       N_VRAM, 0,  600,  800, 2021, 0x000000ff, 0,
/* 800x600/16  */
       N_VRAM, 0,  600,  800,  710, 0x0000ffff, 0,
/* 800x600/32  */
       N_VRAM, 0,  600,  800,   55, 0xffffffff, 0,
       N_VRAM, 0,    0,  800,  600, 0xff000000, 0,
/* 1024x768/8  */
       N_VRAM, 0,  768, 1024, 1280, 0x000000ff, 0,
/* 1024x768/16 */
       N_VRAM, 0,  768, 1024,  256, 0x0000ffff, 0,
/* 1152x882/8  */
       N_VRAM, 0,  882, 1152,  938, 0x000000ff, 0,
/* 1152x882/16 */
       N_VRAM, 0,  882, 1152,   28, 0x0000ffff, 0,
/* 1280x1024/8 */
       N_VRAM, 0, 1024, 1280,  614, 0x000000ff, 0,
/* 1600x1200/8 */
       N_VRAM, 0, 1200, 1600,  110, 0x000000ff, 0
};




/*------------------------------*/
/*** MGA-ULT/ 2Mb INTERLACE   ***/
/*------------------------------*/

OffScrData iOffScrFBM_010_A[] = {
/* 640x480/8   */
       N_VRAM,   0,  480,  768, 2250, 0x000000ff, 0,
       N_VRAM, 640,    0,  128,  480, 0x000000ff, 0,
/* 640x480/16  */
       N_VRAM,   0,  480,  768,  885, 0x0000ffff, 0,
       N_VRAM, 640,    0,  128,  480, 0x0000ffff, 0,
/* 640x480/32  */
       N_VRAM,   0,  480,  768,  202, 0xffffffff, 0,
       N_VRAM, 640,    0,  128,  480, 0xffffffff, 0,
       N_VRAM,   0,    0,  640,  480, 0xff000000, 0,
/* 800x600/8   */
       N_VRAM,   0,  600, 1024, 1448, 0x000000ff, 0,
       N_VRAM, 800,    0,  224,  600, 0x000000ff, 0,
/* 800x600/16  */
       N_VRAM,   0,  600, 1024,  424, 0x0000ffff, 0,
       N_VRAM, 800,    0,  224,  600, 0x0000ffff, 0,
/* 1152x882/8  */
       N_VRAM,   0,  882, 1280,  756, 0x000000ff, 0,
       N_VRAM,1152,    0,  128,  882, 0x000000ff, 0,
};


/*------------------*/
/*** MGA-IMP/ 3Mb ***/
/*------------------*/

OffScrData OffScrFBM_010_B[] = {
/* 640x480/8   */
       N_VRAM, 0,  480,  640, 4435, 0x000000ff, 0,
/* 640x480/8Z  */
       N_VRAM, 0,  480,  640, 2796, 0x000000ff, 0,
       Z_VRAM, 0, 3276,  640,  960, 0x000000ff, 512,
       N_VRAM, 0, 4237,  640,  678, 0x000000ff, 0,
/* 640x480/16  */
       N_VRAM, 0,  480,  640, 1977, 0x0000ffff, 0,
/* 640x480/16Z */
       N_VRAM, 0,  480,  640, 1158, 0x0000ffff, 0,
       Z_VRAM, 0, 1638,  640,  480, 0x0000ffff, 256,
       N_VRAM, 0, 2119,  640,  338, 0x0000ffff, 0,
/* 640x480/32  */
       N_VRAM, 0,  480,  640,  748, 0xffffffff, 0,
       N_VRAM, 0,    0,  640,  480, 0xff000000, 0,
/* 640x480/32Z */
       N_VRAM, 0,  480,  640,  339, 0xffffffff, 0,
       Z_VRAM, 0,  819,  640,  240, 0xffffffff, 128,
       N_VRAM, 0, 1060,  640,  168, 0xffffffff, 0,
       N_VRAM, 0,    0,  640,  480, 0xff000000, 0,
/* 768x576/8   */
       N_VRAM, 0,  576,  768, 3520, 0x000000ff, 0,
/* 768x576/8Z  */
       N_VRAM, 0,  576,  768, 2154, 0x000000ff, 0,
       Z_VRAM, 0, 2730,  768, 1152, 0x000000ff, 512,
       N_VRAM, 0, 3883,  768,  213, 0x000000ff, 0,
/* 768x576/16  */
       N_VRAM, 0,  576,  768, 1472, 0x0000ffff, 0,
/* 768x576/16Z */
       N_VRAM, 0,  576,  768,  789, 0x0000ffff, 0,
       Z_VRAM, 0, 1365,  768,  576, 0x0000ffff, 256,
       N_VRAM, 0, 1942,  768,  106, 0x0000ffff, 0,
/* 768x576/32  */
       N_VRAM, 0,  576,  768,  448, 0xffffffff, 0,
       N_VRAM, 0,    0,  768,  576, 0xff000000, 0,
/* 768x576/32Z */
       Z_VRAM, 0,  682,  768,  288, 0xffffffff, 512,
       N_VRAM, 0,  576,  768,  106, 0xffffffff, 0,
       N_VRAM, 0,  971,  768,   53, 0xffffffff, 0,
       N_VRAM, 0,    0,  768,  576, 0xff000000, 0,
/* 800x600/8   */
       N_VRAM, 0,  600,  800, 3332, 0x000000ff, 0,
/* 800x600/8Z  */
       N_VRAM, 0,  600,  800, 2021, 0x000000ff, 0,
       Z_VRAM, 0, 2621,  800, 1200, 0x000000ff, 352,
       N_VRAM, 0, 3822,  800,  110, 0x000000ff, 0,
/* 800x600/16  */
       N_VRAM, 0,  600,  800, 1366, 0x0000ffff, 0,
/* 800x600/16Z */
       N_VRAM, 0,  600,  800,  710, 0x0000ffff, 0,
       Z_VRAM, 0, 1310,  800,  600, 0x0000ffff, 576,
       N_VRAM, 0, 1911,  800,   55, 0x0000ffff, 0,
/* 800x600/32  */
       N_VRAM, 0,  600,  800,  383, 0xffffffff, 0,
       N_VRAM, 0,    0,  800,  600, 0xff000000, 0,
/* 800x600/32Z */
       Z_VRAM, 0,  655,  800,  300, 0xffffffff, 288,
       N_VRAM, 0,  600,  800,   55, 0xffffffff, 0,
       N_VRAM, 0,  956,  800,   27, 0xffffffff, 0,
       N_VRAM, 0,    0,  800,  600, 0xff000000, 0,
/* 1024x768/8  */
       N_VRAM, 0,  768, 1024, 2304, 0x000000ff, 0,
/* 1024x768/16 */
       N_VRAM, 0,  768, 1024,  768, 0x0000ffff, 0,
/* 1024x768/32 */
       N_VRAM, 0,    0, 1024,  768, 0xff000000, 0,
/* 1152x882/8  */
       N_VRAM, 0,  882, 1152, 1848, 0x000000ff, 0,
/* 1152x882/16 */
       N_VRAM, 0,  882, 1152,  483, 0x0000ffff, 1,
/* 1280x1024/8 */
       N_VRAM, 0, 1024, 1280, 1433, 0x000000ff, 0,
/* 1280x1024/16 */
       N_VRAM, 0, 1024, 1280,  204, 0x0000ffff, 1,
/* 1600x1200/8 */
       N_VRAM, 0, 1200, 1600,  766, 0x000000ff, 1
};

/*----------------------------*/
/*** MGA-IMP/ 3Mb INTERLACE ***/
/*----------------------------*/

OffScrData iOffScrFBM_010_B[] = {
/* 640x480/8   */
       N_VRAM,   0,  480,  768, 3616, 0x000000ff, 0,
       N_VRAM, 640,    0,  128,  480, 0x000000ff, 0,
/* 640x480/8Z  */
       N_VRAM,   0,  480,  768, 2250, 0x000000ff, 0,
       Z_VRAM,   0, 2730,  768,  800, 0x000000ff, 512,
       N_VRAM,   0, 3531,  768,  565, 0x000000ff, 0,
       N_VRAM, 640,    0,  128,  480, 0x000000ff, 0,
/* 640x480/16  */
       N_VRAM,   0,  480,  768, 1568, 0x0000ffff, 0,
       N_VRAM, 640,    0,  128,  480, 0x0000ffff, 0,
/* 640x480/16Z */
       N_VRAM,   0,  480,  768,  885, 0x0000ffff, 0,
       Z_VRAM,   0, 1365,  768,  400, 0x0000ffff, 256,
       N_VRAM,   0, 1766,  768,  282, 0x0000ffff, 0,
       N_VRAM, 640,    0,  128,  480, 0x0000ffff, 0,
/* 640x480/32  */
       N_VRAM,   0,  480,  768,  544, 0xffffffff, 0,
       N_VRAM, 640,    0,  128,  480, 0xffffffff, 0,
       N_VRAM,   0,    0,  640,  480, 0xff000000, 0,
/* 640x480/32Z */
       N_VRAM,   0,  480,  768,  202, 0xffffffff, 0,
       Z_VRAM,   0,  682,  768,  200, 0xffffffff, 512,
       N_VRAM,   0,  883,  768,  141, 0xffffffff, 0,
       N_VRAM, 640,    0,  128,  480, 0xffffffff, 0,
       N_VRAM,   0,    0,  640,  480, 0xff000000, 0,
/* 800x600/8   */
       N_VRAM,   0,  480, 1024, 2472, 0x000000ff, 0,
       N_VRAM, 800,    0,  224,  600, 0x000000ff, 0,
/* 800x600/8Z  */
       N_VRAM,   0,  600, 1024, 1448, 0x000000ff, 0,
       Z_VRAM,   0, 2048, 1024,  937, 0x000000ff, 0,
       N_VRAM,   0, 2986, 1024,   86, 0x000000ff, 0,
       N_VRAM, 800,    0,  224,  600, 0x000000ff, 0,
/* 800x600/16  */
       N_VRAM,   0,  600, 1024,  936, 0x0000ffff, 0,
       N_VRAM, 800,    0,  224,  600, 0x0000ffff, 0,
/* 800x600/16Z */
       Z_VRAM,   0, 1024, 1024,  468, 0x0000ffff, 0,
       N_VRAM,   0,  600, 1024,  424, 0x0000ffff, 0,
       N_VRAM,   0, 1493, 1024,   43, 0x0000ffff, 0,
       N_VRAM, 800,    0,  224,  600, 0x0000ffff, 0,
/* 800x600/32  */
       N_VRAM,   0,  600, 1024,  168, 0xffffffff, 0,
       N_VRAM, 800,    0,  224,  600, 0xffffffff, 0,
       N_VRAM,   0,    0,  800,  600, 0xff000000, 0,
/* 1152x882/8  */
       N_VRAM,   0,  882, 1280, 1575, 0x000000ff, 0,
       N_VRAM,1152,    0,  128,  882, 0x000000ff, 0,
/* 1152x882/16 */
       N_VRAM,   0,  882, 1280,  346, 0x0000ffff, 0,
       N_VRAM,1152,    0,  128,  882, 0x0000ffff, 0
};


/*-------------------------*/
/*** MGA-IMP/ 3Mb with Z ***/
/*-------------------------*/

OffScrData OffScrFBM_011_A[] = {
/* 640x480/8   */
       N_VRAM, 0,  480,  640, 3616, 0x000000ff, 0,
       N_DRAM, 0, 6554,  640, 3276, 0x000000ff, 0,
       N_VRAM, 0, 9831,  640,  818, 0x000000ff, 0,
/* 640x480/8Z  */
       N_VRAM, 0,  480,  640, 3616, 0x000000ff, 0,
       N_DRAM, 0, 7514,  640, 2316, 0x000000ff, 0,
       Z_DRAM, 0, 6553,  640,  960, 0x000000ff, 384,
       N_VRAM, 0, 9831,  640,  818, 0x000000ff, 0,
/* 640x480/16  */
       N_DRAM, 0, 3277,  640, 1638, 0x0000ffff, 0,
       N_VRAM, 0,  480,  640, 1568, 0x0000ffff, 0,
       N_VRAM, 0, 4916,  640,  408, 0x0000ffff, 0,
/* 640x480/16Z */
       N_VRAM, 0,  480,  640, 1568, 0x0000ffff, 0,
       N_DRAM, 0, 3757,  640, 1158, 0x0000ffff, 0,
       Z_DRAM, 0, 3276,  640,  480, 0x0000ffff, 512,
       N_VRAM, 0, 4916,  640,  408, 0x0000ffff, 0,
/* 640x480/32  */
       N_DRAM, 0, 1639,  640,  818, 0xffffffff, 0,
       N_VRAM, 0,  480,  640,  544, 0xffffffff, 0,
       N_VRAM, 0, 2458,  640,  204, 0xffffffff, 0,
       N_VRAM, 0,    0,  640,  480, 0xff000000, 0,
/* 640x480/32Z */
       N_DRAM, 0, 1879,  640,  578, 0xffffffff, 0,
       N_VRAM, 0,  480,  640,  544, 0xffffffff, 0,
       Z_DRAM, 0, 1638,  640,  240, 0xffffffff, 256,
       N_VRAM, 0, 2458,  640,  204, 0xffffffff, 0,
       N_VRAM, 0,    0,  640,  480, 0xff000000, 0,
/* 768x576/8   */
       N_VRAM, 0,  576,  768, 2837, 0x000000ff, 0,
       N_DRAM, 0, 5462,  768, 2730, 0x000000ff, 0,
       N_VRAM, 0, 8192,  768,  682, 0x000000ff, 0,
/* 768x576/8Z  */
       N_VRAM, 0,  576,  768, 2837, 0x000000ff, 0,
       N_DRAM, 0, 6614,  768, 1578, 0x000000ff, 0,
       Z_DRAM, 0, 5461,  768, 1152, 0x000000ff, 256,
       N_VRAM, 0, 8192,  768,  682, 0x000000ff, 0,
/* 768x576/16  */
       N_DRAM, 0, 2731,  768, 1365, 0x0000ffff, 0,
       N_VRAM, 0,  576,  768, 1130, 0x0000ffff, 0,
       N_VRAM, 0, 4096,  768,  341, 0x0000ffff, 0,
/* 768x576/16Z */
       N_VRAM, 0,  576,  768, 1130, 0x0000ffff, 0,
       N_DRAM, 0, 3307,  768,  789, 0x0000ffff, 0,
       Z_DRAM, 0, 2730,  768,  576, 0x0000ffff, 512,
       N_VRAM, 0, 4096,  768,  341, 0x0000ffff, 0,
/* 768x576/32  */
       N_DRAM, 0, 1366,  768,  682, 0xffffffff, 0,
       N_VRAM, 0,  576,  768,  277, 0xffffffff, 0,
       N_VRAM, 0, 2048,  768,  170, 0xffffffff, 0,
       N_VRAM, 0,    0,  768,  576, 0xff000000, 0,
/* 768x576/32Z */
       N_DRAM, 0, 1654,  768,  394, 0xffffffff, 0,
       Z_DRAM, 0, 1365,  768,  288, 0xffffffff, 256,
       N_VRAM, 0,  576,  768,  277, 0xffffffff, 0,
       N_VRAM, 0, 2048,  768,  170, 0xffffffff, 0,
       N_VRAM, 0,    0,  768,  576, 0xff000000, 0,
/* 800x600/8   */
       N_VRAM, 0,  600,  800, 2676, 0x000000ff, 0,
       N_DRAM, 0, 5243,  800, 2621, 0x000000ff, 0,
       N_VRAM, 0, 7865,  800,  654, 0x000000ff, 0,
/* 800x600/8Z  */
       N_VRAM, 0,  600,  800, 2676, 0x000000ff, 0,
       N_DRAM, 0, 6443,  800, 1421, 0x000000ff, 0,
       Z_DRAM, 0, 5242,  800, 1200, 0x000000ff, 704,
       N_VRAM, 0, 7865,  800,  654, 0x000000ff, 0,
/* 800x600/16  */
       N_DRAM, 0, 2622,  800, 1310, 0x0000ffff, 0,
       N_VRAM, 0,  600,  800, 1038, 0x0000ffff, 0,
       N_VRAM, 0, 3933,  800,  326, 0x0000ffff, 0,
/* 800x600/16Z */
       N_VRAM, 0,  600,  800, 1038, 0x0000ffff, 0,
       N_DRAM, 0, 3222,  800,  710, 0x0000ffff, 0,
       Z_DRAM, 0, 2621,  800,  600, 0x0000ffff, 352,
       N_VRAM, 0, 3933,  800,  326, 0x0000ffff, 0,
/* 800x600/32  */
       N_DRAM, 0, 1311,  800,  655, 0xffffffff, 0,
       N_VRAM, 0,  600,  800,  219, 0xffffffff, 0,
       N_VRAM, 0, 1967,  800,  162, 0xffffffff, 0,
       N_VRAM, 0,    0,  800,  600, 0xff000000, 0,
/* 800x600/32Z */
       N_DRAM, 0, 1611,  800,  355, 0xffffffff, 0,
       Z_DRAM, 0, 1310,  800,  300, 0xffffffff, 576,
       N_VRAM, 0,  600,  800,  219, 0xffffffff, 0,
       N_VRAM, 0, 1967,  800,  162, 0xffffffff, 0,
       N_VRAM, 0,    0,  800,  600, 0xff000000, 0,
/* 1024x768/8  */
       N_DRAM, 0, 4096, 1024, 2048, 0x000000ff, 0,
       N_VRAM, 0,  768, 1024, 1792, 0x000000ff, 0,
       N_VRAM, 0, 6144, 1024,  512, 0x000000ff, 0,
/* 1024x768/8Z */
       N_VRAM, 0,  768, 1024, 1792, 0x000000ff, 0,
       Z_DRAM, 0, 4096, 1024, 1536, 0x000000ff, 0,
       N_VRAM, 0, 6144, 1024,  512, 0x000000ff, 0,
       N_DRAM, 0, 5632, 1024,  512, 0x000000ff, 0,
/* 1024x768/16 */
       N_DRAM, 0, 2048, 1024, 1024, 0x0000ffff, 0,
       N_VRAM, 0,  768, 1024,  512, 0x0000ffff, 0,
       N_VRAM, 0, 3072, 1024,  256, 0x0000ffff, 0,
/* 1024x768/16Z*/
       Z_DRAM, 0, 2048, 1024,  768, 0x0000ffff, 0,
       N_VRAM, 0,  768, 1024,  512, 0x0000ffff, 0,
       N_VRAM, 0, 3072, 1024,  256, 0x0000ffff, 0,
       N_DRAM, 0, 2816, 1024,  256, 0x0000ffff, 0,
/* 1024x768/32*/
       N_DRAM, 0, 1024, 1024,  512, 0xffffffff, 0,
       N_VRAM, 0,    0, 1024,  768, 0xff000000, 0,
/* 1152x882/8  */
       N_DRAM, 0, 3641, 1152, 1820, 0x000000ff, 0,
       N_VRAM, 0,  882, 1152, 1393, 0x000000ff, 0,
       N_VRAM, 0, 5462, 1152,  454, 0x000000ff, 0,
/* 1152x882/8Z */
       Z_DRAM, 0, 3640, 1152, 1764, 0x000000ff, 1024,
       N_VRAM, 0,  882, 1152, 1393, 0x000000ff, 0,
       N_VRAM, 0, 5462, 1152,  454, 0x000000ff, 0,
       N_DRAM, 0, 5405, 1152,   56, 0x000000ff, 0,
/* 1152x882/16 */
       N_DRAM, 0, 1821, 1152,  909, 0x0000ffff, 0,
       N_VRAM, 0,  882, 1152,  255, 0x0000ffff, 0,
       N_VRAM, 0, 2731, 1152,  227, 0x0000ffff, 0,
/* 1152x882/16Z*/
       Z_DRAM, 0, 1820, 1152,  882, 0x0000ffff, 512,
       N_VRAM, 0,  882, 1152,  255, 0x0000ffff, 0,
       N_VRAM, 0, 2731, 1152,  227, 0x0000ffff, 0,
       N_DRAM, 0, 2703, 1152,   27, 0x0000ffff, 0,
/* 1280x1024/8 */
       N_DRAM, 0, 3277, 1280, 1638, 0x000000ff, 0,
       N_VRAM, 0, 1024, 1280, 1024, 0x000000ff, 0,
       N_VRAM, 0, 4916, 1280,  408, 0x000000ff, 0,
/* 1280x1024/8Z*/
       N_VRAM, 0, 1024, 1280, 1024, 0x000000ff, 0,
/* 1280x1024/16 */
       N_DRAM, 0, 1639, 1280,  818, 0x0000ffff, 0,
       N_VRAM, 0, 2458, 1280,  204, 0x0000ffff, 0,
/* 1280x1024/16Z */
       {(word) -1},
/* 1600x1200/8 */
       N_DRAM, 0, 2622, 1600, 1310, 0x000000ff, 0,
       N_VRAM, 0, 1200, 1600,  438, 0x000000ff, 0,
       N_VRAM, 0, 3933, 1600,  326, 0x000000ff, 0
};


/*------------------------------------*/
/*** MGA-IMP/ 3Mb with Z  INTERLACE ***/
/*------------------------------------*/

OffScrData iOffScrFBM_011_A[] = {
/* 640x480/8   */
       N_VRAM,   0,  480,  768, 2933, 0x000000ff, 0,
       N_DRAM,   0, 5462,  768, 2730, 0x000000ff, 0,
       N_VRAM,   0, 8192,  768,  682, 0x000000ff, 0,
       N_VRAM, 640,    0,  128,  480, 0x000000ff, 0,
/* 640x480/8Z  */
       N_VRAM,   0,  480,  768, 2933, 0x000000ff, 0,
       N_DRAM,   0, 6262,  768, 1930, 0x000000ff, 0,
       Z_DRAM,   0, 5462,  768,  800, 0x000000ff, 256,
       N_VRAM,   0, 8192,  768,  682, 0x000000ff, 0,
       N_VRAM, 640,    0,  128,  480, 0x000000ff, 0,
/* 640x480/16  */
       N_DRAM,   0, 2731,  768, 1365, 0x0000ffff, 0,
       N_VRAM,   0,  480,  768, 1226, 0x0000ffff, 0,
       N_VRAM,   0, 4096,  768,  341, 0x0000ffff, 0,
       N_VRAM, 640,    0,  128,  480, 0x0000ffff, 0,
/* 640x480/16Z */
       N_VRAM,   0,  480,  768, 1226, 0x0000ffff, 0,
       N_DRAM,   0, 3131,  768,  965, 0x0000ffff, 0,
       Z_DRAM,   0, 2731,  768,  400, 0x0000ffff, 512,
       N_VRAM,   0, 4096,  768,  341, 0x0000ffff, 0,
       N_VRAM, 640,    0,  128,  480, 0x0000ffff, 0,
/* 640x480/32  */
       N_DRAM,   0, 1366,  768,  682, 0xffffffff, 0,
       N_VRAM,   0,  480,  768,  373, 0xffffffff, 0,
       N_VRAM,   0, 2048,  768,  170, 0xffffffff, 0,
       N_VRAM, 640,    0,  128,  480, 0xffffffff, 0,
       N_VRAM,   0,    0,  640,  480, 0xff000000, 0,
/* 640x480/32Z */
       N_DRAM,   0, 1566,  768,  482, 0xffffffff, 0,
       N_VRAM,   0,  480,  768,  373, 0xffffffff, 0,
       Z_DRAM,   0, 1365,  768,  200, 0xffffffff, 256,
       N_VRAM,   0, 2048,  768,  170, 0xffffffff, 0,
       N_VRAM, 640,    0,  128,  480, 0xffffffff, 0,
       N_VRAM,   0,    0,  640,  480, 0xff000000, 0,
/* 800x600/8   */
       N_DRAM,   0, 4096, 1024, 2048, 0x000000ff, 0,
       N_VRAM,   0,  600, 1024, 1960, 0x000000ff, 0,
       N_VRAM,   0, 6144, 1024,  512, 0x000000ff, 0,
       N_VRAM, 800,    0,  224,  600, 0x000000ff, 0,
/* 800x600/8Z  */
       N_VRAM,   0,  600, 1024, 1960, 0x000000ff, 0,
       N_DRAM,   0, 5034, 1024, 1110, 0x000000ff, 0,
       Z_DRAM,   0, 4096, 1024,  937, 0x000000ff, 0,
       N_VRAM,   0, 6144, 1024,  512, 0x000000ff, 0,
       N_VRAM, 800,    0,  224,  600, 0x000000ff, 0,
/* 800x600/16  */
       N_DRAM,   0, 2048, 1024, 1024, 0x0000ffff, 0,
       N_VRAM,   0,  600, 1024,  680, 0x0000ffff, 0,
       N_VRAM,   0, 3072, 1024,  256, 0x0000ffff, 0,
       N_VRAM, 800,    0,  224,  600, 0x0000ffff, 0,
/* 800x600/16Z */
       N_VRAM,   0,  600, 1024,  680, 0x0000ffff, 0,
       N_DRAM,   0, 2517, 1024,  555, 0x0000ffff, 0,
       Z_DRAM,   0, 2048, 1024,  468, 0x0000ffff, 0,
       N_VRAM,   0, 3072, 1024,  256, 0x0000ffff, 0,
       N_VRAM, 800,    0,  224,  600, 0x0000ffff, 0,
/* 800x600/32  */
       N_DRAM,   0, 1024, 1024,  512, 0xffffffff, 0,
       N_VRAM,   0, 1536, 1024,  128, 0xffffffff, 0,
       N_VRAM,   0,  600, 1024,   40, 0xffffffff, 0,
       N_VRAM, 800,    0,  224,  600, 0xffffffff, 0,
       N_VRAM,   0,    0,  800,  600, 0xff000000, 0,
/* 800x600/32Z */
       N_DRAM,   0, 1259, 1024,  277, 0xffffffff, 0,
       Z_DRAM,   0, 1024, 1024,  234, 0xffffffff, 0,
       N_VRAM,   0, 1536, 1024,  128, 0xffffffff, 0,
       N_VRAM,   0,  600, 1024,   40, 0xffffffff, 0,
       N_VRAM, 800,    0,  224,  600, 0xffffffff, 0,
       N_VRAM,   0,    0,  800,  600, 0xff000000, 0,
/* 1152x882/8  */
       N_DRAM,   0, 3277, 1280, 1638, 0x000000ff, 0,
       N_VRAM,   0,  882, 1280, 1166, 0x000000ff, 0,
       N_VRAM,   0, 4916, 1280,  408, 0x000000ff, 0,
       N_VRAM,1152,    0,  128,  882, 0x000000ff, 0,
/* 1152x882/8Z */
       Z_DRAM,   0, 2048, 1280, 1587, 0x000000ff, 1024,
       N_VRAM,   0,  882, 1280, 1166, 0x000000ff, 0,
       N_VRAM,   0, 4916, 1280,  408, 0x000000ff, 0,
       N_DRAM,   0, 4865, 1280,   50, 0x000000ff, 0,
       N_VRAM,1152,    0,  128,  882, 0x000000ff, 0,
/* 1152x882/16 */
       N_DRAM,   0, 1639, 1280,  818, 0x0000ffff, 0,
       N_VRAM,   0, 2458, 1280,  204, 0x0000ffff, 0,
       N_VRAM,   0,  882, 1280,  142, 0x0000ffff, 0,
       N_VRAM,1152,    0,  128,  882, 0x0000ffff, 0,
/* 1152x882/16Z*/
       Z_DRAM,   0, 1638, 1280,  793, 0x0000ffff, 512,
       N_VRAM,   0, 2458, 1280,  204, 0x0000ffff, 0,
       N_VRAM,   0,  882, 1280,  142, 0x0000ffff, 0,
       N_DRAM,   0, 2433, 1280,   24, 0x0000ffff, 0,
       N_VRAM,1152,    0,  128,  882, 0x0000ffff, 0
};


/*--------------------------*/
/*** MGA-PRO/4/V (4.5Meg) ***/
/*--------------------------*/

OffScrData OffScrFBM_101_B[] = {
/* 640x480/24 */
       N_VRAM, 0,  480,  640, 1772, 0x00ffffff, 0,
       N_DRAM, 0, 2253,  640,  204, 0xffffffff, 0,
/* 768x576/24 */
       N_VRAM, 0,  576,  768, 1301, 0x00ffffff, 0,
       N_DRAM, 0, 1878,  768,  170, 0xffffffff, 0,
/* 800x600/24 */
       N_VRAM, 0,  600,  800, 1202, 0x00ffffff, 0,
       N_DRAM, 0, 1803,  800,  163, 0xffffffff, 0,
/* 1024x768/24 */
       N_VRAM, 0,  768, 1024,  640, 0x00ffffff, 0,
       N_DRAM, 0, 1408, 1024,  128, 0xffffffff, 0,
/* 1152x882/24 */
       N_VRAM, 0,  882, 1152,  369, 0x00ffffff, 0,
       N_DRAM, 0, 1252, 1152,  113, 0xffffffff, 0,
/* 1280x1024/24 */
       N_VRAM, 0, 1024, 1280,  102, 0x00ffffff, 0,
       N_DRAM, 0, 1127, 1280,  101, 0xffffffff, 0
};



/*------------------------------------*/
/*** MGA-PRO/4/V (4.5Meg) INTERLACE ***/
/*------------------------------------*/

OffScrData iOffScrFBM_101_B[] = {
/* 640x480/24 */
       N_VRAM,    0,  480,  768, 1397, 0x00ffffff, 0,
       N_DRAM,    0, 1878,  768,  170, 0xffffffff, 0,
       N_VRAM,  640,    0,  128,  480, 0x00ffffff, 0,
/* 800x600/24 */
       N_VRAM,    0,  600, 1024,  808, 0x00ffffff, 0,
       N_DRAM,    0, 1408, 1024,  128, 0xffffffff, 0,
       N_VRAM,  800,    0,  224,  600, 0x00ffffff, 0,
/* 1152x882/24 */
       N_VRAM,    0,  882, 1280,  244, 0x00ffffff, 0,
       N_DRAM,    0, 1127, 1280,  101, 0xffffffff, 0,
       N_VRAM, 1152,    0,  128,  882, 0x00ffffff, 0
};



/*-----------------------------------------*/
/*** MGA-PRO/4Z/V (4.5Mb + 4Mb Z-buffer) ***/
/*-----------------------------------------*/

OffScrData OffScrFBM_111_A[] = {
/* 640x480/24 */
       N_VRAM, 0,  480,  640, 1977, 0x00ffffff, 0,
       N_DRAM, 0, 2458,  640, 1638, 0xffffffff, 0,
/* 640x480/24Z */
       N_VRAM, 0,  480,  640, 1977, 0x00ffffff, 0,
       N_DRAM, 0, 2698,  640, 1398, 0xffffffff, 0,
       Z_DRAM, 0, 2458,  640,  239, 0xffffffff, 0,
/* 768x576/24 */
       N_VRAM, 0,  576,  768, 1472, 0x00ffffff, 0,
       N_DRAM, 0, 2048,  768, 1365, 0xffffffff, 0,
/* 768x576/24Z */
       N_VRAM, 0,  576,  768, 1472, 0x00ffffff, 0,
       N_DRAM, 0, 2336,  768, 1077, 0xffffffff, 0,
       Z_DRAM, 0, 2048,  768,  288, 0xffffffff, 0,
/* 800x600/24 */
       N_VRAM, 0,  600,  800, 1366, 0x00ffffff, 0,
       N_DRAM, 0, 1967,  800, 1309, 0xffffffff, 0,
/* 800x600/24Z */
       N_VRAM, 0,  600,  800, 1366, 0x00ffffff, 0,
       N_DRAM, 0, 2267,  800, 1009, 0xffffffff, 0,
       Z_DRAM, 0, 1967,  800,  299, 0xffffffff, 0,
/* 1024x768/24 */
       N_DRAM, 0, 1536, 1024, 1024, 0xffffffff, 0,
       N_VRAM, 0,  768, 1024,  768, 0x00ffffff, 0,
/* 1024x768/24Z */
       N_VRAM, 0,  768, 1024,  768, 0x00ffffff, 0,
       N_DRAM, 0, 1920, 1024,  640, 0xffffffff, 0,
       Z_DRAM, 0, 1536, 1024,  384, 0xffffffff, 0,
/* 1152x882/24 */
       N_DRAM, 0, 1366, 1152,  909, 0xffffffff, 0,
       N_VRAM, 0,  882, 1152,  483, 0x00ffffff, 0,
/* 1152x882/24Z */
       N_VRAM, 0,  882, 1152,  483, 0x00ffffff, 0,
       N_DRAM, 0, 1807, 1152,  468, 0xffffffff, 0,
       Z_DRAM, 0, 1366, 1152,  440, 0xffffffff, 0,
/* 1280x1024/24 */
       N_DRAM, 0, 1229, 1280,  819, 0xffffffff, 0,
       N_VRAM, 0, 1024, 1280,  204, 0x00ffffff, 0,
/* 1280x1024/24Z */
       Z_DRAM, 0, 1229, 1280,  511, 0xffffffff, 0,
       N_DRAM, 0, 1741, 1280,  307, 0xffffffff, 0,
       N_VRAM, 0, 1024, 1280,  204, 0x00ffffff, 0
};



/*---------------------------------------------------*/
/*** MGA-PRO/4Z/V (4.5Mb + 4Mb Z-buffer) INTERLACE ***/
/*---------------------------------------------------*/

OffScrData iOffScrFBM_111_A[] = {
/* 640x480/24 */
       N_VRAM,   0,  480,  768, 1568, 0x00ffffff, 0,
       N_DRAM,   0, 2048,  768, 1365, 0xffffffff, 0,
       N_VRAM, 640,    0,  128,  480, 0x00ffffff, 0,
/* 640x480/24Z */
       N_VRAM,   0,  480,  768, 1568, 0x00ffffff, 0,
       N_DRAM,   0, 2248,  768, 1165, 0xffffffff, 0,
       Z_DRAM,   0, 2048,  768,  200, 0xffffffff, 0,
       N_VRAM, 640,    0,  128,  480, 0x00ffffff, 0,
/* 800x600/24 */
       N_DRAM,   0, 1536, 1024, 1024, 0xffffffff, 0,
       N_VRAM,   0,  600, 1024,  936, 0x00ffffff, 0,
       N_VRAM, 800,    0,  224,  600, 0x00ffffff, 0,
/* 800x600/24Z */
       N_VRAM,   0,  600, 1024,  936, 0x00ffffff, 0,
       N_DRAM,   0, 1771, 1024,  789, 0xffffffff, 0,
       Z_DRAM,   0, 1536, 1024,  234, 0xffffffff, 0,
       N_VRAM, 800,    0,  224,  600, 0x00ffffff, 0,
/* 1152x882/24 */
       N_DRAM,   0, 1229, 1280,  819, 0xffffffff, 0,
       N_VRAM,   0,  882, 1280,  346, 0x00ffffff, 0,
       N_VRAM,1152,    0,  128,  882, 0x00ffffff, 0,
/* 1152x882/24Z */
       N_DRAM,   0, 1626, 1280,  422, 0xffffffff, 0,
       Z_DRAM,   0, 1229, 1280,  396, 0xffffffff, 0,
       N_VRAM,   0,  882, 1280,  346, 0x00ffffff, 0,
       N_VRAM,1152,    0,  128,  882, 0x00ffffff, 0
};





/**************************/
/*** HWMODES DEFINITION ***/
/**************************/

/*------------------*/
/*** MGA-ULT/ 1Mb ***/
/*------------------*/

HwModeData HwModesFBM_000_A[21] = {
     640,  480,        DB, 0,  8,      256,  640, 1, &OffScrFBM_000_A[0],
     640,  480,    DB+LUT, 0,  8,      256,  640, 1, &OffScrFBM_000_A[0],
     640,  480,        DB, 0, 16,    32768,  640, 1, &OffScrFBM_000_A[1],
     640,  480,      M565, 0, 16,    65536,  640, 1, &OffScrFBM_000_A[1],
     800,  600,        DB, 0,  8,      256,  800, 1, &OffScrFBM_000_A[4],
     800,  600,    DB+LUT, 0,  8,      256,  800, 1, &OffScrFBM_000_A[4],
     800,  600,        DB, 0, 16,    32768,  800, 1, &OffScrFBM_000_A[5],
     800,  600,      M565, 0, 16,    65536,  800, 1, &OffScrFBM_000_A[5],
    1024,  768,        DB, 0,  8,      256, 1024, 1, &OffScrFBM_000_A[6],
    1024,  768,    DB+LUT, 0,  8,      256, 1024, 1, &OffScrFBM_000_A[6],
    1152,  882,        DB, 0,  8,      256, 1152, 1, &OffScrFBM_000_A[7],
    1152,  882,    DB+LUT, 0,  8,      256, 1152, 1, &OffScrFBM_000_A[7],
     640,  480,     DB+TV, 0,  8,      256,  640, 2, &OffScrFBM_000_A[0],
     640,  480, DB+TV+LUT, 0,  8,      256,  640, 2, &OffScrFBM_000_A[0],
     640,  480,     DB+TV, 0, 16,    32768,  640, 2, &OffScrFBM_000_A[1],
     640,  480,   TV+M565, 0, 16,    65536,  640, 2, &OffScrFBM_000_A[1],
     768,  576,     DB+TV, 0,  8,      256,  768, 1, &OffScrFBM_000_A[2],
     768,  576, DB+TV+LUT, 0,  8,      256,  768, 1, &OffScrFBM_000_A[2],
     768,  576,     DB+TV, 0, 16,    32768,  768, 1, &OffScrFBM_000_A[3],
     768,  576,   TV+M565, 0, 16,    65536,  768, 1, &OffScrFBM_000_A[3],{(word) -1}
};



HwModeInterlace iHwModesFBM_000_A[21] = {

/* 640x480/8         */  768,        DB, 2, &iOffScrFBM_000_A[0],
/* 640x480/8  LUT    */  768,    DB+LUT, 2, &iOffScrFBM_000_A[0],
/* 640x480/16        */  768,        DB, 2, &iOffScrFBM_000_A[2],
/* 640x480/15        */  768,      M565, 2, &iOffScrFBM_000_A[2],
/* 800x600/8         */ 1024,        DB, 2, &iOffScrFBM_000_A[4],
/* 800x600/8  LUT    */ 1024,    DB+LUT, 2, &iOffScrFBM_000_A[4],
/* 800x600/16        */ 1024,     ND+DB, 0, 0,
/* 800x600/15        */ 1024,   ND+M565, 0, 0,
/* 1024x768/8        */  {0},
/* 1024x768/8 LUT    */  {0},
/* 1152x882/8        */ 1280,     ND+DB, 0, 0,
/* 1152x882/8 LUT    */ 1280, ND+DB+LUT, 0, 0,
/* 640x480/8  TV     */  768,     DB+TV, 2, &iOffScrFBM_000_A[0],
/* 640x480/8  TV+LUT */  768, DB+TV+LUT, 2, &iOffScrFBM_000_A[0],
/* 640x480/16 TV     */  768,     DB+TV, 2, &iOffScrFBM_000_A[2],
/* 640x480/15 TV     */  768,   TV+M565, 2, &iOffScrFBM_000_A[2],
/* 768x576/8  TV     */  {0},
/* 768x576/8  TV+LUT */  {0},
/* 768x576/16 TV     */  {0},
/* 768x576/15 TV     */  {0},
                        {(word) -1}
};




/*------------------------*/
/*** MGA-ULT/ 2Mb TITAN ***/
/*------------------------*/

HwModeData HwModesFBM_010_A[34] = {
     640,  480,        DB, 0,  8,      256,  640, 1, &OffScrFBM_010_A[0],
     640,  480,    LUT+DB, 0,  8,      256,  640, 1, &OffScrFBM_010_A[0],
     640,  480,        DB, 0, 16,    32768,  640, 1, &OffScrFBM_010_A[1],
     640,  480,      M565, 0, 16,    65536,  640, 1, &OffScrFBM_010_A[1],
     640,  480,        DB, 0, 32, 16777216,  640, 2, &OffScrFBM_010_A[2],
     800,  600,        DB, 0,  8,      256,  800, 1, &OffScrFBM_010_A[8],
     800,  600,    DB+LUT, 0,  8,      256,  800, 1, &OffScrFBM_010_A[8],
     800,  600,        DB, 0, 16,    32768,  800, 1, &OffScrFBM_010_A[9],
     800,  600,      M565, 0, 16,    65536,  800, 1, &OffScrFBM_010_A[9],
     800,  600,        DB, 0, 32, 16777216,  800, 2, &OffScrFBM_010_A[10],
    1024,  768,        DB, 0,  8,      256, 1024, 1, &OffScrFBM_010_A[12],
    1024,  768,    DB+LUT, 0,  8,      256, 1024, 1, &OffScrFBM_010_A[12],
    1024,  768,        DB, 0, 16,    32768, 1024, 1, &OffScrFBM_010_A[13],
    1024,  768,      M565, 0, 16,    65536, 1024, 1, &OffScrFBM_010_A[13],
    1152,  882,        DB, 0,  8,      256, 1152, 1, &OffScrFBM_010_A[14],
    1152,  882,    DB+LUT, 0,  8,      256, 1152, 1, &OffScrFBM_010_A[14],
    1152,  882,        DB, 0, 16,    32768, 1152, 1, &OffScrFBM_010_A[15],
    1152,  882,      M565, 0, 16,    65536, 1152, 1, &OffScrFBM_010_A[15],
    1280, 1024,        DB, 0,  8,      256, 1280, 1, &OffScrFBM_010_A[16],
    1280, 1024,    DB+LUT, 0,  8,      256, 1280, 1, &OffScrFBM_010_A[16],
    1600, 1200,        DB, 0,  8,      256, 1600, 1, &OffScrFBM_010_A[17],
    1600, 1200,    DB+LUT, 0,  8,      256, 1600, 1, &OffScrFBM_010_A[17],
     640,  480,     TV+DB, 0,  8,      256,  640, 2, &OffScrFBM_010_A[0],
     640,  480, TV+DB+LUT, 0,  8,      256,  640, 2, &OffScrFBM_010_A[0],
     640,  480,     TV+DB, 0, 16,    32768,  640, 2, &OffScrFBM_010_A[1],
     640,  480,   TV+M565, 0, 16,    65536,  640, 2, &OffScrFBM_010_A[1],
     640,  480,     TV+DB, 0, 32, 16777216,  640, 3, &OffScrFBM_010_A[2],
     768,  576,     TV+DB, 0,  8,      256,  768, 1, &OffScrFBM_010_A[4],
     768,  576, TV+DB+LUT, 0,  8,      256,  768, 1, &OffScrFBM_010_A[4],
     768,  576,     TV+DB, 0, 16,    32768,  768, 1, &OffScrFBM_010_A[5],
     768,  576,   TV+M565, 0, 16,    65536,  768, 1, &OffScrFBM_010_A[5],
     768,  576,     TV+DB, 0, 32, 16777216,  768, 2, &OffScrFBM_010_A[6],{(word) -1}
};



HwModeInterlace iHwModesFBM_010_A[34] = {

/* 640x480/8          */     768,        DB, 2, &iOffScrFBM_010_A[0],
/* 640x480/8   LUT    */     768,    DB+LUT, 2, &iOffScrFBM_010_A[0],
/* 640x480/16         */     768,        DB, 2, &iOffScrFBM_010_A[2],
/* 640x480/15         */     768,      M565, 2, &iOffScrFBM_010_A[2],
/* 640x480/32         */     768,        DB, 3, &iOffScrFBM_010_A[4],
/* 800x600/8          */    1024,        DB, 2, &iOffScrFBM_010_A[7],
/* 800x600/8   LUT    */    1024,    DB+LUT, 2, &iOffScrFBM_010_A[7],
/* 800x600/16         */    1024,        DB, 2, &iOffScrFBM_010_A[9],
/* 800x600/15         */    1024,      M565, 2, &iOffScrFBM_010_A[9],
/* 800x600/32         */    1024,     ND+DB, 0, 0,
/* 1024x768/8         */     {0},
/* 1024x768/8  LUT    */     {0},
/* 1024x768/16        */     {0},
/* 1024x768/15        */     {0},
/* 1152x882/8         */    1280,        DB, 2, &iOffScrFBM_010_A[11],
/* 1152x882/8  LUT    */    1280,    DB+LUT, 2, &iOffScrFBM_010_A[11],
/* 1152x882/16        */    1280,     ND+DB, 0, 0,
/* 1152x882/15        */    1280,   ND+M565, 0, 0,
/* 1280x1024/8        */     {0},
/* 1280x1024/8 LUT    */     {0},
/* 1600x1200/8        */    1600,     ND+DB, 0, 0,
/* 1600x1200/8 LUT    */    1600, ND+DB+LUT, 0, 0,
/* 640x480/8   TV     */     768,     TV+DB, 2, &iOffScrFBM_010_A[0],
/* 640x480/8   TV+LUT */     768, TV+DB+LUT, 2, &iOffScrFBM_010_A[0],
/* 640x480/16  TV     */     768,     TV+DB, 2, &iOffScrFBM_010_A[2],
/* 640x480/15  TV     */     768,   TV+M565, 2, &iOffScrFBM_010_A[2],
/* 640x480/32  TV     */     768,     TV+DB, 3, &iOffScrFBM_010_A[4],
/* 768x576/8   TV     */     {0},
/* 768x576/8   TV+LUT */     {0},
/* 768x576/16  TV     */     {0},
/* 768x576/15  TV     */     {0},
/* 768x576/32  TV     */     {0},
                            {(word) -1}
};


/*------------------*/
/*** MGA-IMP/ 3Mb ***/
/*------------------*/

HwModeData HwModesFBM_010_B[48] = {
     640,  480,        DB, 0,  8,      256,  640, 1, &OffScrFBM_010_B[0],
     640,  480,    DB+LUT, 0,  8,      256,  640, 1, &OffScrFBM_010_B[0],
     640,  480,        DB, Z,  8,      256,  640, 3, &OffScrFBM_010_B[1],
     640,  480,        DB, 0, 16,    32768,  640, 1, &OffScrFBM_010_B[4],
     640,  480,      M565, 0, 16,    65536,  640, 1, &OffScrFBM_010_B[4],
     640,  480,        DB, Z, 16,    65536,  640, 3, &OffScrFBM_010_B[5],
     640,  480,        DB, 0, 32, 16777216,  640, 2, &OffScrFBM_010_B[8],
     640,  480,        DB, Z, 32, 16777216,  640, 4, &OffScrFBM_010_B[10],
     800,  600,        DB, 0,  8,      256,  800, 1, &OffScrFBM_010_B[28],
     800,  600,    DB+LUT, 0,  8,      256,  800, 1, &OffScrFBM_010_B[28],
     800,  600,        DB, Z,  8,      256,  800, 3, &OffScrFBM_010_B[29],
     800,  600,        DB, 0, 16,    32768,  800, 1, &OffScrFBM_010_B[32],
     800,  600,      M565, 0, 16,    65536,  800, 1, &OffScrFBM_010_B[32],
     800,  600,        DB, Z, 16,    32768,  800, 3, &OffScrFBM_010_B[33],
     800,  600,        DB, 0, 32, 16777216,  800, 2, &OffScrFBM_010_B[36],
     800,  600,        DB, Z, 32, 16777216,  800, 4, &OffScrFBM_010_B[38],
    1024,  768,        DB, 0,  8,      256, 1024, 1, &OffScrFBM_010_B[42],
    1024,  768,    DB+LUT, 0,  8,      256, 1024, 1, &OffScrFBM_010_B[42],
    1024,  768,        DB, 0, 16,    32768, 1024, 1, &OffScrFBM_010_B[43],
    1024,  768,      M565, 0, 16,    65536, 1024, 1, &OffScrFBM_010_B[43],
    1024,  768,        DB, 0, 32, 16777216, 1024, 1, &OffScrFBM_010_B[44],
    1152,  882,        DB, 0,  8,      256, 1152, 1, &OffScrFBM_010_B[45],
    1152,  882,    DB+LUT, 0,  8,      256, 1152, 1, &OffScrFBM_010_B[45],
    1152,  882,        DB, 0, 16,    32768, 1152, 1, &OffScrFBM_010_B[46],
    1152,  882,      M565, 0, 16,    65536, 1152, 1, &OffScrFBM_010_B[46],
    1280, 1024,        DB, 0,  8,      256, 1280, 1, &OffScrFBM_010_B[47],
    1280, 1024,    DB+LUT, 0,  8,      256, 1280, 1, &OffScrFBM_010_B[47],
    1280, 1024,     ND+DB, 0, 16,    32768, 1280, 1, &OffScrFBM_010_B[48],
    1280, 1024,   ND+M565, 0, 16,    65536, 1280, 1, &OffScrFBM_010_B[48],
    1600, 1200,        DB, 0,  8,      256, 1600, 1, &OffScrFBM_010_B[49],
    1600, 1200,    DB+LUT, 0,  8,      256, 1600, 1, &OffScrFBM_010_B[49],
     640,  480,     TV+DB, 0,  8,      256,  640, 2, &OffScrFBM_010_B[0],
     640,  480, TV+DB+LUT, 0,  8,      256,  640, 2, &OffScrFBM_010_B[0],
     640,  480,     TV+DB, Z,  8,      256,  640, 4, &OffScrFBM_010_B[1],
     640,  480,     TV+DB, 0, 16,    32768,  640, 2, &OffScrFBM_010_B[4],
     640,  480,   TV+M565, 0, 16,    65536,  640, 2, &OffScrFBM_010_B[4],
     640,  480,     TV+DB, Z, 16,    32768,  640, 4, &OffScrFBM_010_B[5],
     640,  480,     TV+DB, 0, 32, 16777216,  640, 3, &OffScrFBM_010_B[8],
     640,  480,     TV+DB, Z, 32, 16777216,  640, 5, &OffScrFBM_010_B[10],
     768,  576,     TV+DB, 0,  8,      256,  768, 1, &OffScrFBM_010_B[14],
     768,  576, TV+DB+LUT, 0,  8,      256,  768, 1, &OffScrFBM_010_B[14],
     768,  576,     TV+DB, Z,  8,      256,  768, 3, &OffScrFBM_010_B[15],
     768,  576,     TV+DB, 0, 16,    32768,  768, 1, &OffScrFBM_010_B[18],
     768,  576,   TV+M565, 0, 16,    65536,  768, 1, &OffScrFBM_010_B[18],
     768,  576,     TV+DB, Z, 16,    32768,  768, 3, &OffScrFBM_010_B[19],
     768,  576,     TV+DB, 0, 32, 16777216,  768, 2, &OffScrFBM_010_B[22],
     768,  576,     TV+DB, Z, 32, 16777216,  768, 4, &OffScrFBM_010_B[24],{(word) -1}
};


/*------------------- ---------*/
/*** MGA-IMP/ 3Mb  INTERLACE ***/
/*-----------------------------*/

HwModeInterlace iHwModesFBM_010_B[48] = {

/* 640X480/8          */     768,        DB, 2, &iOffScrFBM_010_B[0],
/* 640X480/8   LUT    */     768,    DB+LUT, 2, &iOffScrFBM_010_B[0],
/* 640X480/8Z         */     768,        DB, 4, &iOffScrFBM_010_B[2],
/* 640X480/16         */     768,        DB, 2, &iOffScrFBM_010_B[6],
/* 640X480/15         */     768,      M565, 2, &iOffScrFBM_010_B[6],
/* 640X480/16Z        */     768,        DB, 4, &iOffScrFBM_010_B[8],
/* 640X480/32         */     768,        DB, 3, &iOffScrFBM_010_B[12],
/* 640X480/32Z        */     768,        DB, 5, &iOffScrFBM_010_B[15],
/* 800X600/8          */    1024,        DB, 2, &iOffScrFBM_010_B[20],
/* 800X600/8   LUT    */    1024,    DB+LUT, 2, &iOffScrFBM_010_B[20],
/* 800X600/8Z         */    1024,        DB, 4, &iOffScrFBM_010_B[22],
/* 800X600/16         */    1024,        DB, 2, &iOffScrFBM_010_B[26],
/* 800X600/15         */    1024,      M565, 2, &iOffScrFBM_010_B[26],
/* 800X600/16Z        */    1024,        DB, 4, &iOffScrFBM_010_B[28],
/* 800X600/32         */    1024,        DB, 3, &iOffScrFBM_010_B[32],
/* 800X600/32Z        */    1024,     ND+DB, 0, 0,
/* 1024x768/8         */     {0},
/* 1024x768/8  LUT    */     {0},
/* 1024x768/16        */     {0},
/* 1024x768/15        */     {0},
/* 1024x768/32        */     {0},
/* 1152X882/8         */    1280,        DB, 2, &iOffScrFBM_010_B[35],
/* 1152X882/8  LUT    */    1280,    DB+LUT, 2, &iOffScrFBM_010_B[35],
/* 1152X882/16        */    1280,     ND+DB, 0, 0,
/* 1152X882/15        */    1280,   ND+M565, 0, 0,
/* 1280x1024/8        */     {0},
/* 1280x1024/8 LUT    */     {0},
/* 1280x1024/16       */     {0},
/* 1280x1024/15       */     {0},
/* 1600x1200/8        */    1600,     ND+DB, 0, 0,
/* 1600x1200/8 LUT    */    1600, ND+DB+LUT, 0, 0,
/* 640X480/8   TV     */     768,     TV+DB, 2, &iOffScrFBM_010_B[0],
/* 640X480/8   TV+LUT */     768, TV+DB+LUT, 2, &iOffScrFBM_010_B[0],
/* 640X480/8Z  TV     */     768,     TV+DB, 4, &iOffScrFBM_010_B[2],
/* 640X480/16  TV     */     768,     TV+DB, 2, &iOffScrFBM_010_B[6],
/* 640X480/15  TV     */     768,   TV+M565, 2, &iOffScrFBM_010_B[6],
/* 640X480/16Z TV     */     768,     TV+DB, 4, &iOffScrFBM_010_B[8],
/* 640X480/32  TV     */     768,     TV+DB, 3, &iOffScrFBM_010_B[12],
/* 640X480/32Z TV     */     768,     TV+DB, 5, &iOffScrFBM_010_B[15],
/* 768X576/8   TV     */     {0},
/* 768X576/8   TV+LUT */     {0},
/* 768X576/8Z  TV     */     {0},
/* 768X576/16  TV     */     {0},
/* 768X576/15  TV     */     {0},
/* 768X576/16Z TV     */     {0},
/* 768X576/32  TV     */     {0},
/* 768X576/32Z TV     */     {0},
                            {(word) -1}
};


/*-------------------------*/
/*** MGA-IMP/ 3Mb with Z ***/
/*-------------------------*/

HwModeData HwModesFBM_011_A[55] = {
     640,  480,        DB, 0,  8,      256,  640, 3, &OffScrFBM_011_A[0],
     640,  480,    DB+LUT, 0,  8,      256,  640, 3, &OffScrFBM_011_A[0],
     640,  480,        DB, Z,  8,      256,  640, 4, &OffScrFBM_011_A[3],
     640,  480,        DB, 0, 16,    32768,  640, 3, &OffScrFBM_011_A[7],
     640,  480,      M565, 0, 16,    65536,  640, 3, &OffScrFBM_011_A[7],
     640,  480,        DB, Z, 16,    32768,  640, 4, &OffScrFBM_011_A[10],
     640,  480,        DB, 0, 32, 16777216,  640, 4, &OffScrFBM_011_A[14],
     640,  480,        DB, Z, 32, 16777216,  640, 5, &OffScrFBM_011_A[18],
     800,  600,        DB, 0,  8,      256,  800, 3, &OffScrFBM_011_A[46],
     800,  600,    DB+LUT, 0,  8,      256,  800, 3, &OffScrFBM_011_A[46],
     800,  600,        DB, Z,  8,      256,  800, 4, &OffScrFBM_011_A[49],
     800,  600,        DB, 0, 16,    32768,  800, 3, &OffScrFBM_011_A[53],
     800,  600,      M565, 0, 16,    65536,  800, 3, &OffScrFBM_011_A[53],
     800,  600,        DB, Z, 16,    32768,  800, 4, &OffScrFBM_011_A[56],
     800,  600,        DB, 0, 32, 16777216,  800, 4, &OffScrFBM_011_A[60],
     800,  600,        DB, Z, 32, 16777216,  800, 5, &OffScrFBM_011_A[64],
    1024,  768,        DB, 0,  8,      256, 1024, 3, &OffScrFBM_011_A[69],
    1024,  768,    DB+LUT, 0,  8,      256, 1024, 3, &OffScrFBM_011_A[69],
    1024,  768,        DB, Z,  8,      256, 1024, 4, &OffScrFBM_011_A[72],
    1024,  768,        DB, 0, 16,    32768, 1024, 3, &OffScrFBM_011_A[76],
    1024,  768,      M565, 0, 16,    65536, 1024, 3, &OffScrFBM_011_A[76],
    1024,  768,        DB, Z, 16,    32768, 1024, 4, &OffScrFBM_011_A[79],
    1024,  768,        DB, 0, 32, 16777216, 1024, 2, &OffScrFBM_011_A[83],
    1152,  882,        DB, 0,  8,      256, 1152, 3, &OffScrFBM_011_A[85],
    1152,  882,    DB+LUT, 0,  8,      256, 1152, 3, &OffScrFBM_011_A[85],
    1152,  882,        DB, Z,  8,      256, 1152, 4, &OffScrFBM_011_A[88],
    1152,  882,        DB, 0, 16,    32768, 1152, 3, &OffScrFBM_011_A[92],
    1152,  882,      M565, 0, 16,    65536, 1152, 3, &OffScrFBM_011_A[92],
    1152,  882,        DB, Z, 16,    32768, 1152, 4, &OffScrFBM_011_A[95],
    1280, 1024,        DB, 0,  8,      256, 1280, 3, &OffScrFBM_011_A[99],
    1280, 1024,    DB+LUT, 0,  8,      256, 1280, 3, &OffScrFBM_011_A[99],
    1280, 1024,        DB, Z,  8,      256, 1280, 1, &OffScrFBM_011_A[102],
    1280, 1024,     ND+DB, 0, 16,    32768, 1280, 2, &OffScrFBM_011_A[103],
    1280, 1024,   ND+M565, 0, 16,    65536, 1280, 2, &OffScrFBM_011_A[103],
    1280, 1024,     ND+DB, Z, 16,    32768, 1280, 0, &OffScrFBM_011_A[105],
    1600, 1200,        DB, 0,  8,      256, 1600, 3, &OffScrFBM_011_A[106],
    1600, 1200,    DB+LUT, 0,  8,      256, 1600, 3, &OffScrFBM_011_A[106],
     640,  480,     TV+DB, 0,  8,      256,  640, 4, &OffScrFBM_011_A[0],
     640,  480, TV+DB+LUT, 0,  8,      256,  640, 4, &OffScrFBM_011_A[0],
     640,  480,     TV+DB, Z,  8,      256,  640, 5, &OffScrFBM_011_A[3],
     640,  480,     TV+DB, 0, 16,    32768,  640, 4, &OffScrFBM_011_A[7],
     640,  480,   TV+M565, 0, 16,    65536,  640, 4, &OffScrFBM_011_A[7],
     640,  480,     TV+DB, Z, 16,    32768,  640, 5, &OffScrFBM_011_A[10],
     640,  480,     TV+DB, 0, 32, 16777216,  640, 5, &OffScrFBM_011_A[14],
     640,  480,     TV+DB, Z, 32, 16777216,  640, 6, &OffScrFBM_011_A[18],
     768,  576,     TV+DB, 0,  8,      256,  768, 3, &OffScrFBM_011_A[23],
     768,  576, TV+DB+LUT, 0,  8,      256,  768, 3, &OffScrFBM_011_A[23],
     768,  576,     TV+DB, Z,  8,      256,  768, 4, &OffScrFBM_011_A[26],
     768,  576,     TV+DB, 0, 16,    32768,  768, 3, &OffScrFBM_011_A[30],
     768,  576,   TV+M565, 0, 16,    65536,  768, 3, &OffScrFBM_011_A[30],
     768,  576,     TV+DB, Z, 16,    32768,  768, 4, &OffScrFBM_011_A[33],
     768,  576,     TV+DB, 0, 32, 16777216,  768, 4, &OffScrFBM_011_A[37],
     768,  576,     TV+DB, Z, 32, 16777216,  768, 5, &OffScrFBM_011_A[41],{(word) -1}
};


/*------------------------------------*/
/*** MGA-IMP/ 3Mb with Z  INTERLACE ***/
/*------------------------------------*/

HwModeInterlace iHwModesFBM_011_A[55] = {

/* 640X480/8           */     768,        DB, 4, &iOffScrFBM_011_A[0],
/* 640X480/8    LUT    */     768,    DB+LUT, 4, &iOffScrFBM_011_A[0],
/* 640X480/8Z          */     768,        DB, 5, &iOffScrFBM_011_A[4],
/* 640X480/16          */     768,        DB, 4, &iOffScrFBM_011_A[9],
/* 640X480/15          */     768,      M565, 4, &iOffScrFBM_011_A[9],
/* 640X480/16Z         */     768,        DB, 5, &iOffScrFBM_011_A[13],
/* 640X480/32          */     768,        DB, 5, &iOffScrFBM_011_A[18],
/* 640X480/32Z         */     768,        DB, 6, &iOffScrFBM_011_A[23],
/* 800X600/8           */    1024,        DB, 4, &iOffScrFBM_011_A[29],
/* 800X600/8    LUT    */    1024,    DB+LUT, 4, &iOffScrFBM_011_A[29],
/* 800X600/8Z          */    1024,        DB, 5, &iOffScrFBM_011_A[33],
/* 800X600/16          */    1024,        DB, 4, &iOffScrFBM_011_A[38],
/* 800X600/15          */    1024,      M565, 4, &iOffScrFBM_011_A[38],
/* 800X600/16Z         */    1024,        DB, 5, &iOffScrFBM_011_A[42],
/* 800X600/32          */    1024,        DB, 5, &iOffScrFBM_011_A[47],
/* 800X600/32Z         */    1024,        DB, 6, &iOffScrFBM_011_A[52],
/* 1024x768/8          */     {0},
/* 1024x768/8   LUT    */     {0},
/* 1024x768/8Z         */     {0},
/* 1024x768/16         */     {0},
/* 1024x768/15         */     {0},
/* 1024x768/16Z        */     {0},
/* 1024x768/32         */     {0},
/* 1152X882/8          */    1280,        DB, 4, &iOffScrFBM_011_A[58],
/* 1152X882/8   LUT    */    1280,    DB+LUT, 4, &iOffScrFBM_011_A[58],
/* 1152X882/8Z         */    1280,        DB, 5, &iOffScrFBM_011_A[62],
/* 1152X882/16         */    1280,     ND+DB, 0, 0,
/* 1152X882/15         */    1280,   ND+M565, 0, 0,
/* 1152X882/16Z        */    1280,     ND+DB, 0, 0,
/* 1280x1024/8         */     {0},
/* 1280x1024/8  LUT    */     {0},
/* 1280x1024/8Z        */     {0},
/* 1280x1024/16        */     {0},
/* 1280x1024/15        */     {0},
/* 1280x1024/16Z       */     {0},
/* 1600x1200/8         */    1600,     ND+DB, 0, 0,
/* 1600x1200/8  LUT    */    1600, ND+DB+LUT, 0, 0,
/* 640X480/8    TV     */     768,     TV+DB, 4, &iOffScrFBM_011_A[0],
/* 640X480/8    TV+LUT */     768, TV+DB+LUT, 4, &iOffScrFBM_011_A[0],
/* 640X480/8Z   TV     */     768,     TV+DB, 5, &iOffScrFBM_011_A[4],
/* 640X480/16   TV     */     768,     TV+DB, 4, &iOffScrFBM_011_A[9],
/* 640X480/15   TV     */     768,   TV+M565, 4, &iOffScrFBM_011_A[9],
/* 640X480/16Z  TV     */     768,     TV+DB, 5, &iOffScrFBM_011_A[13],
/* 640X480/32   TV     */     768,     TV+DB, 5, &iOffScrFBM_011_A[18],
/* 640X480/32Z  TV     */     768,     TV+DB, 6, &iOffScrFBM_011_A[23],
/* 768X576/8    TV     */     {0},
/* 768X576/8    TV+LUT */     {0},
/* 768X576/8Z   TV     */     {0},
/* 768X576/16   TV     */     {0},
/* 768X576/15   TV     */     {0},
/* 768X576/16Z  TV     */     {0},
/* 768X576/32   TV     */     {0},
/* 768X576/32Z  TV     */     {0},
                             {(word) -1}
};



/*--------------------------*/
/*** MGA-PRO/4/V (4.5Meg) ***/
/*--------------------------*/

HwModeData HwModesFBM_101_B[8] = {
     640,  480,   DB, 0, 32, 16777216,  640, 2, &OffScrFBM_101_B[0],
     800,  600,   DB, 0, 32, 16777216,  800, 2, &OffScrFBM_101_B[4],
    1024,  768,   DB, 0, 32, 16777216, 1024, 2, &OffScrFBM_101_B[6],
    1152,  882,   DB, 0, 32, 16777216, 1152, 2, &OffScrFBM_101_B[8],
    1280, 1024,   DB, 0, 32, 16777216, 1280, 2, &OffScrFBM_101_B[10],
     640,  480,TV+DB, 0, 32, 16777216,  640, 2, &OffScrFBM_101_B[0],
     768,  576,TV+DB, 0, 32, 16777216,  768, 2, &OffScrFBM_101_B[2],{(word) -1}
};



HwModeInterlace iHwModesFBM_101_B[8] = {

/* 640x480/24      */     768,    DB, 3, &iOffScrFBM_101_B[0],
/* 800x600/24      */    1024,    DB, 3, &iOffScrFBM_101_B[3],
/* 1024x768/24     */     {0},
/* 1152x882/24     */    1280,    DB, 3, &iOffScrFBM_101_B[6],
/* 1280x1024/24    */     {0},
/* 640x480/24   TV */     768, TV+DB, 3, &iOffScrFBM_101_B[0],
/* 768x576/24   TV */     {0},
                         {(word) -1}
};


/*-----------------------------------------*/
/*** MGA-PRO/4Z/V (4.5Mb + 4Mb Z-buffer) ***/
/*-----------------------------------------*/

HwModeData HwModesFBM_111_A[15] = {
     640,  480,   DB, 0, 32, 16777216,  640, 2, &OffScrFBM_111_A[0],
     640,  480,   DB, Z, 32, 16777216,  640, 3, &OffScrFBM_111_A[2],
     800,  600,   DB, 0, 32, 16777216,  800, 2, &OffScrFBM_111_A[10],
     800,  600,   DB, Z, 32, 16777216,  800, 3, &OffScrFBM_111_A[12],
    1024,  768,   DB, 0, 32, 16777216, 1024, 2, &OffScrFBM_111_A[15],
    1024,  768,   DB, Z, 32, 16777216, 1024, 3, &OffScrFBM_111_A[17],
    1152,  882,   DB, 0, 32, 16777216, 1152, 2, &OffScrFBM_111_A[20],
    1152,  882,   DB, Z, 32, 16777216, 1152, 3, &OffScrFBM_111_A[22],
    1280, 1024,   DB, 0, 32, 16777216, 1280, 2, &OffScrFBM_111_A[25],
    1280, 1024,   DB, Z, 32, 16777216, 1280, 3, &OffScrFBM_111_A[27],
     640,  480,TV+DB, 0, 32, 16777216,  640, 2, &OffScrFBM_111_A[0],
     640,  480,TV+DB, Z, 32, 16777216,  640, 3, &OffScrFBM_111_A[2],
     768,  576,TV+DB, 0, 32, 16777216,  768, 2, &OffScrFBM_111_A[5],
     768,  576,TV+DB, Z, 32, 16777216,  768, 3, &OffScrFBM_111_A[7],{(word) -1}
};



HwModeInterlace iHwModesFBM_111_A[15] = {

/* 640x480/24       */     768,    DB, 3, &iOffScrFBM_111_A[0],
/* 640x480/24Z      */     768,    DB, 4, &iOffScrFBM_111_A[3],
/* 800x600/24       */    1024,    DB, 3, &iOffScrFBM_111_A[7],
/* 800x600/24Z      */    1024,    DB, 4, &iOffScrFBM_111_A[10],
/* 1024x768/24      */     {0},
/* 1024x768/24Z     */     {0},
/* 1152x882/24      */    1280,    DB, 3, &iOffScrFBM_111_A[14],
/* 1152x882/24Z     */    1280,    DB, 4, &iOffScrFBM_111_A[17],
/* 1280x1024/24     */     {0},
/* 1280x1024/24Z    */     {0},
/* 640x480/24    TV */     768, TV+DB, 3, &iOffScrFBM_111_A[0],
/* 640x480/24Z   TV */     768, TV+DB, 4, &iOffScrFBM_111_A[3],
/* 768x576/24    TV */     {0},
/* 768x576/24Z   TV */     {0},
                          {(word) -1}
};


/*----------------------------------*/
/*** MGA PCI 2Mb (Atlas+Athena) ***/
/*----------------------------------*/

OffScrData OffAth2[] = {
/*  640x 480/ 8 */
 N_VRAM,  0,   480,   640,  2796, 0x000000ff,   0,
/*  640x 480/ 8 DB */
 N_VRAM,  0,   960,   640,  2316, 0x000000ff,   0,
DB_VRAM,  0,   480,   640,   480, 0x000000ff,   0,
/*  640x 480/ 8 DB+Z */
 N_VRAM,  0,   480,   640,   339, 0x0000ffff,   0,
 N_VRAM,  0,  1300,   640,   338, 0x0000ffff,   0,
 Z_VRAM,  0,   819,   640,   480, 0x0000ffff, 128,
/*  640x 480/16 */
 N_VRAM,  0,   480,   640,  1158, 0x0000ffff,   0,
/*  640x 480/16 Z */
 N_VRAM,  0,   480,   640,   339, 0x0000ffff,   0,
 N_VRAM,  0,  1300,   640,   338, 0x0000ffff,   0,
 Z_VRAM,  0,   819,   640,   480, 0x0000ffff, 128,
/*  640x 480/16 DB */
 N_VRAM,  0,   960,   640,   678, 0x0000ffff,   0,
DB_VRAM,  0,   480,   640,   480, 0x0000ffff,   0,
/*  640x 480/32 */
 N_VRAM,  0,   480,   640,   339, 0xffffffff,   0,
 N_VRAM,  0,    0,    480,   640, 0xff000000,   0,
/*  800x 600/ 8 */
 N_VRAM,  0,   600,   800,  2021, 0x000000ff,   0,
/*  800x 600/ 8 DB */
 N_VRAM,  0,  1200,   800,  1421, 0x000000ff,   0,
DB_VRAM,  0,   600,   800,   600, 0x000000ff,   0,
/*  800x 600/ 8 DB+Z */
 N_VRAM,  0,   600,   800,    55, 0x0000ffff,   0,
 N_VRAM,  0,  1256,   800,    54, 0x0000ffff,   0,
 Z_VRAM,  0,   655,   800,   600, 0x0000ffff, 288,
/*  800x 600/16 */
 N_VRAM,  0,   600,   800,   710, 0x0000ffff,   0,
/*  800x 600/16 Z */
 N_VRAM,  0,   600,   800,    55, 0x0000ffff,   0,
 N_VRAM,  0,  1256,   800,    54, 0x0000ffff,   0,
 Z_VRAM,  0,   655,   800,   600, 0x0000ffff, 288,
/*  800x 600/16 DB */
 N_VRAM,  0,  1200,   800,   110, 0x0000ffff,   0,
DB_VRAM,  0,   600,   800,   600, 0x0000ffff,   0,
/*  800x 600/32 */
 N_VRAM,  0,   600,   800,    55, 0xffffffff,   0,
 N_VRAM,  0,    0,    600,   800, 0xff000000,   0,
/* 1024x 768/ 8 */
 N_VRAM,  0,   768,  1024,  1280, 0x000000ff,   0,
/* 1024x 768/ 8 DB */
 N_VRAM,  0,  1536,  1024,   512, 0x000000ff,   0,
DB_VRAM,  0,   768,  1024,   768, 0x000000ff,   0,
/* 1024x 768/16 */
 N_VRAM,  0,   768,  1024,   256, 0x0000ffff,   0,
/* 1152x 882/ 8 */
 N_VRAM,  0,   882,  1152,   938, 0x000000ff,   0,
/* 1152x 882/ 8 DB */
 N_VRAM,  0,  1764,  1152,    56, 0x000000ff,   0,
DB_VRAM,  0,   882,  1152,   882, 0x000000ff,   0,
/* 1152x 882/16 */
 N_VRAM,  0,   882,  1152,    28, 0x0000ffff,   0,
/* 1280x1024/ 8 */
 N_VRAM,  0,  1024,  1280,   614, 0x000000ff,   0,
/* 1600x1200/ 8 */
 N_VRAM,  0,  1200,  1600,   110, 0x000000ff,   0,
/*  768x 576/ 8 */
 N_VRAM,  0,   576,   768,  2154, 0x000000ff,   0,
/*  768x 576/ 8 DB */
 N_VRAM,  0,  1152,   768,  1578, 0x000000ff,   0,
DB_VRAM,  0,   576,   768,   576, 0x000000ff,   0,
/*  768x 576/ 8 DB+Z */
 N_VRAM,  0,   576,   768,   106, 0x0000ffff,   0,
 N_VRAM,  0,  1259,   768,   105, 0x0000ffff,   0,
 Z_VRAM,  0,   682,   768,   576, 0x0000ffff, 512,
/*  768x 576/16 */
 N_VRAM,  0,   576,   768,   789, 0x0000ffff,   0,
/*  768x 576/16 Z */
 N_VRAM,  0,   576,   768,   106, 0x0000ffff,   0,
 N_VRAM,  0,  1259,   768,   105, 0x0000ffff,   0,
 Z_VRAM,  0,   682,   768,   576, 0x0000ffff, 512,
/*  768x 576/16 DB */
 N_VRAM,  0,  1152,   768,   213, 0x0000ffff,   0,
DB_VRAM,  0,   576,   768,   576, 0x0000ffff,   0,
/*  768x 576/32 */
 N_VRAM,  0,   576,   768,   106, 0xffffffff,   0,
 N_VRAM,  0,    0,    576,   768, 0xff000000,   0,
};


/*----------------------------------*/
/*** MGA PCI 2Mb (Atlas+Athena) ***/
/*----------------------------------*/

OffScrData iOffAth2[] = {
/*  640x 480/ 8 */
 N_VRAM,    0,  480,  768, 2250, 0x000000ff,   0,
 N_VRAM,  480,    0,  128,  480, 0x000000ff,   0,
/*  640x 480/ 8 DB */
 N_VRAM,    0,  960,  768, 1770, 0x000000ff,   0,
 N_VRAM,  640,    0,  128,  480, 0x000000ff,   0,
DB_VRAM,    0,  480,  768,  480, 0x000000ff,   0,
/*  640x 480/ 8 DB+Z */
 N_VRAM,    0,  480,  768,  202, 0x0000ffff,   0,
 N_VRAM,    0, 1083,  768,  281, 0x0000ffff,   0,
 N_VRAM,  640,    0,  128,  682, 0x0000ffff,   0,
 N_VRAM,  640, 1083,  128,  281, 0x0000ffff,   0,
 Z_VRAM,    0,  682,  768,  400, 0x0000ffff, 512,
DB_VRAM,    0,  480,  768,  480, 0x0000ffff,   0,
/*  640x 480/16 */
 N_VRAM,    0,  480,  768,  885, 0x0000ffff,   0,
 N_VRAM,  480,    0,  128,  480, 0x0000ffff,   0,
/*  640x 480/16 Z */
 N_VRAM,    0, 1083,  768,  281, 0x0000ffff,   0,
 N_VRAM,    0,  480,  768,  202, 0x0000ffff,   0,
 N_VRAM,  640,    0,  128,  682, 0x0000ffff,   0,
 N_VRAM,  640, 1083,  128,  281, 0x0000ffff,   0,
 Z_VRAM,    0,  682,  768,  400, 0x0000ffff, 512,
/*  640x 480/16 DB */
 N_VRAM,    0,  960,  768,  405, 0x0000ffff,   0,
 N_VRAM,  640,    0,  128,  480, 0x0000ffff,   0,
DB_VRAM,    0,  480,  768,  480, 0x0000ffff,   0,
/*  640x 480/32 */
 N_VRAM,    0,  480,  768,  202, 0xffffffff,   0,
 N_VRAM,  480,    0,  128,  480, 0xffffffff,   0,
 N_VRAM,    0,    0,  480,  768, 0xff000000,   0,
/*  800x 600/ 8 */
 N_VRAM,    0,  600, 1024, 1448, 0x000000ff,   0,
 N_VRAM,  600,    0,  224,  600, 0x000000ff,   0,
/*  800x 600/ 8 DB */
 N_VRAM,    0, 1200, 1024,  848, 0x000000ff,   0,
 N_VRAM,  800,    0,  224,  600, 0x000000ff,   0,
DB_VRAM,    0,  600, 1024,  600, 0x000000ff,   0,
/*  800x 600/16 */
 N_VRAM,    0,  600, 1024,  424, 0x0000ffff,   0,
 N_VRAM,  600,    0,  224,  600, 0x0000ffff,   0,
/* 1024x 768/ 8 */
 N_VRAM,    0,  768, 1024, 1280, 0x000000ff,   0,
 N_VRAM,  768,    0,    0,  768, 0x000000ff,   0,
/* 1024x 768/ 8 DB */
 N_VRAM,    0, 1536, 1024,  512, 0x000000ff,   0,
 N_VRAM, 1024,    0,    0,  768, 0x000000ff,   0,
DB_VRAM,    0,  768, 1024,  768, 0x000000ff,   0,
/* 1024x 768/16 */
 N_VRAM,    0,  768, 1024,  256, 0x0000ffff,   0,
 N_VRAM,  768,    0,    0,  768, 0x0000ffff,   0,
/* 1152x 882/ 8 */
 N_VRAM,    0,  882, 1280,  756, 0x000000ff,   0,
 N_VRAM,  882,    0,  128,  882, 0x000000ff,   0,
/* 1280x1024/ 8 */
 N_VRAM,    0, 1024, 1280,  614, 0x000000ff,   0,
 N_VRAM, 1024,    0,    0, 1024, 0x000000ff,   0,
/* 1600x1200/ 8 */
 N_VRAM,    0, 1200, 1600,  110, 0x000000ff,   0,
 N_VRAM, 1200,    0,    0, 1200, 0x000000ff,   0,
/*  768x 576/ 8 */
 N_VRAM,    0,  576,  768, 2154, 0x000000ff,   0,
 N_VRAM,  576,    0,    0,  576, 0x000000ff,   0,
/*  768x 576/ 8 DB */
 N_VRAM,    0, 1152,  768, 1578, 0x000000ff,   0,
 N_VRAM,  768,    0,    0,  576, 0x000000ff,   0,
DB_VRAM,    0,  576,  768,  576, 0x000000ff,   0,
/*  768x 576/ 8 DB+Z */
 N_VRAM,    0,  576,  768,  106, 0x0000ffff,   0,
 N_VRAM,    0, 1259,  768,  105, 0x0000ffff,   0,
 N_VRAM,  768,    0,    0,  682, 0x0000ffff,   0,
 N_VRAM,  768, 1259,    0,  105, 0x0000ffff,   0,
 Z_VRAM,    0,  682,  768,  576, 0x0000ffff, 512,
DB_VRAM,    0,  576,  768,  576, 0x0000ffff,   0,
/*  768x 576/16 */
 N_VRAM,    0,  576,  768,  789, 0x0000ffff,   0,
 N_VRAM,  576,    0,    0,  576, 0x0000ffff,   0,
/*  768x 576/16 Z */
 N_VRAM,    0, 1259,  768,  105, 0x0000ffff,   0,
 N_VRAM,    0,  576,  768,  106, 0x0000ffff,   0,
 N_VRAM,  768,    0,    0,  682, 0x0000ffff,   0,
 N_VRAM,  768, 1259,    0,  105, 0x0000ffff,   0,
 Z_VRAM,    0,  682,  768,  576, 0x0000ffff, 512,
/*  768x 576/16 DB */
 N_VRAM,    0, 1152,  768,  213, 0x0000ffff,   0,
 N_VRAM,  768,    0,    0,  576, 0x0000ffff,   0,
DB_VRAM,    0,  576,  768,  576, 0x0000ffff,   0,
/*  768x 576/32 */
 N_VRAM,    0,  576,  768,  106, 0xffffffff,   0,
 N_VRAM,  576,    0,    0,  576, 0xffffffff,   0,
 N_VRAM,    0,    0,  576,  768, 0xff000000,   0,
};


/*----------------------------------*/
/*** MGA PCI 2Mb (Atlas+Athena) ***/
/*----------------------------------*/

HwModeData ModesAth2[63] = {
  640,  480,         0, 0,  8,      256,  640,  1, &OffAth2[0],
  640,  480,        DB, 0,  8,      256,  640,  2, &OffAth2[1],
  640,  480,        DB, Z,  8,      256,  640,  3, &OffAth2[3],
  640,  480,       LUT, 0,  8,      256,  640,  1, &OffAth2[0],
  640,  480,    DB+LUT, 0,  8,      256,  640,  1, &OffAth2[0],
  640,  480,         0, 0, 16,    32768,  640,  1, &OffAth2[6],
  640,  480,         0, Z, 16,    32768,  640,  3, &OffAth2[7],
  640,  480,        DB, 0, 16,    32768,  640,  2, &OffAth2[10],
  640,  480,      M565, 0, 16,    65536,  640,  1, &OffAth2[6],
  640,  480,   M565+DB, 0, 16,    65536,  640,  2, &OffAth2[10],
  640,  480,         0, 0, 32, 16777216,  640,  2, &OffAth2[12],
  800,  600,         0, 0,  8,      256,  800,  1, &OffAth2[14],
  800,  600,        DB, 0,  8,      256,  800,  2, &OffAth2[15],
  800,  600,        DB, Z,  8,      256,  800,  3, &OffAth2[17],
  800,  600,       LUT, 0,  8,      256,  800,  1, &OffAth2[14],
  800,  600,    DB+LUT, 0,  8,      256,  800,  1, &OffAth2[14],
  800,  600,         0, 0, 16,    32768,  800,  1, &OffAth2[20],
  800,  600,         0, Z, 16,    32768,  800,  3, &OffAth2[21],
  800,  600,        DB, 0, 16,    32768,  800,  2, &OffAth2[24],
  800,  600,      M565, 0, 16,    65536,  800,  1, &OffAth2[20],
  800,  600,   M565+DB, 0, 16,    65536,  800,  2, &OffAth2[24],
  800,  600,         0, 0, 32, 16777216,  800,  2, &OffAth2[26],
 1024,  768,         0, 0,  8,      256, 1024,  1, &OffAth2[28],
 1024,  768,        DB, 0,  8,      256, 1024,  2, &OffAth2[29],
 1024,  768,       LUT, 0,  8,      256, 1024,  1, &OffAth2[28],
 1024,  768,    DB+LUT, 0,  8,      256, 1024,  1, &OffAth2[28],
 1024,  768,         0, 0, 16,    32768, 1024,  1, &OffAth2[31],
 1024,  768,      M565, 0, 16,    65536, 1024,  1, &OffAth2[31],
 1152,  882,         0, 0,  8,      256, 1152,  1, &OffAth2[32],
 1152,  882,        DB, 0,  8,      256, 1152,  2, &OffAth2[33],
 1152,  882,       LUT, 0,  8,      256, 1152,  1, &OffAth2[32],
 1152,  882,    DB+LUT, 0,  8,      256, 1152,  1, &OffAth2[32],
 1152,  882,         0, 0, 16,    32768, 1152,  1, &OffAth2[35],
 1152,  882,      M565, 0, 16,    65536, 1152,  1, &OffAth2[35],
 1280, 1024,         0, 0,  8,      256, 1280,  1, &OffAth2[36],
 1280, 1024,       LUT, 0,  8,      256, 1280,  1, &OffAth2[36],
 1280, 1024,    DB+LUT, 0,  8,      256, 1280,  1, &OffAth2[36],
 1600, 1200,         0, 0,  8,      256, 1600,  1, &OffAth2[37],
 1600, 1200,       LUT, 0,  8,      256, 1600,  1, &OffAth2[37],
 1600, 1200,    DB+LUT, 0,  8,      256, 1600,  1, &OffAth2[37],
  640,  480,        TV, 0,  8,      256,  640,  1, &OffAth2[0],
  640,  480,     TV+DB, 0,  8,      256,  640,  2, &OffAth2[1],
  640,  480,     TV+DB, Z,  8,      256,  640,  3, &OffAth2[3],
  640,  480,    TV+LUT, 0,  8,      256,  640,  1, &OffAth2[0],
  640,  480, TV+DB+LUT, 0,  8,      256,  640,  1, &OffAth2[0],
  640,  480,        TV, 0, 16,    32768,  640,  1, &OffAth2[6],
  640,  480,        TV, Z, 16,    32768,  640,  3, &OffAth2[7],
  640,  480,     TV+DB, 0, 16,    32768,  640,  2, &OffAth2[10],
  640,  480,   TV+M565, 0, 16,    65536,  640,  1, &OffAth2[6],
  640,  480,TV+M565+DB, 0, 16,    65536,  640,  2, &OffAth2[10],
  640,  480,        TV, 0, 32, 16777216,  640,  2, &OffAth2[12],
  768,  576,        TV, 0,  8,      256,  768,  1, &OffAth2[38],
  768,  576,     TV+DB, 0,  8,      256,  768,  2, &OffAth2[39],
  768,  576,     TV+DB, Z,  8,      256,  768,  3, &OffAth2[41],
  768,  576,    TV+LUT, 0,  8,      256,  768,  1, &OffAth2[38],
  768,  576, TV+DB+LUT, 0,  8,      256,  768,  1, &OffAth2[38],
  768,  576,        TV, 0, 16,    32768,  768,  1, &OffAth2[44],
  768,  576,        TV, Z, 16,    32768,  768,  3, &OffAth2[45],
  768,  576,     TV+DB, 0, 16,    32768,  768,  2, &OffAth2[48],
  768,  576,   TV+M565, 0, 16,    65536,  768,  1, &OffAth2[44],
  768,  576,TV+M565+DB, 0, 16,    65536,  768,  2, &OffAth2[48],
  768,  576,        TV, 0, 32, 16777216,  768,  2, &OffAth2[50],
{(word) -1}
};


/*----------------------------------*/
/*** MGA PCI 2Mb (Atlas+Athena) ***/
/*----------------------------------*/

HwModeInterlace iModesAth2[63] = {
/*  640x 480/ 8 */   768,         0, 2, &iOffAth2[0],
/*  640x 480/ 8 */   768,        DB, 3, &iOffAth2[2],
/*  640x 480/ 8 */   768,        DB, 6, &iOffAth2[5],
/*  640x 480/ 8 */   768,       LUT, 2, &iOffAth2[0],
/*  640x 480/ 8 */   768,    DB+LUT, 2, &iOffAth2[0],
/*  640x 480/16 */   768,         0, 2, &iOffAth2[11],
/*  640x 480/16 */   768,         0, 5, &iOffAth2[13],
/*  640x 480/16 */   768,        DB, 3, &iOffAth2[18],
/*  640x 480/16 */   768,      M565, 2, &iOffAth2[11],
/*  640x 480/16 */   768,   M565+DB, 3, &iOffAth2[18],
/*  640x 480/32 */   768,         0, 3, &iOffAth2[21],
/*  800x 600/ 8 */  1024,         0, 2, &iOffAth2[24],
/*  800x 600/ 8 */  1024,        DB, 3, &iOffAth2[26],
/*  800x 600/ 8 */  1024,        ND, 0, 0,
/*  800x 600/ 8 */  1024,       LUT, 2, &iOffAth2[24],
/*  800x 600/ 8 */  1024,    DB+LUT, 2, &iOffAth2[24],
/*  800x 600/16 */  1024,         0, 2, &iOffAth2[29],
/*  800x 600/16 */  1024,        ND, 0, 0,
/*  800x 600/16 */  1024,        ND, 0, 0,
/*  800x 600/16 */  1024,      M565, 2, &iOffAth2[29],
/*  800x 600/16 */  1024,        ND, 0, 0,
/*  800x 600/32 */  1024,        ND, 0, 0,
/* 1024x 768/ 8 */   {0},
/* 1024x 768/ 8 */   {0},
/* 1024x 768/ 8 */   {0},
/* 1024x 768/ 8 */   {0},
/* 1024x 768/16 */   {0},
/* 1024x 768/16 */   {0},
/* 1152x 882/ 8 */  1280,         0, 2, &iOffAth2[38],
/* 1152x 882/ 8 */  1280,        ND, 0, 0,
/* 1152x 882/ 8 */  1280,       LUT, 2, &iOffAth2[38],
/* 1152x 882/ 8 */  1280,    DB+LUT, 2, &iOffAth2[38],
/* 1152x 882/16 */  1280,        ND, 0, 0,
/* 1152x 882/16 */  1280,        ND, 0, 0,
/* 1280x1024/ 8 */   {0},
/* 1280x1024/ 8 */   {0},
/* 1280x1024/ 8 */   {0},
/* 1600x1200/ 8 */  1600,         0, 2, &iOffAth2[42],
/* 1600x1200/ 8 */  1600,       LUT, 2, &iOffAth2[42],
/* 1600x1200/ 8 */  1600,    DB+LUT, 2, &iOffAth2[42],
/*  640x 480/ 8 */   768,        TV, 2, &iOffAth2[0],
/*  640x 480/ 8 */   768,     TV+DB, 3, &iOffAth2[2],
/*  640x 480/ 8 */   768,     TV+DB, 6, &iOffAth2[5],
/*  640x 480/ 8 */   768,    TV+LUT, 2, &iOffAth2[0],
/*  640x 480/ 8 */   768, TV+DB+LUT, 2, &iOffAth2[0],
/*  640x 480/16 */   768,        TV, 2, &iOffAth2[11],
/*  640x 480/16 */   768,        TV, 5, &iOffAth2[13],
/*  640x 480/16 */   768,     TV+DB, 3, &iOffAth2[18],
/*  640x 480/16 */   768,   TV+M565, 2, &iOffAth2[11],
/*  640x 480/16 */   768,TV+M565+DB, 3, &iOffAth2[18],
/*  640x 480/32 */   768,        TV, 3, &iOffAth2[21],
/*  768x 576/ 8 */   {0},
/*  768x 576/ 8 */   {0},
/*  768x 576/ 8 */   {0},
/*  768x 576/ 8 */   {0},
/*  768x 576/ 8 */   {0},
/*  768x 576/16 */   {0},
/*  768x 576/16 */   {0},
/*  768x 576/16 */   {0},
/*  768x 576/16 */   {0},
/*  768x 576/16 */   {0},
/*  768x 576/32 */   {0},
{(word) -1}
};

/*----------------------------------*/
/*** MGA PCI 4Mb (Atlas+Athena) ***/
/*----------------------------------*/

OffScrData OffAth4[] = {
/*  640x 480/ 8 */
 N_VRAM,  0,   480,   640,  6073, 0x000000ff,   0,
/*  640x 480/ 8 Z */
 N_VRAM,  0,   480,   640,  2796, 0x000000ff,   0,
 N_VRAM,  0,  4237,   640,  2315, 0x000000ff,   0,
 Z_VRAM,  0,  3276,   640,   960, 0x000000ff, 512,
/*  640x 480/ 8 DB */
 N_VRAM,  0,   960,   640,  5593, 0x000000ff,   0,
DB_VRAM,  0,   480,   640,   480, 0x000000ff,   0,
/*  640x 480/ 8 DB+Z */
 N_VRAM,  0,  4237,   640,  2315, 0x000000ff,   0,
 N_VRAM,  0,   480,   640,  1158, 0x000000ff,   0,
 N_VRAM,  0,  2119,   640,  1157, 0x000000ff,   0,
 Z_VRAM,  0,  3276,   640,   960, 0x000000ff, 512,
DB_VRAM,  0,  1639,   640,   479, 0x000000ff,   0,
/*  640x 480/16 */
 N_VRAM,  0,   480,   640,  2796, 0x0000ffff,   0,
/*  640x 480/16 Z */
 N_VRAM,  0,   480,   640,  1158, 0x0000ffff,   0,
 N_VRAM,  0,  2119,   640,  1157, 0x0000ffff,   0,
 Z_VRAM,  0,  1638,   640,   480, 0x0000ffff, 256,
/*  640x 480/16 DB */
 N_VRAM,  0,   960,   640,  2316, 0x0000ffff,   0,
DB_VRAM,  0,   480,   640,   480, 0x0000ffff,   0,
/*  640x 480/16 DB+Z */
 N_VRAM,  0,   960,   640,   678, 0x0000ffff,   0,
 N_VRAM,  0,  2599,   640,   677, 0x0000ffff,   0,
 Z_VRAM,  0,  1638,   640,   480, 0x0000ffff, 256,
 Z_VRAM,  0,  2118,   640,   480, 0x0000ffff, 256,
DB_VRAM,  0,   480,   640,   480, 0x0000ffff,   0,
/*  640x 480/32 */
 N_VRAM,  0,   480,   640,  1158, 0xffffffff,   0,
 N_VRAM,  0,    0,    480,   640, 0xff000000,   0,
/*  640x 480/32 Z */
 N_VRAM,  0,  1060,   640,   578, 0xffffffff,   0,
 N_VRAM,  0,   480,   640,   339, 0xffffffff,   0,
 Z_VRAM,  0,   819,   640,   240, 0xffffffff, 128,
/*  640x 480/32 DB */
 N_VRAM,  0,   960,   640,   678, 0xffffffff,   0,
DB_VRAM,  0,   480,   640,   480, 0xffffffff,   0,
/*  800x 600/ 8 */
 N_VRAM,  0,   600,   800,  4642, 0x000000ff,   0,
/*  800x 600/ 8 Z */
 N_VRAM,  0,   600,   800,  2021, 0x000000ff,   0,
 N_VRAM,  0,  3822,   800,  1420, 0x000000ff,   0,
 Z_VRAM,  0,  2621,   800,  1200, 0x000000ff, 352,
/*  800x 600/ 8 DB */
 N_VRAM,  0,  1200,   800,  4042, 0x000000ff,   0,
DB_VRAM,  0,   600,   800,   600, 0x000000ff,   0,
/*  800x 600/ 8 DB+Z */
 N_VRAM,  0,  3822,   800,  1420, 0x000000ff,   0,
 N_VRAM,  0,   600,   800,   710, 0x000000ff,   0,
 N_VRAM,  0,  1911,   800,   709, 0x000000ff,   0,
 Z_VRAM,  0,  2621,   800,  1200, 0x000000ff, 352,
DB_VRAM,  0,  1311,   800,   599, 0x000000ff,   0,
/*  800x 600/16 */
 N_VRAM,  0,   600,   800,  2021, 0x0000ffff,   0,
/*  800x 600/16 Z */
 N_VRAM,  0,   600,   800,   710, 0x0000ffff,   0,
 N_VRAM,  0,  1911,   800,   709, 0x0000ffff,   0,
 Z_VRAM,  0,  1310,   800,   600, 0x0000ffff, 576,
/*  800x 600/16 DB */
 N_VRAM,  0,  1200,   800,  1421, 0x0000ffff,   0,
DB_VRAM,  0,   600,   800,   600, 0x0000ffff,   0,
/*  800x 600/16 DB+Z */
 N_VRAM,  0,  1200,   800,   110, 0x0000ffff,   0,
 N_VRAM,  0,  2511,   800,   109, 0x0000ffff,   0,
 Z_VRAM,  0,  1310,   800,   600, 0x0000ffff, 576,
 Z_VRAM,  0,  1910,   800,   600, 0x0000ffff, 576,
DB_VRAM,  0,   600,   800,   600, 0x0000ffff,   0,
/*  800x 600/32 */
 N_VRAM,  0,   600,   800,   710, 0xffffffff,   0,
 N_VRAM,  0,    0,    600,   800, 0xff000000,   0,
/*  800x 600/32 Z */
 N_VRAM,  0,   956,   800,   354, 0xffffffff,   0,
 N_VRAM,  0,   600,   800,    55, 0xffffffff,   0,
 Z_VRAM,  0,   655,   800,   300, 0xffffffff, 288,
/*  800x 600/32 DB */
 N_VRAM,  0,  1200,   800,   110, 0xffffffff,   0,
DB_VRAM,  0,   600,   800,   600, 0xffffffff,   0,
/* 1024x 768/ 8 */
 N_VRAM,  0,   768,  1024,  3328, 0x000000ff,   0,
/* 1024x 768/ 8 Z */
 N_VRAM,  0,   768,  1024,  1280, 0x000000ff,   0,
 N_VRAM,  0,  3585,  1024,   511, 0x000000ff,   0,
 Z_VRAM,  0,  2048,  1024,  1536, 0x000000ff,   0,
/* 1024x 768/ 8 DB */
 N_VRAM,  0,  1536,  1024,  2560, 0x000000ff,   0,
DB_VRAM,  0,   768,  1024,   768, 0x000000ff,   0,
/* 1024x 768/ 8 DB+Z */
 N_VRAM,  0,  3585,  1024,   511, 0x000000ff,   0,
 N_VRAM,  0,   768,  1024,   256, 0x000000ff,   0,
 N_VRAM,  0,  1793,  1024,   255, 0x000000ff,   0,
 Z_VRAM,  0,  2048,  1024,  1536, 0x000000ff,   0,
DB_VRAM,  0,  1025,  1024,   767, 0x000000ff,   0,
/* 1024x 768/16 */
 N_VRAM,  0,   768,  1024,  1280, 0x0000ffff,   0,
/* 1024x 768/16 Z */
 N_VRAM,  0,   768,  1024,   256, 0x0000ffff,   0,
 N_VRAM,  0,  1793,  1024,   255, 0x0000ffff,   0,
 Z_VRAM,  0,  1024,  1024,   768, 0x0000ffff,   0,
/* 1024x 768/16 DB */
 N_VRAM,  0,  1536,  1024,   512, 0x0000ffff,   0,
DB_VRAM,  0,   768,  1024,   768, 0x0000ffff,   0,
/* 1024x 768/32 */
 N_VRAM,  0,   768,  1024,   256, 0xffffffff,   0,
 N_VRAM,  0,    0,    768,  1024, 0xff000000,   0,
/* 1152x 882/ 8 */
 N_VRAM,  0,   882,  1152,  2758, 0x000000ff,   0,
/* 1152x 882/ 8 Z */
 N_VRAM,  0,   882,  1152,   938, 0x000000ff,   0,
 N_VRAM,  0,  3585,  1152,    55, 0x000000ff,   0,
 Z_VRAM,  0,  1820,  1152,  1764, 0x000000ff, 512,
/* 1152x 882/ 8 DB */
 N_VRAM,  0,  1764,  1152,  1876, 0x000000ff,   0,
DB_VRAM,  0,   882,  1152,   882, 0x000000ff,   0,
/* 1152x 882/ 8 DB+Z */
 N_VRAM,  0,  3585,  1152,    55, 0x000000ff,   0,
 N_VRAM,  0,   882,  1152,    28, 0x000000ff,   0,
 N_VRAM,  0,  1793,  1152,    27, 0x000000ff,   0,
 Z_VRAM,  0,  1820,  1152,  1764, 0x000000ff, 512,
DB_VRAM,  0,   911,  1152,   881, 0x000000ff,   0,
/* 1152x 882/16 */
 N_VRAM,  0,   882,  1152,   938, 0x0000ffff,   0,
/* 1152x 882/16 Z */
 N_VRAM,  0,   882,  1152,    28, 0x0000ffff,   0,
 N_VRAM,  0,  1793,  1152,    27, 0x0000ffff,   0,
 Z_VRAM,  0,   910,  1152,   882, 0x0000ffff, 256,
/* 1152x 882/16 DB */
 N_VRAM,  0,  1764,  1152,    56, 0x0000ffff,   0,
DB_VRAM,  0,   882,  1152,   882, 0x0000ffff,   0,
/* 1152x 882/32 */
 N_VRAM,  0,   882,  1152,    28, 0xffffffff,   0,
 N_VRAM,  0,    0,    882,  1152, 0xff000000,   0,
/* 1280x1024/ 8 */
 N_VRAM,  0,  1024,  1280,  2252, 0x000000ff,   0,
/* 1280x1024/ 8 DB */
 N_VRAM,  0,  2048,  1280,  1228, 0x000000ff,   0,
DB_VRAM,  0,  1024,  1280,  1024, 0x000000ff,   0,
/* 1280x1024/16 */
 N_VRAM,  0,  1024,  1280,   614, 0x0000ffff,   0,
/* 1280x1024/ 24 */
 N_VRAM,  0,  1024,  1280,    68, 0x00ffffff,   0,
/* 1600x1200/ 8 */
 N_VRAM,  0,  1200,  1600,  1421, 0x000000ff,   0,
/* 1600x1200/ 8 DB */
 N_VRAM,  0,  2400,  1600,   221, 0x000000ff,   0,
DB_VRAM,  0,  1200,  1600,  1200, 0x000000ff,   0,
/* 1600x1200/16 */
 N_VRAM,  0,  1200,  1600,   110, 0x0000ffff,   0,
/*  768x 576/ 8 */
 N_VRAM,  0,   576,   768,  4885, 0x000000ff,   0,
/*  768x 576/ 8 Z */
 N_VRAM,  0,   576,   768,  2154, 0x000000ff,   0,
 N_VRAM,  0,  3883,   768,  1577, 0x000000ff,   0,
 Z_VRAM,  0,  2730,   768,  1152, 0x000000ff, 512,
/*  768x 576/ 8 DB */
 N_VRAM,  0,  1152,   768,  4309, 0x000000ff,   0,
DB_VRAM,  0,   576,   768,   576, 0x000000ff,   0,
/*  768x 576/ 8 DB+Z */
 N_VRAM,  0,  3883,   768,  1577, 0x000000ff,   0,
 N_VRAM,  0,   576,   768,   789, 0x000000ff,   0,
 N_VRAM,  0,  1942,   768,   788, 0x000000ff,   0,
 Z_VRAM,  0,  2730,   768,  1152, 0x000000ff, 512,
DB_VRAM,  0,  1366,   768,   575, 0x000000ff,   0,
/*  768x 576/16 */
 N_VRAM,  0,   576,   768,  2154, 0x0000ffff,   0,
/*  768x 576/16 Z */
 N_VRAM,  0,   576,   768,   789, 0x0000ffff,   0,
 N_VRAM,  0,  1942,   768,   788, 0x0000ffff,   0,
 Z_VRAM,  0,  1365,   768,   576, 0x0000ffff, 256,
/*  768x 576/16 DB */
 N_VRAM,  0,  1152,   768,  1578, 0x0000ffff,   0,
DB_VRAM,  0,   576,   768,   576, 0x0000ffff,   0,
/*  768x 576/16 DB+Z */
 N_VRAM,  0,  1152,   768,   213, 0x0000ffff,   0,
 N_VRAM,  0,  2518,   768,   212, 0x0000ffff,   0,
 Z_VRAM,  0,  1365,   768,   576, 0x0000ffff, 256,
 Z_VRAM,  0,  1941,   768,   576, 0x0000ffff, 256,
DB_VRAM,  0,   576,   768,   576, 0x0000ffff,   0,
/*  768x 576/32 */
 N_VRAM,  0,   576,   768,   789, 0xffffffff,   0,
 N_VRAM,  0,    0,    576,   768, 0xff000000,   0,
/*  768x 576/32 Z */
 N_VRAM,  0,   971,   768,   393, 0xffffffff,   0,
 N_VRAM,  0,   576,   768,   106, 0xffffffff,   0,
 Z_VRAM,  0,   682,   768,   288, 0xffffffff, 512,
/*  768x 576/32 DB */
 N_VRAM,  0,  1152,   768,   213, 0xffffffff,   0,
DB_VRAM,  0,   576,   768,   576, 0xffffffff,   0,
};


/*----------------------------------*/
/*** MGA PCI 4Mb (Atlas+Athena) ***/
/*----------------------------------*/

OffScrData iOffAth4[] = {
/*  640x 480/ 8 */
 N_VRAM,    0,  480,  768, 4981, 0x000000ff,   0,
 N_VRAM,  480,    0,  128,  480, 0x000000ff,   0,
/*  640x 480/ 8 Z */
 N_VRAM,    0,  480,  768, 2250, 0x000000ff,   0,
 N_VRAM,    0, 3531,  768, 1929, 0x000000ff,   0,
 N_VRAM,  640,    0,  128, 2730, 0x000000ff,   0,
 N_VRAM,  640, 3531,  128, 1929, 0x000000ff,   0,
 Z_VRAM,    0, 2730,  768,  800, 0x000000ff, 512,
/*  640x 480/ 8 DB */
 N_VRAM,    0,  960,  768, 4501, 0x000000ff,   0,
 N_VRAM,  640,    0,  128,  480, 0x000000ff,   0,
DB_VRAM,    0,  480,  768,  480, 0x000000ff,   0,
/*  640x 480/ 8 DB+Z */
 N_VRAM,    0, 3531,  768, 1929, 0x000000ff,   0,
 N_VRAM,    0,  480,  768,  885, 0x000000ff,   0,
 N_VRAM,    0, 1846,  768,  884, 0x000000ff,   0,
 N_VRAM,  640,    0,  128,  480, 0x000000ff,   0,
 N_VRAM,  640, 1364,  128,  479, 0x000000ff,   0,
 Z_VRAM,    0, 2731,  768,  799, 0x000000ff, 512,
DB_VRAM,    0, 1366,  768,  479, 0x000000ff,   0,
/*  640x 480/16 */
 N_VRAM,    0,  480,  768, 2250, 0x0000ffff,   0,
 N_VRAM,  480,    0,  128,  480, 0x0000ffff,   0,
/*  640x 480/16 Z */
 N_VRAM,    0, 1766,  768,  964, 0x0000ffff,   0,
 N_VRAM,    0,  480,  768,  885, 0x0000ffff,   0,
 N_VRAM,  640,    0,  128, 1365, 0x0000ffff,   0,
 N_VRAM,  640, 1766,  128,  964, 0x0000ffff,   0,
 Z_VRAM,    0, 1365,  768,  400, 0x0000ffff, 256,
/*  640x 480/16 DB */
 N_VRAM,    0,  960,  768, 1770, 0x0000ffff,   0,
 N_VRAM,  640,    0,  128,  480, 0x0000ffff,   0,
DB_VRAM,    0,  480,  768,  480, 0x0000ffff,   0,
/*  640x 480/16 DB+Z */
 N_VRAM,    0,  960,  768,  810, 0x0000ffff,   0,
 N_VRAM,    0, 4331,  768,  564, 0x0000ffff,   0,
 N_VRAM,  640,    0,  128,  960, 0x0000ffff,   0,
 Z_VRAM,    0, 1366,  768,  399, 0x0000ffff, 256,
 Z_VRAM,    0, 1766,  768,  399, 0x0000ffff, 256,
DB_VRAM,    0,  480,  768,  480, 0x0000ffff,   0,
/*  640x 480/32 */
 N_VRAM,    0,  480,  768,  885, 0xffffffff,   0,
 N_VRAM,  480,    0,  128,  480, 0xffffffff,   0,
 N_VRAM,    0,    0,  480,  768, 0xff000000,   0,
/*  640x 480/32 Z */
 N_VRAM,    0,  883,  768,  481, 0xffffffff,   0,
 N_VRAM,    0,  480,  768,  202, 0xffffffff,   0,
 N_VRAM,  640,    0,  128,  682, 0xffffffff,   0,
 N_VRAM,  640,  883,  128,  481, 0xffffffff,   0,
 Z_VRAM,    0,  682,  768,  200, 0xffffffff, 512,
/*  640x 480/32 DB */
 N_VRAM,    0,  960,  768,  405, 0xffffffff,   0,
 N_VRAM,  640,    0,  128,  480, 0xffffffff,   0,
DB_VRAM,    0,  480,  768,  480, 0xffffffff,   0,
/*  800x 600/ 8 */
 N_VRAM,    0,  600, 1024, 3496, 0x000000ff,   0,
 N_VRAM,  600,    0,  224,  600, 0x000000ff,   0,
/*  800x 600/ 8 Z */
 N_VRAM,    0,  600, 1024, 1448, 0x000000ff,   0,
 N_VRAM,    0, 2986, 1024, 1109, 0x000000ff,   0,
 N_VRAM,  800,    0,  224, 2048, 0x000000ff,   0,
 N_VRAM,  800, 2986,  224, 1109, 0x000000ff,   0,
 Z_VRAM,    0, 2048, 1024,  937, 0x000000ff,   0,
/*  800x 600/ 8 DB */
 N_VRAM,    0, 1200, 1024, 2896, 0x000000ff,   0,
 N_VRAM,  800,    0,  224,  600, 0x000000ff,   0,
DB_VRAM,    0,  600, 1024,  600, 0x000000ff,   0,
/*  800x 600/16 */
 N_VRAM,    0,  600, 1024, 1448, 0x0000ffff,   0,
 N_VRAM,  600,    0,  224,  600, 0x0000ffff,   0,
/*  800x 600/16 Z */
 N_VRAM,    0, 1493, 1024,  554, 0x0000ffff,   0,
 N_VRAM,    0,  600, 1024,  424, 0x0000ffff,   0,
 N_VRAM,  800,    0,  224, 1024, 0x0000ffff,   0,
 N_VRAM,  800, 1493,  224,  554, 0x0000ffff,   0,
 Z_VRAM,    0, 1024, 1024,  468, 0x0000ffff,   0,
/*  800x 600/16 DB */
 N_VRAM,    0, 1200, 1024,  848, 0x0000ffff,   0,
 N_VRAM,  800,    0,  224,  600, 0x0000ffff,   0,
DB_VRAM,    0,  600, 1024,  600, 0x0000ffff,   0,
/*  800x 600/32 */
 N_VRAM,    0,  600, 1024,  424, 0xffffffff,   0,
 N_VRAM,  600,    0,  224,  600, 0xffffffff,   0,
 N_VRAM,    0,    0,  600, 1024, 0xff000000,   0,
/* 1024x 768/ 8 */
 N_VRAM,    0,  768, 1024, 3328, 0x000000ff,   0,
 N_VRAM,  768,    0,    0,  768, 0x000000ff,   0,
/* 1024x 768/ 8 Z */
 N_VRAM,    0,  768, 1024, 1280, 0x000000ff,   0,
 N_VRAM,    0, 3585, 1024,  511, 0x000000ff,   0,
 N_VRAM, 1024,    0,    0, 2048, 0x000000ff,   0,
 N_VRAM, 1024, 3585,    0,  511, 0x000000ff,   0,
 Z_VRAM,    0, 2048, 1024, 1536, 0x000000ff,   0,
/* 1024x 768/ 8 DB */
 N_VRAM,    0, 1536, 1024, 2560, 0x000000ff,   0,
 N_VRAM, 1024,    0,    0,  768, 0x000000ff,   0,
DB_VRAM,    0,  768, 1024,  768, 0x000000ff,   0,
/* 1024x 768/16 */
 N_VRAM,    0,  768, 1024, 1280, 0x0000ffff,   0,
 N_VRAM,  768,    0,    0,  768, 0x0000ffff,   0,
/* 1024x 768/16 Z */
 N_VRAM,    0, 1793, 1024,  255, 0x0000ffff,   0,
 N_VRAM,    0,  768, 1024,  256, 0x0000ffff,   0,
 N_VRAM, 1024,    0,    0, 1024, 0x0000ffff,   0,
 N_VRAM, 1024, 1793,    0,  255, 0x0000ffff,   0,
 Z_VRAM,    0, 1024, 1024,  768, 0x0000ffff,   0,
/* 1024x 768/16 DB */
 N_VRAM,    0, 1536, 1024,  512, 0x0000ffff,   0,
 N_VRAM, 1024,    0,    0,  768, 0x0000ffff,   0,
DB_VRAM,    0,  768, 1024,  768, 0x0000ffff,   0,
/* 1024x 768/32 */
 N_VRAM,    0,  768, 1024,  256, 0xffffffff,   0,
 N_VRAM,  768,    0,    0,  768, 0xffffffff,   0,
 N_VRAM,    0,    0,  768, 1024, 0xff000000,   0,
/* 1152x 882/ 8 */
 N_VRAM,    0,  882, 1280, 2394, 0x000000ff,   0,
 N_VRAM,  882,    0,  128,  882, 0x000000ff,   0,
/* 1152x 882/ 8 Z */
 N_VRAM,    0,  882, 1280,  756, 0x000000ff,   0,
 N_VRAM,    0, 3227, 1280,   49, 0x000000ff,   0,
 N_VRAM, 1152,    0,  128, 1638, 0x000000ff,   0,
 N_VRAM, 1152, 3227,  128,   49, 0x000000ff,   0,
 Z_VRAM,    0, 1638, 1280, 1587, 0x000000ff, 512,
/* 1152x 882/ 8 DB */
 N_VRAM,    0, 1764, 1280, 1512, 0x000000ff,   0,
 N_VRAM, 1152,    0,  128,  882, 0x000000ff,   0,
DB_VRAM,    0,  882, 1280,  882, 0x000000ff,   0,
/* 1152x 882/16 */
 N_VRAM,    0,  882, 1280,  756, 0x0000ffff,   0,
 N_VRAM,  882,    0,  128,  882, 0x0000ffff,   0,
/* 1280x1024/ 8 */
 N_VRAM,    0, 1024, 1280, 2252, 0x000000ff,   0,
 N_VRAM, 1024,    0,    0, 1024, 0x000000ff,   0,
/* 1280x1024/ 8 DB */
 N_VRAM,    0, 2048, 1280, 1228, 0x000000ff,   0,
 N_VRAM, 1280,    0,    0, 1024, 0x000000ff,   0,
DB_VRAM,    0, 1024, 1280, 1024, 0x000000ff,   0,
/* 1280x1024/16 */
 N_VRAM,    0, 1024, 1280,  614, 0x0000ffff,   0,
 N_VRAM, 1024,    0,    0, 1024, 0x0000ffff,   0,
/* 1600x1200/ 8 */
 N_VRAM,    0, 1200, 1600, 1421, 0x000000ff,   0,
 N_VRAM, 1200,    0,    0, 1200, 0x000000ff,   0,
/* 1600x1200/ 8 DB */
 N_VRAM,    0, 2400, 1600,  221, 0x000000ff,   0,
 N_VRAM, 1600,    0,    0, 1200, 0x000000ff,   0,
DB_VRAM,    0, 1200, 1600, 1200, 0x000000ff,   0,
/* 1600x1200/16 */
 N_VRAM,    0, 1200, 1600,  110, 0x0000ffff,   0,
 N_VRAM, 1200,    0,    0, 1200, 0x0000ffff,   0,
/*  768x 576/ 8 */
 N_VRAM,    0,  576,  768, 4885, 0x000000ff,   0,
 N_VRAM,  576,    0,    0,  576, 0x000000ff,   0,
/*  768x 576/ 8 Z */
 N_VRAM,    0,  576,  768, 2154, 0x000000ff,   0,
 N_VRAM,    0, 3883,  768, 1577, 0x000000ff,   0,
 N_VRAM,  768,    0,    0, 2730, 0x000000ff,   0,
 N_VRAM,  768, 3883,    0, 1577, 0x000000ff,   0,
 Z_VRAM,    0, 2730,  768, 1152, 0x000000ff, 512,
/*  768x 576/ 8 DB */
 N_VRAM,    0, 1152,  768, 4309, 0x000000ff,   0,
 N_VRAM,  768,    0,    0,  576, 0x000000ff,   0,
DB_VRAM,    0,  576,  768,  576, 0x000000ff,   0,
/*  768x 576/ 8 DB+Z */
 N_VRAM,    0, 3883,  768, 1577, 0x000000ff,   0,
 N_VRAM,    0,  576,  768,  789, 0x000000ff,   0,
 N_VRAM,    0, 1942,  768,  788, 0x000000ff,   0,
 N_VRAM,  768,    0,    0,  576, 0x000000ff,   0,
 N_VRAM,  768, 1364,    0,  575, 0x000000ff,   0,
 Z_VRAM,    0, 2731,  768, 1151, 0x000000ff, 512,
DB_VRAM,    0, 1366,  768,  575, 0x000000ff,   0,
/*  768x 576/16 */
 N_VRAM,    0,  576,  768, 2154, 0x0000ffff,   0,
 N_VRAM,  576,    0,    0,  576, 0x0000ffff,   0,
/*  768x 576/16 Z */
 N_VRAM,    0, 1942,  768,  788, 0x0000ffff,   0,
 N_VRAM,    0,  576,  768,  789, 0x0000ffff,   0,
 N_VRAM,  768,    0,    0, 1365, 0x0000ffff,   0,
 N_VRAM,  768, 1942,    0,  788, 0x0000ffff,   0,
 Z_VRAM,    0, 1365,  768,  576, 0x0000ffff, 256,
/*  768x 576/16 DB */
 N_VRAM,    0, 1152,  768, 1578, 0x0000ffff,   0,
 N_VRAM,  768,    0,    0,  576, 0x0000ffff,   0,
DB_VRAM,    0,  576,  768,  576, 0x0000ffff,   0,
/*  768x 576/16 DB+Z */
 N_VRAM,    0, 1152,  768,  426, 0x0000ffff,   0,
 N_VRAM,    0, 5035,  768,  212, 0x0000ffff,   0,
 N_VRAM,  768,    0,    0, 1152, 0x0000ffff,   0,
 Z_VRAM,    0, 1366,  768,  575, 0x0000ffff, 256,
 Z_VRAM,    0, 1942,  768,  575, 0x0000ffff, 256,
DB_VRAM,    0,  576,  768,  576, 0x0000ffff,   0,
/*  768x 576/32 */
 N_VRAM,    0,  576,  768,  789, 0xffffffff,   0,
 N_VRAM,  576,    0,    0,  576, 0xffffffff,   0,
 N_VRAM,    0,    0,  576,  768, 0xff000000,   0,
/*  768x 576/32 Z */
 N_VRAM,    0,  971,  768,  393, 0xffffffff,   0,
 N_VRAM,    0,  576,  768,  106, 0xffffffff,   0,
 N_VRAM,  768,    0,    0,  682, 0xffffffff,   0,
 N_VRAM,  768,  971,    0,  393, 0xffffffff,   0,
 Z_VRAM,    0,  682,  768,  288, 0xffffffff, 512,
/*  768x 576/32 DB */
 N_VRAM,    0, 1152,  768,  213, 0xffffffff,   0,
 N_VRAM,  768,    0,    0,  576, 0xffffffff,   0,
DB_VRAM,    0,  576,  768,  576, 0xffffffff,   0,
};


/*----------------------------------*/
/*** MGA PCI 4Mb (Atlas+Athena) ***/
/*----------------------------------*/

HwModeData ModesAth4[98] = {
  640,  480,         0, 0,  8,      256,  640,  1, &OffAth4[0],
  640,  480,         0, Z,  8,      256,  640,  3, &OffAth4[1],
  640,  480,        DB, 0,  8,      256,  640,  2, &OffAth4[4],
  640,  480,        DB, Z,  8,      256,  640,  5, &OffAth4[6],
  640,  480,       LUT, 0,  8,      256,  640,  1, &OffAth4[0],
  640,  480,    DB+LUT, 0,  8,      256,  640,  1, &OffAth4[0],
  640,  480,         0, 0, 16,    32768,  640,  1, &OffAth4[11],
  640,  480,         0, Z, 16,    32768,  640,  3, &OffAth4[12],
  640,  480,        DB, 0, 16,    32768,  640,  2, &OffAth4[15],
  640,  480,        DB, Z, 16,    32768,  640,  5, &OffAth4[17],
  640,  480,      M565, 0, 16,    65536,  640,  1, &OffAth4[11],
  640,  480,   M565+DB, 0, 16,    65536,  640,  2, &OffAth4[15],
  640,  480,         0, 0, 32, 16777216,  640,  2, &OffAth4[22],
  640,  480,         0, Z, 32, 16777216,  640,  3, &OffAth4[24],
  640,  480,        DB, 0, 32, 16777216,  640,  2, &OffAth4[27],
  800,  600,         0, 0,  8,      256,  800,  1, &OffAth4[29],
  800,  600,         0, Z,  8,      256,  800,  3, &OffAth4[30],
  800,  600,        DB, 0,  8,      256,  800,  2, &OffAth4[33],
  800,  600,        DB, Z,  8,      256,  800,  5, &OffAth4[35],
  800,  600,       LUT, 0,  8,      256,  800,  1, &OffAth4[29],
  800,  600,    DB+LUT, 0,  8,      256,  800,  1, &OffAth4[29],
  800,  600,         0, 0, 16,    32768,  800,  1, &OffAth4[40],
  800,  600,         0, Z, 16,    32768,  800,  3, &OffAth4[41],
  800,  600,        DB, 0, 16,    32768,  800,  2, &OffAth4[44],
  800,  600,        DB, Z, 16,    32768,  800,  5, &OffAth4[46],
  800,  600,      M565, 0, 16,    65536,  800,  1, &OffAth4[40],
  800,  600,   M565+DB, 0, 16,    65536,  800,  2, &OffAth4[44],
  800,  600,         0, 0, 32, 16777216,  800,  2, &OffAth4[51],
  800,  600,         0, Z, 32, 16777216,  800,  3, &OffAth4[53],
  800,  600,        DB, 0, 32, 16777216,  800,  2, &OffAth4[56],
 1024,  768,         0, 0,  8,      256, 1024,  1, &OffAth4[58],
 1024,  768,         0, Z,  8,      256, 1024,  3, &OffAth4[59],
 1024,  768,        DB, 0,  8,      256, 1024,  2, &OffAth4[62],
 1024,  768,        DB, Z,  8,      256, 1024,  5, &OffAth4[64],
 1024,  768,       LUT, 0,  8,      256, 1024,  1, &OffAth4[58],
 1024,  768,    DB+LUT, 0,  8,      256, 1024,  1, &OffAth4[58],
 1024,  768,         0, 0, 16,    32768, 1024,  1, &OffAth4[69],
 1024,  768,         0, Z, 16,    32768, 1024,  3, &OffAth4[70],
 1024,  768,        DB, 0, 16,    32768, 1024,  2, &OffAth4[73],
 1024,  768,      M565, 0, 16,    65536, 1024,  1, &OffAth4[69],
 1024,  768,   M565+DB, 0, 16,    65536, 1024,  2, &OffAth4[73],
 1024,  768,         0, 0, 32, 16777216, 1024,  2, &OffAth4[75],
 1152,  882,         0, 0,  8,      256, 1152,  1, &OffAth4[77],
 1152,  882,         0, Z,  8,      256, 1152,  3, &OffAth4[78],
 1152,  882,        DB, 0,  8,      256, 1152,  2, &OffAth4[81],
 1152,  882,        DB, Z,  8,      256, 1152,  5, &OffAth4[83],
 1152,  882,       LUT, 0,  8,      256, 1152,  1, &OffAth4[77],
 1152,  882,    DB+LUT, 0,  8,      256, 1152,  1, &OffAth4[77],
 1152,  882,         0, 0, 16,    32768, 1152,  1, &OffAth4[88],
 1152,  882,         0, Z, 16,    32768, 1152,  3, &OffAth4[89],
 1152,  882,        DB, 0, 16,    32768, 1152,  2, &OffAth4[92],
 1152,  882,      M565, 0, 16,    65536, 1152,  1, &OffAth4[88],
 1152,  882,   M565+DB, 0, 16,    65536, 1152,  2, &OffAth4[92],
 1152,  882,         0, 0, 32, 16777216, 1152,  2, &OffAth4[94],
 1280, 1024,         0, 0,  8,      256, 1280,  1, &OffAth4[96],
 1280, 1024,        DB, 0,  8,      256, 1280,  2, &OffAth4[97],
 1280, 1024,       LUT, 0,  8,      256, 1280,  1, &OffAth4[96],
 1280, 1024,    DB+LUT, 0,  8,      256, 1280,  1, &OffAth4[96],
 1280, 1024,         0, 0, 16,    32768, 1280,  1, &OffAth4[99],
 1280, 1024,      M565, 0, 16,    65536, 1280,  1, &OffAth4[99],
 1280, 1024,         0, 0, 24, 16777216, 1280,  1, &OffAth4[100],
 1600, 1200,         0, 0,  8,      256, 1600,  1, &OffAth4[101],
 1600, 1200,        DB, 0,  8,      256, 1600,  2, &OffAth4[102],
 1600, 1200,       LUT, 0,  8,      256, 1600,  1, &OffAth4[101],
 1600, 1200,    DB+LUT, 0,  8,      256, 1600,  1, &OffAth4[101],
 1600, 1200,         0, 0, 16,    32768, 1600,  1, &OffAth4[104],
 1600, 1200,      M565, 0, 16,    65536, 1600,  1, &OffAth4[104],
  640,  480,        TV, 0,  8,      256,  640,  1, &OffAth4[0],
  640,  480,        TV, Z,  8,      256,  640,  3, &OffAth4[1],
  640,  480,     TV+DB, 0,  8,      256,  640,  2, &OffAth4[4],
  640,  480,     TV+DB, Z,  8,      256,  640,  5, &OffAth4[6],
  640,  480,    TV+LUT, 0,  8,      256,  640,  1, &OffAth4[0],
  640,  480, TV+DB+LUT, 0,  8,      256,  640,  1, &OffAth4[0],
  640,  480,        TV, 0, 16,    32768,  640,  1, &OffAth4[11],
  640,  480,        TV, Z, 16,    32768,  640,  3, &OffAth4[12],
  640,  480,     TV+DB, 0, 16,    32768,  640,  2, &OffAth4[15],
  640,  480,     TV+DB, Z, 16,    32768,  640,  5, &OffAth4[17],
  640,  480,   TV+M565, 0, 16,    65536,  640,  1, &OffAth4[11],
  640,  480,TV+M565+DB, 0, 16,    65536,  640,  2, &OffAth4[15],
  640,  480,        TV, 0, 32, 16777216,  640,  2, &OffAth4[22],
  640,  480,        TV, Z, 32, 16777216,  640,  3, &OffAth4[24],
  640,  480,     TV+DB, 0, 32, 16777216,  640,  2, &OffAth4[27],
  768,  576,        TV, 0,  8,      256,  768,  1, &OffAth4[105],
  768,  576,        TV, Z,  8,      256,  768,  3, &OffAth4[106],
  768,  576,     TV+DB, 0,  8,      256,  768,  2, &OffAth4[109],
  768,  576,     TV+DB, Z,  8,      256,  768,  5, &OffAth4[111],
  768,  576,    TV+LUT, 0,  8,      256,  768,  1, &OffAth4[105],
  768,  576, TV+DB+LUT, 0,  8,      256,  768,  1, &OffAth4[105],
  768,  576,        TV, 0, 16,    32768,  768,  1, &OffAth4[116],
  768,  576,        TV, Z, 16,    32768,  768,  3, &OffAth4[117],
  768,  576,     TV+DB, 0, 16,    32768,  768,  2, &OffAth4[120],
  768,  576,     TV+DB, Z, 16,    32768,  768,  5, &OffAth4[122],
  768,  576,   TV+M565, 0, 16,    65536,  768,  1, &OffAth4[116],
  768,  576,TV+M565+DB, 0, 16,    65536,  768,  2, &OffAth4[120],
  768,  576,        TV, 0, 32, 16777216,  768,  2, &OffAth4[127],
  768,  576,        TV, Z, 32, 16777216,  768,  3, &OffAth4[129],
  768,  576,     TV+DB, 0, 32, 16777216,  768,  2, &OffAth4[132],
{(word) -1}
};


/*----------------------------------*/
/*** MGA PCI 4Mb (Atlas+Athena) ***/
/*----------------------------------*/

HwModeInterlace iModesAth4[98] = {
/*  640x 480/ 8 */   768,         0, 2, &iOffAth4[0],
/*  640x 480/ 8 */   768,         0, 5, &iOffAth4[2],
/*  640x 480/ 8 */   768,        DB, 3, &iOffAth4[7],
/*  640x 480/ 8 */   768,        DB, 7, &iOffAth4[10],
/*  640x 480/ 8 */   768,       LUT, 2, &iOffAth4[0],
/*  640x 480/ 8 */   768,    DB+LUT, 2, &iOffAth4[0],
/*  640x 480/16 */   768,         0, 2, &iOffAth4[17],
/*  640x 480/16 */   768,         0, 5, &iOffAth4[19],
/*  640x 480/16 */   768,        DB, 3, &iOffAth4[24],
/*  640x 480/16 */   768,        DB, 6, &iOffAth4[27],
/*  640x 480/16 */   768,      M565, 2, &iOffAth4[17],
/*  640x 480/16 */   768,   M565+DB, 3, &iOffAth4[24],
/*  640x 480/32 */   768,         0, 3, &iOffAth4[33],
/*  640x 480/32 */   768,         0, 5, &iOffAth4[36],
/*  640x 480/32 */   768,        DB, 3, &iOffAth4[41],
/*  800x 600/ 8 */  1024,         0, 2, &iOffAth4[44],
/*  800x 600/ 8 */  1024,         0, 5, &iOffAth4[46],
/*  800x 600/ 8 */  1024,        DB, 3, &iOffAth4[51],
/*  800x 600/ 8 */  1024,        DB, 0, &iOffAth4[54],
/*  800x 600/ 8 */  1024,       LUT, 2, &iOffAth4[44],
/*  800x 600/ 8 */  1024,    DB+LUT, 2, &iOffAth4[44],
/*  800x 600/16 */  1024,         0, 2, &iOffAth4[54],
/*  800x 600/16 */  1024,         0, 5, &iOffAth4[56],
/*  800x 600/16 */  1024,        DB, 3, &iOffAth4[61],
/*  800x 600/16 */  1024,        ND, 0, 0,
/*  800x 600/16 */  1024,      M565, 2, &iOffAth4[54],
/*  800x 600/16 */  1024,   M565+DB, 3, &iOffAth4[61],
/*  800x 600/32 */  1024,         0, 3, &iOffAth4[64],
/*  800x 600/32 */  1024,        ND, 0, 0,
/*  800x 600/32 */  1024,        ND, 0, 0,
/* 1024x 768/ 8 */   {0},
/* 1024x 768/ 8 */   {0},
/* 1024x 768/ 8 */   {0},
/* 1024x 768/ 8 */   {0},
/* 1024x 768/ 8 */   {0},
/* 1024x 768/ 8 */   {0},
/* 1024x 768/16 */   {0},
/* 1024x 768/16 */   {0},
/* 1024x 768/16 */   {0},
/* 1024x 768/16 */   {0},
/* 1024x 768/16 */   {0},
/* 1024x 768/32 */   {0},
/* 1152x 882/ 8 */  1280,         0, 2, &iOffAth4[90],
/* 1152x 882/ 8 */  1280,         0, 5, &iOffAth4[92],
/* 1152x 882/ 8 */  1280,        DB, 3, &iOffAth4[97],
/* 1152x 882/ 8 */  1280,        ND, 0, 0,
/* 1152x 882/ 8 */  1280,       LUT, 2, &iOffAth4[90],
/* 1152x 882/ 8 */  1280,    DB+LUT, 2, &iOffAth4[90],
/* 1152x 882/16 */  1280,         0, 2, &iOffAth4[100],
/* 1152x 882/16 */  1280,        ND, 0, 0,
/* 1152x 882/16 */  1280,        ND, 0, 0,
/* 1152x 882/16 */  1280,      M565, 2, &iOffAth4[100],
/* 1152x 882/16 */  1280,        ND, 0, 0,
/* 1152x 882/32 */  1280,        ND, 0, 0,
/* 1280x1024/ 8 */   {0},
/* 1280x1024/ 8 */   {0},
/* 1280x1024/ 8 */   {0},
/* 1280x1024/ 8 */   {0},
/* 1280x1024/16 */   {0},
/* 1280x1024/16 */   {0},
/* 1280x1024/24 */   {0},
/* 1600x1200/ 8 */  1600,         0, 2, &iOffAth4[109],
/* 1600x1200/ 8 */  1600,        DB, 3, &iOffAth4[111],
/* 1600x1200/ 8 */  1600,       LUT, 2, &iOffAth4[109],
/* 1600x1200/ 8 */  1600,    DB+LUT, 2, &iOffAth4[109],
/* 1600x1200/16 */  1600,         0, 2, &iOffAth4[114],
/* 1600x1200/16 */  1600,      M565, 2, &iOffAth4[114],
/*  640x 480/ 8 */   768,        TV, 2, &iOffAth4[0],
/*  640x 480/ 8 */   768,        TV, 5, &iOffAth4[2],
/*  640x 480/ 8 */   768,     TV+DB, 3, &iOffAth4[7],
/*  640x 480/ 8 */   768,     TV+DB, 7, &iOffAth4[10],
/*  640x 480/ 8 */   768,    TV+LUT, 2, &iOffAth4[0],
/*  640x 480/ 8 */   768, TV+DB+LUT, 2, &iOffAth4[0],
/*  640x 480/16 */   768,        TV, 2, &iOffAth4[17],
/*  640x 480/16 */   768,        TV, 5, &iOffAth4[19],
/*  640x 480/16 */   768,     TV+DB, 3, &iOffAth4[24],
/*  640x 480/16 */   768,     TV+DB, 6, &iOffAth4[27],
/*  640x 480/16 */   768,   TV+M565, 2, &iOffAth4[17],
/*  640x 480/16 */   768,TV+M565+DB, 3, &iOffAth4[24],
/*  640x 480/32 */   768,        TV, 3, &iOffAth4[33],
/*  640x 480/32 */   768,        TV, 5, &iOffAth4[36],
/*  640x 480/32 */   768,     TV+DB, 3, &iOffAth4[41],
/*  768x 576/ 8 */   {0},
/*  768x 576/ 8 */   {0},
/*  768x 576/ 8 */   {0},
/*  768x 576/ 8 */   {0},
/*  768x 576/ 8 */   {0},
/*  768x 576/ 8 */   {0},
/*  768x 576/16 */   {0},
/*  768x 576/16 */   {0},
/*  768x 576/16 */   {0},
/*  768x 576/16 */   {0},
/*  768x 576/16 */   {0},
/*  768x 576/16 */   {0},
/*  768x 576/32 */   {0},
/*  768x 576/32 */   {0},
/*  768x 576/32 */   {0},
{(word) -1}
};



