#ifndef __OPERATOR_HXX__
#define __OPERATOR_HXX__
//
// operator identifier definitions.
//

typedef enum _operators
	{
	 OP_START
	,OP_ILLEGAL = OP_START

	,OP_UNARY_START

	,OP_UNARY_ARITHMETIC_START	= OP_UNARY_START
	,OP_UNARY_PLUS 				= OP_UNARY_ARITHMETIC_START
	,OP_UNARY_MINUS
	,OP_UNARY_ARITHMETIC_END

	,OP_UNARY_LOGICAL_START		= OP_UNARY_ARITHMETIC_END
	,OP_UNARY_NOT				= OP_UNARY_LOGICAL_START
	,OP_UNARY_COMPLEMENT
	,OP_UNARY_LOGICAL_END

	,OP_UNARY_INDIRECTION		= OP_UNARY_LOGICAL_END
	,OP_UNARY_CAST
	,OP_UNARY_AND
	,OP_UNARY_SIZEOF
	,OP_PRE_INCR
	,OP_PRE_DECR
	,OP_POST_INCR
	,OP_POST_DECR

	,OP_UNARY_END

	,OP_BINARY_START			= OP_UNARY_END

	,OP_BINARY_ARITHMETIC_START	= OP_BINARY_START
	,OP_PLUS					= OP_BINARY_ARITHMETIC_START
	,OP_MINUS
	,OP_STAR
	,OP_SLASH
	,OP_MOD
	,OP_BINARY_ARITHMETIC_END

	,OP_BINARY_SHIFT_START		= OP_BINARY_ARITHMETIC_END
	,OP_LEFT_SHIFT				= OP_BINARY_SHIFT_START
	,OP_RIGHT_SHIFT
	,OP_BINARY_SHIFT_END

	,OP_BINARY_RELATIONAL_START	= OP_BINARY_SHIFT_END
	,OP_LESS					= OP_BINARY_RELATIONAL_START
	,OP_LESS_EQUAL
	,OP_GREATER_EQUAL
	,OP_GREATER
	,OP_EQUAL
	,OP_NOT_EQUAL
	,OP_BINARY_RELATIONAL_END

	,OP_BINARY_BITWISE_START	= OP_BINARY_RELATIONAL_END
	,OP_AND						= OP_BINARY_BITWISE_START
	,OP_OR
	,OP_XOR
	,OP_BINARY_BITWISE_END

	,OP_BINARY_LOGICAL_START	= OP_BINARY_BITWISE_END
	,OP_LOGICAL_AND				= OP_BINARY_LOGICAL_START
	,OP_LOGICAL_OR
	,OP_BINARY_LOGICAL_END

	,OP_BINARY_TERNARY_START	= OP_BINARY_LOGICAL_END
	,OP_QM						= OP_BINARY_TERNARY_START
	,OP_COLON
	,OP_BINARY_TERNARY_END

	,OP_BINARY_END				= OP_BINARY_TERNARY_END

	,OP_INTERNAL_START			= OP_BINARY_END
	,OP_FUNCTION
	,OP_PARAM

	,OP_POINTSTO
	,OP_DOT
	,OP_INDEX
	,OP_COMMA
	,OP_STMT
	,OP_ASSIGN
	
	,OP_END
	} OPERATOR;

#endif // __OPERATOR_HXX__
