/* asmindex.h -- include file for microsoft 80x86 assembler
**
** microsoft (r) macro assembler
** copyright (c) microsoft corp 1986.  all rights reserved
**
** randy nevin
*/

/* indices of opcodes */

#define I_AAA           0
#define I_AAD           1
#define I_AAM           2
#define I_AAS           3
#define I_ADC           4
#define I_ADD           5
#define I_AND           6
#define I_CALL          7
#define I_CBW           8
#define I_CLC           9
#define I_CLD           10
#define I_CLI           11
#define I_CMC           12
#define I_CMP           13
#define I_CMPS          14
#define I_CMPSB         15
#define I_CMPSW         16
#define I_CWD           17
#define I_DAA           18
#define I_DAS           19
#define I_DEC           20
#define I_DIV           21
#define I_ESC           22
#define I_HLT           23
#define I_IDIV          24
#define I_IMUL          25
#define I_IN            26
#define I_INC           27
#define I_INT           28
#define I_INTO          29
#define I_IRET          30
#define I_JA            31
#define I_JAE           32
#define I_JB            33
#define I_JBE           34
#define I_JC            35
#define I_JCXZ          36
#define I_JE            37
#define I_JG            38
#define I_JGE           39
#define I_JL            40
#define I_JLE           41
#define I_JMP           42
#define I_JNA           43
#define I_JNAE          44
#define I_JNB           45
#define I_JNBE          46
#define I_JNC           47
#define I_JNE           48
#define I_JNG           49
#define I_JNGE          50
#define I_JNL           51
#define I_JNLE          52
#define I_JNO           53
#define I_JNP           54
#define I_JNS           55
#define I_JNZ           56
#define I_JO            57
#define I_JP            58
#define I_JPE           59
#define I_JPO           60
#define I_JS            61
#define I_JZ            62
#define I_LAHF          63
#define I_LEA           64
#define I_LES           65
#define I_LDS           66
#define I_LOCK          67
#define I_LODS          68
#define I_LODSB         69
#define I_LODSW         70
#define I_LOOP          71
#define I_LOOPE         72
#define I_LOOPNE        73
#define I_LOOPNZ        74
#define I_LOOPZ         75
#define I_MOV           76
#define I_MOVS          77
#define I_MOVSB         78
#define I_MOVSW         79
#define I_MUL           80
#define I_NEG           81
#define I_NOP           82
#define I_NOT           83
#define I_OR            84
#define I_OUT           85
#define I_POP           86
#define I_POPF          87
#define I_PUSH          88
#define I_PUSHF         89
#define I_RCL           90
#define I_RCR           91
#define I_REP           92
#define I_REPE          93
#define I_REPNE         94
#define I_REPNZ         95
#define I_REPZ          96
#define I_RET           97
#define I_ROL           98
#define I_ROR           99
#define I_SAHF          100
#define I_SAL           101
#define I_SAR           102
#define I_SBB           103
#define I_SCAS          104
#define I_SCASB         105
#define I_SCASW         106
#define I_SHL           107
#define I_SHR           108
#define I_STC           109
#define I_STD           110
#define I_STI           111
#define I_STOS          112
#define I_STOSB         113
#define I_STOSW         114
#define I_SUB           115
#define I_TEST          116
#define I_WAIT          117
#define I_XCHG          118
#define I_XLAT          119
#define I_XLATB         120
#define I_XOR           121
#define I_ARPL          122
#define I_BOUND         123
#define I_CLTS          124
#define I_ENTER         125
#define I_INS           126
#define I_INSB          127
#define I_INSW          128
#define I_LAR           129
#define I_LEAVE         130
#define I_LGDT          131
#define I_LIDT          132
#define I_LLDT          133
#define I_LMSW          134
#define I_LSL           135
#define I_LTR           136
#define I_OUTS          137
#define I_OUTSB         138
#define I_OUTSW         139
#define I_POPA          140
#define I_PUSHA         141
#define I_SGDT          142
#define I_SIDT          143
#define I_SLDT          144
#define I_SMSW          145
#define I_STR           146
#define I_VERR          147
#define I_VERW          148
#define I_F2XM1         149
#define I_FABS          150
#define I_FADD          151
#define I_FADDP         152
#define I_FBLD          153
#define I_FBSTP         154
#define I_FCHS          155
#define I_FCLEX         156
#define I_FCOM          157
#define I_FCOMP         158
#define I_FCOMPP        159
#define I_FDECSTP       160
#define I_FDISI         161
#define I_FDIV          162
#define I_FDIVP         163
#define I_FDIVR         164
#define I_FDIVRP        165
#define I_FENI          166
#define I_FFREE         167
#define I_FIADD         168
#define I_FICOM         169
#define I_FICOMP        170
#define I_FIDIV         171
#define I_FIDIVR        172
#define I_FILD          173
#define I_FIMUL         174
#define I_FINCSTP       175
#define I_FINIT         176
#define I_FIST          177
#define I_FISTP         178
#define I_FISUB         179
#define I_FISUBR        180
#define I_FLD           181
#define I_FLD1          182
#define I_FLDCW         183
#define I_FLDENV        184
#define I_FLDL2E        185
#define I_FLDL2T        186
#define I_FLDLG2        187
#define I_FLDLN2        188
#define I_FLDPI         189
#define I_FLDZ          190
#define I_FMUL          191
#define I_FMULP         192
#define I_FNCLEX        193
#define I_FNDISI        194
#define I_FNENI         195
#define I_FNINIT        196
#define I_FNOP          197
#define I_FNSAVE        198
#define I_FNSTCW        199
#define I_FNSTENV       200
#define I_FNSTSW        201
#define I_FPATAN        202
#define I_FPREM         203
#define I_FPTAN         204
#define I_FRNDINT       205
#define I_FRSTOR        206
#define I_FSAVE         207
#define I_FSCALE        208
#define I_FSQRT         209
#define I_FST           210
#define I_FSTCW         211
#define I_FSTENV        212
#define I_FSTP          213
#define I_FSTSW         214
#define I_FSETPM        215
#define I_FSUB          216
#define I_FSUBP         217
#define I_FSUBR         218
#define I_FSUBRP        219
#define I_FTST          220
#define I_FWAIT         221
#define I_FXAM          222
#define I_FXCH          223
#define I_FXTRACT       224
#define I_FYL2X         225
#define I_FYL2XP1       226
#define I_FNRSTOR       227

#ifdef V386

#define I_MOVSX         228
#define I_MOVZX         229
#define I_CWDE          230
#define I_CDQ           231
#define I_LFS           232
#define I_LGS           233
#define I_LSS           234
#define I_SHLD          235
#define I_SHRD          236
#define I_CMPSD         237
#define I_INSD          238
#define I_LODSD         239
#define I_MOVSD         240
#define I_OUTSD         241
#define I_SCASD         242
#define I_STOSD         243
#define I_BSF           244
#define I_BSR           245
#define I_BT            246
#define I_BTC           247
#define I_BTR           248
#define I_BTS           249
#define I_IBTS          250
#define I_XBTS          251
#define I_JECXZ         252
#define I_SETO          253
#define I_SETNO         254
#define I_SETB          255
#define I_SETNAE        256
#define I_SETNB         257
#define I_SETAE         258
#define I_SETE          259
#define I_SETZ          260
#define I_SETNE         261
#define I_SETNZ         262
#define I_SETBE         263
#define I_SETNA         264
#define I_SETNBE        265
#define I_SETA          266
#define I_SETS          267
#define I_SETNS         268
#define I_SETP          269
#define I_SETPE         270
#define I_SETNP         271
#define I_SETPO         272
#define I_SETL          273
#define I_SETNGE        274
#define I_SETC          275
#define I_SETNC         276
#define I_SETLE         277
#define I_SETNG         278
#define I_SETNL         279
#define I_SETGE         280
#define I_SETNLE        281
#define I_SETG          282
#define I_PUSHAD        283
#define I_POPAD         284
#define I_POPFD         285
#define I_PUSHFD        286
#define I_IRETD         287
#define I_FUCOM         288
#define I_FUCOMP        289
#define I_FUCOMPP       290
#define I_FPREM1        291
#define I_FCOS          292
#define I_FSIN          293
#define I_FSINCOS       294
#define I_RETN          295
#define I_RETF          296

#else

#define I_RETN          228
#define I_RETF          229

#endif

/* indices for size table */

#define I_BYTE          0
#define I_DWORD         1
#define I_FAR           2
#define I_NEAR          3
#define I_QWORD         4
#define I_TBYTE         5
#define I_WORD          6
#define I_FWORD         7
#define I_PROC          8


/* indices for first tokens */

#define I_TASSUME       0
#define I_TCOMMENT      1
#define I_TDB           2
#define I_TDD           3
#define I_TDQ           4
#define I_TDT           5
#define I_TDW           6
#define I_TELSE         7
#define I_TEND          8
#define I_TENDIF        9
#define I_TENDM         10
#define I_TERR          11
#define I_TERR1         12
#define I_TERR2         13
#define I_TERRB         14
#define I_TERRDEF       15
#define I_TERRDIF       16
#define I_TERRE         17
#define I_TERRNZ        18
#define I_TERRIDN       19
#define I_TERRNB        20
#define I_TERRNDEF      21
#define I_TEVEN         22
#define I_TEXITM        23
#define I_TEXTRN        24
#define I_TIF           25
#define I_TIF1          26
#define I_TIF2          27
#define I_TIFB          28
#define I_TIFDEF        29
#define I_TIFDIF        30
#define I_TIFE          31
#define I_TIFIDN        32
#define I_TIFNB         33
#define I_TIFNDEF       34
#define I_TINCLUDE      35
#define I_TIRP          36
#define I_TIRPC         37
#define I_TLOCAL        38
#define I_TNAME         39
#define I_TORG          40
#define I_TPAGE         41
#define I_TPUBLIC       42
#define I_TPURGE        43
#define I_TREPT         44
#define I_TSUBTTL       45
#define I_TTITLE        46
#define I_TCREF         47
#define I_TLALL         48
#define I_TLFCOND       49
#define I_TLIST         50
#define I_TRADIX        51
#define I_TSALL         52
#define I_TSFCOND       53
#define I_TTFCOND       54
#define I_TXALL         55
#define I_TXCREF        56
#define I_TXLIST        57
#define I_TOUT          58
#define I_TALIGN        59
#define I_T8086         60
#define I_T8087         61
#define I_T287          62
#define I_T186          63
#define I_T286C         64
#define I_T286P         65
#define I_TINCLIB       66
#define I_TMSTACK       67
#define I_TDOSSEG       68
#define I_TMODEL        69
#define I_TCODE         70
#define I_TDATA         71
#define I_TDATAQ        72
#define I_TCONST        73
#define I_TFARDATA      74
#define I_TFARDATAQ     75
#define I_TSEQ          76
#define I_TALPHA        77
#define I_TCOMM         78
#define I_TIFDIFI       79
#define I_TIFIDNI       80
#define I_TERRDIFI      81
#define I_TERRIDNI      82
#define I_TELSEIF       83
#define I_TELSEIF1      84
#define I_TELSEIF2      85
#define I_TELSEIFB      86
#define I_TELSEIFDEF    87
#define I_TELSEIFDIF    88
#define I_TELSEIFE      89
#define I_TELSEIFIDN    90
#define I_TELSEIFNB     91
#define I_TELSEIFNDEF   92
#define I_TELSEIFDIFI   93
#define I_TELSEIFIDNI   94
#define I_TFPO          99

#ifdef V386
#define I_T386C         95
#define I_T386P         96
#define I_T387          97
#define I_TDF           98
#endif

/* indices for second tokens */

#define I2_TDB          0
#define I2_TDD          1
#define I2_TDQ          2
#define I2_TDT          3
#define I2_TDW          4
#define I2_TENDP        5
#define I2_TENDS        6
#define I2_TEQU         7
#define I2_TSUBSTR      8
#define I2_TCATSTR      9
#define I2_TSIZESTR     10
#define I2_TINSTR       11
#define I2_TGROUP       12
#define I2_TLABEL       13
#define I2_TMACRO       14
#define I2_TPROC        15
#define I2_TRECORD      16
#define I2_TSEGMENT     17
#define I2_TSTRUC       18

#ifdef V386
#define I2_TDF          19
#endif

/* indices for segment attributes */

#define IS_AT           0
#define IS_BYTE         1
#define IS_COMMON       2
#define IS_MEMORY       3
#define IS_PAGE         4
#define IS_PARA         5
#define IS_PUBLIC       6
#define IS_STACK        7
#define IS_WORD         8
#define IS_DWORD        9

#ifdef V386
#define IS_USE32        10
#define IS_USE16        11
#endif

