/* asmopcod.h -- include file for microsoft 80x86 assembler
**
** microsoft (r) macro assembler
** copyright (c) microsoft corp 1986.  all rights reserved
**
** randy nevin
*/

#define IMUL3		0x69	/* 3 argument integer multiply */
#define ARITHBASE	0xF6	/* base opcode for arithmetic opcodes */

/* base opcode for all instructions */

#define O_AAA		0x37
#define O_AAD		0xD5
#define O_AAM		0xD4
#define O_AAS		0x3F
#define O_ADC		0x10       /* ?????? */
#define O_ADD		0x00       /* ?????? */
#define O_AND		0x20       /* ?????? */
#define O_ARPL		0x63
#define O_BOUND		0x62
#define O_CALL		0xE8
#define O_CALLGATE	0xFF
#define O_CBW		0x98
#define O_CLC		0xF8
#define O_CLD		0xFC
#define O_CLI		0xFA
#define O_CLTS		0x0F
#define O_CMC		0xF5
#define O_CMP		0x38       /* ?????? */
#define O_CMPS		0xA6
#define O_CMPSB		0xA6
#define O_CMPSW		0xA7
#define O_CWD		0x99
#define O_DAA		0x27
#define O_DAS		0x2F
#define O_DEC		0x48       /* ?????? */
#define O_DIV		0xF6
#define O_ENTER		0xC8
#define O_ESC		0x36       /* not opcode */
#define O_HLT		0xF4
#define O_IDIV		0xF6
#define O_IMUL		0xF6
#define O_IN		0xE4
#define O_INC		0x40
#define O_INS		0x6C
#define O_INSB		0x6C
#define O_INSW		0x6D
#define O_INT		0xCC
#define O_INTO		0xCE
#define O_IRET		0xCF
#define O_JA		0x77
#define O_JAE		0x73
#define O_JB		0x72
#define O_JBE		0x76
#define O_JC		0x72
#define O_JCXZ		0xE3
#define O_JE		0x74
#define O_JG		0x7F
#define O_JGE		0x7D
#define O_JL		0x7C
#define O_JLE		0x7E
#define O_JMP		0xE9
#define O_JNA		0x76
#define O_JNAE		0x72
#define O_JNB		0x73
#define O_JNBE		0x77
#define O_JNC		0x73
#define O_JNE		0x75
#define O_JNG		0x7E
#define O_JNGE		0x7C
#define O_JNL		0x7D
#define O_JNLE		0x7F
#define O_JNO		0x71
#define O_JNP		0x7B
#define O_JNS		0x79
#define O_JNZ		0x75
#define O_JO		0x70
#define O_JP		0x7A
#define O_JPE		0x7A
#define O_JPO		0x7B
#define O_JS		0x78
#define O_JZ		0x74
#define O_LAHF		0x9F
#define O_LAR		0x0F
#define O_LDS		0xC5
#define O_LEA		0x8D
#define O_LES		0xC4
#define O_LEAVE		0xC9
#define O_LGDT		0x0F
#define O_LIDT		0x0F
#define O_LLDT		0x0F
#define O_LMSW		0x0F
#define O_LOCK		0xF0
#define O_LODS		0xAC
#define O_LODSB		0xAC
#define O_LODSW		0xAD
#define O_LOOP		0xE2
#define O_LOOPE		0xE1
#define O_LOOPNE	0xE0
#define O_LOOPNZ	0xE0
#define O_LOOPZ		0xE1
#define O_LSL		0x0F
#define O_LTR		0x0F
#define O_MOV		0xA2
#define O_MOVBOFF	0xA0
#define O_MOVBREA	0x88
#define O_MOVFSEG	0x8C
#define O_MOVTSEG	0x8E
#define O_MOVS		0xA4
#define O_MOVSB		0xA4
#define O_MOVSW		0xA5
#define O_MUL		0xF6
#define O_NEG		0xF6
#define O_NOP		0x90
#define O_NOT		0xF6
#define O_OR		0x08
#define O_OUT		0xE6
#define O_OUTS		0x6E
#define O_OUTSB		0x6E
#define O_OUTSW		0x6F
#define O_POP		0x58
#define O_POPA		0x61
#define O_POPF		0x9D
#define O_POPM		0x8F
#define O_PUSH		0x50
#define O_PUSHA		0x60
#define O_PUSHF		0x9C
#define O_PUSHM		0xFF
#define O_RCL		0xD0
#define O_RCR		0xD0
#define O_REP		0xF3
#define O_REPE		0xF3
#define O_REPNE		0xF2
#define O_REPNZ		0xF2
#define O_REPZ		0xF3
#define O_RET		0xC3
#define O_ROL		0xD0
#define O_ROR		0xD0
#define O_SAHF		0x9E
#define O_SAL		0xD0
#define O_SAR		0xD0
#define O_SBB		0x18
#define O_SCAS		0xAE
#define O_SCASB		0xAE
#define O_SCASW		0xAF
#define O_SGDT		0x0F
#define O_SHL		0xD0
#define O_SHR		0xD0
#define O_SIDT		0x0F
#define O_SLDT		0x0F
#define O_SMSW		0x0F
#define O_STC		0xF9
#define O_STD		0xFD
#define O_STI		0xFB
#define O_STOS		0xAA
#define O_STOSB		0xAA
#define O_STOSW		0xAB
#define O_STR		0x0F
#define O_SUB		0x28
#define O_TEST		0x84
#define O_VERR		0x0F
#define O_VERW		0x0F
#define O_WAIT		0x9B
#define O_XCHG		0x90
#define O_XCHGBREA	0x86
#define O_XCHGWRAX	0x90
#define O_XLAT		0xD7
#define O_XLATB		0xD7
#define O_XOR		0x30

#ifdef V386
#define O_MOVSX		0x0FBE
#define O_MOVZX		0x0FB6
#define O_CWDE		0x98
#define O_CDQ		0x99
#define O_LFS		0xB4
#define O_LGS		0xB5
#define O_LSS		0xB2
#define O_SHLD		0xA4
#define O_SHRD		0xAC
#define O_CMPSD		0xA7
#define O_INSD		0x6D
#define O_LODSD		0xAD
#define O_MOVSD		0xA5
#define O_OUTSD		0x6F
#define O_SCASD		0xAF
#define O_STOSD		0xAB
#define O_BSF		0x0F
#define O_BSR		0x0F
#define O_BT		0x0F
#define O_BTC		0x0F
#define O_BTR		0x0F
#define O_BTS		0x0F
#define O_IBTS		0x0F
#define O_XBTS		0x0F
#define O_JECXZ		0xE3
#define O_SETO		0x0F
#define O_SETNO		0x0F
#define O_SETB		0x0F
#define O_SETNAE	0x0F
#define O_SETNB		0x0F
#define O_SETAE		0x0F
#define O_SETE		0x0F
#define O_SETZ		0x0F
#define O_SETNE		0x0F
#define O_SETNZ		0x0F
#define O_SETBE		0x0F
#define O_SETNA		0x0F
#define O_SETNBE	0x0F
#define O_SETA		0x0F
#define O_SETS		0x0F
#define O_SETNS		0x0F
#define O_SETP		0x0F
#define O_SETPE		0x0F
#define O_SETNP		0x0F
#define O_SETPO		0x0F
#define O_SETL		0x0F
#define O_SETNGE	0x0F
#define O_SETC		0x0F
#define O_SETNC		0x0F
#define O_SETLE		0x0F
#define O_SETNG		0x0F
#define O_SETNL		0x0F
#define O_SETGE		0x0F
#define O_SETNLE	0x0F
#define O_SETG		0x0F
#define O_PUSHAD	0x60
#define O_POPAD		0x61
#define O_POPFD		0x9D
#define O_PUSHFD	0x9C
#define O_IRETD		0xCF
#endif

#define O_RETN		0xC3
#define O_RETF		0xCB

/* modrm bits for 8086/186/286/386 instructions  */

#define R_AAD		0x0A
#define R_AAM		0x0A
#define R_CLTS		0x06
#define R_DIV		0x06
#define R_IDIV		0x07
#define R_IMUL		0x05
#define R_LAR		0x02
#define R_LGDT		0x02
#define R_LIDT		0x03
#define R_LLDT		0x02
#define R_LMSW		0x06
#define R_LSL		0x03
#define R_LTR		0x03
#define R_MUL		0x04
#define R_NEG		0x03
#define R_NOT		0x02
#define R_RCL		0x02
#define R_RCR		0x03
#define R_ROL		0x00
#define R_ROR		0x01
#define R_SAL		0x04
#define R_SAR		0x07
#define R_SGDT		0x00
#define R_SHL		0x04
#define R_SHR		0x05
#define R_SIDT		0x01
#define R_SLDT		0x00
#define R_SMSW		0x04
#define R_STR		0x01
#define R_VERR		0x04
#define R_VERW		0x05
#define R_BT		0x04
#define R_BTC		0x07
#define R_BTR		0x06
#define R_BTS		0x05
#define R_SETO		0x90
#define R_SETNO		0x91
#define R_SETB		0x92
#define R_SETNAE	0x92
#define R_SETNB		0x93
#define R_SETAE		0x93
#define R_SETE		0x94
#define R_SETZ		0x94
#define R_SETNE		0x95
#define R_SETNZ		0x95
#define R_SETBE		0x96
#define R_SETNA		0x96
#define R_SETNBE	0x97
#define R_SETA		0x97
#define R_SETS		0x98
#define R_SETNS		0x99
#define R_SETP		0x9A
#define R_SETPE		0x9A
#define R_SETNP		0x9B
#define R_SETPO		0x9B
#define R_SETL		0x9C
#define R_SETNGE	0x9C
#define R_SETC		0x92
#define R_SETNC		0x93
#define R_SETLE		0x9E
#define R_SETNG		0x9E
#define R_SETNL		0x9D
#define R_SETGE		0x9D
#define R_SETNLE	0x9F
#define R_SETG		0x9F


/* 8087/287 instructions */

#define O_F2XM1		0xD9
#define O_FABS		0xD9
#define O_FADD		0xD8
#define O_FADDP		0xDE
#define O_FBLD		0xDF
#define O_FBSTP		0xDF
#define O_FCHS		0xD9
#define O_FCLEX		0xDB
#define O_FCOM		0xD8
#define O_FCOMP		0xD8
#define O_FCOMPP	0xDE
#define O_FDECSTP	0xD9
#define O_FDISI		0xDB
#define O_FDIV		0xD8
#define O_FDIVP		0xDE
#define O_FDIVR		0xD8
#define O_FDIVRP	0xDE
#define O_FENI		0xDB
#define O_FFREE		0xDD
#define O_FIADD		0xDA
#define O_FICOM		0xDA
#define O_FICOMP	0xDA
#define O_FIDIV		0xDA
#define O_FIDIVR	0xDA
#define O_FILD		0xDB
#define O_FIMUL		0xDA
#define O_FINCSTP	0xD9
#define O_FINIT		0xDB
#define O_FIST		0xDB
#define O_FISTP		0xDB
#define O_FISUB		0xDA
#define O_FISUBR	0xDA
#define O_FLD		0xD9
#define O_FLD1		0xD9
#define O_FLDCW		0xD9
#define O_FLDENV	0xD9
#define O_FLDL2E	0xD9
#define O_FLDL2T	0xD9
#define O_FLDLG2	0xD9
#define O_FLDLN2	0xD9
#define O_FLDPI		0xD9
#define O_FLDZ		0xD9
#define O_FMUL		0xD8
#define O_FMULP		0xDE
#define O_FNCLEX	0xDB
#define O_FNDISI	0xDB
#define O_FNENI		0xDB
#define O_FNINIT	0xDB
#define O_FNOP		0xD9
#define O_FNSAVE	0xDD
#define O_FNSTCW	0xD9
#define O_FNSTENV	0xD9
#define O_FNSTSW	0xDD
#define O_FPATAN	0xD9
#define O_FPREM		0xD9
#define O_FPTAN		0xD9
#define O_FRNDINT	0xD9
#define O_FRSTOR	0xDD
#define O_FSAVE		0xDD
#define O_FSCALE	0xD9
#define O_FSETPM	0xDB
#define O_FSQRT		0xD9
#define O_FST		0xD9
#define O_FSTCW		0xD9
#define O_FSTENV	0xD9
#define O_FSTP		0xD9
#define O_FSTSW		0xDD
#define O_FSTSWAX	0xDF
#define O_FSUB		0xD8
#define O_FSUBP		0xDE
#define O_FSUBR		0xD8
#define O_FSUBRP	0xDE
#define O_FTST		0xD9
#define O_FWAIT		0xD8
#define O_FXAM		0xD9
#define O_FXCH		0xD9
#define O_FXTRACT	0xD9
#define O_FYL2X		0xD9
#define O_FYL2XP1	0xD9
#define O_FNRSTOR	0xDD

#ifdef V386

#define O_FSIN		0xD9
#define O_FSINCOS	0xD9
#define O_FCOS		0xD9
#define O_FPREM1	0xD9
#define O_FUCOM 	0xDD
#define O_FUCOMP	0xDD
#define O_FUCOMPP	0xDA

#endif
/* 8087/287 modrm bits */

#define R_F2XM1		0xF0
#define R_FABS		0xE1
#define R_FADD		0x00
#define R_FADDP		0x00
#define R_FBLD		0x04
#define R_FBSTP		0x06
#define R_FCHS		0xE0
#define R_FCLEX		0xE2
#define R_FCOM		0x02
#define R_FCOMP		0x03
#define R_FCOMPP	0xD9
#define R_FDECSTP	0xF6
#define R_FDISI		0xE1
#define R_FDIV		0x06
#define R_FDIVP		0x07
#define R_FDIVR		0x07
#define R_FDIVRP	0x06
#define R_FENI		0xE0
#define R_FFREE		0x00
#define R_FIADD		0x00
#define R_FICOM		0x02
#define R_FICOMP	0x03
#define R_FIDIV		0x06
#define R_FIDIVR	0x07
#define R_FILD		0x00
#define R_FIMUL		0x01
#define R_FINCSTP	0xF7
#define R_FINIT		0xE3
#define R_FIST		0x02
#define R_FISTP		0x03
#define R_FISUB		0x04
#define R_FISUBR	0x05
#define R_FLD		0x00
#define R_FLD1		0xE8
#define R_FLDCW		0x05
#define R_FLDENV	0x04
#define R_FLDL2E	0xEA
#define R_FLDL2T	0xE9
#define R_FLDLG2	0xEC
#define R_FLDLN2	0xED
#define R_FLDPI		0xEB
#define R_FLDZ		0xEE
#define R_FMUL		0x01
#define R_FMULP		0x01
#define R_FNCLEX	0xE2
#define R_FNDISI	0xE1
#define R_FNENI		0xE0
#define R_FNINIT	0xE3
#define R_FNOP		0xD0
#define R_FNSAVE	0x06
#define R_FNSTCW	0x07
#define R_FNSTENV	0x06
#define R_FNSTSW	0x07
#define R_FPATAN	0xF3
#define R_FPREM		0xF8
#define R_FPTAN		0xF2
#define R_FRNDINT	0xFC
#define R_FRSTOR	0x04
#define R_FSAVE		0x06
#define R_FSCALE	0xFD
#define R_FSETPM	0xE4
#define R_FSQRT		0xFA
#define R_FST		0x02
#define R_FSTCW		0x07
#define R_FSTENV	0x06
#define R_FSTP		0x03
#define R_FSTSW		0x07
#define R_FSTSWAX	0x04	/* sleazy trick to make fltmodrm work */
#define R_FSUB		0x04
#define R_FSUBP		0x05
#define R_FSUBR		0x05
#define R_FSUBRP	0x04
#define R_FTST		0xE4
#define R_FWAIT		0x9B
#define R_FXAM		0xE5
#define R_FXCH		0x01
#define R_FXTRACT	0xF4
#define R_FYL2X		0xF1
#define R_FYL2XP1	0xF9
#define R_FNRSTOR	0x04

#ifdef V386

#define R_FPREM1	0xF5
#define R_FSIN		0xFE
#define R_FCOS		0xFF
#define R_FSINCOS	0xFB
#define R_FUCOM 	0x04
#define R_FUCOMP	0x05
#define R_FUCOMPP	0xE9

#endif
