/*++ BUILD Version: 0001    // Increment this if a change has global effects

Copyright (c) 1992  Microsoft Corporation

Module Name:

    datanbf.c

Abstract:
       
    a file containing the constant data structures
    for the Performance Monitor data for the Nbf
    Extensible Objects.

    This file contains a set of constant data structures which are
    currently defined for the Nbf Extensible Objects.  This is an 
    example of how other such objects could be defined.

Created:

    Russ Blake  07/31/92

Revision History:

    None.

--*/
//
//  Include Files
//

#include <nt.h>
#include <ntrtl.h>
#include <nturtl.h>
#include <windows.h>
#include <winperf.h>
#include "datanbf.h"

//
//  Constant structure initializations
//

NBF_RESOURCE_DATA_DEFINITION NbfResourceDataDefinition = {

    {   sizeof(NBF_RESOURCE_DATA_DEFINITION) + SIZE_OF_NBF_RESOURCE_DATA,
        sizeof(NBF_RESOURCE_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        494,
        0,
        495,
        0,
        PERF_DETAIL_ADVANCED,
        (sizeof(NBF_RESOURCE_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        1,
        0,
        0
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        496,
        0,
        497,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        MAXIMUM_USED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        498,
        0,
        499,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        AVERAGE_USED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        500,
        0,
        501,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        NUMBER_OF_EXHAUSTIONS_OFFSET
    }
};




NBF_DATA_DEFINITION NbfDataDefinition = {

    {   sizeof(NBF_DATA_DEFINITION) + SIZE_OF_NBF_DATA,
        sizeof(NBF_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        492,
        0,
        493,
        0,
        PERF_DETAIL_ADVANCED,
        (sizeof(NBF_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        5,     // default is Bytes Total /sec
        0,
        0
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        438,
        0,
        439,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        DATAGRAMS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        440,
        0,
        441,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        DATAGRAM_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        400,
        0,
        451,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        PACKETS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        456,
        0,
        457,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        FRAMES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        458,
        0,
        459,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        FRAMES_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        388,
        0,
        67,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        BYTES_TOTAL_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        412,
        0,
        413,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        OPEN_CONNECTIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        414,
        0,
        415,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        CONNECTIONS_NO_RETRY_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        416,
        0,
        417,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        CONNECTIONS_RETRY_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        418,
        0,
        419,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        LOCAL_DISCONNECTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        420,
        0,
        421,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        REMOTE_DISCONNECTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        422,
        0,
        423,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        LINK_FAILURES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        424,
        0,
        425,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ADAPTER_FAILURES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        426,
        0,
        427,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SESSION_TIMEOUTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        428,
        0,
        429,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        CANCELLED_CONNECTIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        430,
        0,
        431,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        REMOTE_RESOURCE_FAILURES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        432,
        0,
        433,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        LOCAL_RESOURCE_FAILURES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        434,
        0,
        435,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        NOT_FOUND_FAILURES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        436,
        0,
        437,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        NO_LISTEN_FAILURES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        442,
        0,
        443,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        DATAGRAMS_SENT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        444,
        0,
        445,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        DATAGRAM_BYTES_SENT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        446,
        0,
        447,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        DATAGRAMS_RECEIVED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        448,
        0,
        449,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        DATAGRAM_BYTES_RECEIVED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        452,
        0,
        453,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        PACKETS_SENT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        266,
        0,
        455,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        PACKETS_RECEIVED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        460,
        0,
        461,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        FRAMES_SENT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        462,
        0,
        463,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        FRAME_BYTES_SENT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        464,
        0,
        465,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        FRAMES_RECEIVED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        466,
        0,
        467,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        FRAME_BYTES_RECEIVED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        468,
        0,
        469,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        FRAMES_RESENT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        470,
        0,
        471,
        0,
        -4,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        FRAME_BYTES_RESENT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        472,
        0,
        473,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        FRAMES_REJECTED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        474,
        0,
        475,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        FRAME_BYTES_REJECTED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        476,
        0,
        477,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        RESPONSE_TIMER_EXPIRATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        478,
        0,
        479,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ACK_TIMER_EXPIRATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        480,
        0,
        481,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        MAXIMUM_SEND_WINDOW_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        482,
        0,
        483,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        AVERAGE_SEND_WINDOW_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        484,
        0,
        485,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        PIGGYBACK_ACK_QUEUED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        486,
        0,
        487,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PIGGYBACK_ACK_TIMEOUTS_OFFSET
    }
};



