!IF 0

Copyright (c) 1994  Microsoft Corporation

Module Name:

    mipsmk.inc

Abstract:

        This module contains the MIPs specific build controls.  It is included
        by makefile.def.

Author:

    Jeff Havens (jhavens) 13-Feb-1994

Revision History:

!ENDIF

#
# Mips option control
#

UMBASE=$(UMBASE:*=mips)
UMLIBS=$(UMLIBS:*=mips)
NTRES=$(NTRES:*=mips)
UMRES=$(UMRES:*=mips)
UMOBJS=$(UMOBJS:*=mips)
LINKLIBS=$(LINKLIBS:*=mips)
DLLBASE=$(DLLBASE:*=mips)
DLLDEF=$(DLLDEF:*=mips)
MACHINE_TARGETLIBS=$(MACHINE_TARGETLIBS:*=mips)
TARGET=$(TARGET:*=mips)
DYNLINK_LIB=$(DYNLINK_LIB:*=mips)
TARGETEXEFILES=$(TARGETEXEFILES:*=mips)
TARGETLIBFILES=$(TARGETLIBFILES:*=mips)
TARGETOBJFILES=$(TARGETOBJFILES:*=mips)
UMOBJFILES=$(UMOBJFILES:*=mips)
UMEXEFILES=$(UMEXEFILES:*=mips)
HEADERFILE=$(HEADERFILE:*=mips)
HEADEROBJNAME=$(HEADEROBJNAME:*=mips)
HEADEROBJ=$(HEADEROBJ:*=mips)
PRECOMPILED=$(PRECOMPILED:*=mips)
PRECOMPILED_CXX=$(PRECOMPILED_CXX:*=mips)
PRECOMPILED_TARGET=$(PRECOMPILED_TARGET:*=mips)

!ifdef NTTARGETFILES
NTTARGETFILES=$(NTTARGETFILES:*=mips)
!endif
!ifdef NTTARGETFILE0
NTTARGETFILE0=$(NTTARGETFILE0:*=mips)
!endif
!ifdef NTTARGETFILE1
NTTARGETFILE1=$(NTTARGETFILE1:*=mips)
!endif

!IF "$(GPSIZE)" != "0"

LIBC_LIB=$(BASEDIR)\public\sdk\lib\mips\small.lib $(LIBC_LIB)

LINKGPSIZE=-gpsize:$(GPSIZE)

!ENDIF

LINKER_FLAGS = $(LINKER_FLAGS) -merge:.xdata=.rdata

MIPS_ENDIAN=MIPSEL

!IF "$(MIPS_F77)" == ""
MIPS_F77=f772.20
!ENDIF

ENTRY_SUFFIX=
GDI_ENTRY_SUFFIX=

!IFDEF MIPS_WARNING_LEVEL
MSC_WARNING_LEVEL=$(MIPS_WARNING_LEVEL)
!ENDIF
!IFDEF MIPS_OPTIMIZATION
MSC_OPTIMIZATION=$(MIPS_OPTIMIZATION)
!ENDIF
!IFDEF MIPS_CPPFLAGS
MSC_CPPFLAGS=$(MIPS_CPPFLAGS)
!ENDIF

#
# Now a bunch of MIPS stuff
#

!IF "$(MSC_OPTFLAGS)" == "/Oxs"
DBGFLAGS=$(MSC_OPTFLAGS:/Oxs=/Ox)
!ENDIF

DBGFLAGS = $(DBGFLAGS:/Zi=-Z7)

# Use /Z7 instead of /Zi

DBGFLAGS=$(DBGFLAGS:-Zi=-Z7)

!IFNDEF MIPS_R3000
MIPS_CPU=-DR4000 -D_M_MRX000=4000
MIPS_TRAP_FILE=x4trap.obj
!ELSE
MIPS_CPU=-DR3000 -D_M_MRX000=3000
MIPS_TRAP_FILE=x3trap.obj
!ENDIF

MIPS_ASM_DEFINES=$(MIPS_ASMCPP)
ENV_DEFINES=$(LIBC_DEFINES) $(C_DEFINES) $(NET_C_DEFINES) $(MSC_CPPFLAGS) $(NTCPPFLAGS)

STD_DEFINES=-DMIPS=1 -D_MIPS_=1 -D$(MIPS_ENDIAN) -DNO_EXT_KEYS -DCONDITION_HANDLING=1 $(STD_DEFINES)

STDFLAGS=-c
MS_MIPS=1

MSC_C_COMPILER_NAME=cl $(CBSTRING) -nologo

CDEFINES=$(STD_DEFINES) $(MIPS_CPU) $(TARGET_DBG_DEFINES) $(ENV_DEFINES)
CFLAGS=$(MIPS_FLAGS) $(NTMIPSFLAGS) $(STDFLAGS) $(DBGFLAGS) $(MIPS_PERFFLAGS) $(USER_C_FLAGS)
AFLAGS=-Gy $(MIPS_FLAGS) $(NTMIPSFLAGS) $(STDFLAGS) $(DBGFLAGS) $(MIPS_PERFFLAGS)

MIPS_CDEFINES=$(CDEFINES)
MIPS_CFLAGS=$(CFLAGS) -Zel -Zp8 -Gy $(MSC_WARNING_LEVEL) -QMOb4000
MIPS_CFLAGS=$(MIPS_CFLAGS:-Qmips=-QM)

C_PREPROCESSOR_NAME  = $(MSC_C_COMPILER_NAME)
C_COMPILER_NAME      = $(MSC_C_COMPILER_NAME)
CXX_COMPILER_NAME    = $(MSC_C_COMPILER_NAME)
MIPS_ASSEMBLER_NAME  = $(MSC_C_COMPILER_NAME)

GLOBAL_C_FLAGS       = -nologo -Imips\ -I. $(INCPATH0) $(CDEFINES) $(MIPS_CFLAGS) \
                       -DFPO=1 -D__stdcall= -D__cdecl= -D_LANGUAGE_C -DLANGUAGE_C $(MFC_FLAGS)

C_PREPROCESSOR_FLAGS = $(GLOBAL_C_FLAGS) $(PRECOMPILED) -EP -Tc
C_COMPILER_FLAGS     = $(GLOBAL_C_FLAGS) $(PRECOMPILED) -Gt$(GPSIZE) $(COMPILER_WARNINGS)
CXX_COMPILER_FLAGS   = $(GLOBAL_C_FLAGS) $(PRECOMPILED_CXX) -Gt$(GPSIZE) $(COMPILER_WARNINGS)

C_PREPROCESSOR = $(C_PREPROCESSOR_NAME) $(C_PREPROCESSOR_FLAGS)
C_COMPILER     = $(C_COMPILER_NAME) $(C_COMPILER_FLAGS)
CXX_COMPILER   = $(CXX_COMPILER_NAME) $(CXX_COMPILER_FLAGS)

ECHO_MSG=ClMips $< " $(C_COMPILER) "

ECHO_PRECOMPILED_MSG=CpMips $(PRECOMPILED_INCLUDE) " $(C_COMPILER) \
                     /Yl$(TARGETNAME) /Yc$(?F) $(HEADERFILE) \
                     $(HEADEROBJ) $(PRECOMPILED_FLAG)"

MIPS_FORTRAN_COMPILER=$(MIPS_F77) $(MSC_WARNINGS) $(MIPS_OPTIONS) -G $(GPSIZE) \
                       -excpt -G0 $(MSC_OPTIMIZATION) -O -EL -c

MIPS_CRFILTER=echo SHOULDN'T NEED TO CRFILTER THIS!

!IF "$(NTDEBUG)" == "" || "$(NTDEBUG)" == "retail"
!IFNDEF MIPS_ENABLE_DIVIDE_CHECK
MIPS_CFLAGS=$(MIPS_CFLAGS)  -d2aNoDivCheck
!ENDIF
!ENDIF

!ifdef MIPS_ENABLE_MIPS3
AFLAGS=$(AFLAGS) -d2QMmips3
!endif

#
# Use Mips MCL for assembler files.
#

MIPS_ASSEMBLER_FLAGS = -nologo -Gt$(GPSIZE) -Ge -c $(MIPS_CPU_SWITCHES) \
                        -Imips\ -I. $(INCPATH0) $(CDEFINES) \
                        $(AFLAGS) -D_LANGUAGE_ASSEMBLY

MIPS_ASSEMBLER = $(MIPS_ASSEMBLER_NAME) $(MIPS_ASSEMBLER_FLAGS)

{..\mips\}.s{obj\mips\}.obj:
    @-erase $@ >nul 2>&1
    @echo AsMips $<     " $(MIPS_ASSEMBLER) "
    @$(MIPS_ASSEMBLER_NAME) @<< -Fo$(MAKEDIR)\$@ $<
$(MIPS_ASSEMBLER_FLAGS: =
)
<<NOKEEP

{mips\}.s{obj\mips\}.obj:
    @-erase $@ >nul 2>&1
    @echo AsMips $<     " $(MIPS_ASSEMBLER) $(MIPS_ASSEMBLER_FLAGS)"
    @$(MIPS_ASSEMBLER_NAME) @<< -Fo$(MAKEDIR)\$@ $<
$(MIPS_ASSEMBLER_FLAGS: =
)
<<NOKEEP

LINKFLAGS=$(LNKFLAGS) -NODEFAULTLIB
LIBRARY_OBJS=$(LINKLIBS) $(OBJECTS)
# LIBRARY_OBJS=

!IFDEF TUKWILA
_NTTREE=$(_NTMIPSTREE)
!ENDIF

!IFDEF CAIRO_PRODUCT
!IFDEF _CAIROMIPSTREE
_NTTREE=$(_CAIROMIPSTREE)
!ENDIF
!ELSEIFDEF _NTMIPSTREE
_NTTREE=$(_NTMIPSTREE)
!ENDIF

!IFDEF KERNEL_MODE
_NTTREE=$(_NTMIPSTREE)\km
!ENDIF

!IFDEF _NTMIPSLIBS
_NTLIBS=$(_NTMIPSLIBS)
!ENDIF

COPYDST=$(MIPSCOPYDST)
LIB_COPY=ntmipscp.cmd

NTTEST_LINK_OPTIONS= -base:0x10000 -entry:KiSystemStartup
