//+---------------------------------------------------------------------------
//
//  Microsoft Windows
//  Copyright (C) Microsoft Corporation, 1992 - 1993.
//
//  File:       hard.cxx
//
//  Contents:   Disk Administrator volume extension class for hard disks
//
//  Classes:
//
//  Functions:
//
//  History:    10-May-93 BruceFo   Created from kevinro event report code
//
//  Note: Eventually, this code will be generated by tools. Therefore, the
//        comments and cleanliness is not up to par.
//
//----------------------------------------------------------------------------

#include <headers.hxx>
#pragma hdrstop

#include "hard.hxx"
#include "global.hxx"


CHardIUnknown::CHardIUnknown()
    : m_pClass(NULL),
      m_uRefs(1)
{
    InterlockedIncrement((LONG*)&g_ulcInstancesHard);
}


CHardIUnknown::~CHardIUnknown()
{
    InterlockedDecrement((LONG*)&g_ulcInstancesHard);
    delete m_pClass;
}

STDMETHODIMP
CHardIUnknown::QueryInterface(REFIID riid, LPVOID* ppvObj)
{
    *ppvObj = NULL;

    IUnknown *pUnkTemp = NULL;
    SCODE    sc = S_OK;

    if (IsEqualIID(IID_IUnknown, riid))
    {
        pUnkTemp = (IUnknown*) this;
    }
    else
    if (IsEqualIID(IID_IDAHardDiskInfo, riid))
    {
        pUnkTemp = (IDAHardDiskInfo*) m_pClass;
    }
    else
    {
        sc = E_NOINTERFACE;
    }

    if (pUnkTemp != NULL)
    {
        pUnkTemp->AddRef();
    }

    *ppvObj = pUnkTemp;

    return sc;
}


STDMETHODIMP_(ULONG)
CHardIUnknown::AddRef()
{
    InterlockedIncrement((LONG*)&m_uRefs);
    return m_uRefs;
}


STDMETHODIMP_(ULONG)
CHardIUnknown::Release()
{
    ULONG cRef;

    if (0 == (cRef=InterlockedDecrement((LONG*)&m_uRefs)))
    {
        delete this;
    }

    return cRef;
}


STDMETHODIMP
CHardCF::QueryInterface(REFIID riid, LPVOID* ppvObj)
{
    *ppvObj = NULL;

    IUnknown* pUnkTemp = NULL;
    SCODE sc = S_OK;

    if (   IsEqualIID(IID_IUnknown, riid)
        || IsEqualIID(IID_IClassFactory, riid))
    {
        pUnkTemp = (CHardCF *)this;
    }
    else
    {
        sc = E_NOINTERFACE;
    }

    if (pUnkTemp != NULL)
    {
        pUnkTemp->AddRef();
    }

    *ppvObj = pUnkTemp;

    return sc;
}


STDMETHODIMP_(ULONG)
CHardCF::AddRef()
{
    InterlockedIncrement((LONG*)&g_ulcInstancesHard);
    return g_ulcInstancesHard;
}

STDMETHODIMP_(ULONG)
CHardCF::Release()
{
    InterlockedDecrement((LONG*)&g_ulcInstancesHard);
    return g_ulcInstancesHard;
}



//
// IClassFactory Overide
//
STDMETHODIMP
CHardCF::CreateInstance(IUnknown* pUnkOuter, REFIID riid, LPVOID* ppvObj)
{
    HRESULT hr = S_OK;
    CHardIUnknown* pIUnk = NULL;

    pIUnk = new CHardIUnknown();

    if (pUnkOuter == NULL)
    {
        pIUnk->m_pClass = new CHard(pIUnk);

        hr = pIUnk->m_pClass->QueryInterface(riid, ppvObj);
        pIUnk->Release();

        if (FAILED(hr))
        {
            //
            // BUGBUG: Whats the error code?
            //

            hr = E_NOINTERFACE;
        }
    }
    else
    {
        if ( ! IsEqualIID(riid, IID_IUnknown) )
        {
            hr = E_NOINTERFACE;
        }
        else
        {
            pIUnk->m_pClass = new CHard(pUnkOuter);
            *ppvObj = (IUnknown *)pIUnk;
            pIUnk->AddRef();
        }
    }

    if (FAILED(hr))
    {
        delete pIUnk;
    }

    return hr;
}


STDMETHODIMP
CHardCF::LockServer(BOOL fLock)
{
    //
    // BUGBUG: Whats supposed to happen here?
    //
    return S_OK;
}
