/*==========================================================================;
 *
 *  Copyright (C) 1995,1996 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       dsdriver.h
 *  Content:    DirectSound driver include file
 *
 ***************************************************************************/

#ifndef _INC_DSDRIVER
#define _INC_DSDRIVER

#ifdef __cplusplus
extern "C" {
#endif


/*
 * The requested COM interface is not available.  This value is the same
 *  as E_NOINTERFACE as defined in winerror.h in the Win32 SDK.
 */
#define DSERR_NOINTERFACE               0x80004002L

//@@BEGIN_MSINTERNAL

// HALHWMODE flags  Note: This file is generated by modeflag.m4

#include "modeflag.h"

//
// HALHWMODE afAbilityFlags values
// 
// These flags describe dynamic capabilities (what the device
// can/cannot do)
// 

#define A_CAN_CHANGE_VOLUME         1   //Can change volume while playing
#define A_CANNOT_CHANGE_VOLUME      0   //Cannot change volume while playing

#define A_CAN_CHANGE_MODE           2   //Can change PCM mode while playing
#define A_CANNOT_CHANGE_MODE        0   //Cannot change PCM mode while playing

#define A_CAN_CHANGE_RATE           4   //Can change rate while playing
#define A_CANNOT_CHANGE_RATE        0   //Cannot change rate while playing

#define A_CAN_LOOP_SECONDARY        8   //Can loop secondary buffers before starting
#define A_CANNOT_LOOP_SECONDARY     0   //Cannot loop secondary buffers before starting

#define A_CAN_UNLOOP_SECONDARY      16  //Secondary bufers do not have to loop
#define A_CANNOT_UNLOOP_SECONDARY   0   //Secondary buffers must always loop

#define A_CAN_CHANGE_LOOP_STATUS    32  //Can turn looping on/off during playback
#define A_CANNOT_CHANGE_LOOP_STATUS 0   //Cannot turn looping on/off during playback

//
// Typedef for H_ flag sets
//

typedef DWORD HFLAGS;

//
// Typedef for A_ flag sets
//

typedef DWORD AFLAGS;

// 
// HALSTRBUF.dwFlags values
// 

#define HSB_DMA_ALLOC 1          // Buffer was allocated from DMA services
#define HSB_RAM_ALLOC 2          // Buffer was allocated from sound card RAM


// 
// Stream buffer descriptor
// 

typedef struct	{
    HFLAGS   hfFormat;           // PCM format flag desc of stream buffer
    DWORD    dwSampleRate;       // Stream sample rate
    LONG     lVolume;		 // mono volume
    LONG     lPan;		 // Pan position
    DWORD    dwLVolume;		 // For mixer  use - linear Left Voume
    DWORD    dwRVolume; 	 // For mixer  use - linear Right Voume
    DWORD    dwMVolume; 	 // For mixer  use - linear MONO Voume
   }                                                    
HALSTRBUF;                                              

typedef HALSTRBUF * LPHALSTRBUF;

//@@END_MSINTERNAL


//
// Driver description
//
typedef struct tDSDRIVERDESC {
    DWORD	dwFlags;
    TCHAR	szDesc[256];
    TCHAR	szDrvname[256];
    DWORD	dnDevNode;
    WORD	wVxdId;
    WORD	wReserved;
    ULONG	ulDeviceNum;
    DWORD	dwHeapType;
    LPVOID	pvDirectDrawHeap;
    DWORD	dwMemStartAddress;
    DWORD	dwMemEndAddress;
    DWORD	dwMemAllocExtra;
    LPVOID	pvReserved1;
    LPVOID	pvReserved2;
} DSDRIVERDESC, *PDSDRIVERDESC;
#define DSDDESC_DOMMSYSTEMOPEN		    0x00000001
#define DSDDESC_DOMMSYSTEMSETFORMAT	    0x00000002
#define DSDDESC_USESYSTEMMEMORY		    0x00000004
#define DSDDESC_DONTNEEDPRIMARYLOCK	    0x00000008
#define DSDDESC_DONTNEEDSECONDARYLOCK	    0x00000010

#define DSDHEAP_NOHEAP			    0x00000000
#define DSDHEAP_CREATEHEAP		    0x00000001
#define DSDHEAP_USEDIRECTDRAWHEAP	    0x00000002
#define DSDHEAP_PRIVATEHEAP		    0x00000003

//
// Driver caps
//
typedef struct tDSDRIVERCAPS {
    DWORD       dwFlags;
    DWORD       dwMinSecondarySampleRate;
    DWORD       dwMaxSecondarySampleRate;
    DWORD       dwPrimaryBuffers;
    DWORD       dwMaxHwMixingAllBuffers;
    DWORD       dwMaxHwMixingStaticBuffers;
    DWORD       dwMaxHwMixingStreamingBuffers;
    DWORD       dwFreeHwMixingAllBuffers;
    DWORD       dwFreeHwMixingStaticBuffers;
    DWORD       dwFreeHwMixingStreamingBuffers;
    DWORD       dwMaxHw3DAllBuffers;
    DWORD       dwMaxHw3DStaticBuffers;
    DWORD       dwMaxHw3DStreamingBuffers;
    DWORD       dwFreeHw3DAllBuffers;
    DWORD       dwFreeHw3DStaticBuffers;
    DWORD       dwFreeHw3DStreamingBuffers;
    DWORD       dwTotalHwMemBytes;
    DWORD       dwFreeHwMemBytes;
    DWORD       dwMaxContigFreeHwMemBytes;
} DSDRIVERCAPS, *PDSDRIVERCAPS;

//
// Buffer volume and pan
//
typedef struct tDSVOLUMEPAN {
    DWORD   dwTotalLeftAmpFactor;
    DWORD   dwTotalRightAmpFactor;
    
    LONG    lVolume;
    DWORD   dwVolAmpFactor;
    
    LONG    lPan;
    DWORD   dwPanLeftAmpFactor;	    // pan effect on left
    DWORD   dwPanRightAmpFactor;    // pan effect on right
} DSVOLUMEPAN, *PDSVOLUMEPAN;

//@@BEGIN_MSINTERNAL
//
// Return codes
//
typedef DWORD HALRESULT;

#define HAL_OK              0
#define HAL_ERROR           1
#define HAL_CANT_OPEN_VXD   2
#define HAL_ALLOC_FAILED    3
#define HAL_NOT_ALLOCATED   4
#define HAL_MUST_STOP_FIRST 5

#define HAL_SYSALLOCMEM	    11

//
// Pass HF_NO_CHANGE to HAL_ChangeStreamFormat() to leave parameter
// unchanged
//

#define HF_NO_CHANGE     0xffffffff


//
// This is slop size added on to the  end of the driver memory space to
// have extra room to loop if needed.
#define DRVMEM_SLOP_SIZE    32

//@@END_MSINTERNAL

//
// Direct Sound Driver interfaces
//
DEFINE_GUID(IID_IDsDriver,       0x8C4233C0L, 0xB4CC, 0x11CE, 0x92, 0x94, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(IID_IDsDriverBuffer, 0x8C4233C1L, 0xB4CC, 0x11CE, 0x92, 0x94, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);

//
//  IDsDriverBuffer
//
typedef struct IDSDRIVERBUFFER {
    struct IDSDRIVERBUFFERVTBL *lpVtbl;
} IDSDRIVERBUFFER, *PIDSDRIVERBUFFER;

typedef struct IDSDRIVERBUFFERVTBL {
    // IUnknown
    HRESULT (__stdcall *QueryInterface)	( PIDSDRIVERBUFFER, REFIID, LPVOID* );
    ULONG (__stdcall *AddRef)		( PIDSDRIVERBUFFER );
    ULONG (__stdcall *Release)		( PIDSDRIVERBUFFER );

    // IDsDriverBuffer
    HRESULT (__stdcall *Lock)		( PIDSDRIVERBUFFER pIDsDriverBuffer,
					  LPLPVOID ppvAudio1,
					  LPDWORD pdwLen1,
					  LPLPVOID ppvAudio2,
					  LPDWORD pdwLen2,
					  DWORD dwWritePosition,
					  DWORD dwWriteLen,
					  DWORD dwFlags );
    HRESULT (__stdcall *Unlock)		( PIDSDRIVERBUFFER pIDsDriverBuffer,
					  LPVOID pvAudio1,
					  DWORD dwLen1,
					  LPVOID pvAudio2,
					  DWORD dwLen2 );
    HRESULT (__stdcall *SetFormat)	( PIDSDRIVERBUFFER pIDsDriverBuffer,
					  LPWAVEFORMATEX pwfxToSet );
    HRESULT (__stdcall *SetFrequency)	( PIDSDRIVERBUFFER pIDsDriverBuffer,
					  DWORD dwFrequency );
    HRESULT (__stdcall *SetVolumePan)	( PIDSDRIVERBUFFER pIDsDriverBuffer,
					  PDSVOLUMEPAN pDsVolumePan );
    HRESULT (__stdcall *SetPosition)	( PIDSDRIVERBUFFER pIDsDriverBuffer,
					  DWORD dwNewPosition );
    HRESULT (__stdcall *GetPosition)	( PIDSDRIVERBUFFER pIDsDriverBuffer,
					  LPDWORD lpdwCurrentPlayCursor,
					  LPDWORD lpdwCurrentWriteCursor );
    HRESULT (__stdcall *Play)		( PIDSDRIVERBUFFER pIDsDriverBuffer,
					  DWORD dwReserved1,
					  DWORD	dwReserved2,
					  DWORD dwFlags );
    HRESULT (__stdcall *Stop)		( PIDSDRIVERBUFFER pIDsDriverBuffer);
} IDSDRIVERBUFFERVTBL;

//
//  IDsDriver
//
typedef struct IDSDRIVER {
    struct IDSDRIVERVTBL *lpVtbl;
} IDSDRIVER, *PIDSDRIVER;

typedef struct IDSDRIVERVTBL {
    // IUnknown
    HRESULT (__stdcall *QueryInterface)	( PIDSDRIVER, REFIID, LPVOID* );
    ULONG (__stdcall *AddRef)		( PIDSDRIVER );
    ULONG (__stdcall *Release)		( PIDSDRIVER );

    // IDsDriver
    HRESULT (__stdcall *GetDriverDesc)    ( PIDSDRIVER pIDsDriver,
					  PDSDRIVERDESC );
    HRESULT (__stdcall *Open)		( PIDSDRIVER pIDsDriver );
    HRESULT (__stdcall *Close)		( PIDSDRIVER pIDsDriver );
    HRESULT (__stdcall *GetCaps)          ( PIDSDRIVER pIDsDriver,
					  PDSDRIVERCAPS pDsDrvCaps );
    HRESULT (__stdcall *CreateSoundBuffer)( PIDSDRIVER pIDsDriver,
					  LPWAVEFORMATEX pwfx,
					  DWORD dwFlags,
					  DWORD dwCardAddress,
					  LPDWORD pdwcbBufferSize,
					  LPBYTE *ppBuffer,
					  LPVOID *ppvObj );
    HRESULT (__stdcall *DuplicateSoundBuffer)( PIDSDRIVER pIDsDriver,
					  PIDSDRIVERBUFFER pIDsDriverBuffer,
					  LPVOID *ppv );
} IDSDRIVERVTBL;


//
//  Driver registration
//
// Device id registered to DSOUND.VXD
#define DSOUND_DEVICE_ID 0x357E

#ifndef Not_VxD

Begin_Service_Table (DSOUND, VxD)
 Declare_Service (_DSOUND_GetVersion, LOCAL)
 Declare_Service (_DSOUND_RegisterDeviceDriver, VxD_CODE)
 Declare_Service (_DSOUND_DeregisterDeviceDriver, VxD_CODE)
End_Service_Table (DSOUND, VxD)

#ifndef NODSOUNDWRAPS

DWORD __inline DSOUND_GetVersion(void)
{
    DWORD dwVersion;
    Touch_Register(eax)
    VxDCall(_DSOUND_GetVersion);
    _asm mov dwVersion, eax
    return dwVersion;
}

HRESULT __inline DSOUND_RegisterDeviceDriver(PIDSDRIVER pIDsDriver, DWORD dwFlags)
{
    HRESULT dsv;
    Touch_Register(eax)
    Touch_Register(ecx)
    Touch_Register(edx)
    _asm push dwFlags;
    _asm push pIDsDriver;
    VxDCall(_DSOUND_RegisterDeviceDriver);
    _asm add esp, 8;
    _asm mov dsv, eax;
    return dsv;
}

HRESULT __inline DSOUND_DeregisterDeviceDriver(PIDSDRIVER pIDsDriver, DWORD dwFlags)
{
    HRESULT dsv;
    Touch_Register(eax)
    Touch_Register(ecx)
    Touch_Register(edx)
    _asm push dwFlags;
    _asm push pIDsDriver;
    VxDCall(_DSOUND_DeregisterDeviceDriver);
    _asm add esp, 8;
    _asm mov dsv, eax;
    return dsv;
}

#endif	// NODSOUNDWRAPS

#endif

#ifdef __cplusplus
};
#endif


#endif
