/*
** Copyright 1992, Silicon Graphics, Inc.
** All Rights Reserved.
**
** This is UNPUBLISHED PROPRIETARY SOURCE CODE of Silicon Graphics, Inc.;
** the contents of this file may not be disclosed to third parties, copied or
** duplicated in any form, in whole or in part, without the prior written
** permission of Silicon Graphics, Inc.
**
** RESTRICTED RIGHTS LEGEND:
** Use, duplication or disclosure by the Government is subject to restrictions
** as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
** and Computer Software clause at DFARS 252.227-7013, and/or in similar or
** successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
** rights reserved under the Copyright Laws of the United States.
*/

#include <windows.h>
#include <GL/gl.h>
#include "shell.h"


enumCheckRec enum_Check[] = {
    {
	"GL_2_BYTES", GL_2_BYTES, 5127
    },
    {
	"GL_3_BYTES", GL_3_BYTES, 5128
    },
    {
	"GL_4_BYTES", GL_4_BYTES, 5129
    },
    {
	"GL_2D", GL_2D, 1536
    },
    {
	"GL_3D", GL_3D, 1537
    },
    {
	"GL_3D_COLOR", GL_3D_COLOR, 1538
    },
    {
	"GL_3D_COLOR_TEXTURE", GL_3D_COLOR_TEXTURE, 1539
    },
    {
	"GL_4D_COLOR_TEXTURE", GL_4D_COLOR_TEXTURE, 1540
    },
    {
	"GL_ACCUM", GL_ACCUM, 256
    },
    {
	"GL_ACCUM_ALPHA_BITS", GL_ACCUM_ALPHA_BITS, 3419
    },
    {
	"GL_ACCUM_BLUE_BITS", GL_ACCUM_BLUE_BITS, 3418
    },
    {
	"GL_ACCUM_BUFFER_BIT", GL_ACCUM_BUFFER_BIT, 512
    },
    {
	"GL_ACCUM_CLEAR_VALUE", GL_ACCUM_CLEAR_VALUE, 2944
    },
    {
	"GL_ACCUM_GREEN_BITS", GL_ACCUM_GREEN_BITS, 3417
    },
    {
	"GL_ACCUM_RED_BITS", GL_ACCUM_RED_BITS, 3416
    },
    {
	"GL_ADD", GL_ADD, 260
    },
    {
	"GL_ALL_ATTRIB_BITS", GL_ALL_ATTRIB_BITS, 1048575
    },
    {
	"GL_ALPHA", GL_ALPHA, 6406
    },
    {
	"GL_ALPHA_BIAS", GL_ALPHA_BIAS, 3357
    },
    {
	"GL_ALPHA_BITS", GL_ALPHA_BITS, 3413
    },
    {
	"GL_ALPHA_SCALE", GL_ALPHA_SCALE, 3356
    },
    {
	"GL_ALPHA_TEST", GL_ALPHA_TEST, 3008
    },
    {
	"GL_ALPHA_TEST_FUNC", GL_ALPHA_TEST_FUNC, 3009
    },
    {
	"GL_ALPHA_TEST_REF", GL_ALPHA_TEST_REF, 3010
    },
    {
	"GL_ALWAYS", GL_ALWAYS, 519
    },
    {
	"GL_AMBIENT", GL_AMBIENT, 4608
    },
    {
	"GL_AMBIENT_AND_DIFFUSE", GL_AMBIENT_AND_DIFFUSE, 5634
    },
    {
	"GL_AND", GL_AND, 5377
    },
    {
	"GL_AND_INVERTED", GL_AND_INVERTED, 5380
    },
    {
	"GL_AND_REVERSE", GL_AND_REVERSE, 5378
    },
    {
	"GL_ATTRIB_STACK_DEPTH", GL_ATTRIB_STACK_DEPTH, 2992
    },
    {
	"GL_AUTO_NORMAL", GL_AUTO_NORMAL, 3456
    },
    {
	"GL_AUX_BUFFERS", GL_AUX_BUFFERS, 3072
    },
    {
	"GL_AUX0", GL_AUX0, 1033
    },
    {
	"GL_AUX1", GL_AUX1, 1034
    },
    {
	"GL_AUX2", GL_AUX2, 1035
    },
    {
	"GL_AUX3", GL_AUX3, 1036
    },
    {
	"GL_BACK", GL_BACK, 1029
    },
    {
	"GL_BACK_LEFT", GL_BACK_LEFT, 1026
    },
    {
	"GL_BACK_RIGHT", GL_BACK_RIGHT, 1027
    },
    {
	"GL_BITMAP", GL_BITMAP, 6656
    },
    {
	"GL_BITMAP_TOKEN", GL_BITMAP_TOKEN, 1796
    },
    {
	"GL_BLEND", GL_BLEND, 3042
    },
    {
	"GL_BLEND_DST", GL_BLEND_DST, 3040
    },
    {
	"GL_BLEND_SRC", GL_BLEND_SRC, 3041
    },
    {
	"GL_BLUE", GL_BLUE, 6405
    },
    {
	"GL_BLUE_BIAS", GL_BLUE_BIAS, 3355
    },
    {
	"GL_BLUE_BITS", GL_BLUE_BITS, 3412
    },
    {
	"GL_BLUE_SCALE", GL_BLUE_SCALE, 3354
    },
    {
	"GL_BYTE", GL_BYTE, 5120
    },
    {
	"GL_CCW", GL_CCW, 2305
    },
    {
	"GL_CLAMP", GL_CLAMP, 10496
    },
    {
	"GL_CLEAR", GL_CLEAR, 5376
    },
    {
	"GL_CLIP_PLANE0", GL_CLIP_PLANE0, 12288
    },
    {
	"GL_CLIP_PLANE1", GL_CLIP_PLANE1, 12289
    },
    {
	"GL_CLIP_PLANE2", GL_CLIP_PLANE2, 12290
    },
    {
	"GL_CLIP_PLANE3", GL_CLIP_PLANE3, 12291
    },
    {
	"GL_CLIP_PLANE4", GL_CLIP_PLANE4, 12292
    },
    {
	"GL_CLIP_PLANE5", GL_CLIP_PLANE5, 12293
    },
    {
	"GL_COEFF", GL_COEFF, 2560
    },
    {
	"GL_COLOR", GL_COLOR, 6144
    },
    {
	"GL_COLOR_BUFFER_BIT", GL_COLOR_BUFFER_BIT, 16384
    },
    {
	"GL_COLOR_CLEAR_VALUE", GL_COLOR_CLEAR_VALUE, 3106
    },
    {
	"GL_COLOR_INDEX", GL_COLOR_INDEX, 6400
    },
    {
	"GL_COLOR_INDEXES", GL_COLOR_INDEXES, 5635
    },
    {
	"GL_COLOR_MATERIAL", GL_COLOR_MATERIAL, 2903
    },
    {
	"GL_COLOR_MATERIAL_FACE", GL_COLOR_MATERIAL_FACE, 2901
    },
    {
	"GL_COLOR_MATERIAL_PARAMETER", GL_COLOR_MATERIAL_PARAMETER, 2902
    },
    {
	"GL_COLOR_WRITEMASK", GL_COLOR_WRITEMASK, 3107
    },
    {
	"GL_COMPILE", GL_COMPILE, 4864
    },
    {
	"GL_COMPILE_AND_EXECUTE", GL_COMPILE_AND_EXECUTE, 4865
    },
    {
	"GL_CONSTANT_ATTENUATION", GL_CONSTANT_ATTENUATION, 4615
    },
    {
	"GL_COPY", GL_COPY, 5379
    },
    {
	"GL_COPY_INVERTED", GL_COPY_INVERTED, 5388
    },
    {
	"GL_COPY_PIXEL_TOKEN", GL_COPY_PIXEL_TOKEN, 1798
    },
    {
	"GL_CULL_FACE", GL_CULL_FACE, 2884
    },
    {
	"GL_CULL_FACE_MODE", GL_CULL_FACE_MODE, 2885
    },
    {
	"GL_CURRENT_BIT", GL_CURRENT_BIT, 1
    },
    {
	"GL_CURRENT_COLOR", GL_CURRENT_COLOR, 2816
    },
    {
	"GL_CURRENT_INDEX", GL_CURRENT_INDEX, 2817
    },
    {
	"GL_CURRENT_NORMAL", GL_CURRENT_NORMAL, 2818
    },
    {
	"GL_CURRENT_RASTER_COLOR", GL_CURRENT_RASTER_COLOR, 2820
    },
    {
	"GL_CURRENT_RASTER_INDEX", GL_CURRENT_RASTER_INDEX, 2821
    },
    {
	"GL_CURRENT_RASTER_POSITION", GL_CURRENT_RASTER_POSITION, 2823
    },
    {
	"GL_CURRENT_RASTER_POSITION_VALID", GL_CURRENT_RASTER_POSITION_VALID, 2824
    },
    {
	"GL_CURRENT_RASTER_TEXTURE_COORDS", GL_CURRENT_RASTER_TEXTURE_COORDS, 2822
    },
    {
	"GL_CURRENT_TEXTURE_COORDS", GL_CURRENT_TEXTURE_COORDS, 2819
    },
    {
	"GL_CW", GL_CW, 2304
    },
    {
	"GL_DECAL", GL_DECAL, 8449
    },
    {
	"GL_DECR", GL_DECR, 7683
    },
    {
	"GL_DEPTH", GL_DEPTH, 6145
    },
    {
	"GL_DEPTH_BIAS", GL_DEPTH_BIAS, 3359
    },
    {
	"GL_DEPTH_BITS", GL_DEPTH_BITS, 3414
    },
    {
	"GL_DEPTH_BUFFER_BIT", GL_DEPTH_BUFFER_BIT, 256
    },
    {
	"GL_DEPTH_CLEAR_VALUE", GL_DEPTH_CLEAR_VALUE, 2931
    },
    {
	"GL_DEPTH_COMPONENT", GL_DEPTH_COMPONENT, 6402
    },
    {
	"GL_DEPTH_FUNC", GL_DEPTH_FUNC, 2932
    },
    {
	"GL_DEPTH_RANGE", GL_DEPTH_RANGE, 2928
    },
    {
	"GL_DEPTH_SCALE", GL_DEPTH_SCALE, 3358
    },
    {
	"GL_DEPTH_TEST", GL_DEPTH_TEST, 2929
    },
    {
	"GL_DEPTH_WRITEMASK", GL_DEPTH_WRITEMASK, 2930
    },
    {
	"GL_DIFFUSE", GL_DIFFUSE, 4609
    },
    {
	"GL_DITHER", GL_DITHER, 3024
    },
    {
	"GL_DOMAIN", GL_DOMAIN, 2562
    },
    {
	"GL_DONT_CARE", GL_DONT_CARE, 4352
    },
    {
	"GL_DOUBLEBUFFER", GL_DOUBLEBUFFER, 3122
    },
    {
	"GL_DRAW_BUFFER", GL_DRAW_BUFFER, 3073
    },
    {
	"GL_DRAW_PIXEL_TOKEN", GL_DRAW_PIXEL_TOKEN, 1797
    },
    {
	"GL_DST_ALPHA", GL_DST_ALPHA, 772
    },
    {
	"GL_DST_COLOR", GL_DST_COLOR, 774
    },
    {
	"GL_EDGE_FLAG", GL_EDGE_FLAG, 2883
    },
    {
	"GL_EMISSION", GL_EMISSION, 5632
    },
    {
	"GL_ENABLE_BIT", GL_ENABLE_BIT, 8192
    },
    {
	"GL_EQUAL", GL_EQUAL, 514
    },
    {
	"GL_EQUIV", GL_EQUIV, 5385
    },
    {
	"GL_EXP", GL_EXP, 2048
    },
    {
	"GL_EXP2", GL_EXP2, 2049
    },
    {
	"GL_EXTENSIONS", GL_EXTENSIONS, 7939
    },
    {
	"GL_EVAL_BIT", GL_EVAL_BIT, 65536
    },
    {
	"GL_EYE_LINEAR", GL_EYE_LINEAR, 9216
    },
    {
	"GL_EYE_PLANE", GL_EYE_PLANE, 9474
    },
    {
	"GL_FALSE", GL_FALSE, 0
    },
    {
	"GL_FASTEST", GL_FASTEST, 4353
    },
    {
	"GL_FEEDBACK", GL_FEEDBACK, 7169
    },
    {
	"GL_FILL", GL_FILL, 6914
    },
    {
	"GL_FLAT", GL_FLAT, 7424
    },
    {
	"GL_FLOAT", GL_FLOAT, 5126
    },
    {
	"GL_FOG", GL_FOG, 2912
    },
    {
	"GL_FOG_BIT", GL_FOG_BIT, 128
    },
    {
	"GL_FOG_COLOR", GL_FOG_COLOR, 2918
    },
    {
	"GL_FOG_DENSITY", GL_FOG_DENSITY, 2914
    },
    {
	"GL_FOG_END", GL_FOG_END, 2916
    },
    {
	"GL_FOG_HINT", GL_FOG_HINT, 3156
    },
    {
	"GL_FOG_INDEX", GL_FOG_INDEX, 2913
    },
    {
	"GL_FOG_MODE", GL_FOG_MODE, 2917
    },
    {
	"GL_FOG_START", GL_FOG_START, 2915
    },
    {
	"GL_FRONT", GL_FRONT, 1028
    },
    {
	"GL_FRONT_AND_BACK", GL_FRONT_AND_BACK, 1032
    },
    {
	"GL_FRONT_FACE", GL_FRONT_FACE, 2886
    },
    {
	"GL_FRONT_LEFT", GL_FRONT_LEFT, 1024
    },
    {
	"GL_FRONT_RIGHT", GL_FRONT_RIGHT, 1025
    },
    {
	"GL_GEQUAL", GL_GEQUAL, 518
    },
    {
	"GL_GREATER", GL_GREATER, 516
    },
    {
	"GL_GREEN", GL_GREEN, 6404
    },
    {
	"GL_GREEN_BIAS", GL_GREEN_BIAS, 3353
    },
    {
	"GL_GREEN_BITS", GL_GREEN_BITS, 3411
    },
    {
	"GL_GREEN_SCALE", GL_GREEN_SCALE, 3352
    },
    {
	"GL_HINT_BIT", GL_HINT_BIT, 32768
    },
    {
	"GL_INCR", GL_INCR, 7682
    },
    {
	"GL_INDEX_BITS", GL_INDEX_BITS, 3409
    },
    {
	"GL_INDEX_CLEAR_VALUE", GL_INDEX_CLEAR_VALUE, 3104
    },
    {
	"GL_INDEX_MODE", GL_INDEX_MODE, 3120
    },
    {
	"GL_INDEX_OFFSET", GL_INDEX_OFFSET, 3347
    },
    {
	"GL_INDEX_SHIFT", GL_INDEX_SHIFT, 3346
    },
    {
	"GL_INDEX_WRITEMASK", GL_INDEX_WRITEMASK, 3105
    },
    {
	"GL_INT", GL_INT, 5124
    },
    {
	"GL_INVALID_ENUM", GL_INVALID_ENUM, 1280
    },
    {
	"GL_INVALID_OPERATION", GL_INVALID_OPERATION, 1282
    },
    {
	"GL_INVALID_VALUE", GL_INVALID_VALUE, 1281
    },
    {
	"GL_INVERT", GL_INVERT, 5386
    },
    {
	"GL_KEEP", GL_KEEP, 7680
    },
    {
	"GL_LEFT", GL_LEFT, 1030
    },
    {
	"GL_LEQUAL", GL_LEQUAL, 515
    },
    {
	"GL_LESS", GL_LESS, 513
    },
    {
	"GL_LIGHT_MODEL_AMBIENT", GL_LIGHT_MODEL_AMBIENT, 2899
    },
    {
	"GL_LIGHT_MODEL_LOCAL_VIEWER", GL_LIGHT_MODEL_LOCAL_VIEWER, 2897
    },
    {
	"GL_LIGHT_MODEL_TWO_SIDE", GL_LIGHT_MODEL_TWO_SIDE, 2898
    },
    {
	"GL_LIGHT0", GL_LIGHT0, 16384
    },
    {
	"GL_LIGHT1", GL_LIGHT1, 16385
    },
    {
	"GL_LIGHT2", GL_LIGHT2, 16386
    },
    {
	"GL_LIGHT3", GL_LIGHT3, 16387
    },
    {
	"GL_LIGHT4", GL_LIGHT4, 16388
    },
    {
	"GL_LIGHT5", GL_LIGHT5, 16389
    },
    {
	"GL_LIGHT6", GL_LIGHT6, 16390
    },
    {
	"GL_LIGHT7", GL_LIGHT7, 16391
    },
    {
	"GL_LIGHTING", GL_LIGHTING, 2896
    },
    {
	"GL_LIGHTING_BIT", GL_LIGHTING_BIT, 64
    },
    {
	"GL_LINE", GL_LINE, 6913
    },
    {
	"GL_LINE_BIT", GL_LINE_BIT, 4
    },
    {
	"GL_LINE_LOOP", GL_LINE_LOOP, 2
    },
    {
	"GL_LINE_RESET_TOKEN", GL_LINE_RESET_TOKEN, 1799
    },
    {
	"GL_LINE_SMOOTH", GL_LINE_SMOOTH, 2848
    },
    {
	"GL_LINE_SMOOTH_HINT", GL_LINE_SMOOTH_HINT, 3154
    },
    {
	"GL_LINE_STIPPLE", GL_LINE_STIPPLE, 2852
    },
    {
	"GL_LINE_STIPPLE_PATTERN", GL_LINE_STIPPLE_PATTERN, 2853
    },
    {
	"GL_LINE_STIPPLE_REPEAT", GL_LINE_STIPPLE_REPEAT, 2854
    },
    {
	"GL_LINE_STRIP", GL_LINE_STRIP, 3
    },
    {
	"GL_LINE_TOKEN", GL_LINE_TOKEN, 1794
    },
    {
	"GL_LINE_WIDTH", GL_LINE_WIDTH, 2849
    },
    {
	"GL_LINE_WIDTH_GRANULARITY", GL_LINE_WIDTH_GRANULARITY, 2851
    },
    {
	"GL_LINE_WIDTH_RANGE", GL_LINE_WIDTH_RANGE, 2850
    },
    {
	"GL_LINEAR", GL_LINEAR, 9729
    },
    {
	"GL_LINEAR_ATTENUATION", GL_LINEAR_ATTENUATION, 4616
    },
    {
	"GL_LINEAR_MIPMAP_NEAREST", GL_LINEAR_MIPMAP_NEAREST, 9985
    },
    {
	"GL_LINEAR_MIPMAP_LINEAR", GL_LINEAR_MIPMAP_LINEAR, 9987
    },
    {
	"GL_LINES", GL_LINES, 1
    },
    {
	"GL_LIST_BASE", GL_LIST_BASE, 2866
    },
    {
	"GL_LIST_BIT", GL_LIST_BIT, 131072
    },
    {
	"GL_LIST_INDEX", GL_LIST_INDEX, 2867
    },
    {
	"GL_LIST_MODE", GL_LIST_MODE, 2864
    },
    {
	"GL_LOAD", GL_LOAD, 257
    },
    {
	"GL_LOGIC_OP", GL_LOGIC_OP, 3057
    },
    {
	"GL_LOGIC_OP_MODE", GL_LOGIC_OP_MODE, 3056
    },
    {
	"GL_LUMINANCE", GL_LUMINANCE, 6409
    },
    {
	"GL_LUMINANCE_ALPHA", GL_LUMINANCE_ALPHA, 6410
    },
    {
	"GL_MAP_COLOR", GL_MAP_COLOR, 3344
    },
    {
	"GL_MAP_STENCIL", GL_MAP_STENCIL, 3345
    },
    {
	"GL_MAP1_COLOR_4", GL_MAP1_COLOR_4, 3472
    },
    {
	"GL_MAP1_GRID_DOMAIN", GL_MAP1_GRID_DOMAIN, 3536
    },
    {
	"GL_MAP1_GRID_SEGMENTS", GL_MAP1_GRID_SEGMENTS, 3537
    },
    {
	"GL_MAP1_INDEX", GL_MAP1_INDEX, 3473
    },
    {
	"GL_MAP1_NORMAL", GL_MAP1_NORMAL, 3474
    },
    {
	"GL_MAP1_TEXTURE_COORD_1", GL_MAP1_TEXTURE_COORD_1, 3475
    },
    {
	"GL_MAP1_TEXTURE_COORD_2", GL_MAP1_TEXTURE_COORD_2, 3476
    },
    {
	"GL_MAP1_TEXTURE_COORD_3", GL_MAP1_TEXTURE_COORD_3, 3477
    },
    {
	"GL_MAP1_TEXTURE_COORD_4", GL_MAP1_TEXTURE_COORD_4, 3478
    },
    {
	"GL_MAP1_VERTEX_3", GL_MAP1_VERTEX_3, 3479
    },
    {
	"GL_MAP1_VERTEX_4", GL_MAP1_VERTEX_4, 3480
    },
    {
	"GL_MAP2_COLOR_4", GL_MAP2_COLOR_4, 3504
    },
    {
	"GL_MAP2_GRID_DOMAIN", GL_MAP2_GRID_DOMAIN, 3538
    },
    {
	"GL_MAP2_GRID_SEGMENTS", GL_MAP2_GRID_SEGMENTS, 3539
    },
    {
	"GL_MAP2_INDEX", GL_MAP2_INDEX, 3505
    },
    {
	"GL_MAP2_NORMAL", GL_MAP2_NORMAL, 3506
    },
    {
	"GL_MAP2_TEXTURE_COORD_1", GL_MAP2_TEXTURE_COORD_1, 3507
    },
    {
	"GL_MAP2_TEXTURE_COORD_2", GL_MAP2_TEXTURE_COORD_2, 3508
    },
    {
	"GL_MAP2_TEXTURE_COORD_3", GL_MAP2_TEXTURE_COORD_3, 3509
    },
    {
	"GL_MAP2_TEXTURE_COORD_4", GL_MAP2_TEXTURE_COORD_4, 3510
    },
    {
	"GL_MAP2_VERTEX_3", GL_MAP2_VERTEX_3, 3511
    },
    {
	"GL_MAP2_VERTEX_4", GL_MAP2_VERTEX_4, 3512
    },
    {
	"GL_MATRIX_MODE", GL_MATRIX_MODE, 2976
    },
    {
	"GL_MAX_ATTRIB_STACK_DEPTH", GL_MAX_ATTRIB_STACK_DEPTH, 3381
    },
    {
	"GL_MAX_CLIP_PLANES", GL_MAX_CLIP_PLANES, 3378
    },
    {
	"GL_MAX_EVAL_ORDER", GL_MAX_EVAL_ORDER, 3376
    },
    {
	"GL_MAX_LIGHTS", GL_MAX_LIGHTS, 3377
    },
    {
	"GL_MAX_LIST_NESTING", GL_MAX_LIST_NESTING, 2865
    },
    {
	"GL_MAX_MODELVIEW_STACK_DEPTH", GL_MAX_MODELVIEW_STACK_DEPTH, 3382
    },
    {
	"GL_MAX_NAME_STACK_DEPTH", GL_MAX_NAME_STACK_DEPTH, 3383
    },
    {
	"GL_MAX_PIXEL_MAP_TABLE", GL_MAX_PIXEL_MAP_TABLE, 3380
    },
    {
	"GL_MAX_PROJECTION_STACK_DEPTH", GL_MAX_PROJECTION_STACK_DEPTH, 3384
    },
    {
	"GL_MAX_TEXTURE_SIZE", GL_MAX_TEXTURE_SIZE, 3379
    },
    {
	"GL_MAX_TEXTURE_STACK_DEPTH", GL_MAX_TEXTURE_STACK_DEPTH, 3385
    },
    {
	"GL_MAX_VIEWPORT_DIMS", GL_MAX_VIEWPORT_DIMS, 3386
    },
    {
	"GL_MODELVIEW", GL_MODELVIEW, 5888
    },
    {
	"GL_MODELVIEW_MATRIX", GL_MODELVIEW_MATRIX, 2982
    },
    {
	"GL_MODELVIEW_STACK_DEPTH", GL_MODELVIEW_STACK_DEPTH, 2979
    },
    {
	"GL_MODULATE", GL_MODULATE, 8448
    },
    {
	"GL_MULT", GL_MULT, 259
    },
    {
	"GL_NAME_STACK_DEPTH", GL_NAME_STACK_DEPTH, 3440
    },
    {
	"GL_NAND", GL_NAND, 5390
    },
    {
	"GL_NEAREST", GL_NEAREST, 9728
    },
    {
	"GL_NEAREST_MIPMAP_LINEAR", GL_NEAREST_MIPMAP_LINEAR, 9986
    },
    {
	"GL_NEAREST_MIPMAP_NEAREST", GL_NEAREST_MIPMAP_NEAREST, 9984
    },
    {
	"GL_NEVER", GL_NEVER, 512
    },
    {
	"GL_NICEST", GL_NICEST, 4354
    },
    {
	"GL_NO_ERROR", GL_NO_ERROR, 0
    },
    {
	"GL_NONE", GL_NONE, 0
    },
    {
	"GL_NOOP", GL_NOOP, 5381
    },
    {
	"GL_NOR", GL_NOR, 5384
    },
    {
	"GL_NORMALIZE", GL_NORMALIZE, 2977
    },
    {
	"GL_NOTEQUAL", GL_NOTEQUAL, 517
    },
    {
	"GL_OBJECT_LINEAR", GL_OBJECT_LINEAR, 9217
    },
    {
	"GL_OBJECT_PLANE", GL_OBJECT_PLANE, 9473
    },
    {
	"GL_ONE", GL_ONE, 1
    },
    {
	"GL_ONE_MINUS_DST_ALPHA", GL_ONE_MINUS_DST_ALPHA, 773
    },
    {
	"GL_ONE_MINUS_DST_COLOR", GL_ONE_MINUS_DST_COLOR, 775
    },
    {
	"GL_ONE_MINUS_SRC_ALPHA", GL_ONE_MINUS_SRC_ALPHA, 771
    },
    {
	"GL_ONE_MINUS_SRC_COLOR", GL_ONE_MINUS_SRC_COLOR, 769
    },
    {
	"GL_OR", GL_OR, 5383
    },
    {
	"GL_OR_INVERTED", GL_OR_INVERTED, 5389
    },
    {
	"GL_OR_REVERSE", GL_OR_REVERSE, 5387
    },
    {
	"GL_ORDER", GL_ORDER, 2561
    },
    {
	"GL_OUT_OF_MEMORY", GL_OUT_OF_MEMORY, 1285
    },
    {
	"GL_PACK_ALIGNMENT", GL_PACK_ALIGNMENT, 3333
    },
    {
	"GL_PACK_LSB_FIRST", GL_PACK_LSB_FIRST, 3329
    },
    {
	"GL_PACK_ROW_LENGTH", GL_PACK_ROW_LENGTH, 3330
    },
    {
	"GL_PACK_SKIP_PIXELS", GL_PACK_SKIP_PIXELS, 3332
    },
    {
	"GL_PACK_SKIP_ROWS", GL_PACK_SKIP_ROWS, 3331
    },
    {
	"GL_PACK_SWAP_BYTES", GL_PACK_SWAP_BYTES, 3328
    },
    {
	"GL_PASS_THROUGH_TOKEN", GL_PASS_THROUGH_TOKEN, 1792
    },
    {
	"GL_PERSPECTIVE_CORRECTION_HINT", GL_PERSPECTIVE_CORRECTION_HINT, 3152
    },
    {
	"GL_PIXEL_MAP_A_TO_A", GL_PIXEL_MAP_A_TO_A, 3193
    },
    {
	"GL_PIXEL_MAP_A_TO_A_SIZE", GL_PIXEL_MAP_A_TO_A_SIZE, 3257
    },
    {
	"GL_PIXEL_MAP_B_TO_B", GL_PIXEL_MAP_B_TO_B, 3192
    },
    {
	"GL_PIXEL_MAP_B_TO_B_SIZE", GL_PIXEL_MAP_B_TO_B_SIZE, 3256
    },
    {
	"GL_PIXEL_MAP_G_TO_G", GL_PIXEL_MAP_G_TO_G, 3191
    },
    {
	"GL_PIXEL_MAP_G_TO_G_SIZE", GL_PIXEL_MAP_G_TO_G_SIZE, 3255
    },
    {
	"GL_PIXEL_MAP_I_TO_A", GL_PIXEL_MAP_I_TO_A, 3189
    },
    {
	"GL_PIXEL_MAP_I_TO_A_SIZE", GL_PIXEL_MAP_I_TO_A_SIZE, 3253
    },
    {
	"GL_PIXEL_MAP_I_TO_B", GL_PIXEL_MAP_I_TO_B, 3188
    },
    {
	"GL_PIXEL_MAP_I_TO_B_SIZE", GL_PIXEL_MAP_I_TO_B_SIZE, 3252
    },
    {
	"GL_PIXEL_MAP_I_TO_G", GL_PIXEL_MAP_I_TO_G, 3187
    },
    {
	"GL_PIXEL_MAP_I_TO_G_SIZE", GL_PIXEL_MAP_I_TO_G_SIZE, 3251
    },
    {
	"GL_PIXEL_MAP_I_TO_I", GL_PIXEL_MAP_I_TO_I, 3184
    },
    {
	"GL_PIXEL_MAP_I_TO_I_SIZE", GL_PIXEL_MAP_I_TO_I_SIZE, 3248
    },
    {
	"GL_PIXEL_MAP_I_TO_R", GL_PIXEL_MAP_I_TO_R, 3186
    },
    {
	"GL_PIXEL_MAP_I_TO_R_SIZE", GL_PIXEL_MAP_I_TO_R_SIZE, 3250
    },
    {
	"GL_PIXEL_MAP_R_TO_R", GL_PIXEL_MAP_R_TO_R, 3190
    },
    {
	"GL_PIXEL_MAP_R_TO_R_SIZE", GL_PIXEL_MAP_R_TO_R_SIZE, 3254
    },
    {
	"GL_PIXEL_MAP_S_TO_S", GL_PIXEL_MAP_S_TO_S, 3185
    },
    {
	"GL_PIXEL_MAP_S_TO_S_SIZE", GL_PIXEL_MAP_S_TO_S_SIZE, 3249
    },
    {
	"GL_PIXEL_MODE_BIT", GL_PIXEL_MODE_BIT, 32
    },
    {
	"GL_POINT", GL_POINT, 6912
    },
    {
	"GL_POINT_BIT", GL_POINT_BIT, 2
    },
    {
	"GL_POINT_SIZE", GL_POINT_SIZE, 2833
    },
    {
	"GL_POINT_SIZE_GRANULARITY", GL_POINT_SIZE_GRANULARITY, 2835
    },
    {
	"GL_POINT_SIZE_RANGE", GL_POINT_SIZE_RANGE, 2834
    },
    {
	"GL_POINT_SMOOTH", GL_POINT_SMOOTH, 2832
    },
    {
	"GL_POINT_SMOOTH_HINT", GL_POINT_SMOOTH_HINT, 3153
    },
    {
	"GL_POINT_TOKEN", GL_POINT_TOKEN, 1793
    },
    {
	"GL_POINTS", GL_POINTS, 0
    },
    {
	"GL_POLYGON", GL_POLYGON, 9
    },
    {
	"GL_POLYGON_BIT", GL_POLYGON_BIT, 8
    },
    {
	"GL_POLYGON_MODE", GL_POLYGON_MODE, 2880
    },
    {
	"GL_POLYGON_SMOOTH", GL_POLYGON_SMOOTH, 2881
    },
    {
	"GL_POLYGON_SMOOTH_HINT", GL_POLYGON_SMOOTH_HINT, 3155
    },
    {
	"GL_POLYGON_STIPPLE", GL_POLYGON_STIPPLE, 2882
    },
    {
	"GL_POLYGON_STIPPLE_BIT", GL_POLYGON_STIPPLE_BIT, 16
    },
    {
	"GL_POLYGON_TOKEN", GL_POLYGON_TOKEN, 1795
    },
    {
	"GL_POSITION", GL_POSITION, 4611
    },
    {
	"GL_PROJECTION", GL_PROJECTION, 5889
    },
    {
	"GL_PROJECTION_MATRIX", GL_PROJECTION_MATRIX, 2983
    },
    {
	"GL_PROJECTION_STACK_DEPTH", GL_PROJECTION_STACK_DEPTH, 2980
    },
    {
	"GL_Q", GL_Q, 8195
    },
    {
	"GL_QUAD_STRIP", GL_QUAD_STRIP, 8
    },
    {
	"GL_QUADRATIC_ATTENUATION", GL_QUADRATIC_ATTENUATION, 4617
    },
    {
	"GL_QUADS", GL_QUADS, 7
    },
    {
	"GL_R", GL_R, 8194
    },
    {
	"GL_READ_BUFFER", GL_READ_BUFFER, 3074
    },
    {
	"GL_RED", GL_RED, 6403
    },
    {
	"GL_RED_BIAS", GL_RED_BIAS, 3349
    },
    {
	"GL_RED_BITS", GL_RED_BITS, 3410
    },
    {
	"GL_RED_SCALE", GL_RED_SCALE, 3348
    },
    {
	"GL_RENDER", GL_RENDER, 7168
    },
    {
	"GL_RENDER_MODE", GL_RENDER_MODE, 3136
    },
    {
	"GL_RENDERER", GL_RENDERER, 7937
    },
    {
	"GL_REPEAT", GL_REPEAT, 10497
    },
    {
	"GL_REPLACE", GL_REPLACE, 7681
    },
    {
	"GL_RETURN", GL_RETURN, 258
    },
    {
	"GL_RGB", GL_RGB, 6407
    },
    {
	"GL_RGBA", GL_RGBA, 6408
    },
    {
	"GL_RGBA_MODE", GL_RGBA_MODE, 3121
    },
    {
	"GL_RIGHT", GL_RIGHT, 1031
    },
    {
	"GL_S", GL_S, 8192
    },
    {
	"GL_SHININESS", GL_SHININESS, 5633
    },
    {
	"GL_SPECULAR", GL_SPECULAR, 4610
    },
    {
	"GL_SRC_ALPHA", GL_SRC_ALPHA, 770
    },
    {
	"GL_SRC_ALPHA_SATURATE", GL_SRC_ALPHA_SATURATE, 776
    },
    {
	"GL_SRC_COLOR", GL_SRC_COLOR, 768
    },
    {
	"GL_SCISSOR_BIT", GL_SCISSOR_BIT, 524288
    },
    {
	"GL_SCISSOR_BOX", GL_SCISSOR_BOX, 3088
    },
    {
	"GL_SCISSOR_TEST", GL_SCISSOR_TEST, 3089
    },
    {
	"GL_SELECT", GL_SELECT, 7170
    },
    {
	"GL_SET", GL_SET, 5391
    },
    {
	"GL_SHADE_MODEL", GL_SHADE_MODEL, 2900
    },
    {
	"GL_SHORT", GL_SHORT, 5122
    },
    {
	"GL_SMOOTH", GL_SMOOTH, 7425
    },
    {
	"GL_SPHERE_MAP", GL_SPHERE_MAP, 9218
    },
    {
	"GL_SPOT_CUTOFF", GL_SPOT_CUTOFF, 4614
    },
    {
	"GL_SPOT_DIRECTION", GL_SPOT_DIRECTION, 4612
    },
    {
	"GL_SPOT_EXPONENT", GL_SPOT_EXPONENT, 4613
    },
    {
	"GL_STACK_OVERFLOW", GL_STACK_OVERFLOW, 1283
    },
    {
	"GL_STACK_UNDERFLOW", GL_STACK_UNDERFLOW, 1284
    },
    {
	"GL_STENCIL", GL_STENCIL, 6146
    },
    {
	"GL_STENCIL_BITS", GL_STENCIL_BITS, 3415
    },
    {
	"GL_STENCIL_BUFFER_BIT", GL_STENCIL_BUFFER_BIT, 1024
    },
    {
	"GL_STENCIL_CLEAR_VALUE", GL_STENCIL_CLEAR_VALUE, 2961
    },
    {
	"GL_STENCIL_FAIL", GL_STENCIL_FAIL, 2964
    },
    {
	"GL_STENCIL_FUNC", GL_STENCIL_FUNC, 2962
    },
    {
	"GL_STENCIL_INDEX", GL_STENCIL_INDEX, 6401
    },
    {
	"GL_STENCIL_PASS_DEPTH_FAIL", GL_STENCIL_PASS_DEPTH_FAIL, 2965
    },
    {
	"GL_STENCIL_PASS_DEPTH_PASS", GL_STENCIL_PASS_DEPTH_PASS, 2966
    },
    {
	"GL_STENCIL_REF", GL_STENCIL_REF, 2967
    },
    {
	"GL_STENCIL_TEST", GL_STENCIL_TEST, 2960
    },
    {
	"GL_STENCIL_VALUE_MASK", GL_STENCIL_VALUE_MASK, 2963
    },
    {
	"GL_STENCIL_WRITEMASK", GL_STENCIL_WRITEMASK, 2968
    },
    {
	"GL_STEREO", GL_STEREO, 3123
    },
    {
	"GL_SUBPIXEL_BITS", GL_SUBPIXEL_BITS, 3408
    },
    {
	"GL_T", GL_T, 8193
    },
    {
	"GL_TEXTURE", GL_TEXTURE, 5890
    },
    {
	"GL_TEXTURE_1D", GL_TEXTURE_1D, 3552
    },
    {
	"GL_TEXTURE_2D", GL_TEXTURE_2D, 3553
    },
    {
	"GL_TEXTURE_BIT", GL_TEXTURE_BIT, 262144
    },
    {
	"GL_TEXTURE_BORDER", GL_TEXTURE_BORDER, 4101
    },
    {
	"GL_TEXTURE_BORDER_COLOR", GL_TEXTURE_BORDER_COLOR, 4100
    },
    {
	"GL_TEXTURE_COMPONENTS", GL_TEXTURE_COMPONENTS, 4099
    },
    {
	"GL_TEXTURE_ENV", GL_TEXTURE_ENV, 8960
    },
    {
	"GL_TEXTURE_ENV_COLOR", GL_TEXTURE_ENV_COLOR, 8705
    },
    {
	"GL_TEXTURE_ENV_MODE", GL_TEXTURE_ENV_MODE, 8704
    },
    {
	"GL_TEXTURE_GEN_MODE", GL_TEXTURE_GEN_MODE, 9472
    },
    {
	"GL_TEXTURE_GEN_Q", GL_TEXTURE_GEN_Q, 3171
    },
    {
	"GL_TEXTURE_GEN_R", GL_TEXTURE_GEN_R, 3170
    },
    {
	"GL_TEXTURE_GEN_S", GL_TEXTURE_GEN_S, 3168
    },
    {
	"GL_TEXTURE_GEN_T", GL_TEXTURE_GEN_T, 3169
    },
    {
	"GL_TEXTURE_HEIGHT", GL_TEXTURE_HEIGHT, 4097
    },
    {
	"GL_TEXTURE_MAG_FILTER", GL_TEXTURE_MAG_FILTER, 10240
    },
    {
	"GL_TEXTURE_MATRIX", GL_TEXTURE_MATRIX, 2984
    },
    {
	"GL_TEXTURE_MIN_FILTER", GL_TEXTURE_MIN_FILTER, 10241
    },
    {
	"GL_TEXTURE_STACK_DEPTH", GL_TEXTURE_STACK_DEPTH, 2981
    },
    {
	"GL_TEXTURE_WIDTH", GL_TEXTURE_WIDTH, 4096
    },
    {
	"GL_TEXTURE_WRAP_S", GL_TEXTURE_WRAP_S, 10242
    },
    {
	"GL_TEXTURE_WRAP_T", GL_TEXTURE_WRAP_T, 10243
    },
    {
	"GL_TRANSFORM_BIT", GL_TRANSFORM_BIT, 4096
    },
    {
	"GL_TRIANGLES", GL_TRIANGLES, 4
    },
    {
	"GL_TRIANGLE_FAN", GL_TRIANGLE_FAN, 6
    },
    {
	"GL_TRIANGLE_STRIP", GL_TRIANGLE_STRIP, 5
    },
    {
	"GL_TRUE", GL_TRUE, 1
    },
    {
	"GL_UNPACK_ALIGNMENT", GL_UNPACK_ALIGNMENT, 3317
    },
    {
	"GL_UNPACK_LSB_FIRST", GL_UNPACK_LSB_FIRST, 3313
    },
    {
	"GL_UNPACK_ROW_LENGTH", GL_UNPACK_ROW_LENGTH, 3314
    },
    {
	"GL_UNPACK_SKIP_PIXELS", GL_UNPACK_SKIP_PIXELS, 3316
    },
    {
	"GL_UNPACK_SKIP_ROWS", GL_UNPACK_SKIP_ROWS, 3315
    },
    {
	"GL_UNPACK_SWAP_BYTES", GL_UNPACK_SWAP_BYTES, 3312
    },
    {
	"GL_UNSIGNED_BYTE", GL_UNSIGNED_BYTE, 5121
    },
    {
	"GL_UNSIGNED_INT", GL_UNSIGNED_INT, 5125
    },
    {
	"GL_UNSIGNED_SHORT", GL_UNSIGNED_SHORT, 5123
    },
    {
	"GL_VENDOR", GL_VENDOR, 7936
    },
    {
	"GL_VIEWPORT", GL_VIEWPORT, 2978
    },
    {
	"GL_VIEWPORT_BIT", GL_VIEWPORT_BIT, 2048
    },
    {
	"GL_XOR", GL_XOR, 5382
    },
    {
	"GL_ZERO", GL_ZERO, 0
    },
    {
	"GL_ZOOM_X", GL_ZOOM_X, 3350
    },
    {
	"GL_ZOOM_Y", GL_ZOOM_Y, 3351
    },
    {
	"GL_VERSION", GL_VERSION, 7938
    },
    {
	"End of List", -1, -1
    }
};

enumTestRec enum_AccumOp[] = {
    "GL_ACCUM", GL_ACCUM,
    "GL_LOAD", GL_LOAD,
    "GL_RETURN", GL_RETURN,
    "GL_MULT", GL_MULT,
    "GL_ADD", GL_ADD,
    "End of List", -1
};

enumTestRec enum_AlphaFunction[] = {
    "GL_NEVER", GL_NEVER,
    "GL_LESS", GL_LESS,
    "GL_EQUAL", GL_EQUAL,
    "GL_LEQUAL", GL_LEQUAL,
    "GL_GREATER", GL_GREATER,
    "GL_NOTEQUAL", GL_NOTEQUAL,
    "GL_GEQUAL", GL_GEQUAL,
    "GL_ALWAYS", GL_ALWAYS,
    "End of List", -1
};

enumTestRec enum_AttribMask[] = {
    "GL_CURRENT_BIT", GL_CURRENT_BIT,
    "GL_POINT_BIT", GL_POINT_BIT,
    "GL_LINE_BIT", GL_LINE_BIT,
    "GL_POLYGON_BIT", GL_POLYGON_BIT,
    "GL_POLYGON_STIPPLE_BIT", GL_POLYGON_STIPPLE_BIT,
    "GL_PIXEL_MODE_BIT", GL_PIXEL_MODE_BIT,
    "GL_LIGHTING_BIT", GL_LIGHTING_BIT,
    "GL_FOG_BIT", GL_FOG_BIT,
    "GL_DEPTH_BUFFER_BIT", GL_DEPTH_BUFFER_BIT,
    "GL_ACCUM_BUFFER_BIT", GL_ACCUM_BUFFER_BIT,
    "GL_STENCIL_BUFFER_BIT", GL_STENCIL_BUFFER_BIT,
    "GL_VIEWPORT_BIT", GL_VIEWPORT_BIT,
    "GL_TRANSFORM_BIT", GL_TRANSFORM_BIT,
    "GL_ENABLE_BIT", GL_ENABLE_BIT,
    "GL_COLOR_BUFFER_BIT", GL_COLOR_BUFFER_BIT,
    "GL_HINT_BIT", GL_HINT_BIT,
    "GL_EVAL_BIT", GL_EVAL_BIT,
    "GL_LIST_BIT", GL_LIST_BIT,
    "GL_TEXTURE_BIT", GL_TEXTURE_BIT,
    "GL_SCISSOR_BIT", GL_SCISSOR_BIT,
    "GL_ALL_ATTRIB_BITS", GL_ALL_ATTRIB_BITS,
    "End of List", -1
};

enumTestRec enum_BlendingFactorDest[] = {
    "GL_ZERO", GL_ZERO,
    "GL_ONE", GL_ONE,
    "GL_SRC_COLOR", GL_SRC_COLOR,
    "GL_ONE_MINUS_SRC_COLOR", GL_ONE_MINUS_SRC_COLOR,
    "GL_SRC_ALPHA", GL_SRC_ALPHA,
    "GL_ONE_MINUS_SRC_ALPHA", GL_ONE_MINUS_SRC_ALPHA,
    "GL_DST_ALPHA", GL_DST_ALPHA,
    "GL_ONE_MINUS_DST_ALPHA", GL_ONE_MINUS_DST_ALPHA,
    "End of List", -1
};

enumTestRec enum_BlendingFactorSrc[] = {
    "GL_ZERO", GL_ZERO,
    "GL_ONE", GL_ONE,
    "GL_DST_COLOR", GL_DST_COLOR,
    "GL_ONE_MINUS_DST_COLOR", GL_ONE_MINUS_DST_COLOR,
    "GL_SRC_ALPHA_SATURATE", GL_SRC_ALPHA_SATURATE,
    "GL_SRC_ALPHA", GL_SRC_ALPHA,
    "GL_ONE_MINUS_SRC_ALPHA", GL_ONE_MINUS_SRC_ALPHA,
    "GL_DST_ALPHA", GL_DST_ALPHA,
    "GL_ONE_MINUS_DST_ALPHA", GL_ONE_MINUS_DST_ALPHA,
    "End of List", -1
};

enumTestRec enum_Boolean[] = {
    "GL_TRUE", GL_TRUE,
    "GL_FALSE", GL_FALSE,
    "End of List", -1
};

enumTestRec enum_Enable[] = {
    "GL_FOG", GL_FOG,
    "GL_LIGHTING", GL_LIGHTING,
    "GL_TEXTURE_1D", GL_TEXTURE_1D,
    "GL_TEXTURE_2D", GL_TEXTURE_2D,
    "GL_LINE_STIPPLE", GL_LINE_STIPPLE,
    "GL_POLYGON_STIPPLE", GL_POLYGON_STIPPLE,
    "GL_CULL_FACE", GL_CULL_FACE,
    "GL_ALPHA_TEST", GL_ALPHA_TEST,
    "GL_BLEND", GL_BLEND,
    "GL_LOGIC_OP", GL_LOGIC_OP,
    "GL_DITHER", GL_DITHER,
    "GL_STENCIL_TEST", GL_STENCIL_TEST,
    "GL_DEPTH_TEST", GL_DEPTH_TEST,
    "GL_CLIP_PLANE0", GL_CLIP_PLANE0,
    "GL_CLIP_PLANE1", GL_CLIP_PLANE1,
    "GL_CLIP_PLANE2", GL_CLIP_PLANE2,
    "GL_CLIP_PLANE3", GL_CLIP_PLANE3,
    "GL_CLIP_PLANE4", GL_CLIP_PLANE4,
    "GL_CLIP_PLANE5", GL_CLIP_PLANE5,
    "GL_LIGHT0", GL_LIGHT0,
    "GL_LIGHT1", GL_LIGHT1,
    "GL_LIGHT2", GL_LIGHT2,
    "GL_LIGHT3", GL_LIGHT3,
    "GL_LIGHT4", GL_LIGHT4,
    "GL_LIGHT5", GL_LIGHT5,
    "GL_LIGHT6", GL_LIGHT6,
    "GL_LIGHT7", GL_LIGHT7,
    "GL_TEXTURE_GEN_S", GL_TEXTURE_GEN_S,
    "GL_TEXTURE_GEN_T", GL_TEXTURE_GEN_T,
    "GL_TEXTURE_GEN_R", GL_TEXTURE_GEN_R,
    "GL_TEXTURE_GEN_Q", GL_TEXTURE_GEN_Q,
    "GL_MAP1_VERTEX_3", GL_MAP1_VERTEX_3,
    "GL_MAP1_VERTEX_4", GL_MAP1_VERTEX_4,
    "GL_MAP1_COLOR_4", GL_MAP1_COLOR_4,
    "GL_MAP1_INDEX", GL_MAP1_INDEX,
    "GL_MAP1_NORMAL", GL_MAP1_NORMAL,
    "GL_MAP1_TEXTURE_COORD_1", GL_MAP1_TEXTURE_COORD_1,
    "GL_MAP1_TEXTURE_COORD_2", GL_MAP1_TEXTURE_COORD_2,
    "GL_MAP1_TEXTURE_COORD_3", GL_MAP1_TEXTURE_COORD_3,
    "GL_MAP1_TEXTURE_COORD_4", GL_MAP1_TEXTURE_COORD_4,
    "GL_MAP2_VERTEX_3", GL_MAP2_VERTEX_3,
    "GL_MAP2_VERTEX_4", GL_MAP2_VERTEX_4,
    "GL_MAP2_COLOR_4", GL_MAP2_COLOR_4,
    "GL_MAP2_INDEX", GL_MAP2_INDEX,
    "GL_MAP2_NORMAL", GL_MAP2_NORMAL,
    "GL_MAP2_TEXTURE_COORD_1", GL_MAP2_TEXTURE_COORD_1,
    "GL_MAP2_TEXTURE_COORD_2", GL_MAP2_TEXTURE_COORD_2,
    "GL_MAP2_TEXTURE_COORD_3", GL_MAP2_TEXTURE_COORD_3,
    "GL_MAP2_TEXTURE_COORD_4", GL_MAP2_TEXTURE_COORD_4,
    "GL_POINT_SMOOTH", GL_POINT_SMOOTH,
    "GL_LINE_SMOOTH", GL_LINE_SMOOTH,
    "GL_POLYGON_SMOOTH", GL_POLYGON_SMOOTH,
    "GL_SCISSOR_TEST", GL_SCISSOR_TEST,
    "GL_COLOR_MATERIAL", GL_COLOR_MATERIAL,
    "GL_NORMALIZE", GL_NORMALIZE,
    "GL_AUTO_NORMAL", GL_AUTO_NORMAL,
    "End of List", -1
};

enumTestRec enum_ClearBufferMask[] = {
    "GL_COLOR_BUFFER_BIT", GL_COLOR_BUFFER_BIT,
    "GL_ACCUM_BUFFER_BIT", GL_ACCUM_BUFFER_BIT,
    "GL_STENCIL_BUFFER_BIT", GL_STENCIL_BUFFER_BIT,
    "GL_DEPTH_BUFFER_BIT", GL_DEPTH_BUFFER_BIT,
    "End of List", -1
};

enumTestRec enum_ClipPlaneName[] = {
    "GL_CLIP_PLANE0", GL_CLIP_PLANE0,
    "GL_CLIP_PLANE1", GL_CLIP_PLANE1,
    "GL_CLIP_PLANE2", GL_CLIP_PLANE2,
    "GL_CLIP_PLANE3", GL_CLIP_PLANE3,
    "GL_CLIP_PLANE4", GL_CLIP_PLANE4,
    "GL_CLIP_PLANE5", GL_CLIP_PLANE5,
    "End of List", -1
};

enumTestRec enum_ColorMaterialFace[] = {
    "GL_FRONT", GL_FRONT,
    "GL_BACK", GL_BACK,
    "GL_FRONT_AND_BACK", GL_FRONT_AND_BACK,
    "End of List", -1
};

enumTestRec enum_ColorMaterialParameter[] = {
    "GL_AMBIENT", GL_AMBIENT,
    "GL_DIFFUSE", GL_DIFFUSE,
    "GL_SPECULAR", GL_SPECULAR,
    "GL_EMISSION", GL_EMISSION,
    "GL_AMBIENT_AND_DIFFUSE", GL_AMBIENT_AND_DIFFUSE,
    "End of List", -1
};

enumTestRec enum_CullFaceMode[] = {
    "GL_FRONT", GL_FRONT,
    "GL_BACK", GL_BACK,
    "End of List", -1
};

enumTestRec enum_DepthFunction[] = {
    "GL_NEVER", GL_NEVER,
    "GL_LESS", GL_LESS,
    "GL_EQUAL", GL_EQUAL,
    "GL_LEQUAL", GL_LEQUAL,
    "GL_GREATER", GL_GREATER,
    "GL_NOTEQUAL", GL_NOTEQUAL,
    "GL_GEQUAL", GL_GEQUAL,
    "GL_ALWAYS", GL_ALWAYS,
    "End of List", -1
};

enumTestRec enum_DrawBufferMode[] = {
    "GL_NONE", GL_NONE,
    "GL_FRONT_LEFT", GL_FRONT_LEFT,
    "GL_FRONT_RIGHT", GL_FRONT_RIGHT,
    "GL_BACK_LEFT", GL_BACK_LEFT,
    "GL_BACK_RIGHT", GL_BACK_RIGHT,
    "GL_BACK", GL_BACK,
    "GL_LEFT", GL_LEFT,
    "GL_RIGHT", GL_RIGHT,
    "GL_FRONT_AND_BACK", GL_FRONT_AND_BACK,
    "GL_AUX0", GL_AUX0,
    "GL_AUX1", GL_AUX1,
    "GL_AUX2", GL_AUX2,
    "GL_AUX3", GL_AUX3,
    "GL_FRONT", GL_FRONT,
    "End of List", -1
};

enumTestRec enum_ErrorCode[] = {
    "GL_NO_ERROR", GL_NO_ERROR,
    "GL_INVALID_ENUM", GL_INVALID_ENUM,
    "GL_INVALID_VALUE", GL_INVALID_VALUE,
    "GL_INVALID_OPERATION", GL_INVALID_OPERATION,
    "GL_STACK_OVERFLOW", GL_STACK_OVERFLOW,
    "GL_STACK_UNDERFLOW", GL_STACK_UNDERFLOW,
    "GL_OUT_OF_MEMORY", GL_OUT_OF_MEMORY,
    "End of List", -1
};

enumTestRec enum_FeedBackMode[] = {
    "GL_2D", GL_2D,
    "GL_3D", GL_3D,
    "GL_3D_COLOR", GL_3D_COLOR,
    "GL_3D_COLOR_TEXTURE", GL_3D_COLOR_TEXTURE,
    "GL_4D_COLOR_TEXTURE", GL_4D_COLOR_TEXTURE,
    "End of List", -1
};

enumTestRec enum_FogMode[] = {
    "GL_LINEAR", GL_LINEAR,
    "GL_EXP", GL_EXP,
    "GL_EXP2", GL_EXP2,
    "End of List", -1
};

enumTestRec enum_FogParameter[] = {
    "GL_FOG_COLOR", GL_FOG_COLOR,
    "GL_FOG_DENSITY", GL_FOG_DENSITY,
    "GL_FOG_END", GL_FOG_END,
    "GL_FOG_INDEX", GL_FOG_INDEX,
    "GL_FOG_MODE", GL_FOG_MODE,
    "GL_FOG_START", GL_FOG_START,
    "End of List", -1
};

enumTestRec enum_FrontFaceDirection[] = {
    "GL_CW", GL_CW,
    "GL_CCW", GL_CCW,
    "End of List", -1
};

enumTestRec enum_GetPixelMap[] = {
    "GL_PIXEL_MAP_I_TO_I", GL_PIXEL_MAP_I_TO_I,
    "GL_PIXEL_MAP_S_TO_S", GL_PIXEL_MAP_S_TO_S,
    "GL_PIXEL_MAP_I_TO_R", GL_PIXEL_MAP_I_TO_R,
    "GL_PIXEL_MAP_I_TO_G", GL_PIXEL_MAP_I_TO_G,
    "GL_PIXEL_MAP_I_TO_B", GL_PIXEL_MAP_I_TO_B,
    "GL_PIXEL_MAP_I_TO_A", GL_PIXEL_MAP_I_TO_A,
    "GL_PIXEL_MAP_R_TO_R", GL_PIXEL_MAP_R_TO_R,
    "GL_PIXEL_MAP_G_TO_G", GL_PIXEL_MAP_G_TO_G,
    "GL_PIXEL_MAP_B_TO_B", GL_PIXEL_MAP_B_TO_B,
    "GL_PIXEL_MAP_A_TO_A", GL_PIXEL_MAP_A_TO_A,
    "End of List", -1
};

enumTestRec enum_GetTarget[] = {
    "GL_NAME_STACK_DEPTH", GL_NAME_STACK_DEPTH,
    "GL_MAX_TEXTURE_SIZE", GL_MAX_TEXTURE_SIZE,
    "GL_MAP1_COLOR_4", GL_MAP1_COLOR_4,
    "GL_MAP1_INDEX", GL_MAP1_INDEX,
    "GL_MAP1_NORMAL", GL_MAP1_NORMAL,
    "GL_MAP1_TEXTURE_COORD_1", GL_MAP1_TEXTURE_COORD_1,
    "GL_MAP1_TEXTURE_COORD_2", GL_MAP1_TEXTURE_COORD_2,
    "GL_MAP1_TEXTURE_COORD_3", GL_MAP1_TEXTURE_COORD_3,
    "GL_MAP1_TEXTURE_COORD_4", GL_MAP1_TEXTURE_COORD_4,
    "GL_MAP1_VERTEX_3", GL_MAP1_VERTEX_3,
    "GL_MAP1_VERTEX_4", GL_MAP1_VERTEX_4,
    "GL_MAP2_COLOR_4", GL_MAP2_COLOR_4,
    "GL_MAP2_INDEX", GL_MAP2_INDEX,
    "GL_MAP2_NORMAL", GL_MAP2_NORMAL,
    "GL_MAP2_TEXTURE_COORD_1", GL_MAP2_TEXTURE_COORD_1,
    "GL_MAP2_TEXTURE_COORD_2", GL_MAP2_TEXTURE_COORD_2,
    "GL_MAP2_TEXTURE_COORD_3", GL_MAP2_TEXTURE_COORD_3,
    "GL_MAP2_TEXTURE_COORD_4", GL_MAP2_TEXTURE_COORD_4,
    "GL_MAP2_VERTEX_3", GL_MAP2_VERTEX_3,
    "GL_MAP2_VERTEX_4", GL_MAP2_VERTEX_4,
    "GL_AUTO_NORMAL", GL_AUTO_NORMAL,
    "GL_EDGE_FLAG", GL_EDGE_FLAG,
    "GL_SUBPIXEL_BITS", GL_SUBPIXEL_BITS,
    "GL_CURRENT_COLOR", GL_CURRENT_COLOR,
    "GL_CURRENT_INDEX", GL_CURRENT_INDEX,
    "GL_CURRENT_NORMAL", GL_CURRENT_NORMAL,
    "GL_CURRENT_TEXTURE_COORDS", GL_CURRENT_TEXTURE_COORDS,
    "GL_CURRENT_RASTER_INDEX", GL_CURRENT_RASTER_INDEX,
    "GL_CURRENT_RASTER_COLOR", GL_CURRENT_RASTER_COLOR,
    "GL_CURRENT_RASTER_TEXTURE_COORDS", GL_CURRENT_RASTER_TEXTURE_COORDS,
    "GL_CURRENT_RASTER_POSITION", GL_CURRENT_RASTER_POSITION,
    "GL_CURRENT_RASTER_POSITION_VALID", GL_CURRENT_RASTER_POSITION_VALID,
    "GL_POINT_SIZE", GL_POINT_SIZE,
    "GL_POINT_SIZE_RANGE", GL_POINT_SIZE_RANGE,
    "GL_POINT_SIZE_GRANULARITY", GL_POINT_SIZE_GRANULARITY,
    "GL_POINT_SMOOTH", GL_POINT_SMOOTH,
    "GL_LINE_SMOOTH", GL_LINE_SMOOTH,
    "GL_LINE_WIDTH", GL_LINE_WIDTH,
    "GL_LINE_WIDTH_RANGE", GL_LINE_WIDTH_RANGE,
    "GL_LINE_WIDTH_GRANULARITY", GL_LINE_WIDTH_GRANULARITY,
    "GL_LINE_STIPPLE_PATTERN", GL_LINE_STIPPLE_PATTERN,
    "GL_LINE_STIPPLE_REPEAT", GL_LINE_STIPPLE_REPEAT,
    "GL_LINE_STIPPLE", GL_LINE_STIPPLE,
    "GL_POLYGON_MODE", GL_POLYGON_MODE,
    "GL_POLYGON_SMOOTH", GL_POLYGON_SMOOTH,
    "GL_POLYGON_STIPPLE", GL_POLYGON_STIPPLE,
    "GL_CULL_FACE", GL_CULL_FACE,
    "GL_CULL_FACE_MODE", GL_CULL_FACE_MODE,
    "GL_FRONT_FACE", GL_FRONT_FACE,
    "GL_LIGHTING", GL_LIGHTING,
    "GL_LIGHT_MODEL_LOCAL_VIEWER", GL_LIGHT_MODEL_LOCAL_VIEWER,
    "GL_LIGHT_MODEL_TWO_SIDE", GL_LIGHT_MODEL_TWO_SIDE,
    "GL_LIGHT_MODEL_AMBIENT", GL_LIGHT_MODEL_AMBIENT,
    "GL_COLOR_MATERIAL", GL_COLOR_MATERIAL,
    "GL_COLOR_MATERIAL_FACE", GL_COLOR_MATERIAL_FACE,
    "GL_COLOR_MATERIAL_PARAMETER", GL_COLOR_MATERIAL_PARAMETER,
    "GL_SHADE_MODEL", GL_SHADE_MODEL,
    "GL_FOG", GL_FOG,
    "GL_FOG_INDEX", GL_FOG_INDEX,
    "GL_FOG_DENSITY", GL_FOG_DENSITY,
    "GL_FOG_START", GL_FOG_START,
    "GL_FOG_END", GL_FOG_END,
    "GL_FOG_MODE", GL_FOG_MODE,
    "GL_FOG_COLOR", GL_FOG_COLOR,
    "GL_DEPTH_RANGE", GL_DEPTH_RANGE,
    "GL_DEPTH_TEST", GL_DEPTH_TEST,
    "GL_DEPTH_WRITEMASK", GL_DEPTH_WRITEMASK,
    "GL_DEPTH_CLEAR_VALUE", GL_DEPTH_CLEAR_VALUE,
    "GL_DEPTH_FUNC", GL_DEPTH_FUNC,
    "GL_ACCUM_CLEAR_VALUE", GL_ACCUM_CLEAR_VALUE,
    "GL_STENCIL_TEST", GL_STENCIL_TEST,
    "GL_STENCIL_CLEAR_VALUE", GL_STENCIL_CLEAR_VALUE,
    "GL_STENCIL_FUNC", GL_STENCIL_FUNC,
    "GL_STENCIL_VALUE_MASK", GL_STENCIL_VALUE_MASK,
    "GL_STENCIL_FAIL", GL_STENCIL_FAIL,
    "GL_STENCIL_PASS_DEPTH_FAIL", GL_STENCIL_PASS_DEPTH_FAIL,
    "GL_STENCIL_PASS_DEPTH_PASS", GL_STENCIL_PASS_DEPTH_PASS,
    "GL_STENCIL_REF", GL_STENCIL_REF,
    "GL_STENCIL_WRITEMASK", GL_STENCIL_WRITEMASK,
    "GL_MATRIX_MODE", GL_MATRIX_MODE,
    "GL_NORMALIZE", GL_NORMALIZE,
    "GL_VIEWPORT", GL_VIEWPORT,
    "GL_ATTRIB_STACK_DEPTH", GL_ATTRIB_STACK_DEPTH,
    "GL_MODELVIEW_STACK_DEPTH", GL_MODELVIEW_STACK_DEPTH,
    "GL_PROJECTION_STACK_DEPTH", GL_PROJECTION_STACK_DEPTH,
    "GL_TEXTURE_STACK_DEPTH", GL_TEXTURE_STACK_DEPTH,
    "GL_MODELVIEW_MATRIX", GL_MODELVIEW_MATRIX,
    "GL_PROJECTION_MATRIX", GL_PROJECTION_MATRIX,
    "GL_TEXTURE_MATRIX", GL_TEXTURE_MATRIX,
    "GL_ALPHA_TEST", GL_ALPHA_TEST,
    "GL_ALPHA_TEST_FUNC", GL_ALPHA_TEST_FUNC,
    "GL_ALPHA_TEST_REF", GL_ALPHA_TEST_REF,
    "GL_DITHER", GL_DITHER,
    "GL_BLEND_DST", GL_BLEND_DST,
    "GL_BLEND_SRC", GL_BLEND_SRC,
    "GL_BLEND", GL_BLEND,
    "GL_LOGIC_OP_MODE", GL_LOGIC_OP_MODE,
    "GL_LOGIC_OP", GL_LOGIC_OP,
    "GL_DRAW_BUFFER", GL_DRAW_BUFFER,
    "GL_READ_BUFFER", GL_READ_BUFFER,
    "GL_SCISSOR_TEST", GL_SCISSOR_TEST,
    "GL_SCISSOR_BOX", GL_SCISSOR_BOX,
    "GL_INDEX_CLEAR_VALUE", GL_INDEX_CLEAR_VALUE,
    "GL_INDEX_MODE", GL_INDEX_MODE,
    "GL_INDEX_WRITEMASK", GL_INDEX_WRITEMASK,
    "GL_COLOR_CLEAR_VALUE", GL_COLOR_CLEAR_VALUE,
    "GL_RGBA_MODE", GL_RGBA_MODE,
    "GL_COLOR_WRITEMASK", GL_COLOR_WRITEMASK,
    "GL_RENDER_MODE", GL_RENDER_MODE,
    "GL_PERSPECTIVE_CORRECTION_HINT", GL_PERSPECTIVE_CORRECTION_HINT,
    "GL_POINT_SMOOTH_HINT", GL_POINT_SMOOTH_HINT,
    "GL_LINE_SMOOTH_HINT", GL_LINE_SMOOTH_HINT,
    "GL_POLYGON_SMOOTH_HINT", GL_POLYGON_SMOOTH_HINT,
    "GL_FOG_HINT", GL_FOG_HINT,
    "GL_LIST_BASE", GL_LIST_BASE,
    "GL_LIST_INDEX", GL_LIST_INDEX,
    "GL_LIST_MODE", GL_LIST_MODE,
    "GL_MAX_LIST_NESTING", GL_MAX_LIST_NESTING,
    "GL_TEXTURE_GEN_S", GL_TEXTURE_GEN_S,
    "GL_TEXTURE_GEN_T", GL_TEXTURE_GEN_T,
    "GL_TEXTURE_GEN_R", GL_TEXTURE_GEN_R,
    "GL_TEXTURE_GEN_Q", GL_TEXTURE_GEN_Q,
    "GL_PACK_SWAP_BYTES", GL_PACK_SWAP_BYTES,
    "GL_PACK_LSB_FIRST", GL_PACK_LSB_FIRST,
    "GL_PACK_ROW_LENGTH", GL_PACK_ROW_LENGTH,
    "GL_PACK_SKIP_ROWS", GL_PACK_SKIP_ROWS,
    "GL_PACK_SKIP_PIXELS", GL_PACK_SKIP_PIXELS,
    "GL_PACK_ALIGNMENT", GL_PACK_ALIGNMENT,
    "GL_UNPACK_SWAP_BYTES", GL_UNPACK_SWAP_BYTES,
    "GL_UNPACK_LSB_FIRST", GL_UNPACK_LSB_FIRST,
    "GL_UNPACK_ROW_LENGTH", GL_UNPACK_ROW_LENGTH,
    "GL_UNPACK_SKIP_ROWS", GL_UNPACK_SKIP_ROWS,
    "GL_UNPACK_SKIP_PIXELS", GL_UNPACK_SKIP_PIXELS,
    "GL_UNPACK_ALIGNMENT", GL_UNPACK_ALIGNMENT,
    "GL_MAP_COLOR", GL_MAP_COLOR,
    "GL_MAP_STENCIL", GL_MAP_STENCIL,
    "GL_INDEX_SHIFT", GL_INDEX_SHIFT,
    "GL_INDEX_OFFSET", GL_INDEX_OFFSET,
    "GL_RED_SCALE", GL_RED_SCALE,
    "GL_GREEN_SCALE", GL_GREEN_SCALE,
    "GL_BLUE_SCALE", GL_BLUE_SCALE,
    "GL_ALPHA_SCALE", GL_ALPHA_SCALE,
    "GL_DEPTH_SCALE", GL_DEPTH_SCALE,
    "GL_RED_BIAS", GL_RED_BIAS,
    "GL_GREEN_BIAS", GL_GREEN_BIAS,
    "GL_BLUE_BIAS", GL_BLUE_BIAS,
    "GL_ALPHA_BIAS", GL_ALPHA_BIAS,
    "GL_DEPTH_BIAS", GL_DEPTH_BIAS,
    "GL_ZOOM_X", GL_ZOOM_X,
    "GL_ZOOM_Y", GL_ZOOM_Y,
    "GL_PIXEL_MAP_I_TO_I_SIZE", GL_PIXEL_MAP_I_TO_I_SIZE,
    "GL_PIXEL_MAP_S_TO_S_SIZE", GL_PIXEL_MAP_S_TO_S_SIZE,
    "GL_PIXEL_MAP_I_TO_R_SIZE", GL_PIXEL_MAP_I_TO_R_SIZE,
    "GL_PIXEL_MAP_I_TO_G_SIZE", GL_PIXEL_MAP_I_TO_G_SIZE,
    "GL_PIXEL_MAP_I_TO_B_SIZE", GL_PIXEL_MAP_I_TO_B_SIZE,
    "GL_PIXEL_MAP_I_TO_A_SIZE", GL_PIXEL_MAP_I_TO_A_SIZE,
    "GL_PIXEL_MAP_R_TO_R_SIZE", GL_PIXEL_MAP_R_TO_R_SIZE,
    "GL_PIXEL_MAP_G_TO_G_SIZE", GL_PIXEL_MAP_G_TO_G_SIZE,
    "GL_PIXEL_MAP_B_TO_B_SIZE", GL_PIXEL_MAP_B_TO_B_SIZE,
    "GL_PIXEL_MAP_A_TO_A_SIZE", GL_PIXEL_MAP_A_TO_A_SIZE,
    "GL_MAX_EVAL_ORDER", GL_MAX_EVAL_ORDER,
    "GL_MAX_LIGHTS", GL_MAX_LIGHTS,
    "GL_MAX_CLIP_PLANES", GL_MAX_CLIP_PLANES,
    "GL_MAX_PIXEL_MAP_TABLE", GL_MAX_PIXEL_MAP_TABLE,
    "GL_MAX_ATTRIB_STACK_DEPTH", GL_MAX_ATTRIB_STACK_DEPTH,
    "GL_MAX_MODELVIEW_STACK_DEPTH", GL_MAX_MODELVIEW_STACK_DEPTH,
    "GL_MAX_NAME_STACK_DEPTH", GL_MAX_NAME_STACK_DEPTH,
    "GL_MAX_PROJECTION_STACK_DEPTH", GL_MAX_PROJECTION_STACK_DEPTH,
    "GL_MAX_TEXTURE_STACK_DEPTH", GL_MAX_TEXTURE_STACK_DEPTH,
    "GL_INDEX_BITS", GL_INDEX_BITS,
    "GL_RED_BITS", GL_RED_BITS,
    "GL_GREEN_BITS", GL_GREEN_BITS,
    "GL_BLUE_BITS", GL_BLUE_BITS,
    "GL_ALPHA_BITS", GL_ALPHA_BITS,
    "GL_DEPTH_BITS", GL_DEPTH_BITS,
    "GL_STENCIL_BITS", GL_STENCIL_BITS,
    "GL_ACCUM_RED_BITS", GL_ACCUM_RED_BITS,
    "GL_ACCUM_GREEN_BITS", GL_ACCUM_GREEN_BITS,
    "GL_ACCUM_BLUE_BITS", GL_ACCUM_BLUE_BITS,
    "GL_ACCUM_ALPHA_BITS", GL_ACCUM_ALPHA_BITS,
    "GL_MAP1_GRID_DOMAIN", GL_MAP1_GRID_DOMAIN,
    "GL_MAP1_GRID_SEGMENTS", GL_MAP1_GRID_SEGMENTS,
    "GL_MAP2_GRID_DOMAIN", GL_MAP2_GRID_DOMAIN,
    "GL_MAP2_GRID_SEGMENTS", GL_MAP2_GRID_SEGMENTS,
    "GL_TEXTURE_1D", GL_TEXTURE_1D,
    "GL_TEXTURE_2D", GL_TEXTURE_2D,
    "GL_MAX_VIEWPORT_DIMS", GL_MAX_VIEWPORT_DIMS,
    "GL_DOUBLEBUFFER", GL_DOUBLEBUFFER,
    "GL_AUX_BUFFERS", GL_AUX_BUFFERS,
    "GL_STEREO", GL_STEREO,
    "End of List", -1
};

enumTestRec enum_HintMode[] = {
    "GL_DONT_CARE", GL_DONT_CARE,
    "GL_FASTEST", GL_FASTEST,
    "GL_NICEST", GL_NICEST,
    "End of List", -1
};

enumTestRec enum_HintTarget[] = {
    "GL_PERSPECTIVE_CORRECTION_HINT", GL_PERSPECTIVE_CORRECTION_HINT,
    "GL_POINT_SMOOTH_HINT", GL_POINT_SMOOTH_HINT,
    "GL_LINE_SMOOTH_HINT", GL_LINE_SMOOTH_HINT,
    "GL_POLYGON_SMOOTH_HINT", GL_POLYGON_SMOOTH_HINT,
    "GL_FOG_HINT", GL_FOG_HINT,
    "End of List", -1
};

enumTestRec enum_LightModelParameter[] = {
    "GL_LIGHT_MODEL_AMBIENT", GL_LIGHT_MODEL_AMBIENT,
    "GL_LIGHT_MODEL_LOCAL_VIEWER", GL_LIGHT_MODEL_LOCAL_VIEWER,
    "GL_LIGHT_MODEL_TWO_SIDE", GL_LIGHT_MODEL_TWO_SIDE,
    "End of List", -1
};

enumTestRec enum_LightName[] = {
    "GL_LIGHT0", GL_LIGHT0,
    "GL_LIGHT1", GL_LIGHT1,
    "GL_LIGHT2", GL_LIGHT2,
    "GL_LIGHT3", GL_LIGHT3,
    "GL_LIGHT4", GL_LIGHT4,
    "GL_LIGHT5", GL_LIGHT5,
    "GL_LIGHT6", GL_LIGHT6,
    "GL_LIGHT7", GL_LIGHT7,
    "End of List", -1
};

enumTestRec enum_LightParameter[] = {
    "GL_AMBIENT", GL_AMBIENT,
    "GL_DIFFUSE", GL_DIFFUSE,
    "GL_SPECULAR", GL_SPECULAR,
    "GL_POSITION", GL_POSITION,
    "GL_SPOT_DIRECTION", GL_SPOT_DIRECTION,
    "GL_SPOT_EXPONENT", GL_SPOT_EXPONENT,
    "GL_SPOT_CUTOFF", GL_SPOT_CUTOFF,
    "GL_CONSTANT_ATTENUATION", GL_CONSTANT_ATTENUATION,
    "GL_LINEAR_ATTENUATION", GL_LINEAR_ATTENUATION,
    "GL_QUADRATIC_ATTENUATION", GL_QUADRATIC_ATTENUATION,
    "End of List", -1
};

enumTestRec enum_ListMode[] = {
    "GL_COMPILE", GL_COMPILE,
    "GL_COMPILE_AND_EXECUTE", GL_COMPILE_AND_EXECUTE,
    "End of List", -1
};

enumTestRec enum_ListNameType[] = {
    "GL_BYTE", GL_BYTE,
    "GL_UNSIGNED_BYTE", GL_UNSIGNED_BYTE,
    "GL_SHORT", GL_SHORT,
    "GL_UNSIGNED_SHORT", GL_UNSIGNED_SHORT,
    "GL_INT", GL_INT,
    "GL_UNSIGNED_INT", GL_UNSIGNED_INT,
    "GL_FLOAT", GL_FLOAT,
    "GL_2_BYTES", GL_2_BYTES,
    "GL_3_BYTES", GL_3_BYTES,
    "GL_4_BYTES", GL_4_BYTES,
    "End of List", -1
};

enumTestRec enum_LogicOp[] = {
    "GL_CLEAR", GL_CLEAR,
    "GL_AND", GL_AND,
    "GL_AND_REVERSE", GL_AND_REVERSE,
    "GL_COPY", GL_COPY,
    "GL_AND_INVERTED", GL_AND_INVERTED,
    "GL_NOOP", GL_NOOP,
    "GL_XOR", GL_XOR,
    "GL_OR", GL_OR,
    "GL_NOR", GL_NOR,
    "GL_EQUIV", GL_EQUIV,
    "GL_INVERT", GL_INVERT,
    "GL_OR_REVERSE", GL_OR_REVERSE,
    "GL_COPY_INVERTED", GL_COPY_INVERTED,
    "GL_OR_INVERTED", GL_OR_INVERTED,
    "GL_NAND", GL_NAND,
    "GL_SET", GL_SET,
    "End of List", -1
};

enumTestRec enum_MapTarget[] = {
    "GL_MAP1_COLOR_4", GL_MAP1_COLOR_4,
    "GL_MAP1_INDEX", GL_MAP1_INDEX,
    "GL_MAP1_NORMAL", GL_MAP1_NORMAL,
    "GL_MAP1_TEXTURE_COORD_1", GL_MAP1_TEXTURE_COORD_1,
    "GL_MAP1_TEXTURE_COORD_2", GL_MAP1_TEXTURE_COORD_2,
    "GL_MAP1_TEXTURE_COORD_3", GL_MAP1_TEXTURE_COORD_3,
    "GL_MAP1_TEXTURE_COORD_4", GL_MAP1_TEXTURE_COORD_4,
    "GL_MAP1_VERTEX_3", GL_MAP1_VERTEX_3,
    "GL_MAP1_VERTEX_4", GL_MAP1_VERTEX_4,
    "GL_MAP2_COLOR_4", GL_MAP2_COLOR_4,
    "GL_MAP2_INDEX", GL_MAP2_INDEX,
    "GL_MAP2_NORMAL", GL_MAP2_NORMAL,
    "GL_MAP2_TEXTURE_COORD_1", GL_MAP2_TEXTURE_COORD_1,
    "GL_MAP2_TEXTURE_COORD_2", GL_MAP2_TEXTURE_COORD_2,
    "GL_MAP2_TEXTURE_COORD_3", GL_MAP2_TEXTURE_COORD_3,
    "GL_MAP2_TEXTURE_COORD_4", GL_MAP2_TEXTURE_COORD_4,
    "GL_MAP2_VERTEX_3", GL_MAP2_VERTEX_3,
    "GL_MAP2_VERTEX_4", GL_MAP2_VERTEX_4,
    "End of List", -1
};

enumTestRec enum_MapGetTarget[] = {
    "GL_COEFF", GL_COEFF,
    "GL_ORDER", GL_ORDER,
    "GL_DOMAIN", GL_DOMAIN,
    "End of List", -1
};

enumTestRec enum_MaterialFace[] = {
    "GL_FRONT", GL_FRONT,
    "GL_BACK", GL_BACK,
    "GL_FRONT_AND_BACK", GL_FRONT_AND_BACK,
    "End of List", -1
};

enumTestRec enum_MaterialParameter[] = {
    "GL_EMISSION", GL_EMISSION,
    "GL_SHININESS", GL_SHININESS,
    "GL_AMBIENT_AND_DIFFUSE", GL_AMBIENT_AND_DIFFUSE,
    "GL_COLOR_INDEXES", GL_COLOR_INDEXES,
    "GL_AMBIENT", GL_AMBIENT,
    "GL_DIFFUSE", GL_DIFFUSE,
    "GL_SPECULAR", GL_SPECULAR,
    "End of List", -1
};

enumTestRec enum_MatrixMode[] = {
    "GL_TEXTURE", GL_TEXTURE,
    "GL_PROJECTION", GL_PROJECTION,
    "GL_MODELVIEW", GL_MODELVIEW,
    "End of List", -1
};

enumTestRec enum_MeshMode1[] = {
    "GL_POINT", GL_POINT,
    "GL_LINE", GL_LINE,
    "End of List", -1
};

enumTestRec enum_MeshMode2[] = {
    "GL_POINT", GL_POINT,
    "GL_LINE", GL_LINE,
    "GL_FILL", GL_FILL,
    "End of List", -1
};

enumTestRec enum_PixelCopyType[] = {
    "GL_COLOR", GL_COLOR,
    "GL_DEPTH", GL_DEPTH,
    "GL_STENCIL", GL_STENCIL,
    "End of List", -1
};

enumTestRec enum_PixelFormat[] = {
    "GL_COLOR_INDEX", GL_COLOR_INDEX,
    "GL_STENCIL_INDEX", GL_STENCIL_INDEX,
    "GL_DEPTH_COMPONENT", GL_DEPTH_COMPONENT,
    "GL_RED", GL_RED,
    "GL_GREEN", GL_GREEN,
    "GL_BLUE", GL_BLUE,
    "GL_ALPHA", GL_ALPHA,
    "GL_RGB", GL_RGB,
    "GL_RGBA", GL_RGBA,
    "GL_LUMINANCE", GL_LUMINANCE,
    "GL_LUMINANCE_ALPHA", GL_LUMINANCE_ALPHA,
    "End of List", -1
};

enumTestRec enum_PixelMap[] = {
    "GL_PIXEL_MAP_I_TO_I", GL_PIXEL_MAP_I_TO_I,
    "GL_PIXEL_MAP_S_TO_S", GL_PIXEL_MAP_S_TO_S,
    "GL_PIXEL_MAP_I_TO_R", GL_PIXEL_MAP_I_TO_R,
    "GL_PIXEL_MAP_I_TO_G", GL_PIXEL_MAP_I_TO_G,
    "GL_PIXEL_MAP_I_TO_B", GL_PIXEL_MAP_I_TO_B,
    "GL_PIXEL_MAP_I_TO_A", GL_PIXEL_MAP_I_TO_A,
    "GL_PIXEL_MAP_R_TO_R", GL_PIXEL_MAP_R_TO_R,
    "GL_PIXEL_MAP_G_TO_G", GL_PIXEL_MAP_G_TO_G,
    "GL_PIXEL_MAP_B_TO_B", GL_PIXEL_MAP_B_TO_B,
    "GL_PIXEL_MAP_A_TO_A", GL_PIXEL_MAP_A_TO_A,
    "End of List", -1
};

enumTestRec enum_PixelStore[] = {
    "GL_UNPACK_SWAP_BYTES", GL_UNPACK_SWAP_BYTES,
    "GL_UNPACK_LSB_FIRST", GL_UNPACK_LSB_FIRST,
    "GL_UNPACK_ROW_LENGTH", GL_UNPACK_ROW_LENGTH,
    "GL_UNPACK_SKIP_ROWS", GL_UNPACK_SKIP_ROWS,
    "GL_UNPACK_SKIP_PIXELS", GL_UNPACK_SKIP_PIXELS,
    "GL_UNPACK_ALIGNMENT", GL_UNPACK_ALIGNMENT,
    "GL_PACK_SWAP_BYTES", GL_PACK_SWAP_BYTES,
    "GL_PACK_LSB_FIRST", GL_PACK_LSB_FIRST,
    "GL_PACK_ROW_LENGTH", GL_PACK_ROW_LENGTH,
    "GL_PACK_SKIP_ROWS", GL_PACK_SKIP_ROWS,
    "GL_PACK_SKIP_PIXELS", GL_PACK_SKIP_PIXELS,
    "GL_PACK_ALIGNMENT", GL_PACK_ALIGNMENT,
    "End of List", -1
};

enumTestRec enum_PixelTransfer[] = {
    "GL_MAP_COLOR", GL_MAP_COLOR,
    "GL_MAP_STENCIL", GL_MAP_STENCIL,
    "GL_INDEX_SHIFT", GL_INDEX_SHIFT,
    "GL_INDEX_OFFSET", GL_INDEX_OFFSET,
    "GL_RED_SCALE", GL_RED_SCALE,
    "GL_RED_BIAS", GL_RED_BIAS,
    "GL_GREEN_SCALE", GL_GREEN_SCALE,
    "GL_GREEN_BIAS", GL_GREEN_BIAS,
    "GL_BLUE_SCALE", GL_BLUE_SCALE,
    "GL_BLUE_BIAS", GL_BLUE_BIAS,
    "GL_ALPHA_SCALE", GL_ALPHA_SCALE,
    "GL_ALPHA_BIAS", GL_ALPHA_BIAS,
    "GL_DEPTH_SCALE", GL_DEPTH_SCALE,
    "GL_DEPTH_BIAS", GL_DEPTH_BIAS,
    "End of List", -1
};

enumTestRec enum_PixelType[] = {
    "GL_BITMAP", GL_BITMAP,
    "GL_BYTE", GL_BYTE,
    "GL_UNSIGNED_BYTE", GL_UNSIGNED_BYTE,
    "GL_SHORT", GL_SHORT,
    "GL_UNSIGNED_SHORT", GL_UNSIGNED_SHORT,
    "GL_INT", GL_INT,
    "GL_UNSIGNED_INT", GL_UNSIGNED_INT,
    "GL_FLOAT", GL_FLOAT,
    "End of List", -1
};

enumTestRec enum_PolygonMode[] = {
    "GL_POINT", GL_POINT,
    "GL_LINE", GL_LINE,
    "GL_FILL", GL_FILL,
    "End of List", -1
};

enumTestRec enum_BeginMode[] = {
    "GL_LINE_LOOP", GL_LINE_LOOP,
    "GL_LINE_STRIP", GL_LINE_STRIP,
    "GL_LINES", GL_LINES,
    "GL_POINTS", GL_POINTS,
    "GL_POLYGON", GL_POLYGON,
    "GL_TRIANGLE_STRIP", GL_TRIANGLE_STRIP,
    "GL_TRIANGLE_FAN", GL_TRIANGLE_FAN,
    "GL_TRIANGLES", GL_TRIANGLES,
    "GL_QUAD_STRIP", GL_QUAD_STRIP,
    "GL_QUADS", GL_QUADS,
    "End of List", -1
};

enumTestRec enum_ReadBufferMode[] = {
    "GL_FRONT_LEFT", GL_FRONT_LEFT,
    "GL_FRONT_RIGHT", GL_FRONT_RIGHT,
    "GL_BACK_LEFT", GL_BACK_LEFT,
    "GL_BACK_RIGHT", GL_BACK_RIGHT,
    "GL_BACK", GL_BACK,
    "GL_LEFT", GL_LEFT,
    "GL_RIGHT", GL_RIGHT,
    "GL_AUX0", GL_AUX0,
    "GL_AUX1", GL_AUX1,
    "GL_AUX2", GL_AUX2,
    "GL_AUX3", GL_AUX3,
    "GL_FRONT", GL_FRONT,
    "End of List", -1
};

enumTestRec enum_RenderingMode[] = {
    "GL_FEEDBACK", GL_FEEDBACK,
    "GL_SELECT", GL_SELECT,
    "GL_RENDER", GL_RENDER,
    "End of List", -1
};

enumTestRec enum_ShadingModel[] = {
    "GL_FLAT", GL_FLAT,
    "GL_SMOOTH", GL_SMOOTH,
    "End of List", -1
};

enumTestRec enum_StencilFunction[] = {
    "GL_NEVER", GL_NEVER,
    "GL_LESS", GL_LESS,
    "GL_EQUAL", GL_EQUAL,
    "GL_LEQUAL", GL_LEQUAL,
    "GL_GREATER", GL_GREATER,
    "GL_NOTEQUAL", GL_NOTEQUAL,
    "GL_GEQUAL", GL_GEQUAL,
    "GL_ALWAYS", GL_ALWAYS,
    "End of List", -1
};

enumTestRec enum_StencilOp[] = {
    "GL_ZERO", GL_ZERO,
    "GL_KEEP", GL_KEEP,
    "GL_REPLACE", GL_REPLACE,
    "GL_INCR", GL_INCR,
    "GL_DECR", GL_DECR,
    "GL_INVERT", GL_INVERT,
    "End of List", -1
};

enumTestRec enum_StringName[] = {
    "GL_VENDOR", GL_VENDOR,
    "GL_RENDERER", GL_RENDERER,
    "GL_VERSION", GL_VERSION,
    "GL_EXTENSIONS", GL_EXTENSIONS,
    "End of List", -1
};

enumTestRec enum_TextureBorder[] = {
    "No border", 0,
    "One Border", 1,
    "End of List", -1
};

enumTestRec enum_TextureCoordName[] = {
    "GL_S", GL_S,
    "GL_T", GL_T,
    "GL_R", GL_R,
    "GL_Q", GL_Q,
    "End of List", -1
};

enumTestRec enum_TextureEnvMode[] = {
    "GL_MODULATE", GL_MODULATE,
    "GL_DECAL", GL_DECAL,
    "GL_BLEND", GL_BLEND,
    "End of List", -1
};

enumTestRec enum_TextureEnvParameter[] = {
    "GL_TEXTURE_ENV_MODE", GL_TEXTURE_ENV_MODE,
    "GL_TEXTURE_ENV_COLOR", GL_TEXTURE_ENV_COLOR,
    "End of List", -1
};

enumTestRec enum_TextureEnvTarget[] = {
    "GL_TEXTURE_ENV", GL_TEXTURE_ENV,
    "End of List", -1
};

enumTestRec enum_TextureGenMode[] = {
    "GL_EYE_LINEAR", GL_EYE_LINEAR,
    "GL_OBJECT_LINEAR", GL_OBJECT_LINEAR,
    "GL_SPHERE_MAP", GL_SPHERE_MAP,
    "End of List", -1
};

enumTestRec enum_TextureGenParameter[] = {
    "GL_TEXTURE_GEN_MODE", GL_TEXTURE_GEN_MODE,
    "GL_OBJECT_PLANE", GL_OBJECT_PLANE,
    "GL_EYE_PLANE", GL_EYE_PLANE,
    "End of List", -1
};

enumTestRec enum_TextureWrapMode[] = {
    "GL_CLAMP", GL_CLAMP,
    "GL_REPEAT", GL_REPEAT,
    "End of List", -1
};

enumTestRec enum_TextureMagFilter[] = {
    "GL_NEAREST", GL_NEAREST,
    "GL_LINEAR", GL_LINEAR,
    "End of List", -1
};

enumTestRec enum_TextureMinFilter[] = {
    "GL_NEAREST", GL_NEAREST,
    "GL_LINEAR", GL_LINEAR,
    "GL_NEAREST_MIPMAP_NEAREST", GL_NEAREST_MIPMAP_NEAREST,
    "GL_LINEAR_MIPMAP_NEAREST", GL_LINEAR_MIPMAP_NEAREST,
    "GL_NEAREST_MIPMAP_LINEAR", GL_NEAREST_MIPMAP_LINEAR,
    "GL_LINEAR_MIPMAP_LINEAR", GL_LINEAR_MIPMAP_LINEAR,
    "End of List", -1
};

enumTestRec enum_TextureParameterName[] = {
    "GL_TEXTURE_MAG_FILTER", GL_TEXTURE_MAG_FILTER,
    "GL_TEXTURE_MIN_FILTER", GL_TEXTURE_MIN_FILTER,
    "GL_TEXTURE_WRAP_S", GL_TEXTURE_WRAP_S,
    "GL_TEXTURE_WRAP_T", GL_TEXTURE_WRAP_T,
    "End of List", -1
};

enumTestRec enum_GetTextureParameter[] = {
    "GL_TEXTURE_MAG_FILTER", GL_TEXTURE_MAG_FILTER,
    "GL_TEXTURE_MIN_FILTER", GL_TEXTURE_MIN_FILTER,
    "GL_TEXTURE_WRAP_S", GL_TEXTURE_WRAP_S,
    "GL_TEXTURE_WRAP_T", GL_TEXTURE_WRAP_T,
    "GL_TEXTURE_WIDTH", GL_TEXTURE_WIDTH,
    "GL_TEXTURE_HEIGHT", GL_TEXTURE_HEIGHT,
    "GL_TEXTURE_COMPONENTS", GL_TEXTURE_COMPONENTS,
    "GL_TEXTURE_BORDER_COLOR", GL_TEXTURE_BORDER_COLOR,
    "GL_TEXTURE_BORDER", GL_TEXTURE_BORDER,
    "End of List", -1
};

enumTestRec enum_TextureTarget[] = {
    "GL_TEXTURE_1D", GL_TEXTURE_1D,
    "GL_TEXTURE_2D", GL_TEXTURE_2D,
    "End of List", -1
};
