#ifndef __FONT_VALIDATION_STATUS_CODES_H
#define __FONT_VALIDATION_STATUS_CODES_H

//
// Detailed status codes for function CheckInfWithStatusA().
// These codes were added after the initial creation of the T1 installer library.
// CheckInfA() returns TRUE/FALSE.  However, a FALSE return value was
// not sufficiently descriptive for a user interface to respond appropriately.
// The function CheckInfWithStatusA() was added to provide detailed status info.
// No new return points were added to T1 installer functions.  These codes merely
// replace the original TRUE/FALSE return values.
//
// These codes are also used in the font folder font validation functions.
//
// The code is designed to return information that identifies:
//    a) What happened.
//    b) What file the status applies to (if applicable).
//
//
// bit->  15                 7               0
//       +-+----------------+-----------------+
//       |S| Status Code    | File Type Code  |
//       +-+----------------+-----------------+
//        |
//        +--- Severity bit.
//
//             1 = Error.  A true error like file i/o, mem alloc etc.
//             0 = No error. But status may indicate invalid font file.
// 
//                 >>>>>>> NOTE <<<<<<<<
//
//   This file contains codes that are generated by the
//   T1 installer function CheckType1A and by related font folder functions.
//   Since both the T1 installer and the font folder must understand
//   these codes, the font folder must include this file.  I apologize for
//   this added coupling between the T1 installer and the font folder but
//   it is necessary for detailed status reporting [brianau].
//
#define FVS_FILE_UNK    0x00  // File unknown or "doesn't matter".
#define FVS_FILE_PFM    0x01  // PFM file
#define FVS_FILE_PFB    0x02  // PFB file
#define FVS_FILE_AFM    0x03  // AFM file
#define FVS_FILE_INF    0x04  // INF file
#define FVS_FILE_TTF    0x05  // TTF file
#define FVS_FILE_FOT    0x06  // FOT file

//
// Status codes.
//
#define FVS_SUCCESS                 0x00   // No problem!
#define FVS_INVALID_FONTFILE        0x01   // Invalid font file or file name.
#define FVS_BAD_VERSION             0x02   // File version not supported.
#define FVS_FILE_BUILD_ERR          0x03   // Error building a font file.
#define FVS_FILE_EXISTS             0x04   // File already exists.
#define FVS_FILE_OPEN_ERR           0x05   // Couldn't find/open existing file.

//
// These codes indicate true system errors.  Note use of high bit
// to indicate severity.
//
#define FVS_FILE_CREATE_ERR         0x80   // Couldn't create new file.
#define FVS_FILE_IO_ERR             0x81   // General file I/O error.
#define FVS_INVALID_ARG             0x82   // Invalid arg passed to function.
#define FVS_EXCEPTION               0x83   // Exception caught.
#define FVS_INSUFFICIENT_BUF        0x84   // Destination buf too small.
#define FVS_MEM_ALLOC_ERR           0x85   // Error allocating memory.
#define FVS_INVALID_STATUS          0x86   // For ensuring status was set.

//
// Macros for creating and parsing status codes.
//
#define FVS_MAKE_CODE(c,f)   ((WORD)(((BYTE)(c) << 8) | (BYTE)(f)))  // Build code
#define FVS_STATUS(c)        (((c) >> 8) & 0x00FF) // Get status part
#define FVS_FILE(c)          ((c) & 0x00FF)        // Get file part
#define FVS_ISERROR(c)       (((c) & 0x8000) != 0) // Severity bit == 1 ?

#endif
