// This file contains help context id's in the master windows.h file.

// Id's over 61440 are reserved and will ALWAYS use windows.hlp when
// used for context-sensitive help.

// Id's from 1-999 are reserved for Object help

// REVIEW: has to be 28440 until new help compiler is available

#define IDH_NO_HELP		28440
#define IDH_MISSING_CONTEXT	28441 // Control doesn't have matching help context
#define IDH_GENERIC_HELP_BUTTON 28442 // Property sheet help button
#define IDH_OK			28443
#define IDH_CANCEL		28444
#define IDH_HELP		28445
#define IDH_NETWORK		28446
#define IDH_COMM_APPLYNOW	28447
#define IDH_FONT_STYLE		28448
#define IDH_FONT_SIZE		28449
#define IDH_FONT_SAMPLE 	28450
#define IDH_FONT_EFFECTS	28451
#define IDH_FONT_FONT		28452
#define IDH_PRINT_SETUP_AVAIL	28453
#define IDH_PRINT_SETUP_OPTIONS 28454
#define IDH_PRINT_SETUP_DETAILS 28455
#define IDH_OPEN_LOCATION	28456
#define IDH_OPEN_FILES		28457
#define IDH_OPEN_SAMPLE 	28458
#define IDH_OPEN_READONLY	28459
#define IDH_OPEN_FILETYPE	28460
#define IDH_OPEN_PATH		28461
#define IDH_OPEN_FILENAME	28462
#define IDH_FIND_SEARCHTEXT	28463
#define IDH_FIND_NEXT_BUTTON	28464
#define IDH_FIND_REPLACE_BUTTON 28465
#define IDH_FIND_SEARCH_LIST	28466
#define IDH_FIND_WHOLE		28467
#define IDH_FIND_CASE		28468
#define IDH_REPLACE_REPLACE	28469
#define IDH_REPLACE_REPLACE_ALL 28470
#define IDH_REPLACE_REPLACEWITH 28471
#define IDH_PRINT_PRINTER	28472
#define IDH_PRINT_PRINTER_SETUP 28473
#define IDH_PRINT_COPIES	28474
#define IDH_PRINT_COLLATE	28475
#define IDH_PRINT_TO_FILE	28476
#define IDH_PRINT_QUALITY	28477
#define IDH_PRINT_RANGE 	28478
#define IDH_NETWORK_DRIVE	28479
#define IDH_NETWORK_PATH	28480
#define IDH_NETWORK_RECONNECT	28481
#define IDH_NETWORK_ALWAYS	28482
#define IDH_NETWORK_SHOW_SHARED 28483
#define IDH_NETWORK_SHARED	28484
#define IDH_PAGE_SAMPLE 	28485
#define IDH_PAGE_ORIENTATION	28486
#define IDH_PAGE_PAPER_SIZE	28487
#define IDH_PAGE_PAPER_SOURCE	28488
#define IDH_PAGE_MARGINS	28489
#define IDH_OPEN_DRIVES 	28490
#define IDH_COMM_DRIVE		28491
#define IDH_COMM_PASSWDBUTT	28492
#define IDH_COMM_OLDPASSWD	28493
#define IDH_COMM_NEWPASSWD	28494
#define IDH_COMM_NEWPASSCONF	28495
#define IDH_BROWSE		28496
#define IDH_COLOR_CUSTOM	28497
#define IDH_COLOR_SAMPLE_COLOR	28498
#define IDH_COLOR_SAMPLE_BW	28499
#define IDH_COLOR_HUE		28500
#define IDH_COLOR_SAT		28501
#define IDH_COLOR_RED		28502
#define IDH_COLOR_GREEN 	28503
#define IDH_COLOR_BLUE		28504
#define IDH_COLOR_LUM		28505
#define IDH_COLOR_ADD		28506
#define IDH_COLOR_COLOR_SOLID	28507
#define IDH_COLOR_DEFINE	28508
#define IDH_QUICKINFO		28509
#define IDH_NO_CROSSREF 	28510
#define IDH_CHARMAP_INSERT	28511

// ID values for windisk

#define IDH_DLGDISK_LABEL	2000
#define IDH_DLGDISK_BITMAP	2001
#define IDH_DLGDISK_DRIVETYPE	2002
#define IDH_DLGDISK_DRIVESTATUS 2003
#define IDH_DLGDISK_FREE	2006
#define IDH_DLGDISK_USED	2011
#define IDH_DLGDISK_CAPACITY	2017
#define IDH_DLGDISK_CONFIGUREB	2021
#define IDH_DLGDISK_MOREINFOB	2022
#define IDH_DLGDISK_VIRUSSCAND	2023
#define IDH_DLGDISK_VIRUSSCANS	2025
#define IDH_DLGDISK_VIRUSSCANB	2026
#define IDH_DLGDISK_OPTIMIZED	2027
#define IDH_DLGDISK_OPTIMIZES	2029
#define IDH_DLGDISK_OPTIMIZEB	2030
#define IDH_DLGDISK_CHKDSKD	2031
#define IDH_DLGDISK_CHKDSKS	2033
#define IDH_DLGDISK_CHKDSKB	2034

// ID values 2200-2299 are reserved for Find File. See findhlp.h.

// ID values 2400-2499 are reserved for MultiMedia control panel. See medhelp.h

// ID values 2500-2699 are reserved for Print Trouble Shooter

// ID values for Mouse property sheet

#define IDH_DLGMOUSE_LEFT	 3000
#define IDH_DLGMOUSE_RIGHT	 3001
#define IDH_DLGMOUSE_DOUBCLICK	 3002
#define IDH_DLGMOUSE_HANDED_PIC  3003
#define IDH_DLGMOUSE_DCLICK_PIC  3004
#define IDH_DLGMOUSE_COLOR	 3005
#define IDH_DLGMOUSE_POINTSIZE	 3006
#define IDH_DLGMOUSE_SHOWTRAIL	 3007
#define IDH_DLGMOUSE_TRAILLENGTH 3008
#define IDH_DLGMOUSE_TYPE	 3009
#define IDH_DLGMOUSE_CHANGE	 3010
#define IDH_DLGMOUSE_POINTMO	 3011

// Briefcase ids

#define IDH_BFC_UPDATE_SCREEN		3100
#define IDH_BFC_UPDATE_BUTTON		3101
#define IDH_BFC_PROP_FILEICON		3102
#define IDH_BFC_PROP_SPLIT_BUTTON	3103
#define IDH_BFC_PROP_FINDORIG_BUTTON	3104
#define IDH_BFC_FILTER_TYPE		3105
#define IDH_BFC_FILTER_INCLUDE		3106
#define IDH_BRIEFCASE_INTRO		3107

// ID values 3300-3499 are reserved for international. See intlhlp.h

// ID values for the Keyboard property sheet

#define IDH_DLGKEY_REPDEL	4000
#define IDH_DLGKEY_REPSPEED	4001
#define IDH_DLGKEY_REPTEST	4002
#define IDH_DLGKEY_CURSON	4003
#define IDH_DLGKEY_NUM		4004
#define IDH_DLGKEY_ARROW	4005
#define IDH_DLGKEY_PNTSPEED	4006
#define IDH_DLGKEY_PNTACC	4007
#define IDH_DLGKEY_TYPE 	4008
#define IDH_DLGKEY_CNTRY	4009
#define IDH_DLGKEY_CHANGE	4010
#define IDH_DLGKEY_CURSBLNK	4011
#define IDH_DLGKEY_LOCATION	4012

#define IDH_LANG_ADD		4020
#define IDH_LANG_DELETE 	4021
#define IDH_LANG_DESCRIPTION	4022
#define IDH_LANG_EDIT		4023
#define IDH_LANG_ICON		4024
#define IDH_LANG_KEYBOARD	4025
#define IDH_LANG_KEYS		4026
#define IDH_LANG_LANGUAGE	4027
#define IDH_LANG_LIST		4028
#define IDH_LANG_MOVE		4029
#define IDH_LANG_SHORTCUT	4030
#define IDH_LANG_DISABLED	4031

// ID values for the Windows Metrics property sheet

#define IDH_METRICS_SCHEME	4050
#define IDH_METRICS_SVSCHEME	4051
#define IDH_METRICS_RMSCHEME	4052
#define IDH_METRICS_PREVIEW	4053
#define IDH_METRICS_ELEMENT	4054
#define IDH_METRICS_ELEMENTSIZE 4055
#define IDH_METRICS_FONTSCAPT	4056
#define IDH_METRICS_FONTSSMCAPT 4057
#define IDH_METRICS_FONTSMENU	4058
#define IDH_METRICS_FONTSMIN	4059
#define IDH_METRICS_FONTSICON	4060
#define IDH_METRICS_FONTSSYSTEM 4061

// ID values for Desktop Property sheet

// Background Page

#define IDH_DSKTPBACKGROUND_MONITOR   4100
#define IDH_DSKTPBACKGROUND_PATTBOX   4101
#define IDH_DSKTPBACKGROUND_PATTLIST  4102
#define IDH_DSKTPBACKGROUND_WALLBOX   4103
#define IDH_DSKTPBACKGROUND_WALLLIST  4104
#define IDH_DSKTPBACKGROUND_BROWSE    4105
#define IDH_DSKTPBACKGROUND_TILE      4106
#define IDH_DSKTPBACKGROUND_CENTER    4107
#define IDH_DSKTPBACKGROUND_DISPLAY   4108
#define IDH_DSKTPBACKGROUND_EDITPAT   4109

// Screen Saver Page

#define IDH_DSKTPSCRSAVER_BOX	      4110
#define IDH_DSKTPSCRSAVER_LISTBX      4111
#define IDH_DSKTPSCRSAVER_WAIT	      4112
#define IDH_DSKTPSCRSAVER_TEST	      4113
#define IDH_DSKTPSCRSAVER_SETTINGS    4114
#define IDH_DSKTPSCRSAVER_MONITOR     4115
#define IDH_SCRSAVER_GRAPHIC	      4116
#define IDH_SCRSAVER_LOWPOWSTANDBY    4117
#define IDH_SCRSAVER_SHUTOFFPOW       4118

// Appearance Page

#define IDH_APPEAR_SCHEME		4120
#define IDH_APPEAR_SAVEAS		4121
#define IDH_APPEAR_DELETE		4122
#define IDH_APPEAR_GRAPHIC		4123
#define IDH_APPEAR_ITEMSIZE		4124
#define IDH_APPEAR_FONTBOLD		4125
#define IDH_APPEAR_FONTSIZE		4126
#define IDH_APPEAR_FONTCOLOR		4127
#define IDH_APPEAR_FONTITALIC		4128
#define IDH_APPEAR_BACKGRNDCOLOR	4129
#define IDH_APPEAR_ITEM 		4130
#define IDH_APPEAR_FONT 		4131

// Monitor Settings Page

#define IDH_DSKTPMONITOR_COLOR	    4135
#define IDH_DSKTPMONITOR_AREA	    4136


#define IDH_DSKTPMONITOR_MONITOR    4140
#define IDH_DSKTPMONITOR_ADTYPE     4143
#define IDH_DSKTPMONITOR_CHANGE1    4144
#define IDH_DSKTPMONITOR_CHANGE2    4145
#define IDH_DSKTPMONITOR_MONTYPE    4146
#define IDH_DSKTPMONITOR_FULLDRAG   4147
#define IDH_DSKTPMONITOR_CUSTOM     4148
#define IDH_DSKTPMONITOR_FONTSIZE   4149

#define IDH_SAVESCHEME_EDITFIELD    4170
#define IDH_CUSTOMFONTS_FONTSCALE   4171
#define IDH_CUSTOMFONTS_RULER	    4172
#define IDH_CUSTOMFONTS_SAMPLE	    4173

// ID values for Defrag

#define IDH_DEFRAG_START		4200
#define IDH_DEFRAG_STOP 		4201
#define IDH_DEFRAG_PAUSE		4202
#define IDH_DEFRAG_SHOWDETAILS		4203
#define IDH_DEFRAG_HIDEDETAILS		4204
#define IDH_DEFRAG_LEGEND		4205
#define IDH_DEFRAG_SPARKLESCRN		4206
#define IDH_DEFRAG_DEFRAGNOW_ANYWY	4207
#define IDH_DEFRAG_SELECTDRIVE		4208
#define IDH_DEFRAG_ADVANCED		4209
#define IDH_DEFRAG_EXIT 		4210
#define IDH_DEFRAG_DRIVELIST		4211
#define IDH_DEFRAG_RESUME		4212
#define IDH_DEFRAG_FULL 		4213
#define IDH_DEFRAG_FILESONLY		4214
#define IDH_DEFRAG_FRSPCONLY		4215
#define IDH_DEFRAG_HIDSYSFILES		4216
#define IDH_DEFRAG_CVFS 		4217
#define IDH_DEFRAG_USEONCE		4218
#define IDH_DEFRAG_USEALWAYS		4219
#define IDH_DEFRAG_GASGAUGE		4220

// RNA id values

#define IDH_RNA_CHOOSE_MODEM		4250
#define IDH_RNA_CONFIG_MODEM		4251
#define IDH_RNA_IN			4252
#define IDH_RNA_IN_CALLBACK		4253
#define IDH_RNA_IN_CALLBACK_BUT 	4254
#define IDH_RNA_IN_COMMENT		4255
#define IDH_RNA_IN_CONNECTION		4256
#define IDH_RNA_IN_DIRECT		4257
#define IDH_RNA_IN_DISCONNECT		4258
#define IDH_RNA_IN_ENABLEACC		4259
#define IDH_RNA_IN_NOACC		4260
#define IDH_RNA_IN_PASSWORD		4261
#define IDH_RNA_IN_TONETANDPC		4262
#define IDH_RNA_IN_TOPC 		4263
#define IDH_RNA_OUT			4264
#define IDH_RNA_OUT_COMMENT		4265
#define IDH_RNA_OUT_CONNECT_BUTTON	4266
#define IDH_RNA_OUT_DIALASST		4267
#define IDH_RNA_OUT_DONTSHOW		4268
#define IDH_RNA_OUT_NAME		4269
#define IDH_RNA_OUT_NAME_STATUS 	4270
#define IDH_RNA_OUT_PHONE_NUMBER	4271

// ID values for printing property sheets

#define IDH_PRTPROPS_NAME		4500
#define IDH_PRTPROPS_TYPE_LOCATION	4501
#define IDH_PRTPROPS_COMMENT		4502
#define IDH_PRTPROPS_WHERE		4503
#define IDH_PRTPROPS_AVAILABLE		4504
#define IDH_PRTPROPS_NAME_STATIC	4505
#define IDH_PRTPROPS_PORT		4506
#define IDH_PRTPROPS_DRIVER		4507
#define IDH_PRTPROPS_NEW_PORT		4508
#define IDH_PRTPROPS_NEW_DRIVER 	4509
#define IDH_PRTPROPS_SEPARATOR		4510
#define IDH_PRTPROPS_PRIORITY		4511
#define IDH_PRTPROPS_ICON		4512
#define IDH_PRTPROPS_SPOOL_SETTINGS	4513
#define IDH_PRTPROPS_PORT_SETTINGS	4514
#define IDH_PRTPROPS_SETUP		4515

// ID values for System property sheets

#define IDH_SYSTEM_SYSTEM		4600
#define IDH_SYSTEM_MEMORY		4601
#define IDH_SYSTEM_RESOURCES		4602
#define IDH_SYSTEM_OWNER		4603
#define IDH_SYSTEM_STARTUP		4604
#define IDH_SYSTEM_STARTUPEDITBTN	4605
#define IDH_SYSTEM_STARTUPREMOVEBTN	4606
#define IDH_SYSTEM_STARTUPADDBTN	4607
#define IDH_SYSTEM_PATH 		4608
#define IDH_SYSTEM_PATHREMOVEALLBTN	4609
#define IDH_SYSTEM_TEMP 		4610
#define IDH_SYSTEM_TEMPBROWSEBTN	4611
#define IDH_SYSTEM_ENV			4612
#define IDH_SYSTEM_ENVVARNAME		4613
#define IDH_SYSTEM_ENVVALUE		4614
#define IDH_SYSTEM_ENVREMOVEBTN 	4615
#define IDH_SYSTEM_ENVADDBTN		4616
#define IDH_SYSTEM_VMPICTURE		4617
#define IDH_SYSTEM_VMRESERVE		4618
#define IDH_SYSTEM_VMRESERVEQTY 	4619
#define IDH_SYSTEM_VMADVANCEDBTN	4620
#define IDH_SYSTEM_VMSHARESWAPFILE	4621
#define IDH_SYSTEM_PATHADDBTN		4622
#define IDH_SYSTEM_PATHREMOVEBTN	4623
#define IDH_SYSTEM_PRO_COPY		4624
#define IDH_SYSTEM_PRO_RENAME		4625
#define IDH_SYSTEM_PRO_DELETE		4626
#define IDH_SYSTEM_PRO_LIST		4627
#define IDH_SYSTEM_CFG_COMBO		4628
#define IDH_SYSTEM_CFG_EDIT		4629
#define IDH_SYSTEM_PROCESSOR            4630

#define IDH_ADVSYS_PROPERTY		4650
#define IDH_ADVSYS_REFRESH		4651
#define IDH_ADVSYS_DELETE		4652
#define IDH_ADVSYS_PRINT		4653
#define IDH_ADVSYS_GLANCE		4654
#define IDH_ADVSYS_HARDTREE		4655
#define IDH_ADVSYS_VIEWTREE		4656
#define IDH_ADVSYSPROP_DETAILS		4657
#define IDH_ADVSYSPROP_ENABLE		4658
#define IDH_ADVSYSRESOURCE_INFO 	4659
#define IDH_ADVSYSRESOURCE_RESERVE	4660
#define IDH_ADVBADSECT_AUTOMRKNO	4661
#define IDH_ADVBADSECT_DATAONLY 	4662
#define IDH_ADVBADSECT_FULL		4663
#define IDH_ADVBADSECT_SYSONLY		4664
#define IDH_ADVBADSECT_TESTALL		4665
#define IDH_ADVBADSECT_UNCORRECT	4666
#define IDH_ADVBADSECT_WRITETEST	4667
#define IDH_ADVCHECKDLG_AUTOFIXMIN	4668
#define IDH_ADVCHECKDLG_AUTOFIXNO	4669
#define IDH_ADVCHECKDLG_CHKBOOTSECT	4670
#define IDH_ADVCHECKDLG_CHKDATETIME	4671
#define IDH_ADVCHECKDLG_CONVTLOSTCLST	4672
#define IDH_ADVCHECKDLG_COPYXLINKS	4673
#define IDH_ADVCHECKDLG_DELXLINKS	4674
#define IDH_ADVCHECKDLG_FREELOSTCLST	4675
#define IDH_ADVCHECKDLG_FULLINTER	4676
#define IDH_ADVCHECKDLG_IGNORE		4677
#define IDH_ADVCHECKDLG_INVALIDNAMES	4678
#define IDH_ADVCHECKDLG_USERSLCTXLINKS	4679
#define IDH_BADSECT_ADVANCED		4680
#define IDH_BADSECT_GASGAUGE		4681
#define IDH_BADSECT_REPORT		4682
#define IDH_CHECKDLG_ADVOPTIONS 	4683
#define IDH_CHECKDLG_BADSECTS		4684
#define IDH_CHECKDLG_GASGAUGE		4685
#define IDH_CHECKDLG_READONLY		4686
#define IDH_CHECKDLG_REPORT		4687

// ID's for File properties

#define IDH_FPROP_VER_INFO		4700
#define IDH_FPROP_SHAR_NOTSHARED	4701
#define IDH_FPROP_SHAR_SHAREDAS 	4702
#define IDH_FPROP_SHAR_SHARENAME	4703
#define IDH_FPROP_SHAR_COMMENT		4704
#define IDH_FPROP_SHAR_RESHARE		4705
#define IDH_FPROP_SHAR_ACCESS		4706
#define IDH_FPROP_SHAR_PASSWORD 	4707
#define IDH_FPROP_GEN_NAME		4708
#define IDH_FPROP_GEN_TYPE		4709
#define IDH_FPROP_GEN_SIZE		4710
#define IDH_FPROP_GEN_LOCATION		4711
#define IDH_FPROP_GEN_DOSNAME		4712
#define IDH_FPROP_GEN_LASTCHANGE	4713
#define IDH_FPROP_GEN_LASTACCESS	4714
#define IDH_FPROP_GEN_READONLY		4715
#define IDH_FPROP_GEN_ARCHIVE		4716
#define IDH_FPROP_GEN_HIDDEN		4717
#define IDH_FPROP_GEN_SYSTEM		4718
#define IDH_FPROP_GEN_PATH		4719
#define IDH_FPROP_VER_ABOUT		4720
#define IDH_FCAB_LINK_NAME		4721
#define IDH_FCAB_LINK_TYPE		4722
#define IDH_FCAB_LINK_LOCATION		4723
#define IDH_FCAB_LINK_LINKTO		4724
#define IDH_FCAB_LINK_LINKTYPE		4725
#define IDH_FCAB_LINK_SIZE		4726
#define IDH_FCAB_LINK_WORKING		4727
#define IDH_FCAB_LINK_HOTKEY		4728
#define IDH_FCAB_LINK_RUN		4729
#define IDH_FCAB_LINK_CHANGEICON	4730
#define IDH_FCAB_LINK_FIND		4731
#define IDH_FCAB_LINK_ICONNAME		4732
#define IDH_FCAB_LINK_CURRENT_ICON	4733

// Screen saver ids

#define IDH_BEZIER_SPEED		4800
#define IDH_BEZIER_LINES		4801
#define IDH_BEZIER_CURVES		4802
#define IDH_BEZIER_DENSITY		4803
#define IDH_BEZIER_ONECOLOR		4804
#define IDH_BEZIER_CHOOSECLR		4805
#define IDH_BEZIER_MULTCOLOR		4806
#define IDH_BEZIER_CLRSCRN		4807
#define IDH_FLYINGWIN_WARP		4808
#define IDH_FLYINGWIN_DENSTY		4809
#define IDH_COMM_PASSWDCHKBOX		4810
#define IDH_MARQUEE_CENTER		4811
#define IDH_MARQUEE_RANDOM		4812
#define IDH_MARQUEE_SPEED		4813
#define IDH_MARQUEE_COLOR		4814
#define IDH_MARQUEE_TEXT		4815
#define IDH_MARQUEE_EXAMP		4816
#define IDH_MARQUEE_FORMAT		4817
#define IDH_MYST_SHAPE			4818
#define IDH_MYST_ACTVBOX		4819
#define IDH_MYST_LINES			4820
#define IDH_MYST_TWOCOLORS		4821
#define IDH_MYST_MULTIPLE		4822
#define IDH_MYST_CLEARSCRN		4823
#define IDH_STARS_WARP			4824
#define IDH_STARS_DENSTY		4825
#define IDH_HOP_DELAY			4826
#define IDH_HOP_SCALE			4827
#define IDH_PASSWDPROMPT_PASSWD 	4828

// id's for date-time property sheet

#define IDH_DATETIME_FORMAT_TIME	4900
#define IDH_DATETIME_MONTH		4901
#define IDH_DATETIME_YEAR		4902
#define IDH_DATETIME_DATE		4903
#define IDH_DATETIME_TIME		4904
#define IDH_DATETIME_FORMATDATE 	4905
#define IDH_DATETIME_FORMATTIME 	4906

// id's for Modem Setup

#define IDH_MODEM_SELECT		5000
#define IDH_MODEM_DETECT		5001
#define IDH_MODEM_PORT			5002
#define IDH_MODEM_NAME			5003
#define IDH_MODEM_INSTALLED		5004
#define IDH_MODEM_PROP			5005
#define IDH_MODEM_NEW			5006
#define IDH_MODEM_DELETE		5007

// id's for TAPI

#define IDH_TAPI_TOLL_PREFIXES		5100
#define IDH_TAPI_TOLL_ADD_BUTTON	5101
#define IDH_TAPI_TOLL_REMOVE_BUTTON	5102
#define IDH_TAPI_TOLL_AREA_CODE 	5103
#define IDH_TAPI_LOCATIONS		5104
#define IDH_TAPI_ACCESS_LINE		5105
#define IDH_TAPI_AREA_CODE		5106
#define IDH_TAPI_LOCATION_CARD		5107
#define IDH_TAPI_CHANGE_CARD		5108
#define IDH_TAPI_COUNTRY		5109
#define IDH_TAPI_CALLCARDS		5110
#define IDH_TAPI_CALLCARD_ADD		5111
#define IDH_TAPI_CALLCARD_EDIT		5112
#define IDH_TAPI_CALLCARD_REMOVE	5113
#define IDH_TAPI_CALLCARD_NAME		5114
#define IDH_TAPI_CALLCARD_NUMBER	5115
#define IDH_TAPI_CALLCARD_INTL_RULES	5116
#define IDH_TAPI_CALLCARD_LONG_RULES	5117
#define IDH_TAPI_CALLCARD_LOCAL_RULES	5118
#define IDH_TAPI_COPY_FROM_BUTTON	5119
#define IDH_TAPI_COPYFROM		5120

// id's 5200 - 5500 are reserved for DOS


// Miscelanious ids

#define IDH_FCAB_ASSOC_EXTENSION	6000
#define IDH_FCAB_ASSOC_APPLICATION	6001
#define IDH_TRAY_RUN_COMMAND		6002
#define IDH_TRAY_RUN_STATE		6003
#define IDH_CONFIGDLG_BOOT		6004
#define IDH_CONFIGDLG_COMPARE		6005
#define IDH_CONFIGDLG_FORMAT		6006
#define IDH_CONFIGDLG_MKCOPY		6007
#define IDH_LANG_LOCALE 		6016
#define IDH_WASTE_AUTODELETE		6017

// ID values for Virtual Memory Property sheet

#define IDH_CTRLS_VIRTMEM_CURRENT    6100
#define IDH_CTRLS_VIRTMEM_DRIVE      6101
#define IDH_CTRLS_VIRTMEM_TYPE	     6102
#define IDH_CTRLS_VIRTMEM_SPACEAVAIL 6103
#define IDH_CTRLS_VIRTMEM_MAXSIZE    6104
#define IDH_CTRLS_VIRTMEM_RECSIZE    6105
#define IDH_CTRLS_VIRTMEM_NEWSIZE    6106
#define IDH_CTRLS_VIRTMEM_32BIT      6607
#define IDH_CTRLS_VIRTMEM_RECMAXSIZE 6108


#define IDH_DEVMGR_ADDHW	6200
#define IDH_DEVMGR_DELETEHW	6201
#define IDH_DEVMGR_PROP 	6202
#define IDH_DEVMGR_HARDWARE	6203

#define IDH_DEVMGRMEM_ADD	6210
#define IDH_DEVMGRMEM_REMOVE	6211
#define IDH_DEVMGRMEM_EDIT	6212
#define IDH_DEVMGRMEM_MEMORY	6213
#define IDH_DEVMGRMEM_BASE	6214
#define IDH_DEVMGRMEM_END	6215

#define IDH_DEVMGRIO_IO 	6220
#define IDH_DEVMGRIO_ADD	6221
#define IDH_DEVMGRIO_REMOVE	6222
#define IDH_DEVMGRIO_EDIT	6223

#define IDH_DEVMGRDMA_DMA	6230
#define IDH_DEVMGRDMA_ADD	6231
#define IDH_DEVMGRDMA_REMOVE	6232
#define IDH_DEVMGRDMA_EDIT	6233

#define IDH_DEVMGRIRQ_IRQ	6240
#define IDH_DEVMGRIRQ_ADD	6241
#define IDH_DEVMGRIRQ_REMOVE	6242
#define IDH_DEVMGRIRQ_EDIT	6243
#define IDH_DEVMGRIRQ_RESERVE	6244

#define IDH_DEVMGRADD_SELECT	6250
#define IDH_DEVMGRADD_COMPDEV	6251
#define IDH_DEVMGRADD_ALLDEV	6252
#define IDH_DEVMGRADD_DISK	6253
#define IDH_DEVMGRADD_OTHER	6254
#define IDH_DEVMGRADD_DEVTYPE	6255
