/*
Copyright (c) 1995  Microsoft Corporation

Module Name:
    ntddjoy.h

Abstract:
    Definitions of all constants and types for the joystick driver.
*/


#ifndef __NTDDJOY_H__
#define __NTDDJOY_H__

// Device Name
#define JOY_DD_DEVICE_NAME       "\\Device\\IBMJOY"
#define JOY_DD_DEVICE_NAME_U    L"\\Device\\IBMJOY"

// Device Parameters
#define JOY_DD_NAXES             "NumberOfAxes"
#define JOY_DD_NAXES_U          L"NumberOfAxes"

#define JOY_DD_DEVICE_ADDRESS    "DeviceAddress"
#define JOY_DD_DEVICE_ADDRESS_U L"DeviceAddress"

#define JOY_DD_TWOSTICKS         "Two Joysticks"
#define JOY_DD_TWOSTICKS_U      L"Two Joysticks"


// Device I/O Port Address
#define JOY_IO_PORT_ADDRESS    0x201

// Device specific bitmasks
#define X_AXIS_BITMASK	0x01

// Analog joystick bitmasks
#define JOYSTICK2_BUTTON2   0x80
#define JOYSTICK2_BUTTON1   0x40
#define JOYSTICK1_BUTTON2   0x20
#define JOYSTICK1_BUTTON1   0x10
#define JOYSTICK2_Y_MASK    0x08
#define JOYSTICK2_X_MASK    0x04
#define JOYSTICK1_R_MASK    0x08
#define JOYSTICK1_Z_MASK    0x04
#define JOYSTICK1_Y_MASK    0x02
#define JOYSTICK1_X_MASK    0x01


#define JOY_START_TIMERS    0

// Device specific timer values
#define ANALOG_POLL_TIMEOUT    16000  // 16 mS upper bound on analog polling, 8ms largest expected value, use 16 for safety
#define ANALOG_POLL_RESOLUTION   100  // 100 uS accuracy on polling time

// Joystick position information is transfered from the device driver to other
// drivers or applications using the JOY_DD_INPUT_DATA structure. Since
// the type of data returned varies whether the device is in analog mode or
// digital mode, a union is formed to convey both types of data. The Mode
// variable allows the recipient of the data to determing how to interpret
// the data.

typedef struct {

    // True if the device is unplugged. This is determined by a timeout mechanism
    BOOL    Unplugged;

    // The number of axi configured for this device (specified in the registry).
    DWORD   Axi;

    // current button state bitmask
    DWORD   Buttons;

    // X, Y, Z, and T axi positioning information contained below. The
    // values are expressed interms of microseconds. The values are
    // generated by measuring the duration of a pulse supplied by
    // the IBM compatable or Soundblaster game port. This is the raw
    // data, and it is the caller's responsibility to perform
    // calibration, ranging, hysteresis, etc.
    //
    // Because of inaccuracies in sampling this data, there is some
    // variation in readings of a stationary joystick.
    //
    // Analog Positioning information for typical joystick
    // values as follows (range information measured using a
    // Soundblaster analog game port).
    //
    //           apprx
    //  name     range        direction
    //  ----     -----        ---------
    //
    //  XTime  20..1600 uS    20 = leftmost, 1600 = rightmost
    //  YTime  20..1600 uS    20 = up,       1600 = down
    //  ZTime  20..1600 uS    20 = left,     1600 = right
    //  TTime  20..1600 uS    20 = forward   1600 = back
    //

    DWORD   XTime;   // Time in microseconds for X
    DWORD   YTime;   // Time in microseconds for Y
    DWORD   ZTime;   // Time in microseconds for Z if 3-axis
    DWORD   TTime;   // Time in microseconds for Throttle if 4 axis
    // return 3rd axis for 3 axis joysticks as TTime.

    } JOY_DD_INPUT_DATA, *PJOY_DD_INPUT_DATA;

#define JOY_TYPE 40001

// The following IOCTL code is used to obtain statistical information for
// debugging and performance testing the joystick driver.
#define IOCTL_JOY_GET_STATISTICS \
    CTL_CODE( JOY_TYPE, 0x903, METHOD_BUFFERED, FILE_READ_ACCESS)

// The following IOCTL code is used by the user-mode driver to determine
// the capabilities which the kernel-mode driver is capable of supporting.
#define IOCTL_JOY_GET_JOYREGHWCONFIG \
    CTL_CODE( JOY_TYPE, 0x906, METHOD_BUFFERED, FILE_READ_ACCESS)

// These stats are used for performance testing and debugging
typedef struct
{
    DWORD   Polls;
    DWORD   Timeouts;
    DWORD   Frequency;
    DWORD   dwQPCLatency;
    LONG    nQuiesceLoop;
    DWORD   Version;
    DWORD   PolledTooSoon;
    DWORD   NumberOfAxes;
    BOOL    bTwoSticks;
    DWORD   Redo;
} JOY_STATISTICS, *PJOY_STATISTICS;

#endif // __NTDDJOY_H__
