﻿@echo off
setlocal enabledelayedexpansion

:: ===========================
:: 配置部分
:: ===========================
set VC_REDIST_URL=https://aka.ms/vs/17/release/vc_redist.x64.exe
set TEMP_DIR=C:\vc_redist
set VC_REDIST_PATH=C:\vc_redist\vc_redist.x64.exe

:: 创建临时目录
if not exist "%TEMP_DIR%" (
    mkdir "%TEMP_DIR%"
)

:: ===========================
:: 检查 Microsoft Visual C++ Redistributable 是否已安装
:: ===========================
echo 检查系统是否已安装 Microsoft Visual C++ Redistributable...
reg query "HKLM\SOFTWARE\Microsoft\VisualStudio\14.0\VC\Runtimes\x64" >nul 2>&1
if %ERRORLEVEL% neq 0 (
    echo 未检测到 Microsoft Visual C++ Redistributable，开始下载...
    powershell -Command "Start-BitsTransfer -Source %VC_REDIST_URL% -Destination %VC_REDIST_PATH%"
    if not exist "%VC_REDIST_PATH%" (
        echo Microsoft Visual C++ Redistributable 下载失败，请检查网络连接。

    )
    echo 正在安装 Microsoft Visual C++ Redistributable...
    "C:\vc_redist\vc_redist.x64.exe" /quiet /norestart
    ) else (
    echo Microsoft Visual C++ Redistributable 已安装，无需重复安装。
)


echo 操作完成！



@echo off
:: 设置下载链接
set PYTHON_URL=https://www.python.org/ftp/python/3.12.5/python-3.12.5-amd64.exe

:: 设置文件保存路径
set DEST_PATH=python_installer.exe

:: 打印下载信息
echo Downloading Python...

:: 使用 PowerShell 的 Start-BitsTransfer 下载文件
powershell -Command "Start-BitsTransfer -Source %PYTHON_URL% -Destination %DEST_PATH%"

:: 安装 Python
start /wait python_installer.exe /quiet InstallAllUsers=1 PrependPath=1

:: 删除安装包
del python_installer.exe

start "" "%~dp0\yylaiyu_Install_auto.py"